/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.FourColorGradient", category="ch.kuramo.javie.api.effectCategory.generate")
public class FourColorGradient {
    @Property
    private IAnimatableVec2d point1;
    @Property(value="1,1,0")
    private IAnimatableColor color1;
    @Property
    private IAnimatableVec2d point2;
    @Property(value="0,1,0")
    private IAnimatableColor color2;
    @Property
    private IAnimatableVec2d point3;
    @Property(value="1,0,1")
    private IAnimatableColor color3;
    @Property
    private IAnimatableVec2d point4;
    @Property(value="0,0,1")
    private IAnimatableColor color4;
    @Property(value="100", min="0")
    private IAnimatableDouble blend;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlendSupport blendSupport;
    private final IShaderProgram program;
    @ShaderSource
    public static final String[] FOUR_COLOR_GRADIENT = new String[]{"uniform vec2 coordOffset;", "uniform vec2 point1;", "uniform vec2 point2;", "uniform vec2 point3;", "uniform vec2 point4;", "uniform mat4 colors;", "uniform float blend;", "uniform float rscale;", "", "void main(void)", "{", "\tvec2 fc = gl_FragCoord.xy + coordOffset;", "", "\tvec4 d = vec4(distance(fc, point1),", "\t\t\t\t  distance(fc, point2),", "\t\t\t\t  distance(fc, point3),", "\t\t\t\t  distance(fc, point4)) * rscale;", "", "\td = 1.0 / (d * d + blend);", "", "\tgl_FragColor = colors * d / dot(d, vec4(1.0));", "}"};

    @Inject
    public FourColorGradient(IVideoEffectContext context, IVideoRenderSupport support, IBlendSupport blendSupport, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blendSupport = blendSupport;
        this.program = shaders.getProgram(FourColorGradient.class, "FOUR_COLOR_GRADIENT");
        blendSupport.setProgramsClass(blendSupport.getPremultAndMatteClass(true));
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer original = this.context.doPreviousEffect();
        VideoBounds bounds = original.getBounds();
        if (bounds.isEmpty()) {
            return original;
        }
        IVideoBuffer buffer = null;
        try {
            Resolution resolution = this.context.getVideoResolution();
            Vec2d point1 = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.point1));
            Color color1 = (Color)this.context.value((IAnimatableValue)this.color1);
            Vec2d point2 = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.point2));
            Color color2 = (Color)this.context.value((IAnimatableValue)this.color2);
            Vec2d point3 = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.point3));
            Color color3 = (Color)this.context.value((IAnimatableValue)this.color3);
            Vec2d point4 = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.point4));
            Color color4 = (Color)this.context.value((IAnimatableValue)this.color4);
            double blend = (Double)this.context.value((IAnimatableValue)this.blend);
            double opacity = (Double)this.context.value((IAnimatableValue)this.opacity) / 100.0;
            BlendMode blendMode = (BlendMode)this.context.value(this.blendMode);
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("coordOffset", 2, this.toFloatBuffer(bounds.x, bounds.y)));
            uniforms.add(new GLUniformData("point1", 2, this.toFloatBuffer(point1.x, point1.y)));
            uniforms.add(new GLUniformData("point2", 2, this.toFloatBuffer(point2.x, point2.y)));
            uniforms.add(new GLUniformData("point3", 2, this.toFloatBuffer(point3.x, point3.y)));
            uniforms.add(new GLUniformData("point4", 2, this.toFloatBuffer(point4.x, point4.y)));
            uniforms.add(new GLUniformData("colors", 4, 4, this.toFloatBuffer(color1.r, color1.g, color1.b, 1.0, color2.r, color2.g, color2.b, 1.0, color3.r, color3.g, color3.b, 1.0, color4.r, color4.g, color4.b, 1.0)));
            uniforms.add(new GLUniformData("blend", (float)(blend * blend)));
            uniforms.add(new GLUniformData("rscale", (float)(1.0 / resolution.scale)));
            buffer = this.context.createVideoBuffer(bounds);
            this.support.useShaderProgram(this.program, uniforms, buffer, new IVideoBuffer[0]);
            IVideoBuffer iVideoBuffer = this.blendSupport.blend(buffer, original, null, blendMode, opacity, this.context);
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
            if (original != null) {
                original.dispose();
            }
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] farray = new float[values.length];
        int i = 0;
        while (i < values.length) {
            farray[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(farray);
    }
}

