/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.distort;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;
import javax.vecmath.Point2d;
import javax.vecmath.Vector3d;

@Effect(id="ch.kuramo.javie.CornerPin", category="ch.kuramo.javie.api.effectCategory.distort")
public class CornerPin {
    @Property
    private IAnimatableVec2d upperLeft;
    @Property
    private IAnimatableVec2d upperRight;
    @Property
    private IAnimatableVec2d lowerRight;
    @Property
    private IAnimatableVec2d lowerLeft;
    @Property(value="true")
    private IAnimatableBoolean perspective;
    @Property(value="true")
    private IAnimatableBoolean interpolation;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram[] programs;
    @ShaderSource
    public static final String[] PERSPECTIVE = CornerPin.createShaderSource(true, true, true);
    @ShaderSource
    public static final String[] PERSPECTIVE_H = CornerPin.createShaderSource(true, true, false);
    @ShaderSource
    public static final String[] PERSPECTIVE_V = CornerPin.createShaderSource(true, false, true);
    @ShaderSource
    public static final String[] PROPORTIONAL = CornerPin.createShaderSource(false, true, true);
    @ShaderSource
    public static final String[] PROPORTIONAL_H = CornerPin.createShaderSource(false, true, false);
    @ShaderSource
    public static final String[] PROPORTIONAL_V = CornerPin.createShaderSource(false, false, true);
    @ShaderSource
    public static final String[] PARALLELOGRAM = CornerPin.createShaderSource(false, false, false);

    @Inject
    public CornerPin(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.programs = new IShaderProgram[7];
        this.programs[0] = shaders.getProgram(CornerPin.class, "PERSPECTIVE");
        this.programs[1] = shaders.getProgram(CornerPin.class, "PERSPECTIVE_H");
        this.programs[2] = shaders.getProgram(CornerPin.class, "PERSPECTIVE_V");
        this.programs[3] = shaders.getProgram(CornerPin.class, "PROPORTIONAL");
        this.programs[4] = shaders.getProgram(CornerPin.class, "PROPORTIONAL_H");
        this.programs[5] = shaders.getProgram(CornerPin.class, "PROPORTIONAL_V");
        this.programs[6] = shaders.getProgram(CornerPin.class, "PARALLELOGRAM");
    }

    private Vec2d[] expand(Vec2d p0, Vec2d p1, Vec2d p2, Vec2d p3) {
        ArrayList<Vec2d> list = new ArrayList<Vec2d>();
        double signum = Double.NaN;
        double expand = 3.0;
        Vec2d[][] vec2dArrayArray = new Vec2d[][]{{p3, p0, p1}, {p0, p1, p2}, {p1, p2, p3}, {p2, p3, p0}};
        int n = vec2dArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            Vec2d[] p = vec2dArrayArray[n2];
            Vector3d v1 = new Vector3d(p[1].x - p[0].x, p[1].y - p[0].y, 0.0);
            Vector3d v2 = new Vector3d(p[2].x - p[1].x, p[2].y - p[1].y, 0.0);
            Vector3d c = new Vector3d();
            c.cross(v1, v2);
            if (c.lengthSquared() == 0.0) {
                return null;
            }
            if (Double.isNaN(signum)) {
                signum = Math.signum(c.z);
            } else if (Math.signum(c.z) != signum) {
                return null;
            }
            Vector3d v3 = new Vector3d();
            v3.cross(v1, c);
            v3.normalize();
            Vector3d v4 = new Vector3d();
            v4.cross(v2, c);
            v4.normalize();
            list.add(new Vec2d(p[1].x + expand * v3.x, p[1].y + expand * v3.y));
            list.add(new Vec2d(p[1].x + expand * v4.x, p[1].y + expand * v4.y));
            ++n2;
        }
        return list.toArray(new Vec2d[list.size()]);
    }

    private VideoBounds calcBounds(Vec2d ... vertices) {
        double upper = Double.POSITIVE_INFINITY;
        double left = Double.POSITIVE_INFINITY;
        double lower = Double.NEGATIVE_INFINITY;
        double right = Double.NEGATIVE_INFINITY;
        Vec2d[] vec2dArray = vertices;
        int n = vertices.length;
        int n2 = 0;
        while (n2 < n) {
            Vec2d v = vec2dArray[n2];
            left = Math.min(v.x, left);
            upper = Math.min(v.y, upper);
            right = Math.max(v.x, right);
            lower = Math.max(v.y, lower);
            ++n2;
        }
        return new VideoBounds(left, upper, (int)Math.ceil(right - left), (int)Math.ceil(lower - upper));
    }

    private Vector3d calcLine(Vec2d p1, Vec2d p2) {
        double x2_x1 = p2.x - p1.x;
        double y2_y1 = p2.y - p1.y;
        return new Vector3d(y2_y1, -x2_x1, x2_x1 * p1.y - y2_y1 * p1.x);
    }

    private Point2d calcIntersection(Vector3d line1, Vector3d line2) {
        double a1b2_a2b1 = line1.x * line2.y - line2.x * line1.y;
        if (a1b2_a2b1 < 1.0E-10) {
            return null;
        }
        return new Point2d((line1.y * line2.z - line2.y * line1.z) / a1b2_a2b1, (line2.x * line1.z - line1.x * line2.z) / a1b2_a2b1);
    }

    public VideoBounds getVideoBounds() {
        Vec2d lowerLeft;
        Vec2d lowerRight;
        Vec2d upperRight;
        Resolution resolution = this.context.getVideoResolution();
        Vec2d upperLeft = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.upperLeft));
        Vec2d[] expanded = this.expand(upperLeft, upperRight = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.upperRight)), lowerRight = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.lowerRight)), lowerLeft = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.lowerLeft)));
        if (expanded != null) {
            return this.calcBounds(expanded);
        }
        return this.calcBounds(upperLeft, upperRight, lowerRight, lowerLeft);
    }

    public IVideoBuffer doVideoEffect() {
        Vec2d lowerLeft;
        Vec2d lowerRight;
        Vec2d upperRight;
        Resolution resolution = this.context.getVideoResolution();
        Vec2d upperLeft = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.upperLeft));
        final Vec2d[] expanded = this.expand(upperLeft, upperRight = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.upperRight)), lowerRight = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.lowerRight)), lowerLeft = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.lowerLeft)));
        if (expanded == null) {
            return this.drawPolygon(upperLeft, upperRight, lowerRight, lowerLeft);
        }
        final VideoBounds outputBounds = this.calcBounds(expanded);
        if (outputBounds.isEmpty()) {
            return this.support.createVideoBuffer(outputBounds);
        }
        IVideoBuffer source = this.context.doPreviousEffect();
        if (source.getBounds().isEmpty()) {
            return source;
        }
        IVideoBuffer buffer = null;
        try {
            IShaderProgram program;
            buffer = this.support.createVideoBuffer(outputBounds);
            buffer.clear();
            boolean perspective = (Boolean)this.context.value((IAnimatableValue)this.perspective);
            boolean interpolation = (Boolean)this.context.value((IAnimatableValue)this.interpolation);
            Vector3d upperLine = this.calcLine(upperLeft, upperRight);
            Vector3d rightLine = this.calcLine(upperRight, lowerRight);
            Vector3d lowerLine = this.calcLine(lowerRight, lowerLeft);
            Vector3d leftLine = this.calcLine(lowerLeft, upperLeft);
            Point2d hInf = this.calcIntersection(upperLine, lowerLine);
            Point2d vInf = this.calcIntersection(leftLine, rightLine);
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("fragCoordOffset", 2, this.toFloatBuffer(outputBounds.x, outputBounds.y)));
            uniforms.add(new GLUniformData("upperLine", 3, this.toFloatBuffer(upperLine.x, upperLine.y, upperLine.z)));
            uniforms.add(new GLUniformData("rightLine", 3, this.toFloatBuffer(rightLine.x, rightLine.y, rightLine.z)));
            uniforms.add(new GLUniformData("lowerLine", 3, this.toFloatBuffer(lowerLine.x, lowerLine.y, lowerLine.z)));
            uniforms.add(new GLUniformData("leftLine", 3, this.toFloatBuffer(leftLine.x, leftLine.y, leftLine.z)));
            if (hInf == null && vInf == null) {
                program = this.programs[6];
            } else if (hInf == null) {
                program = perspective ? this.programs[2] : this.programs[5];
                uniforms.add(new GLUniformData("vInf", 2, this.toFloatBuffer(vInf.x, vInf.y)));
            } else if (vInf == null) {
                program = perspective ? this.programs[1] : this.programs[4];
                uniforms.add(new GLUniformData("hInf", 2, this.toFloatBuffer(hInf.x, hInf.y)));
            } else {
                program = perspective ? this.programs[0] : this.programs[3];
                uniforms.add(new GLUniformData("hInf", 2, this.toFloatBuffer(hInf.x, hInf.y)));
                uniforms.add(new GLUniformData("vInf", 2, this.toFloatBuffer(vInf.x, vInf.y)));
            }
            Runnable operation = new Runnable(){

                public void run() {
                    CornerPin.this.support.ortho2D(outputBounds);
                    GL2 gl = CornerPin.this.context.getGL().getGL2();
                    gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                    gl.glBegin(9);
                    Vec2d[] vec2dArray = expanded;
                    int n = expanded.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Vec2d v = vec2dArray[n2];
                        gl.glVertex2f((float)v.x, (float)v.y);
                        ++n2;
                    }
                    gl.glEnd();
                }
            };
            source.setTextureFilter(this.context.getQuality() == Quality.DRAFT || resolution.scale < 1.0 ? IVideoBuffer.TextureFilter.NEAREST : (interpolation ? IVideoBuffer.TextureFilter.MIPMAP : IVideoBuffer.TextureFilter.LINEAR));
            int pushAttribs = 1;
            this.support.useShaderProgram(program, uniforms, operation, pushAttribs, buffer, new IVideoBuffer[]{source});
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
            source.dispose();
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] farray = new float[values.length];
        int i = 0;
        while (i < values.length) {
            farray[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(farray);
    }

    private static String[] createShaderSource(boolean perspective, boolean horizontal, boolean vertical) {
        boolean p = perspective;
        boolean h = horizontal;
        boolean v = vertical;
        return new String[]{p ? "#define PERSPECTIVE" : "", h ? "#define HORIZONTAL" : "", v ? "#define VERTICAL" : "", "", "uniform sampler2D texture;", "uniform vec2 fragCoordOffset;", "uniform vec3 upperLine;", "uniform vec3 rightLine;", "uniform vec3 lowerLine;", "uniform vec3 leftLine;", "", "#ifdef HORIZONTAL", "\tuniform vec2 hInf;", "#endif", "", "#ifdef VERTICAL", "\tuniform vec2 vInf;", "#endif", "", "vec3 calcLine(vec2 p1, vec2 p2)", "{", "\tvec2 v = p2 - p1;", "\treturn vec3(v.y, -v.x, v.x*p1.y - v.y*p1.x);", "}", "", "vec2 calcIntersection(vec3 line1, vec3 line2)", "{", "\treturn vec2(line1.y*line2.z - line2.y*line1.z,", "\t\t\t\tline2.x*line1.z - line1.x*line2.z)", "\t\t\t/ (line1.x*line2.y - line2.x*line1.y);", "}", "", "void main(void)", "{", "\tvec2 xy = gl_FragCoord.xy + fragCoordOffset;", "\tvec3 line;", "\tvec2 ip1, ip2;", "\tfloat d1, d2, d;", "\tfloat s, t;", "", "#ifdef HORIZONTAL", "\tline = calcLine(xy, hInf);", "#else", "\tline = vec3(upperLine.xy, -dot(upperLine.xy, xy));", "#endif", "\tip1 = calcIntersection(line, leftLine);", "\tip2 = calcIntersection(line, rightLine);", "#if defined(PERSPECTIVE) && defined(HORIZONTAL)", "\td1 = distance(ip1, hInf);", "\td2 = distance(ip2, hInf);", "\td = distance(xy, hInf);", "\ts = (1.0/d-1.0/d1) / (1.0/d2-1.0/d1);", "#else", "\ts = sign(dot(leftLine, vec3(xy, 1.0)) * dot(leftLine, vec3(ip2, 1.0)))", "\t\t\t* distance(xy, ip1) / distance(ip2, ip1);", "#endif", "", "#ifdef VERTICAL", "\tline = calcLine(xy, vInf);", "#else", "\tline = vec3(leftLine.xy, -dot(leftLine.xy, xy));", "#endif", "\tip1 = calcIntersection(line, upperLine);", "\tip2 = calcIntersection(line, lowerLine);", "#if defined(PERSPECTIVE) && defined(VERTICAL)", "\td1 = distance(ip1, vInf);", "\td2 = distance(ip2, vInf);", "\td = distance(xy, vInf);", "\tt = (1.0/d-1.0/d1) / (1.0/d2-1.0/d1);", "#else", "\tt = sign(dot(upperLine, vec3(xy, 1.0)) * dot(upperLine, vec3(ip2, 1.0)))", "\t\t\t* distance(xy, ip1) / distance(ip2, ip1);", "#endif", "", "\tgl_FragColor = texture2D(texture, vec2(s, t));", "}"};
    }

    private IVideoBuffer drawPolygon(final Vec2d ... vertices) {
        final VideoBounds outputBounds = this.calcBounds(vertices);
        if (outputBounds.isEmpty()) {
            return this.support.createVideoBuffer(outputBounds);
        }
        IVideoBuffer buffer = null;
        try {
            buffer = this.support.createVideoBuffer(outputBounds);
            buffer.clear();
            Runnable operation = new Runnable(){

                public void run() {
                    CornerPin.this.support.ortho2D(outputBounds);
                    GL2 gl = CornerPin.this.context.getGL().getGL2();
                    gl.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
                    gl.glLineWidth(2.0f);
                    gl.glBegin(2);
                    Vec2d[] vec2dArray = vertices;
                    int n = vertices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Vec2d v = vec2dArray[n2];
                        gl.glVertex2f((float)v.x, (float)v.y);
                        ++n2;
                    }
                    gl.glEnd();
                }
            };
            int pushAttribs = 5;
            this.support.useFramebuffer(operation, pushAttribs, buffer, new IVideoBuffer[0]);
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }
}

