/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.colorCorrection;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec3d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.ChannelMixer", category="ch.kuramo.javie.api.effectCategory.colorCorrection")
public class ChannelMixer {
    @Property(value="100,0,0", min="-200", max="200")
    private IAnimatableVec3d redRGB;
    @Property(value="0", min="-200", max="200")
    private IAnimatableDouble redAlpha;
    @Property(value="0", min="-200", max="200")
    private IAnimatableDouble redConst;
    @Property(value="0,100,0", min="-200", max="200")
    private IAnimatableVec3d greenRGB;
    @Property(value="0", min="-200", max="200")
    private IAnimatableDouble greenAlpha;
    @Property(value="0", min="-200", max="200")
    private IAnimatableDouble greenConst;
    @Property(value="0,0,100", min="-200", max="200")
    private IAnimatableVec3d blueRGB;
    @Property(value="0", min="-200", max="200")
    private IAnimatableDouble blueAlpha;
    @Property(value="0", min="-200", max="200")
    private IAnimatableDouble blueConst;
    @Property(value="0,0,0", min="-200", max="200")
    private IAnimatableVec3d alphaRGB;
    @Property(value="100", min="-200", max="200")
    private IAnimatableDouble alphaAlpha;
    @Property(value="0", min="-200", max="200")
    private IAnimatableDouble alphaConst;
    @Property
    private IAnimatableBoolean monochrome;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram colorProgram;
    private final IShaderProgram monoProgram;
    @ShaderSource
    public static final String[] COLOR = ChannelMixer.createShaderSource(false);
    @ShaderSource
    public static final String[] MONO = ChannelMixer.createShaderSource(true);

    @Inject
    public ChannelMixer(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.colorProgram = shaders.getProgram(ChannelMixer.class, "COLOR");
        this.monoProgram = shaders.getProgram(ChannelMixer.class, "MONO");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        if (source.getBounds().isEmpty()) {
            return source;
        }
        Vec3d redRGB = (Vec3d)this.context.value((IAnimatableValue)this.redRGB);
        double redAlpha = (Double)this.context.value((IAnimatableValue)this.redAlpha);
        double redConst = (Double)this.context.value((IAnimatableValue)this.redConst);
        Vec3d greenRGB = (Vec3d)this.context.value((IAnimatableValue)this.greenRGB);
        double greenAlpha = (Double)this.context.value((IAnimatableValue)this.greenAlpha);
        double greenConst = (Double)this.context.value((IAnimatableValue)this.greenConst);
        Vec3d blueRGB = (Vec3d)this.context.value((IAnimatableValue)this.blueRGB);
        double blueAlpha = (Double)this.context.value((IAnimatableValue)this.blueAlpha);
        double blueConst = (Double)this.context.value((IAnimatableValue)this.blueConst);
        Vec3d alphaRGB = (Vec3d)this.context.value((IAnimatableValue)this.alphaRGB);
        double alphaAlpha = (Double)this.context.value((IAnimatableValue)this.alphaAlpha);
        double alphaConst = (Double)this.context.value((IAnimatableValue)this.alphaConst);
        double[] mat = new double[]{redRGB.x / 100.0, greenRGB.x / 100.0, blueRGB.x / 100.0, alphaRGB.x / 100.0, redRGB.y / 100.0, greenRGB.y / 100.0, blueRGB.y / 100.0, alphaRGB.y / 100.0, redRGB.z / 100.0, greenRGB.z / 100.0, blueRGB.z / 100.0, alphaRGB.z / 100.0, redAlpha / 100.0, greenAlpha / 100.0, blueAlpha / 100.0, alphaAlpha / 100.0};
        double[] cns = new double[]{redConst / 100.0, greenConst / 100.0, blueConst / 100.0, alphaConst / 100.0};
        try {
            IShaderProgram program = (Boolean)this.context.value((IAnimatableValue)this.monochrome) != false ? this.monoProgram : this.colorProgram;
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("mat", 4, 4, this.toFloatBuffer(mat)));
            uniforms.add(new GLUniformData("cns", 4, this.toFloatBuffer(cns)));
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(program, uniforms, null, new IVideoBuffer[]{source});
            return iVideoBuffer;
        }
        finally {
            source.dispose();
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] farray = new float[values.length];
        int i = 0;
        while (i < values.length) {
            farray[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(farray);
    }

    private static String[] createShaderSource(boolean mono) {
        return new String[]{mono ? "#define MONO" : "", "", "uniform sampler2D texture;", "uniform mat4 mat;", "uniform vec4 cns;", "", "void main(void)", "{", "\tvec4 color = texture2D(texture, gl_TexCoord[0].st);", "\tif (color.a != 0.0) {", "\t\tcolor.rgb /= color.a;", "\t}", "\tcolor = mat * color + cns;", "\tcolor.a = clamp(color.a, 0.0, 1.0);", "", "#ifdef MONO", "\tcolor.rgb = vec3(color.r * color.a);", "#else", "\tcolor.rgb *= color.a;", "#endif", "", "\tgl_FragColor = color;", "}"};
    }
}

