/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.nukimas3;

import java.util.List;
import java.util.Map;

import ch.kuramo.javie.api.annotations.Effect;

@Effect(id="ch.kuramo.nukimas3.Imas2StageDifferenceKey",
		convertTo="ch.kuramo.nukimas3.Imas2StageDifferenceKey2")
public class Imas2StageDifferenceKey {

	public void convert(Map<String, Object> map) {
		renameEnumElement(map, "output", "MASK", "MATTE_ONLY");
		renameEnumElement(map, "output", "DIFFERENCE", "DIFF");
		renameEnumElement(map, "output", "DIFFERENCE_AND_EDGE", "DIFF_AND_EDGE_1");
	}

	private void renameEnumElement(
			Map<String, Object> map, String propertyName,
			String oldElementName, String newElementName) {

		Object obj = map.get(propertyName);
		if (obj instanceof Map<?, ?>) {
			@SuppressWarnings("unchecked")
			Map<String, Object> propertyObj = (Map<String, Object>) obj;

			Object staticValue = propertyObj.get("staticValue");
			if (oldElementName.equals(staticValue)) {
				propertyObj.put("staticValue", newElementName);
			}

			obj = propertyObj.get("keyframes");
			if (obj instanceof List<?>) {
				@SuppressWarnings("unchecked")
				List<Map<String, Object>> keyframes = (List<Map<String, Object>>) obj;

				for (Map<String, Object> kf : keyframes) {
					if (oldElementName.equals(kf.get("value"))) {
						kf.put("value", newElementName);
					}
				}
			}
		}
	}

}
