/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.nukimas3;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IObjectArray;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Effect(id="ch.kuramo.nukimas3.Imas2StageDifferenceKey2", category="ch.kuramo.nukimas3.nukimas3Category")
public class Imas2StageDifferenceKey2 {
    @Property
    private IAnimatableLayerReference stage2;
    @Property
    private IAnimatableLayerReference stage3;
    @Property
    private IAnimatableLayerReference stage4;
    @Property(value="40", min="0", max="100")
    private IAnimatableDouble unsharpMaskAmount;
    @Property(value="15", min="0", max="50")
    private IAnimatableDouble unsharpMaskRadius;
    @Property(value="100", min="0")
    private IAnimatableDouble differenceThreshold;
    @Property(value="30", min="0")
    private IAnimatableDouble differenceCutoff;
    @Property(value="20", min="0", max="100")
    private IAnimatableDouble edgeThreshold;
    @Property(value="50", min="0", max="100")
    private IAnimatableDouble minEdgeCoverage;
    @Property(value="10", min="0")
    private IAnimatableInteger minRegionSize;
    @Property(value="0")
    private IAnimatableColor pupilColor;
    @Property(value="1")
    private IAnimatableColor scleraColor;
    @Property(value="0.9,0.8,0.66")
    private IAnimatableColor fleshColor1;
    @Property(value="0.9,0.74,0.55")
    private IAnimatableColor fleshColor2;
    @Property(value="FLESH_COLOR_1")
    private IAnimatableEnum<UseFleshColor> useFleshColor;
    @Property(value="0", min="0")
    private IAnimatableDouble detectEyeColor;
    @Property(value="0", min="0")
    private IAnimatableInteger maxEyeSize;
    @Property(value="50", min="0")
    private IAnimatableDouble blinkThresholdEdge;
    @Property(value="30", min="0", max="100")
    private IAnimatableDouble blinkThresholdColor;
    @Property
    private IAnimatableLayerReference blinkMask;
    @Property(value="DIFF_AND_EDGE_1")
    private IAnimatableEnum<Output> output;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlurSupport blurSupport;
    private final IBlendSupport blendSupport;
    private final IArrayPools arrayPools;
    private final IShaderRegistry shaders;
    private final IShaderProgram unsharpMaskProgram;
    private final IShaderProgram luminosityProgram;
    private final IShaderProgram gradientProgram;
    private final IShaderProgram toMatteProgram;
    @ShaderSource
    public static final String[] UNSHARP_MASK = new String[]{"uniform sampler2D srcTex;", "uniform sampler2D blrTex;", "uniform float amount;", "", "void main(void)", "{", "\tvec2 tc = gl_TexCoord[0].st;", "\tvec4 srcColor = texture2D(srcTex, tc);", "\tvec4 blrColor = texture2D(blrTex, tc);", "", "\tsrcColor.rgb = (srcColor.a > 0.0) ? srcColor.rgb/srcColor.a : vec3(0.0);", "\tblrColor.rgb = (blrColor.a > 0.0) ? blrColor.rgb/blrColor.a : vec3(0.0);", "", "\tvec3 diff = srcColor.rgb - blrColor.rgb;", "", "\tgl_FragColor = vec4((srcColor.rgb+diff*amount)*srcColor.a, srcColor.a);", "}"};
    @ShaderSource
    public static final String[] LUMINOSITY = new String[]{"uniform sampler2D texture;", "", "const vec3 yvec = vec3(0.299, 0.587, 0.114);", "", "void main(void)", "{", "\tvec4 color = texture2D(texture, gl_TexCoord[0].st);", "\tfloat y = (color.a > 0.0) ? dot(color.rgb/color.a, yvec) : 0.0;", "\tgl_FragColor = vec4(y);", "}"};
    @ShaderSource
    public static final String[] GRADIENT = new String[]{"uniform sampler2D texture;", "uniform vec2 offset[8];", "", "void main(void)", "{", "\tvec2 tc = gl_TexCoord[0].st;", "\tfloat y00 = texture2D(texture, tc+offset[0]).r;", "\tfloat y10 = texture2D(texture, tc+offset[1]).r;", "\tfloat y20 = texture2D(texture, tc+offset[2]).r;", "\tfloat y01 = texture2D(texture, tc+offset[3]).r;", "\tfloat y11 = texture2D(texture, tc          ).r;", "\tfloat y21 = texture2D(texture, tc+offset[4]).r;", "\tfloat y02 = texture2D(texture, tc+offset[5]).r;", "\tfloat y12 = texture2D(texture, tc+offset[6]).r;", "\tfloat y22 = texture2D(texture, tc+offset[7]).r;", "", "\tfloat grad = max(max(abs(y10-y11), abs(y01-y11)),", "\t\t\t\t\t max(abs(y21-y11), abs(y12-y11)));", "", "\tfloat lap = y00+y10+y20+y01-8.0*y11+y21+y02+y12+y22;", "", "\tgl_FragColor = (lap > 0.0) ? vec4(grad, 0.0, 0.0, 1.0)", "\t\t\t\t\t\t\t   : vec4(0.0, grad, 0.0, 1.0);", "}"};
    @ShaderSource
    public static final String[] TO_MATTE = new String[]{"uniform sampler2D texture;", "", "void main(void)", "{", "\tgl_FragColor = vec4(texture2D(texture, gl_TexCoord[0].st).r);", "}"};

    @Inject
    public Imas2StageDifferenceKey2(IVideoEffectContext context, IVideoRenderSupport support, IBlurSupport blurSupport, IBlendSupport blendSupport, IArrayPools arrayPools, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blurSupport = blurSupport;
        this.blendSupport = blendSupport;
        this.arrayPools = arrayPools;
        this.shaders = shaders;
        this.unsharpMaskProgram = shaders.getProgram(Imas2StageDifferenceKey2.class, "UNSHARP_MASK");
        this.luminosityProgram = shaders.getProgram(Imas2StageDifferenceKey2.class, "LUMINOSITY");
        this.gradientProgram = shaders.getProgram(Imas2StageDifferenceKey2.class, "GRADIENT");
        this.toMatteProgram = shaders.getProgram(Imas2StageDifferenceKey2.class, "TO_MATTE");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IVideoBuffer doVideoEffect() {
        source1 = this.context.doPreviousEffect();
        bounds = source1.getBounds();
        if (bounds.width < 2) return source1;
        if (bounds.height < 2) {
            return source1;
        }
        buffers = new ArrayList<IVideoBuffer>();
        buffers.add(source1);
        try {
            srcAndSrp = new IVideoBuffer[2][4];
            srcAndSrp[0][0] = source1;
            srcGotten = this.getSourceBuffers(srcAndSrp[0], buffers);
            if (!srcGotten) {
                buffers.remove(srcAndSrp[0][0]);
                var13_6 = srcAndSrp[0][0];
                return var13_6;
            }
            output = (Output)this.context.value(this.output);
            if (this.isStage(output)) {
                outbuf = srcAndSrp[0][output.ordinal() - Output.STAGE1.ordinal()];
                var13_7 = outbuf != null ? this.quit(outbuf, buffers) : this.blank(bounds);
                return var13_7;
            }
            if (this.doUnsharpMask(srcAndSrp, buffers)) {
                this.disposeSourceBuffers(srcAndSrp[0], buffers, output);
            }
            if (this.isStageUM(output)) {
                outbuf = srcAndSrp[1][output.ordinal() - Output.STAGE1_UM.ordinal()];
                var13_8 = outbuf != null ? this.quit(outbuf, buffers) : this.blank(bounds);
                return var13_8;
            }
            if (output == Output.DIFF) {
                diff = this.createDiff(srcAndSrp[1], buffers);
                var13_9 = this.quit(diff, buffers);
                return var13_9;
            }
            if (output == Output.EDGE) {
                edge = this.createEdge(bounds, srcAndSrp[1], buffers);
                var13_10 = this.quit(edge, buffers);
                return var13_10;
            }
            diffAndEdge = this.createDiff(srcAndSrp[1], buffers);
            if (output == Output.DIFF_AND_EDGE_1) {
                this.addEdgeAndBlinkMask(srcAndSrp[1], false, diffAndEdge);
                var13_11 = this.quit(diffAndEdge, buffers);
                return var13_11;
            }
            addBlinkMask = output != Output.DIFF_AND_EDGE_2;
            hasBlinkMask = this.addEdgeAndBlinkMask(srcAndSrp[1], addBlinkMask, diffAndEdge);
            this.disposeSharpedBuffers(srcAndSrp[1], buffers, output);
            if (output == Output.DIFF_AND_EDGE_2) {
                this.doRegionFilters(diffAndEdge, hasBlinkMask, buffers, true);
                var13_12 = this.quit(diffAndEdge, buffers);
                return var13_12;
            }
            this.doRegionFilters(diffAndEdge, hasBlinkMask, buffers, false);
            matteBuffer = this.toMatteBuffer(diffAndEdge, buffers);
            if (output == Output.MATTE_ONLY) {
                var13_13 = this.quit(matteBuffer, buffers);
                return var13_13;
            }
            v0 = this.isResult(output) != false ? srcAndSrp[0][output.ordinal() - Output.RESULT_FROM_STAGE1.ordinal()] : (stage = this.isResultUM(output) != false ? srcAndSrp[1][output.ordinal() - Output.RESULT_FROM_STAGE1_UM.ordinal()] : null);
            if (stage != null) {
                var13_14 = this.blendSupport.blend(matteBuffer, stage, null, BlendMode.STENCIL_ALPHA, 1.0);
                return var13_14;
            }
            var13_15 = this.blank(bounds);
            return var13_15;
        }
        finally {
            ** for (buf : buffers)
        }
lbl-1000:
        // 1 sources

        {
            buf.dispose();
            continue;
        }
lbl65:
        // 1 sources

        return var13_6;
    }

    private boolean getSourceBuffers(IVideoBuffer[] sources, List<IVideoBuffer> buffers) {
        boolean gotten = false;
        IAnimatableLayerReference[] iAnimatableLayerReferenceArray = new IAnimatableLayerReference[4];
        iAnimatableLayerReferenceArray[1] = this.stage2;
        iAnimatableLayerReferenceArray[2] = this.stage3;
        iAnimatableLayerReferenceArray[3] = this.stage4;
        IAnimatableLayerReference[] refs = iAnimatableLayerReferenceArray;
        int i = 1;
        while (i < 4) {
            IVideoBuffer buf = this.context.getLayerVideoFrame(refs[i]);
            if (buf != null) {
                sources[i] = buf;
                buffers.add(buf);
                gotten = true;
            }
            ++i;
        }
        return gotten;
    }

    private boolean doUnsharpMask(IVideoBuffer[][] srcAndSrp, List<IVideoBuffer> buffers) {
        Resolution resolution = this.context.getVideoResolution();
        double amount = (Double)this.context.value((IAnimatableValue)this.unsharpMaskAmount) / 100.0;
        double radius = resolution.scale(((Double)this.context.value((IAnimatableValue)this.unsharpMaskRadius)).doubleValue());
        boolean fast = true;
        if (amount == 0.0 || radius == 0.0) {
            srcAndSrp[1] = srcAndSrp[0];
            return false;
        }
        int i = 0;
        while (i < 4) {
            IVideoBuffer src = srcAndSrp[0][i];
            if (src != null) {
                IVideoBuffer blur = this.blurSupport.gaussianBlur(src, radius, IBlurSupport.BlurDimensions.BOTH, true, fast);
                try {
                    HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
                    uniforms.add(new GLUniformData("srcTex", 0));
                    uniforms.add(new GLUniformData("blrTex", 1));
                    uniforms.add(new GLUniformData("amount", (float)amount));
                    srcAndSrp[1][i] = this.support.useShaderProgram(this.unsharpMaskProgram, uniforms, null, new IVideoBuffer[]{src, blur});
                    buffers.add(srcAndSrp[1][i]);
                }
                finally {
                    blur.dispose();
                }
            }
            ++i;
        }
        return true;
    }

    private void disposeSourceBuffers(IVideoBuffer[] sources, List<IVideoBuffer> buffers, Output output) {
        int o = output.ordinal() - Output.RESULT_FROM_STAGE1.ordinal();
        int i = 0;
        while (i < 4) {
            IVideoBuffer src;
            if (i != o && (src = sources[i]) != null) {
                src.dispose();
                sources[i] = null;
                buffers.remove(src);
            }
            ++i;
        }
    }

    private void disposeSharpedBuffers(IVideoBuffer[] sharped, List<IVideoBuffer> buffers, Output output) {
        int o = output.ordinal() - Output.RESULT_FROM_STAGE1_UM.ordinal();
        int i = 0;
        while (i < 4) {
            IVideoBuffer srp;
            if (i != o && (srp = sharped[i]) != null) {
                srp.dispose();
                sharped[i] = null;
                buffers.remove(srp);
            }
            ++i;
        }
    }

    private IVideoBuffer createDiff(IVideoBuffer[] sharped, List<IVideoBuffer> buffers) {
        double threshold = (Double)this.context.value((IAnimatableValue)this.differenceThreshold) / 1000.0;
        double cutoff = (Double)this.context.value((IAnimatableValue)this.differenceCutoff) / 1000.0;
        Color pupilColor = (Color)this.context.value((IAnimatableValue)this.pupilColor);
        Color scleraColor = (Color)this.context.value((IAnimatableValue)this.scleraColor);
        Color fleshColor1 = null;
        Color fleshColor2 = null;
        UseFleshColor useFleshColor = (UseFleshColor)((Object)this.context.value(this.useFleshColor));
        switch (useFleshColor) {
            case FLESH_COLOR_1: {
                fleshColor1 = (Color)this.context.value((IAnimatableValue)this.fleshColor1);
                break;
            }
            case FLESH_COLOR_2: {
                fleshColor1 = (Color)this.context.value((IAnimatableValue)this.fleshColor2);
                break;
            }
            default: {
                fleshColor1 = (Color)this.context.value((IAnimatableValue)this.fleshColor1);
                fleshColor2 = (Color)this.context.value((IAnimatableValue)this.fleshColor2);
            }
        }
        double detectEyeColor = (Double)this.context.value((IAnimatableValue)this.detectEyeColor) / 1000.0;
        ArrayList<IVideoBuffer> srpList = new ArrayList<IVideoBuffer>();
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        int i = 0;
        while (i < 4) {
            if (sharped[i] != null) {
                srpList.add(sharped[i]);
                int j = srpList.size();
                uniforms.add(new GLUniformData("texture" + j, j - 1));
            }
            ++i;
        }
        uniforms.add(new GLUniformData("threshold", (float)threshold));
        uniforms.add(new GLUniformData("t_minus_c", (float)(threshold - cutoff)));
        uniforms.add(new GLUniformData("pupilColor", 3, this.toFloatBuffer(pupilColor.r, pupilColor.g, pupilColor.b)));
        uniforms.add(new GLUniformData("scleraColor", 3, this.toFloatBuffer(scleraColor.r, scleraColor.g, scleraColor.b)));
        uniforms.add(new GLUniformData("fleshColor1", 3, this.toFloatBuffer(fleshColor1.r, fleshColor1.g, fleshColor1.b)));
        uniforms.add(new GLUniformData("detectEyeColor", (float)detectEyeColor));
        if (fleshColor2 != null) {
            uniforms.add(new GLUniformData("fleshColor2", 3, this.toFloatBuffer(fleshColor2.r, fleshColor2.g, fleshColor2.b)));
        }
        IShaderProgram program = this.getDiffProgram(srpList.size(), fleshColor2 != null);
        IVideoBuffer diff = this.support.useShaderProgram(program, uniforms, null, srpList.toArray(new IVideoBuffer[srpList.size()]));
        buffers.add(diff);
        return diff;
    }

    private IVideoBuffer createEdge(VideoBounds bounds, IVideoBuffer[] sharped, List<IVideoBuffer> buffers) {
        IVideoBuffer edge = this.context.createVideoBuffer(bounds);
        buffers.add(edge);
        edge.clear(Color.BLACK);
        this.addEdgeAndBlinkMask(sharped, false, edge);
        return edge;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addEdgeAndBlinkMask(IVideoBuffer[] sharped, boolean addBlinkMask, IVideoBuffer dstbuf) {
        bounds = dstbuf.getBounds();
        dx = 1.0 / (double)bounds.width;
        dy = 1.0 / (double)bounds.height;
        offset = this.toFloatBuffer(new double[]{-dx, -dy, 0.0, -dy, dx, -dy, -dx, 0.0, dx, 0.0, -dx, dy, 0.0, dy, dx, dy});
        buffers = new ArrayList<IVideoBuffer>();
        try {
            i = 0;
            while (i < 4) {
                srp = sharped[i];
                if (srp != null) {
                    uniforms = new HashSet<GLUniformData>();
                    uniforms.add(new GLUniformData("texture", 0));
                    luma = this.support.useShaderProgram(this.luminosityProgram, uniforms, null, new IVideoBuffer[]{srp});
                    try {
                        luma.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE);
                        uniforms.clear();
                        uniforms.add(new GLUniformData("texture", 0));
                        uniforms.add(new GLUniformData("offset[0]", 2, offset));
                        buffers.add(this.support.useShaderProgram(this.gradientProgram, uniforms, null, new IVideoBuffer[]{luma}));
                    }
                    finally {
                        luma.dispose();
                    }
                }
                ++i;
            }
            threshold = (Double)this.context.value((IAnimatableValue)this.edgeThreshold) / 100.0;
            uniforms = new HashSet<E>();
            i = 0;
            while (i < buffers.size()) {
                uniforms.add(new GLUniformData("texture" + (i + 1), i));
                ++i;
            }
            uniforms.add(new GLUniformData("threshold", (float)threshold));
            uniforms.add(new GLUniformData("offset[0]", 2, offset));
            v0 = blinkMask = addBlinkMask != false ? this.context.getLayerVideoFrame(this.blinkMask) : null;
            if (blinkMask != null) {
                buffers.add(blinkMask);
                uniforms.add(new GLUniformData("blinkMask", buffers.size() - 1));
            } else {
                addBlinkMask = false;
            }
            operation = new Runnable(){

                public void run() {
                    GL2 gl = Imas2StageDifferenceKey2.this.context.getGL().getGL2();
                    gl.glEnable(3042);
                    gl.glBlendFuncSeparate(1, 1, 1, 0);
                    gl.glBlendEquation(32774);
                    Imas2StageDifferenceKey2.this.support.ortho2D(bounds);
                    Imas2StageDifferenceKey2.this.support.quad2D(bounds, (double[][][])new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}}});
                }
            };
            program = addBlinkMask != false ? this.getEdgeProgram(buffers.size() - 1, true) : this.getEdgeProgram(buffers.size(), false);
            pushAttribs = 24576;
            this.support.useShaderProgram(program, uniforms, operation, pushAttribs, dstbuf, buffers.toArray(new IVideoBuffer[buffers.size()]));
            var19_20 = addBlinkMask;
            return var19_20;
        }
        finally {
            ** for (buf : buffers)
        }
lbl-1000:
        // 1 sources

        {
            buf.dispose();
            continue;
        }
lbl62:
        // 1 sources

        return var19_20;
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] farray = new float[values.length];
        int i = 0;
        while (i < values.length) {
            farray[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(farray);
    }

    private void doRegionFilters(IVideoBuffer diffAndEdge, boolean hasBlinkMask, List<IVideoBuffer> buffers, boolean preview) {
        block16: {
            boolean filter2Enabled;
            Resolution resolution = this.context.getVideoResolution();
            double minEdgeCoverage = (Double)this.context.value((IAnimatableValue)this.minEdgeCoverage) / 100.0;
            double minRegionSize = resolution.scale(resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.minRegionSize)).intValue()));
            double maxEyeSize = resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.maxEyeSize)).intValue());
            double blinkThresholdEdge = (Double)this.context.value((IAnimatableValue)this.blinkThresholdEdge) / 100.0;
            double blinkThresholdColor = (Double)this.context.value((IAnimatableValue)this.blinkThresholdColor) / 100.0;
            boolean filter1Enabled = minEdgeCoverage > 0.0 || minRegionSize > 0.0;
            boolean bl = filter2Enabled = maxEyeSize > 0.0;
            if (filter1Enabled || filter2Enabled) {
                MatteSetter ms;
                switch (diffAndEdge.getColorMode()) {
                    case RGBA8: {
                        class MatteSetter8
                        implements MatteSetter {
                            final byte[] b;

                            MatteSetter8(IVideoBuffer iVideoBuffer) {
                                this.b = (byte[])iVideoBuffer.getArray();
                            }

                            public void set(int i) {
                                this.b[i * 4 + 2] = this.b[i * 4 + 3];
                            }

                            public void set2(int i) {
                                this.b[i * 4 + 2] = -1;
                                this.b[i * 4 + 1] = -1;
                                this.b[i * 4] = -1;
                            }

                            public void clear(int i) {
                                this.b[i * 4 + 2] = 0;
                            }
                        }
                        ms = hasBlinkMask ? new MatteSetter8(diffAndEdge) : new MatteSetter8(diffAndEdge){
                            {
                                super(iVideoBuffer);
                            }

                            public void set(int i) {
                                this.b[i * 4 + 2] = -1;
                            }
                        };
                        break;
                    }
                    case RGBA16: {
                        class MatteSetter16
                        implements MatteSetter {
                            final short[] s;

                            MatteSetter16(IVideoBuffer iVideoBuffer) {
                                this.s = (short[])iVideoBuffer.getArray();
                            }

                            public void set(int i) {
                                this.s[i * 4 + 2] = this.s[i * 4 + 3];
                            }

                            public void set2(int i) {
                                this.s[i * 4 + 2] = -1;
                                this.s[i * 4 + 1] = -1;
                                this.s[i * 4] = -1;
                            }

                            public void clear(int i) {
                                this.s[i * 4 + 2] = 0;
                            }
                        }
                        ms = hasBlinkMask ? new MatteSetter16(diffAndEdge) : new MatteSetter16(diffAndEdge){
                            {
                                super(iVideoBuffer);
                            }

                            public void set(int i) {
                                this.s[i * 4 + 2] = -1;
                            }
                        };
                        break;
                    }
                    default: {
                        class MatteSetterF
                        implements MatteSetter {
                            final float[] f;

                            MatteSetterF(IVideoBuffer iVideoBuffer) {
                                this.f = (float[])iVideoBuffer.getArray();
                            }

                            public void set(int i) {
                                this.f[i * 4 + 2] = this.f[i * 4 + 3];
                            }

                            public void set2(int i) {
                                this.f[i * 4 + 2] = 1.0f;
                                this.f[i * 4 + 1] = 1.0f;
                                this.f[i * 4] = 1.0f;
                            }

                            public void clear(int i) {
                                this.f[i * 4 + 2] = 0.0f;
                            }
                        }
                        ms = hasBlinkMask ? new MatteSetterF(diffAndEdge) : new MatteSetterF(diffAndEdge){
                            {
                                super(iVideoBuffer);
                            }

                            public void set(int i) {
                                this.f[i * 4 + 2] = 1.0f;
                            }
                        };
                    }
                }
                RegionData data = new RegionData(diffAndEdge, hasBlinkMask);
                try {
                    if (filter1Enabled) {
                        RegionFilter1 filter1 = new RegionFilter1(data);
                        try {
                            filter1.filter(minEdgeCoverage, minRegionSize, ms);
                        }
                        finally {
                            filter1.dispose();
                        }
                    }
                    if (!filter2Enabled) break block16;
                    RegionFilter2 filter2 = new RegionFilter2(data);
                    try {
                        filter2.filter(maxEyeSize, blinkThresholdEdge, blinkThresholdColor, hasBlinkMask, ms, preview);
                    }
                    finally {
                        filter2.dispose();
                    }
                }
                finally {
                    data.dispose();
                }
            }
        }
    }

    private IVideoBuffer toMatteBuffer(IVideoBuffer diffAndEdge, List<IVideoBuffer> buffers) {
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("texture", 0));
        IVideoBuffer matteBuffer = this.support.useShaderProgram(this.toMatteProgram, uniforms, null, new IVideoBuffer[]{diffAndEdge});
        buffers.add(matteBuffer);
        return matteBuffer;
    }

    private boolean isStage(Output output) {
        int o = output.ordinal();
        return o >= Output.STAGE1.ordinal() && o <= Output.STAGE4.ordinal();
    }

    private boolean isStageUM(Output output) {
        int o = output.ordinal();
        return o >= Output.STAGE1_UM.ordinal() && o <= Output.STAGE4_UM.ordinal();
    }

    private boolean isResult(Output output) {
        int o = output.ordinal();
        return o >= Output.RESULT_FROM_STAGE1.ordinal() && o <= Output.RESULT_FROM_STAGE4.ordinal();
    }

    private boolean isResultUM(Output output) {
        int o = output.ordinal();
        return o >= Output.RESULT_FROM_STAGE1_UM.ordinal() && o <= Output.RESULT_FROM_STAGE4_UM.ordinal();
    }

    private IVideoBuffer quit(IVideoBuffer outbuf, List<IVideoBuffer> buffers) {
        buffers.remove(outbuf);
        return outbuf;
    }

    private IVideoBuffer blank(VideoBounds bounds) {
        IVideoBuffer buffer = null;
        try {
            buffer = this.context.createVideoBuffer(bounds);
            buffer.clear();
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private IShaderProgram getDiffProgram(int n, boolean twoFleshColors) {
        String programName = String.valueOf(Imas2StageDifferenceKey2.class.getName()) + ".DIFF_" + n + (twoFleshColors ? "_TWO_FLESH_COLORS" : "");
        IShaderProgram program = this.shaders.getProgram(programName);
        if (program == null) {
            String[] source = this.createDiffProgramSource(n, twoFleshColors);
            program = this.shaders.registerProgram(programName, ShaderType.FRAGMENT_SHADER, null, source);
        }
        return program;
    }

    private String[] createDiffProgramSource(int n, boolean twoFleshColors) {
        if (n < 2 || n > 4) {
            throw new IllegalArgumentException();
        }
        boolean tfc = twoFleshColors;
        return new String[]{"#define N " + n, tfc ? "#define TWO_FLESH_COLORS" : "", "", "uniform sampler2D texture1;", "uniform sampler2D texture2;", "", "#if N >= 3", "\tuniform sampler2D texture3;", "#endif", "", "#if N >= 4", "\tuniform sampler2D texture4;", "#endif", "", "uniform float threshold;", "uniform float t_minus_c;", "", "uniform vec3 pupilColor;", "uniform vec3 scleraColor;", "uniform vec3 fleshColor1;", "uniform float detectEyeColor;", "", "#ifdef TWO_FLESH_COLORS", "\tuniform vec3 fleshColor2;", "#endif", "", "float eyeColorDiff(vec3 color)", "{", "\tfloat pupil  = distance(color, pupilColor);", "\tfloat sclera = distance(color, scleraColor);", "\tfloat flesh1 = distance(color, fleshColor1);", "", "#ifdef TWO_FLESH_COLORS", "\tfloat flesh2 = distance(color, fleshColor2);", "\treturn min(min(pupil, sclera), min(flesh1, flesh2));", "#else", "\treturn min(min(pupil, sclera), flesh1);", "#endif", "}", "", "void main(void)", "{", "\tvec2 tc = gl_TexCoord[0].st;", "\tvec3 sum;", "\tfloat sum2;", "\tfloat sum3;", "", "\tvec4 color1 = texture2D(texture1, tc);", "\tcolor1.rgb = (color1.a > 0.0) ? color1.rgb/color1.a : vec3(0.0);", "\tsum = color1.rgb;", "\tsum2 = dot(color1.rgb, color1.rgb);", "\tsum3 = eyeColorDiff(color1.rgb);", "", "\tvec4 color2 = texture2D(texture2, tc);", "\tcolor2.rgb = (color2.a > 0.0) ? color2.rgb/color2.a : vec3(0.0);", "\tsum += color2.rgb;", "\tsum2 += dot(color2.rgb, color2.rgb);", "\tsum3 += eyeColorDiff(color2.rgb);", "", "#if N >= 3", "\tvec4 color3 = texture2D(texture3, tc);", "\tcolor3.rgb = (color3.a > 0.0) ? color3.rgb/color3.a : vec3(0.0);", "\tsum += color3.rgb;", "\tsum2 += dot(color3.rgb, color3.rgb);", "\tsum3 += eyeColorDiff(color3.rgb);", "#endif", "", "#if N >= 4", "\tvec4 color4 = texture2D(texture4, tc);", "\tcolor4.rgb = (color4.a > 0.0) ? color4.rgb/color4.a : vec3(0.0);", "\tsum += color4.rgb;", "\tsum2 += dot(color4.rgb, color4.rgb);", "\tsum3 += eyeColorDiff(color4.rgb);", "#endif", "", "\tvec3 avg = sum / float(N);", "\tfloat variance = max(sum2 / float(N) - dot(avg, avg), 0.0);", "\tfloat red = clamp((threshold-sqrt(variance))/t_minus_c, 0.0, 1.0);", "", "\tfloat blue = 1.0 - step(detectEyeColor, sum3/float(N));", "", "\tgl_FragColor = vec4(red, 0.0, blue, 1.0);", "}"};
    }

    private IShaderProgram getEdgeProgram(int n, boolean withBlinkMask) {
        String programName = String.valueOf(Imas2StageDifferenceKey2.class.getName()) + ".EDGE_" + n + (withBlinkMask ? "_BLINKMASK" : "");
        IShaderProgram program = this.shaders.getProgram(programName);
        if (program == null) {
            String[] source = Imas2StageDifferenceKey2.createEdgeProgramSource(n, withBlinkMask);
            program = this.shaders.registerProgram(programName, ShaderType.FRAGMENT_SHADER, null, source);
        }
        return program;
    }

    private static String[] createEdgeProgramSource(int n, boolean withBlinkMask) {
        if (n < 2 || n > 4) {
            throw new IllegalArgumentException();
        }
        boolean b = withBlinkMask;
        return new String[]{"#define N " + n, b ? "#define BLINKMASK" : "", "", "uniform sampler2D texture1;", "uniform sampler2D texture2;", "", "#if N >= 3", "\tuniform sampler2D texture3;", "#endif", "", "#if N >= 4", "\tuniform sampler2D texture4;", "#endif", "", "uniform float threshold;", "uniform vec2 offset[8];", "", "#ifdef BLINKMASK", "\tuniform sampler2D blinkMask;", "#endif", "", "float grad(sampler2D texture, vec2 tc)", "{", "\tfloat grad = texture2D(texture, tc).r;", "\tif (grad != 0.0 && (", "\t\t\t   texture2D(texture, tc+offset[0]).g != 0.0", "\t\t\t|| texture2D(texture, tc+offset[1]).g != 0.0", "\t\t\t|| texture2D(texture, tc+offset[2]).g != 0.0", "\t\t\t|| texture2D(texture, tc+offset[3]).g != 0.0", "\t\t\t|| texture2D(texture, tc+offset[4]).g != 0.0", "\t\t\t|| texture2D(texture, tc+offset[5]).g != 0.0", "\t\t\t|| texture2D(texture, tc+offset[6]).g != 0.0", "\t\t\t|| texture2D(texture, tc+offset[7]).g != 0.0)) {", "\t\treturn grad;", "\t} else {", "\t\treturn 0.0;", "\t}", "}", "", "void main(void)", "{", "\tvec2 tc = gl_TexCoord[0].st;", "\tfloat sum = grad(texture1, tc)", "\t\t\t  + grad(texture2, tc)", "#if N >= 3", "\t\t\t  + grad(texture3, tc)", "#endif", "#if N >= 4", "\t\t\t  + grad(texture4, tc)", "#endif", "\t\t;", "", "\tfloat green = step(threshold, sum/float(N));", "#ifdef BLINKMASK", "\tfloat alpha = texture2D(blinkMask, tc).a;", "\tgl_FragColor = vec4(0.0, green, 0.0, alpha);", "#else", "\tgl_FragColor = vec4(0.0, green, 0.0, 1.0);", "#endif", "}"};
    }

    private IArray<int[]> expandArray(IArray<int[]> oldArray) {
        try {
            IArray newArray = this.arrayPools.getIntArray(oldArray.getLength() * 2);
            System.arraycopy(oldArray.getArray(), 0, newArray.getArray(), 0, oldArray.getLength());
            IArray iArray = newArray;
            return iArray;
        }
        finally {
            oldArray.release();
        }
    }

    private static interface MatteSetter {
        public void set(int var1);

        public void set2(int var1);

        public void clear(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Output {
        RESULT_FROM_STAGE1,
        RESULT_FROM_STAGE2,
        RESULT_FROM_STAGE3,
        RESULT_FROM_STAGE4,
        RESULT_FROM_STAGE1_UM,
        RESULT_FROM_STAGE2_UM,
        RESULT_FROM_STAGE3_UM,
        RESULT_FROM_STAGE4_UM,
        MATTE_ONLY,
        STAGE1,
        STAGE2,
        STAGE3,
        STAGE4,
        STAGE1_UM,
        STAGE2_UM,
        STAGE3_UM,
        STAGE4_UM,
        DIFF,
        EDGE,
        DIFF_AND_EDGE_1,
        DIFF_AND_EDGE_2;

    }

    private class RegionData {
        private final VideoBounds bounds;
        private final IArray<byte[]> dataIA;
        private final byte[] data;

        RegionData(IVideoBuffer diffAndEdge, boolean hasBlinkMask) {
            this.bounds = diffAndEdge.getBounds();
            int len = this.bounds.width * this.bounds.height;
            this.dataIA = Imas2StageDifferenceKey2.this.arrayPools.getByteArray(len);
            this.data = (byte[])this.dataIA.getArray();
            this.initData(diffAndEdge, hasBlinkMask);
        }

        private void initData(IVideoBuffer buffer, boolean hasBlinkMask) {
            abstract class ArrayToData {
                ArrayToData() {
                }

                abstract byte toData(int var1);

                byte toData(int r, int g, int b, int a) {
                    return (byte)((r != 0 ? 33 : 0) + (g != 0 ? 2 : 0) + (b != 0 ? 4 : 0) + (a != 0 ? 16 : 0));
                }

                byte toData(int r, int g, int b) {
                    return (byte)((r != 0 ? 33 : 0) + (g != 0 ? 2 : 0) + (b != 0 ? 4 : 0) + 16);
                }

                byte toData(float r, float g, float b, float a) {
                    return (byte)((r != 0.0f ? 33 : 0) + (g != 0.0f ? 2 : 0) + (b != 0.0f ? 4 : 0) + (a != 0.0f ? 16 : 0));
                }

                byte toData(float r, float g, float b) {
                    return (byte)((r != 0.0f ? 33 : 0) + (g != 0.0f ? 2 : 0) + (b != 0.0f ? 4 : 0) + 16);
                }
            }
            ArrayToData a2d;
            switch (buffer.getColorMode()) {
                case RGBA8: {
                    final byte[] b = (byte[])buffer.getArray();
                    a2d = hasBlinkMask ? new ArrayToData(){
                        {
                        }

                        byte toData(int i) {
                            return this.toData(b[i * 4 + 2], b[i * 4 + 1], b[i * 4], b[i * 4 + 3]);
                        }
                    } : new ArrayToData(){
                        {
                        }

                        byte toData(int i) {
                            return this.toData(b[i * 4 + 2], b[i * 4 + 1], b[i * 4]);
                        }
                    };
                    break;
                }
                case RGBA16: {
                    final short[] s = (short[])buffer.getArray();
                    a2d = hasBlinkMask ? new ArrayToData(){
                        {
                        }

                        byte toData(int i) {
                            return this.toData(s[i * 4 + 2], s[i * 4 + 1], s[i * 4], s[i * 4 + 3]);
                        }
                    } : new ArrayToData(){
                        {
                        }

                        byte toData(int i) {
                            return this.toData(s[i * 4 + 2], s[i * 4 + 1], s[i * 4]);
                        }
                    };
                    break;
                }
                default: {
                    final float[] f = (float[])buffer.getArray();
                    a2d = hasBlinkMask ? new ArrayToData(){
                        {
                        }

                        byte toData(int i) {
                            return this.toData(f[i * 4 + 2], f[i * 4 + 1], f[i * 4], f[i * 4 + 3]);
                        }
                    } : new ArrayToData(){
                        {
                        }

                        byte toData(int i) {
                            return this.toData(f[i * 4 + 2], f[i * 4 + 1], f[i * 4]);
                        }
                    };
                }
            }
            int len = this.dataIA.getLength();
            int i = 0;
            while (i < len) {
                this.data[i] = a2d.toData(i);
                ++i;
            }
        }

        void dispose() {
            this.dataIA.release();
        }
    }

    private class RegionFilter1 {
        private final VideoBounds bounds;
        private final byte[] data;
        private final IArray<int[]> regionLabelsIA;
        private final int[] regionLabels;
        private int regionCount;
        private IArray<int[]> regionSizesIA;
        private int[] regionSizes;
        private IArray<int[]> regionBoundsIA;
        private int[] regionBounds;
        private IArray<int[]> edgeLengthsIA;
        private int[] edgeLengths;
        private IArray<int[]> edgeCoveragesIA;
        private int[] edgeCoverages;

        RegionFilter1(RegionData data) {
            this.bounds = data.bounds;
            this.data = data.data;
            this.regionLabelsIA = Imas2StageDifferenceKey2.this.arrayPools.getIntArray(data.dataIA.getLength());
            this.regionLabels = (int[])this.regionLabelsIA.getArray();
            this.regionSizesIA = Imas2StageDifferenceKey2.this.arrayPools.getIntArray(4096);
            this.regionSizes = (int[])this.regionSizesIA.getArray();
            this.regionSizes[0] = 0;
            this.regionBoundsIA = Imas2StageDifferenceKey2.this.arrayPools.getIntArray(16384);
            this.regionBounds = (int[])this.regionBoundsIA.getArray();
            this.edgeLengthsIA = Imas2StageDifferenceKey2.this.arrayPools.getIntArray(4096);
            this.edgeLengths = (int[])this.edgeLengthsIA.getArray();
            this.edgeCoveragesIA = Imas2StageDifferenceKey2.this.arrayPools.getIntArray(4096);
            this.edgeCoverages = (int[])this.edgeCoveragesIA.getArray();
        }

        void dispose() {
            this.regionLabelsIA.release();
            this.regionSizesIA.release();
            this.regionBoundsIA.release();
            this.edgeLengthsIA.release();
            this.edgeCoveragesIA.release();
        }

        void filter(double minEdgeCoverage, double minRegionSize, MatteSetter matteSetter) {
            int p;
            int w = this.bounds.width;
            int w1 = this.bounds.width - 1;
            int h1 = this.bounds.height - 1;
            this.add(0, 0, 0, (byte)0, (byte)0, this.data[0], this.data[1], this.data[w]);
            int x = 1;
            while (x < w1) {
                this.add(x, 0, this.regionLabels[x - 1], (byte)0, this.data[x - 1], this.data[x], this.data[x + 1], this.data[x + w]);
                ++x;
            }
            this.add(w1, 0, this.regionLabels[w1 - 1], (byte)0, this.data[w1 - 1], this.data[w1], (byte)0, this.data[w1 + w]);
            int y = 1;
            while (y < h1) {
                p = y * w;
                this.add(p, this.regionLabels[p - w], 0, this.data[p - w], (byte)0, this.data[p], this.data[p + 1], this.data[p + w]);
                int x2 = 1;
                while (x2 < w1) {
                    p = y * w + x2;
                    this.add(p, this.regionLabels[p - w], this.regionLabels[p - 1], this.data[p - w], this.data[p - 1], this.data[p], this.data[p + 1], this.data[p + w]);
                    ++x2;
                }
                this.add(++p, this.regionLabels[p - w], this.regionLabels[p - 1], this.data[p - w], this.data[p - 1], this.data[p], (byte)0, this.data[p + w]);
                ++y;
            }
            p = h1 * w;
            this.add(p, this.regionLabels[p - w], 0, this.data[p - w], (byte)0, this.data[p], this.data[p + 1], (byte)0);
            x = 1;
            while (x < w1) {
                p = h1 * w + x;
                this.add(p, this.regionLabels[p - w], this.regionLabels[p - 1], this.data[p - w], this.data[p - 1], this.data[p], this.data[p + 1], (byte)0);
                ++x;
            }
            this.add(++p, this.regionLabels[p - w], this.regionLabels[p - 1], this.data[p - w], this.data[p - 1], this.data[p], (byte)0, (byte)0);
            int i = 1;
            while (i <= this.regionCount) {
                int regionSize;
                int label = i;
                while ((regionSize = this.regionSizes[label]) < 0) {
                    label = -regionSize;
                }
                if (label != i) {
                    this.regionSizes[i] = -label;
                }
                ++i;
            }
            i = 1;
            while (i <= this.regionCount) {
                int regionSize = this.regionSizes[i];
                if (regionSize > 0 && ((double)regionSize < minRegionSize || (double)this.edgeCoverages[i] < (double)this.edgeLengths[i] * minEdgeCoverage)) {
                    int left = this.regionBounds[i * 4];
                    int top = this.regionBounds[i * 4 + 1];
                    int right = this.regionBounds[i * 4 + 2];
                    int bottom = this.regionBounds[i * 4 + 3];
                    int y2 = top;
                    while (y2 < bottom) {
                        int x3 = left;
                        while (x3 < right) {
                            int j = y2 * this.bounds.width + x3;
                            int label = this.regionLabels[j];
                            int size = this.regionSizes[label];
                            if (size < 0) {
                                label = -size;
                            }
                            if (label == i) {
                                int n = j;
                                this.data[n] = (byte)(this.data[n] & 0xFFFFFFDF);
                                matteSetter.clear(j);
                            }
                            ++x3;
                        }
                        ++y2;
                    }
                }
                ++i;
            }
        }

        private void add(int pxIndex, int upperLabel, int leftLabel, byte upper, byte left, byte center, byte right, byte lower) {
            boolean edge;
            if ((center & 1) == 0) {
                this.regionLabels[pxIndex] = 0;
                return;
            }
            int x = pxIndex % this.bounds.width;
            int y = pxIndex / this.bounds.width;
            int label = 0;
            if (upperLabel > 0 && leftLabel > 0 && upperLabel != leftLabel) {
                while (this.regionSizes[upperLabel] < 0) {
                    upperLabel = -this.regionSizes[upperLabel];
                }
                while (this.regionSizes[leftLabel] < 0) {
                    leftLabel = -this.regionSizes[leftLabel];
                }
                if (leftLabel != upperLabel) {
                    int n = upperLabel;
                    this.regionSizes[n] = this.regionSizes[n] + this.regionSizes[leftLabel];
                    this.regionSizes[leftLabel] = -upperLabel;
                    this.regionBounds[upperLabel * 4] = Math.min(this.regionBounds[upperLabel * 4], this.regionBounds[leftLabel * 4]);
                    this.regionBounds[upperLabel * 4 + 1] = Math.min(this.regionBounds[upperLabel * 4 + 1], this.regionBounds[leftLabel * 4 + 1]);
                    this.regionBounds[upperLabel * 4 + 2] = Math.max(this.regionBounds[upperLabel * 4 + 2], this.regionBounds[leftLabel * 4 + 2]);
                    this.regionBounds[upperLabel * 4 + 3] = Math.max(this.regionBounds[upperLabel * 4 + 3], this.regionBounds[leftLabel * 4 + 3]);
                    int n2 = upperLabel;
                    this.edgeLengths[n2] = this.edgeLengths[n2] + this.edgeLengths[leftLabel];
                    int n3 = upperLabel;
                    this.edgeCoverages[n3] = this.edgeCoverages[n3] + this.edgeCoverages[leftLabel];
                }
                label = upperLabel;
            } else if (upperLabel > 0) {
                label = upperLabel;
            } else if (leftLabel > 0) {
                label = leftLabel;
            }
            if (label > 0) {
                while (this.regionSizes[label] < 0) {
                    label = -this.regionSizes[label];
                }
                this.regionLabels[pxIndex] = label;
                int n = label;
                this.regionSizes[n] = this.regionSizes[n] + 1;
                this.regionBounds[label * 4] = Math.min(this.regionBounds[label * 4], x);
                this.regionBounds[label * 4 + 1] = Math.min(this.regionBounds[label * 4 + 1], y);
                this.regionBounds[label * 4 + 2] = Math.max(this.regionBounds[label * 4 + 2], x + 1);
                this.regionBounds[label * 4 + 3] = Math.max(this.regionBounds[label * 4 + 3], y + 1);
            } else {
                if (this.regionSizesIA.getLength() - 1 == this.regionCount) {
                    this.regionSizesIA = Imas2StageDifferenceKey2.this.expandArray((IArray<int[]>)this.regionSizesIA);
                    this.regionSizes = (int[])this.regionSizesIA.getArray();
                    this.regionBoundsIA = Imas2StageDifferenceKey2.this.expandArray((IArray<int[]>)this.regionBoundsIA);
                    this.regionBounds = (int[])this.regionBoundsIA.getArray();
                    this.edgeLengthsIA = Imas2StageDifferenceKey2.this.expandArray((IArray<int[]>)this.edgeLengthsIA);
                    this.edgeLengths = (int[])this.edgeLengthsIA.getArray();
                    this.edgeCoveragesIA = Imas2StageDifferenceKey2.this.expandArray((IArray<int[]>)this.edgeCoveragesIA);
                    this.edgeCoverages = (int[])this.edgeCoveragesIA.getArray();
                }
                this.regionLabels[pxIndex] = label = ++this.regionCount;
                this.regionSizes[label] = 1;
                this.regionBounds[label * 4] = x;
                this.regionBounds[label * 4 + 1] = y;
                this.regionBounds[label * 4 + 2] = x + 1;
                this.regionBounds[label * 4 + 3] = y + 1;
                this.edgeLengths[label] = 0;
                this.edgeCoverages[label] = 0;
            }
            boolean bl = edge = (center & 2) != 0;
            if ((upper & 1) == 0) {
                int n = label;
                this.edgeLengths[n] = this.edgeLengths[n] + 1;
                if (edge || (upper & 2) != 0) {
                    int n4 = label;
                    this.edgeCoverages[n4] = this.edgeCoverages[n4] + 1;
                }
            }
            if ((left & 1) == 0) {
                int n = label;
                this.edgeLengths[n] = this.edgeLengths[n] + 1;
                if (edge || (left & 2) != 0) {
                    int n5 = label;
                    this.edgeCoverages[n5] = this.edgeCoverages[n5] + 1;
                }
            }
            if ((right & 1) == 0) {
                int n = label;
                this.edgeLengths[n] = this.edgeLengths[n] + 1;
                if (edge || (right & 2) != 0) {
                    int n6 = label;
                    this.edgeCoverages[n6] = this.edgeCoverages[n6] + 1;
                }
            }
            if ((lower & 1) == 0) {
                int n = label;
                this.edgeLengths[n] = this.edgeLengths[n] + 1;
                if (edge || (lower & 2) != 0) {
                    int n7 = label;
                    this.edgeCoverages[n7] = this.edgeCoverages[n7] + 1;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RegionFilter2 {
        private final VideoBounds bounds;
        private final byte[] data;
        private final IArray<int[]> regionLabels1IA;
        private final int[] regionLabels1;
        private int regionCount1;
        private int actualRegionCount1;
        private IArray<int[]> regionSizes1IA;
        private int[] regionSizes1;
        private IArray<int[]> regionBounds1IA;
        private int[] regionBounds1;
        private final IArray<int[]> regionLabels2IA;
        private final int[] regionLabels2;
        private int regionCount2;
        private int actualRegionCount2;
        private IArray<int[]> regionSizes2IA;
        private int[] regionSizes2;
        private IArray<int[]> regionBounds2IA;
        private int[] regionBounds2;

        RegionFilter2(RegionData data) {
            this.bounds = data.bounds;
            this.data = data.data;
            this.regionLabels1IA = Imas2StageDifferenceKey2.this.arrayPools.getIntArray(data.dataIA.getLength());
            this.regionLabels1 = (int[])this.regionLabels1IA.getArray();
            this.regionSizes1IA = Imas2StageDifferenceKey2.this.arrayPools.getIntArray(4096);
            this.regionSizes1 = (int[])this.regionSizes1IA.getArray();
            this.regionSizes1[0] = 0;
            this.regionBounds1IA = Imas2StageDifferenceKey2.this.arrayPools.getIntArray(20480);
            this.regionBounds1 = (int[])this.regionBounds1IA.getArray();
            this.regionLabels2IA = Imas2StageDifferenceKey2.this.arrayPools.getIntArray(data.dataIA.getLength());
            this.regionLabels2 = (int[])this.regionLabels2IA.getArray();
            this.regionSizes2IA = Imas2StageDifferenceKey2.this.arrayPools.getIntArray(4096);
            this.regionSizes2 = (int[])this.regionSizes2IA.getArray();
            this.regionSizes2[0] = 0;
            this.regionBounds2IA = Imas2StageDifferenceKey2.this.arrayPools.getIntArray(20480);
            this.regionBounds2 = (int[])this.regionBounds2IA.getArray();
        }

        void dispose() {
            this.regionLabels1IA.release();
            this.regionSizes1IA.release();
            this.regionBounds1IA.release();
            this.regionLabels2IA.release();
            this.regionSizes2IA.release();
            this.regionBounds2IA.release();
        }

        void filter(double maxEyeSize, double blinkThresholdEdge, double blinkThresholdColor, boolean hasBlinkMask, MatteSetter matteSetter, boolean preview) {
            int p;
            int w = this.bounds.width;
            int w1 = this.bounds.width - 1;
            int h1 = this.bounds.height - 1;
            this.add1(0, 0, 0, this.data[0]);
            this.add2(0, 0, 0, this.data[0]);
            int x = 1;
            while (x < w1) {
                this.add1(x, 0, this.regionLabels1[x - 1], this.data[x]);
                this.add2(x, 0, this.regionLabels2[x - 1], this.data[x]);
                ++x;
            }
            this.add1(w1, 0, this.regionLabels1[w1 - 1], this.data[w1]);
            this.add2(w1, 0, this.regionLabels2[w1 - 1], this.data[w1]);
            int y = 1;
            while (y < h1) {
                p = y * w;
                this.add1(p, this.regionLabels1[p - w], 0, this.data[p]);
                this.add2(p, this.regionLabels2[p - w], 0, this.data[p]);
                int x2 = 1;
                while (x2 < w1) {
                    p = y * w + x2;
                    this.add1(p, this.regionLabels1[p - w], this.regionLabels1[p - 1], this.data[p]);
                    this.add2(p, this.regionLabels2[p - w], this.regionLabels2[p - 1], this.data[p]);
                    ++x2;
                }
                this.add1(++p, this.regionLabels1[p - w], this.regionLabels1[p - 1], this.data[p]);
                this.add2(p, this.regionLabels2[p - w], this.regionLabels2[p - 1], this.data[p]);
                ++y;
            }
            p = h1 * w;
            this.add1(p, this.regionLabels1[p - w], 0, this.data[p]);
            this.add2(p, this.regionLabels2[p - w], 0, this.data[p]);
            x = 1;
            while (x < w1) {
                p = h1 * w + x;
                this.add1(p, this.regionLabels1[p - w], this.regionLabels1[p - 1], this.data[p]);
                this.add2(p, this.regionLabels2[p - w], this.regionLabels2[p - 1], this.data[p]);
                ++x;
            }
            this.add1(++p, this.regionLabels1[p - w], this.regionLabels1[p - 1], this.data[p]);
            this.add2(p, this.regionLabels2[p - w], this.regionLabels2[p - 1], this.data[p]);
            IObjectArray regionLabelsIA = null;
            try {
                int rh;
                int rw;
                int regionSize;
                int label;
                regionLabelsIA = Imas2StageDifferenceKey2.this.arrayPools.getObjectArray(this.actualRegionCount1 + this.actualRegionCount2);
                Object[] regionLabels = (Object[])regionLabelsIA.getArray();
                int arCount = 0;
                int i = 1;
                while (i <= this.regionCount1) {
                    label = i;
                    while ((regionSize = this.regionSizes1[label]) < 0) {
                        label = -regionSize;
                    }
                    if (label == i) {
                        rw = this.regionBounds1[i * 5 + 2] - this.regionBounds1[i * 5];
                        rh = this.regionBounds1[i * 5 + 3] - this.regionBounds1[i * 5 + 1];
                        this.regionBounds1[i * 5 + 4] = Math.max(rw, (int)Math.ceil((double)rh * 1.5));
                        regionLabels[arCount++] = label;
                    } else {
                        this.regionSizes1[i] = -label;
                    }
                    ++i;
                }
                i = 1;
                while (i <= this.regionCount2) {
                    label = i;
                    while ((regionSize = this.regionSizes2[label]) < 0) {
                        label = -regionSize;
                    }
                    if (label == i) {
                        rw = this.regionBounds2[i * 5 + 2] - this.regionBounds2[i * 5];
                        rh = this.regionBounds2[i * 5 + 3] - this.regionBounds2[i * 5 + 1];
                        this.regionBounds2[i * 5 + 4] = Math.max(rw, rh);
                        regionLabels[arCount++] = -label;
                    } else {
                        this.regionSizes2[i] = -label;
                    }
                    ++i;
                }
                Arrays.sort(regionLabels, 0, arCount, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        int label1 = (Integer)o1;
                        int label2 = (Integer)o2;
                        int size1 = label1 > 0 ? RegionFilter2.this.regionBounds1[label1 * 5 + 4] : RegionFilter2.this.regionBounds2[-label1 * 5 + 4];
                        int size2 = label2 > 0 ? RegionFilter2.this.regionBounds1[label2 * 5 + 4] : RegionFilter2.this.regionBounds2[-label2 * 5 + 4];
                        return size2 - size1;
                    }
                });
                double maxEyeSize2 = maxEyeSize * 0.5;
                HashSet<Integer> exclude = new HashSet<Integer>();
                LinkedHashSet<Integer> regions = new LinkedHashSet<Integer>();
                int k = 0;
                while (k < arCount) {
                    int size;
                    Integer label2 = (Integer)regionLabels[k];
                    int n = size = label2 > 0 ? this.regionBounds1[label2 * 5 + 4] : this.regionBounds2[-label2.intValue() * 5 + 4];
                    if (!(label2 > 0 && (double)size > maxEyeSize || label2 < 0 && (double)size > maxEyeSize2)) {
                        int bottom;
                        int right;
                        int top;
                        int left;
                        if (label2 > 0) {
                            left = this.regionBounds1[label2 * 5];
                            top = this.regionBounds1[label2 * 5 + 1];
                            right = this.regionBounds1[label2 * 5 + 2];
                            bottom = this.regionBounds1[label2 * 5 + 3];
                        } else {
                            left = this.regionBounds2[-label2.intValue() * 5];
                            top = this.regionBounds2[-label2.intValue() * 5 + 1];
                            right = this.regionBounds2[-label2.intValue() * 5 + 2];
                            bottom = this.regionBounds2[-label2.intValue() * 5 + 3];
                        }
                        if (right - left + (bottom - top) >= 4) {
                            boolean loop;
                            exclude.clear();
                            block12: do {
                                int rh2;
                                int rw2;
                                loop = false;
                                int i2 = 1;
                                while (!(Math.max((double)(rw2 = right - left + i2), (double)(rh2 = bottom - top + i2) * 1.5) > maxEyeSize)) {
                                    int x0 = Math.max(left - i2, 0);
                                    int y0 = Math.max(top - i2, 0);
                                    int x1 = Math.min(right + i2, this.bounds.width);
                                    int y1 = Math.min(bottom + i2, this.bounds.height);
                                    regions.clear();
                                    if (x0 == left - i2) {
                                        this.findRegionsV(x0, y0, y1, i2 <= 2, exclude, regions);
                                    }
                                    if (y0 == top - i2) {
                                        this.findRegionsH(y0, x0 + 1, x1 - 1, i2 <= 2, exclude, regions);
                                    }
                                    if (x1 == right + i2) {
                                        this.findRegionsV(x1 - 1, y0, y1, i2 <= 2, exclude, regions);
                                    }
                                    if (y1 == bottom + i2) {
                                        this.findRegionsH(y1 - 1, x0 + 1, x1 - 1, i2 <= 2, exclude, regions);
                                    }
                                    if (!regions.isEmpty()) {
                                        for (Integer label22 : regions) {
                                            int bottom2;
                                            int right2;
                                            int top2;
                                            int left2;
                                            if (label22 > 0) {
                                                left2 = Math.min(this.regionBounds1[label22 * 5], left);
                                                top2 = Math.min(this.regionBounds1[label22 * 5 + 1], top);
                                                right2 = Math.max(this.regionBounds1[label22 * 5 + 2], right);
                                                bottom2 = Math.max(this.regionBounds1[label22 * 5 + 3], bottom);
                                            } else {
                                                left2 = Math.min(this.regionBounds2[-label22.intValue() * 5], left);
                                                top2 = Math.min(this.regionBounds2[-label22.intValue() * 5 + 1], top);
                                                right2 = Math.max(this.regionBounds2[-label22.intValue() * 5 + 2], right);
                                                bottom2 = Math.max(this.regionBounds2[-label22.intValue() * 5 + 3], bottom);
                                            }
                                            int rw22 = right2 - left2;
                                            int rh22 = bottom2 - top2;
                                            if (Math.max((double)rw22, (double)rh22 * 1.5) <= maxEyeSize) {
                                                if (left2 == left && top2 == top && right2 == right && bottom2 == bottom) continue;
                                                left = left2;
                                                top = top2;
                                                right = right2;
                                                bottom = bottom2;
                                                loop = true;
                                                continue;
                                            }
                                            exclude.add(label22);
                                        }
                                        continue block12;
                                    }
                                    ++i2;
                                }
                            } while (loop);
                            this.filter(left, top, right, bottom, blinkThresholdEdge, blinkThresholdColor, hasBlinkMask, matteSetter, preview);
                        }
                    }
                    ++k;
                }
            }
            finally {
                if (regionLabelsIA != null) {
                    regionLabelsIA.release();
                }
            }
        }

        private void findRegionsH(int y, int fromX, int toX, boolean sensitive, Set<Integer> exclude, Set<Integer> regions) {
            int i0 = y * this.bounds.width;
            int x = fromX;
            while (x < toX) {
                this.findRegions(i0 + x, sensitive, exclude, regions);
                ++x;
            }
        }

        private void findRegionsV(int x, int fromY, int toY, boolean sensitive, Set<Integer> exclude, Set<Integer> regions) {
            int i = fromY * this.bounds.width + x;
            int y = fromY;
            while (y < toY) {
                this.findRegions(i, sensitive, exclude, regions);
                ++y;
                i += this.bounds.width;
            }
        }

        private void findRegions(int i, boolean sensitive, Set<Integer> exclude, Set<Integer> regions) {
            Integer label = this.regionLabels1[i];
            int size = this.regionSizes1[label];
            if (size < 0) {
                label = -size;
            }
            if (label > 0 && !exclude.contains(label) && (sensitive || this.regionBounds1[label * 5 + 4] > 5)) {
                regions.add(label);
            }
            if ((size = this.regionSizes2[label = Integer.valueOf(this.regionLabels2[i])]) < 0) {
                label = -size;
            }
            if (label > 0 && !exclude.contains(-label.intValue()) && (sensitive || this.regionBounds2[label * 5 + 4] > 5)) {
                regions.add(-label.intValue());
            }
        }

        private void filter(int left, int top, int right, int bottom, double blinkThresholdEdge, double blinkThresholdColor, boolean hasBlinkMask, MatteSetter matteSetter, boolean preview) {
            int outside = 0;
            int edge = 0;
            int eye = 0;
            int complexity = 0;
            HashSet<Integer> regions = new HashSet<Integer>();
            HashSet<Integer> exclude = new HashSet<Integer>();
            int y = top;
            while (y < bottom) {
                int x = left;
                while (x < right) {
                    int label2;
                    int size2;
                    int j = y * this.bounds.width + x;
                    int label1 = this.regionLabels1[j];
                    int size1 = this.regionSizes1[label1];
                    if (size1 < 0) {
                        label1 = -size1;
                    }
                    if (label1 > 0 && !regions.contains(label1) && !exclude.contains(label1)) {
                        int left2 = this.regionBounds1[label1 * 5];
                        int top2 = this.regionBounds1[label1 * 5 + 1];
                        int right2 = this.regionBounds1[label1 * 5 + 2];
                        int bottom2 = this.regionBounds1[label1 * 5 + 3];
                        if (left2 >= left && top2 >= top && right2 <= right && bottom2 <= bottom) {
                            regions.add(label1);
                        } else {
                            exclude.add(label1);
                        }
                    }
                    if ((size2 = this.regionSizes2[label2 = this.regionLabels2[j]]) < 0) {
                        label2 = -size2;
                    }
                    if (label2 > 0 && !regions.contains(-label2) && !exclude.contains(-label2)) {
                        int left2 = this.regionBounds2[label2 * 5];
                        int top2 = this.regionBounds2[label2 * 5 + 1];
                        int right2 = this.regionBounds2[label2 * 5 + 2];
                        int bottom2 = this.regionBounds2[label2 * 5 + 3];
                        if (left2 >= left && top2 >= top && right2 <= right && bottom2 <= bottom) {
                            ++complexity;
                            regions.add(-label2);
                        } else {
                            exclude.add(-label2);
                        }
                    }
                    if (!((this.data[j] & 0x20) != 0 || exclude.contains(label1) && exclude.contains(-label2))) {
                        ++outside;
                        if ((this.data[j] & 2) != 0) {
                            ++edge;
                        }
                        if ((this.data[j] & 4) != 0) {
                            ++eye;
                        }
                    }
                    ++x;
                }
                ++y;
            }
            double logOutside = 100.0 * Math.log((double)outside / 100.0 + 1.0);
            if (!hasBlinkMask && (double)complexity <= logOutside * 0.1 + 1.0) {
                return;
            }
            if ((double)edge <= blinkThresholdEdge * logOutside) {
                return;
            }
            if ((double)eye <= blinkThresholdColor * (double)outside) {
                return;
            }
            int y2 = top;
            while (y2 < bottom) {
                int x = left;
                while (x < right) {
                    int j = y2 * this.bounds.width + x;
                    if ((this.data[j] & 0x10) != 0) {
                        int label1 = this.regionLabels1[j];
                        int size1 = this.regionSizes1[label1];
                        if (size1 < 0) {
                            label1 = -size1;
                        }
                        if (regions.contains(label1)) {
                            matteSetter.set(j);
                        } else {
                            int label2 = this.regionLabels2[j];
                            int size2 = this.regionSizes2[label2];
                            if (size2 < 0) {
                                label2 = -size2;
                            }
                            if (regions.contains(-label2)) {
                                matteSetter.set(j);
                            } else if ((this.data[j] & 2) != 0) {
                                matteSetter.set(j);
                            }
                        }
                    }
                    ++x;
                }
                ++y2;
            }
            if (preview) {
                int j0 = top * this.bounds.width;
                int j1 = (bottom - 1) * this.bounds.width;
                int x = left;
                while (x < right) {
                    matteSetter.set2(j0 + x);
                    matteSetter.set2(j1 + x);
                    ++x;
                }
                j0 = top * this.bounds.width + left;
                j1 = top * this.bounds.width + right - 1;
                int y3 = top + 1;
                while (y3 < bottom - 1) {
                    matteSetter.set2(j0 += this.bounds.width);
                    matteSetter.set2(j1 += this.bounds.width);
                    ++y3;
                }
            }
        }

        private void add1(int pxIndex, int upperLabel, int leftLabel, byte data) {
            if ((data & 0x20) != 0) {
                this.regionLabels1[pxIndex] = 0;
                return;
            }
            int x = pxIndex % this.bounds.width;
            int y = pxIndex / this.bounds.width;
            int label = 0;
            if (upperLabel > 0 && leftLabel > 0 && upperLabel != leftLabel) {
                while (this.regionSizes1[upperLabel] < 0) {
                    upperLabel = -this.regionSizes1[upperLabel];
                }
                while (this.regionSizes1[leftLabel] < 0) {
                    leftLabel = -this.regionSizes1[leftLabel];
                }
                if (leftLabel != upperLabel) {
                    --this.actualRegionCount1;
                    int n = upperLabel;
                    this.regionSizes1[n] = this.regionSizes1[n] + this.regionSizes1[leftLabel];
                    this.regionSizes1[leftLabel] = -upperLabel;
                    this.regionBounds1[upperLabel * 5] = Math.min(this.regionBounds1[upperLabel * 5], this.regionBounds1[leftLabel * 5]);
                    this.regionBounds1[upperLabel * 5 + 1] = Math.min(this.regionBounds1[upperLabel * 5 + 1], this.regionBounds1[leftLabel * 5 + 1]);
                    this.regionBounds1[upperLabel * 5 + 2] = Math.max(this.regionBounds1[upperLabel * 5 + 2], this.regionBounds1[leftLabel * 5 + 2]);
                    this.regionBounds1[upperLabel * 5 + 3] = Math.max(this.regionBounds1[upperLabel * 5 + 3], this.regionBounds1[leftLabel * 5 + 3]);
                }
                label = upperLabel;
            } else if (upperLabel > 0) {
                label = upperLabel;
            } else if (leftLabel > 0) {
                label = leftLabel;
            }
            if (label > 0) {
                while (this.regionSizes1[label] < 0) {
                    label = -this.regionSizes1[label];
                }
                this.regionLabels1[pxIndex] = label;
                int n = label;
                this.regionSizes1[n] = this.regionSizes1[n] + 1;
                this.regionBounds1[label * 5] = Math.min(this.regionBounds1[label * 5], x);
                this.regionBounds1[label * 5 + 1] = Math.min(this.regionBounds1[label * 5 + 1], y);
                this.regionBounds1[label * 5 + 2] = Math.max(this.regionBounds1[label * 5 + 2], x + 1);
                this.regionBounds1[label * 5 + 3] = Math.max(this.regionBounds1[label * 5 + 3], y + 1);
            } else {
                if (this.regionSizes1IA.getLength() - 1 == this.regionCount1) {
                    this.regionSizes1IA = Imas2StageDifferenceKey2.this.expandArray((IArray<int[]>)this.regionSizes1IA);
                    this.regionSizes1 = (int[])this.regionSizes1IA.getArray();
                    this.regionBounds1IA = Imas2StageDifferenceKey2.this.expandArray((IArray<int[]>)this.regionBounds1IA);
                    this.regionBounds1 = (int[])this.regionBounds1IA.getArray();
                }
                label = ++this.regionCount1;
                ++this.actualRegionCount1;
                this.regionLabels1[pxIndex] = label;
                this.regionSizes1[label] = 1;
                this.regionBounds1[label * 5] = x;
                this.regionBounds1[label * 5 + 1] = y;
                this.regionBounds1[label * 5 + 2] = x + 1;
                this.regionBounds1[label * 5 + 3] = y + 1;
            }
        }

        private void add2(int pxIndex, int upperLabel, int leftLabel, byte data) {
            if ((data & 0x22) != 0) {
                this.regionLabels2[pxIndex] = 0;
                return;
            }
            int x = pxIndex % this.bounds.width;
            int y = pxIndex / this.bounds.width;
            int label = 0;
            if (upperLabel > 0 && leftLabel > 0 && upperLabel != leftLabel) {
                while (this.regionSizes2[upperLabel] < 0) {
                    upperLabel = -this.regionSizes2[upperLabel];
                }
                while (this.regionSizes2[leftLabel] < 0) {
                    leftLabel = -this.regionSizes2[leftLabel];
                }
                if (leftLabel != upperLabel) {
                    --this.actualRegionCount2;
                    int n = upperLabel;
                    this.regionSizes2[n] = this.regionSizes2[n] + this.regionSizes2[leftLabel];
                    this.regionSizes2[leftLabel] = -upperLabel;
                    this.regionBounds2[upperLabel * 5] = Math.min(this.regionBounds2[upperLabel * 5], this.regionBounds2[leftLabel * 5]);
                    this.regionBounds2[upperLabel * 5 + 1] = Math.min(this.regionBounds2[upperLabel * 5 + 1], this.regionBounds2[leftLabel * 5 + 1]);
                    this.regionBounds2[upperLabel * 5 + 2] = Math.max(this.regionBounds2[upperLabel * 5 + 2], this.regionBounds2[leftLabel * 5 + 2]);
                    this.regionBounds2[upperLabel * 5 + 3] = Math.max(this.regionBounds2[upperLabel * 5 + 3], this.regionBounds2[leftLabel * 5 + 3]);
                }
                label = upperLabel;
            } else if (upperLabel > 0) {
                label = upperLabel;
            } else if (leftLabel > 0) {
                label = leftLabel;
            }
            if (label > 0) {
                while (this.regionSizes2[label] < 0) {
                    label = -this.regionSizes2[label];
                }
                this.regionLabels2[pxIndex] = label;
                int n = label;
                this.regionSizes2[n] = this.regionSizes2[n] + 1;
                this.regionBounds2[label * 5] = Math.min(this.regionBounds2[label * 5], x);
                this.regionBounds2[label * 5 + 1] = Math.min(this.regionBounds2[label * 5 + 1], y);
                this.regionBounds2[label * 5 + 2] = Math.max(this.regionBounds2[label * 5 + 2], x + 1);
                this.regionBounds2[label * 5 + 3] = Math.max(this.regionBounds2[label * 5 + 3], y + 1);
            } else {
                if (this.regionSizes2IA.getLength() - 1 == this.regionCount2) {
                    this.regionSizes2IA = Imas2StageDifferenceKey2.this.expandArray((IArray<int[]>)this.regionSizes2IA);
                    this.regionSizes2 = (int[])this.regionSizes2IA.getArray();
                    this.regionBounds2IA = Imas2StageDifferenceKey2.this.expandArray((IArray<int[]>)this.regionBounds2IA);
                    this.regionBounds2 = (int[])this.regionBounds2IA.getArray();
                }
                label = ++this.regionCount2;
                ++this.actualRegionCount2;
                this.regionLabels2[pxIndex] = label;
                this.regionSizes2[label] = 1;
                this.regionBounds2[label * 5] = x;
                this.regionBounds2[label * 5 + 1] = y;
                this.regionBounds2[label * 5 + 2] = x + 1;
                this.regionBounds2[label * 5 + 3] = y + 1;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UseFleshColor {
        FLESH_COLOR_1,
        FLESH_COLOR_2,
        TWO_FLESH_COLORS;

    }
}

