/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.nukimas3;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.nukimas3.Imas2StageDifferenceKey2;
import com.google.inject.Inject;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.nukimas3.Imas2DifferenceMatte", category="ch.kuramo.nukimas3.nukimas3Category")
public class Imas2DifferenceMatte {
    @Property
    private IAnimatableLayerReference differenceLayer;
    @Property(value="40", min="0", max="100")
    private IAnimatableDouble unsharpMaskAmount;
    @Property(value="15", min="0", max="50")
    private IAnimatableDouble unsharpMaskRadius;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble matchingTolerance;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble matchingSoftness;
    @Property(value="RESULT")
    private IAnimatableEnum<Output> output;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlurSupport blurSupport;
    private final IShaderRegistry shaders;
    private final IShaderProgram unsharpMaskProgram;

    @Inject
    public Imas2DifferenceMatte(IVideoEffectContext context, IVideoRenderSupport support, IBlurSupport blurSupport, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blurSupport = blurSupport;
        this.shaders = shaders;
        this.unsharpMaskProgram = shaders.getProgram(Imas2StageDifferenceKey2.class, "UNSHARP_MASK");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        VideoBounds bounds = source.getBounds();
        if (bounds.isEmpty()) {
            return source;
        }
        IVideoBuffer diffLayer = null;
        IVideoBuffer[] sharped = null;
        try {
            Output output = (Output)((Object)this.context.value(this.output));
            if (output == Output.SOURCE_ONLY) {
                IVideoBuffer result = source;
                source = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            diffLayer = this.context.getLayerVideoFrame(this.differenceLayer);
            if (diffLayer == null) {
                IVideoBuffer result = source;
                source = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            sharped = this.unsharpMask(source, diffLayer);
            double tolerance = (Double)this.context.value((IAnimatableValue)this.matchingTolerance) * Math.sqrt(3.0) / 100.0;
            double softness = (Double)this.context.value((IAnimatableValue)this.matchingSoftness) / 100.0;
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture1", 0));
            uniforms.add(new GLUniformData("texture2", 1));
            uniforms.add(new GLUniformData("t", (float)tolerance));
            uniforms.add(new GLUniformData("s", (float)((Math.sqrt(3.0) - tolerance) * softness)));
            if (output != Output.MATTE_ONLY) {
                uniforms.add(new GLUniformData("source", 2));
            }
            switch (output) {
                case RESULT: {
                    IVideoBuffer iVideoBuffer = this.support.useShaderProgram(this.getProgram(false), uniforms, null, new IVideoBuffer[]{sharped[0], sharped[1], source});
                    return iVideoBuffer;
                }
                case MATTE_ONLY: {
                    IVideoBuffer iVideoBuffer = this.support.useShaderProgram(this.getProgram(true), uniforms, null, new IVideoBuffer[]{sharped[0], sharped[1]});
                    return iVideoBuffer;
                }
            }
            throw new Error();
        }
        finally {
            if (source != null) {
                source.dispose();
            }
            if (diffLayer != null) {
                diffLayer.dispose();
            }
            if (sharped != null) {
                sharped[0].dispose();
                sharped[1].dispose();
            }
        }
    }

    private IVideoBuffer[] unsharpMask(IVideoBuffer buffer1, IVideoBuffer buffer2) {
        Resolution resolution = this.context.getVideoResolution();
        double amount = (Double)this.context.value((IAnimatableValue)this.unsharpMaskAmount) / 100.0;
        double radius = resolution.scale(((Double)this.context.value((IAnimatableValue)this.unsharpMaskRadius)).doubleValue());
        boolean fast = true;
        IVideoBuffer[] sharped = null;
        try {
            sharped = new IVideoBuffer[]{this.unsharpMask(buffer1, amount, radius, fast), this.unsharpMask(buffer2, amount, radius, fast)};
            IVideoBuffer[] result = sharped;
            sharped = null;
            IVideoBuffer[] iVideoBufferArray = result;
            return iVideoBufferArray;
        }
        finally {
            if (sharped != null) {
                if (sharped[0] != null) {
                    sharped[0].dispose();
                }
                if (sharped[1] != null) {
                    sharped[1].dispose();
                }
            }
        }
    }

    private IVideoBuffer unsharpMask(IVideoBuffer buffer, double amount, double radius, boolean fast) {
        IVideoBuffer blur = this.blurSupport.gaussianBlur(buffer, radius, IBlurSupport.BlurDimensions.BOTH, true, fast);
        try {
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("srcTex", 0));
            uniforms.add(new GLUniformData("blrTex", 1));
            uniforms.add(new GLUniformData("amount", (float)amount));
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(this.unsharpMaskProgram, uniforms, null, new IVideoBuffer[]{buffer, blur});
            return iVideoBuffer;
        }
        finally {
            blur.dispose();
        }
    }

    private IShaderProgram getProgram(boolean matteOnly) {
        String programName = String.valueOf(Imas2DifferenceMatte.class.getName()) + (matteOnly ? ".MATTE_ONLY" : ".DIFFERENCE_MATTE");
        IShaderProgram program = this.shaders.getProgram(programName);
        if (program == null) {
            String[] source = this.createProgramSource(matteOnly);
            program = this.shaders.registerProgram(programName, ShaderType.FRAGMENT_SHADER, null, source);
        }
        return program;
    }

    private String[] createProgramSource(boolean matteOnly) {
        boolean mo = matteOnly;
        return new String[]{mo ? "#define MATTE_ONLY" : "", "", "uniform sampler2D texture1;", "uniform sampler2D texture2;", "uniform float t;", "uniform float s;", "", "#ifndef MATTE_ONLY", "\tuniform sampler2D source;", "#endif", "", "void main(void)", "{", "\tvec2 tc = gl_TexCoord[0].st;", "", "\tvec4 color1 = texture2D(texture1, tc);", "\tcolor1.rgb = (color1.a > 0.0) ? color1.rgb/color1.a : vec3(0.0);", "", "\tvec4 color2 = texture2D(texture2, tc);", "\tcolor2.rgb = (color2.a > 0.0) ? color2.rgb/color2.a : vec3(0.0);", "", "\tfloat d = distance(color1.rgb, color2.rgb);", "\td = clamp((d-t)/s, 0.0, 1.0);", "", "#ifdef MATTE_ONLY", "\tgl_FragColor = vec4(d);", "#else", "\tgl_FragColor = texture2D(source, tc) * d;", "#endif", "}"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Output {
        RESULT,
        SOURCE_ONLY,
        MATTE_ONLY;

    }
}

