/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.nukimas3;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Effect(id="ch.kuramo.nukimas3.Imas2StageDifferenceKey", category="ch.kuramo.nukimas3.nukimas3Category")
public class Imas2StageDifferenceKey {
    @Property
    private IAnimatableLayerReference stage2;
    @Property
    private IAnimatableLayerReference stage3;
    @Property
    private IAnimatableLayerReference stage4;
    @Property(value="40", min="0", max="100")
    private IAnimatableDouble unsharpMaskAmount;
    @Property(value="15", min="0", max="50")
    private IAnimatableDouble unsharpMaskRadius;
    @Property(value="100", min="0")
    private IAnimatableDouble differenceThreshold;
    @Property(value="30", min="0")
    private IAnimatableDouble differenceCutoff;
    @Property(value="20", min="0", max="100")
    private IAnimatableDouble edgeThreshold;
    @Property(value="50", min="0", max="100")
    private IAnimatableDouble minEdgeCoverage;
    @Property(value="10", min="0")
    private IAnimatableInteger minRegionSize;
    @Property(value="DIFFERENCE_AND_EDGE")
    private IAnimatableEnum<Output> output;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlurSupport blurSupport;
    private final IBlendSupport blendSupport;
    private final IArrayPools arrayPools;
    private final IShaderProgram unsharpMaskProgram;
    private final IShaderProgram[] differencePrograms;
    private final IShaderProgram luminosityProgram;
    private final IShaderProgram gradientProgram;
    private final IShaderProgram[] edgePrograms;
    @ShaderSource
    public static final String[] UNSHARP_MASK = new String[]{"uniform sampler2D srcTex;", "uniform sampler2D blrTex;", "uniform float amount;", "", "void main(void)", "{", "\tvec2 tc = gl_TexCoord[0].st;", "\tvec4 srcColor = texture2D(srcTex, tc);", "\tvec4 blrColor = texture2D(blrTex, tc);", "", "\tsrcColor.rgb = (srcColor.a > 0.0) ? srcColor.rgb/srcColor.a : vec3(0.0);", "\tblrColor.rgb = (blrColor.a > 0.0) ? blrColor.rgb/blrColor.a : vec3(0.0);", "", "\tvec3 diff = srcColor.rgb - blrColor.rgb;", "", "\tgl_FragColor = vec4((srcColor.rgb+diff*amount)*srcColor.a, srcColor.a);", "}"};
    @ShaderSource
    public static final String[] DIFFERENCE_2 = Imas2StageDifferenceKey.createDifferenceProgramSource(2);
    @ShaderSource
    public static final String[] DIFFERENCE_3 = Imas2StageDifferenceKey.createDifferenceProgramSource(3);
    @ShaderSource
    public static final String[] DIFFERENCE_4 = Imas2StageDifferenceKey.createDifferenceProgramSource(4);
    @ShaderSource
    public static final String[] LUMINOSITY = new String[]{"uniform sampler2D texture;", "", "const vec3 yvec = vec3(0.299, 0.587, 0.114);", "", "void main(void)", "{", "\tvec4 color = texture2D(texture, gl_TexCoord[0].st);", "\tfloat y = (color.a > 0.0) ? dot(color.rgb/color.a, yvec) : 0.0;", "\tgl_FragColor = vec4(y);", "}"};
    @ShaderSource
    public static final String[] GRADIENT = new String[]{"uniform sampler2D texture;", "uniform vec2 offset[8];", "", "void main(void)", "{", "\tvec2 tc = gl_TexCoord[0].st;", "\tfloat y00 = texture2D(texture, tc+offset[0]).r;", "\tfloat y10 = texture2D(texture, tc+offset[1]).r;", "\tfloat y20 = texture2D(texture, tc+offset[2]).r;", "\tfloat y01 = texture2D(texture, tc+offset[3]).r;", "\tfloat y11 = texture2D(texture, tc          ).r;", "\tfloat y21 = texture2D(texture, tc+offset[4]).r;", "\tfloat y02 = texture2D(texture, tc+offset[5]).r;", "\tfloat y12 = texture2D(texture, tc+offset[6]).r;", "\tfloat y22 = texture2D(texture, tc+offset[7]).r;", "", "\tfloat grad = max(max(abs(y10-y11), abs(y01-y11)),", "\t\t\t\t\t max(abs(y21-y11), abs(y12-y11)));", "", "\tfloat lap = y00+y10+y20+y01-8.0*y11+y21+y02+y12+y22;", "", "\tgl_FragColor = (lap > 0.0) ? vec4(grad, 0.0, 0.0, 1.0)", "\t\t\t\t\t\t\t   : vec4(0.0, grad, 0.0, 1.0);", "}"};
    @ShaderSource
    public static final String[] EDGE_2 = Imas2StageDifferenceKey.createEdgeProgramSource(2);
    @ShaderSource
    public static final String[] EDGE_3 = Imas2StageDifferenceKey.createEdgeProgramSource(3);
    @ShaderSource
    public static final String[] EDGE_4 = Imas2StageDifferenceKey.createEdgeProgramSource(4);

    @Inject
    public Imas2StageDifferenceKey(IVideoEffectContext context, IVideoRenderSupport support, IBlurSupport blurSupport, IBlendSupport blendSupport, IArrayPools arrayPools, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blurSupport = blurSupport;
        this.blendSupport = blendSupport;
        this.arrayPools = arrayPools;
        this.unsharpMaskProgram = shaders.getProgram(Imas2StageDifferenceKey.class, "UNSHARP_MASK");
        this.differencePrograms = new IShaderProgram[]{shaders.getProgram(Imas2StageDifferenceKey.class, "DIFFERENCE_2"), shaders.getProgram(Imas2StageDifferenceKey.class, "DIFFERENCE_3"), shaders.getProgram(Imas2StageDifferenceKey.class, "DIFFERENCE_4")};
        this.luminosityProgram = shaders.getProgram(Imas2StageDifferenceKey.class, "LUMINOSITY");
        this.gradientProgram = shaders.getProgram(Imas2StageDifferenceKey.class, "GRADIENT");
        this.edgePrograms = new IShaderProgram[]{shaders.getProgram(Imas2StageDifferenceKey.class, "EDGE_2"), shaders.getProgram(Imas2StageDifferenceKey.class, "EDGE_3"), shaders.getProgram(Imas2StageDifferenceKey.class, "EDGE_4")};
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IVideoBuffer doVideoEffect() {
        source1 = this.context.doPreviousEffect();
        bounds = source1.getBounds();
        if (bounds.width < 2) return source1;
        if (bounds.height < 2) {
            return source1;
        }
        buffers = new ArrayList<IVideoBuffer>();
        buffers.add(source1);
        try {
            srcAndSrp = new IVideoBuffer[2][4];
            srcAndSrp[0][0] = source1;
            if (!this.getSourceBuffers(srcAndSrp[0], buffers)) {
                buffers.remove(source1);
                var9_5 = source1;
                return var9_5;
            }
            output = (Output)this.context.value(this.output);
            if (this.isStage(output)) {
                outbuf = srcAndSrp[0][output.ordinal() - Output.STAGE1.ordinal()];
                var9_6 = outbuf != null ? this.quit(outbuf, buffers) : this.blank(bounds);
                return var9_6;
            }
            if (this.doUnsharpMask(srcAndSrp, buffers)) {
                this.disposeSourceBuffers(srcAndSrp[0], buffers, output);
            }
            if (this.isStageUM(output)) {
                outbuf = srcAndSrp[1][output.ordinal() - Output.STAGE1_UM.ordinal()];
                var9_7 = outbuf != null ? this.quit(outbuf, buffers) : this.blank(bounds);
                return var9_7;
            }
            if (output == Output.DIFFERENCE) {
                difference = this.createDifference(srcAndSrp[1], buffers);
                var9_8 = this.quit(difference, buffers);
                return var9_8;
            }
            if (output == Output.EDGE) {
                edge = this.createEdge(bounds, srcAndSrp[1], buffers);
                var9_9 = this.quit(edge, buffers);
                return var9_9;
            }
            diffAndEdge = this.createDifference(srcAndSrp[1], buffers);
            this.addEdge(srcAndSrp[1], diffAndEdge);
            if (output == Output.DIFFERENCE_AND_EDGE) {
                var9_10 = this.quit(diffAndEdge, buffers);
                return var9_10;
            }
            this.disposeSharpedBuffers(srcAndSrp[1], buffers, output);
            this.filterGarbage(diffAndEdge);
            if (output == Output.MASK) {
                var9_11 = this.quit(diffAndEdge, buffers);
                return var9_11;
            }
            v0 = this.isResult(output) != false ? srcAndSrp[0][output.ordinal() - Output.RESULT_FROM_STAGE1.ordinal()] : (stage = this.isResultUM(output) != false ? srcAndSrp[1][output.ordinal() - Output.RESULT_FROM_STAGE1_UM.ordinal()] : null);
            if (stage != null) {
                var9_12 = this.blendSupport.blend(diffAndEdge, stage, null, BlendMode.STENCIL_ALPHA, 1.0);
                return var9_12;
            }
            var9_13 = this.blank(bounds);
            return var9_13;
        }
        finally {
            ** for (buf : buffers)
        }
lbl-1000:
        // 1 sources

        {
            buf.dispose();
            continue;
        }
lbl56:
        // 1 sources

        return var9_5;
    }

    private boolean getSourceBuffers(IVideoBuffer[] sources, List<IVideoBuffer> buffers) {
        boolean gotten = false;
        IAnimatableLayerReference[] iAnimatableLayerReferenceArray = new IAnimatableLayerReference[4];
        iAnimatableLayerReferenceArray[1] = this.stage2;
        iAnimatableLayerReferenceArray[2] = this.stage3;
        iAnimatableLayerReferenceArray[3] = this.stage4;
        IAnimatableLayerReference[] refs = iAnimatableLayerReferenceArray;
        int i = 1;
        while (i < 4) {
            IVideoBuffer buf = this.context.getLayerVideoFrame(refs[i]);
            if (buf != null) {
                sources[i] = buf;
                buffers.add(buf);
                gotten = true;
            }
            ++i;
        }
        return gotten;
    }

    private boolean doUnsharpMask(IVideoBuffer[][] srcAndSrp, List<IVideoBuffer> buffers) {
        Resolution resolution = this.context.getVideoResolution();
        double amount = (Double)this.context.value((IAnimatableValue)this.unsharpMaskAmount) / 100.0;
        double radius = resolution.scale(((Double)this.context.value((IAnimatableValue)this.unsharpMaskRadius)).doubleValue());
        boolean fast = true;
        if (amount == 0.0 || radius == 0.0) {
            srcAndSrp[1] = srcAndSrp[0];
            return false;
        }
        int i = 0;
        while (i < 4) {
            IVideoBuffer src = srcAndSrp[0][i];
            if (src != null) {
                IVideoBuffer blur = this.blurSupport.gaussianBlur(src, radius, IBlurSupport.BlurDimensions.BOTH, true, fast);
                try {
                    HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
                    uniforms.add(new GLUniformData("srcTex", 0));
                    uniforms.add(new GLUniformData("blrTex", 1));
                    uniforms.add(new GLUniformData("amount", (float)amount));
                    srcAndSrp[1][i] = this.support.useShaderProgram(this.unsharpMaskProgram, uniforms, null, new IVideoBuffer[]{src, blur});
                    buffers.add(srcAndSrp[1][i]);
                }
                finally {
                    blur.dispose();
                }
            }
            ++i;
        }
        return true;
    }

    private void disposeSourceBuffers(IVideoBuffer[] sources, List<IVideoBuffer> buffers, Output output) {
        int o = output.ordinal() - Output.RESULT_FROM_STAGE1.ordinal();
        int i = 0;
        while (i < 4) {
            IVideoBuffer src;
            if (i != o && (src = sources[i]) != null) {
                src.dispose();
                sources[i] = null;
                buffers.remove(src);
            }
            ++i;
        }
    }

    private void disposeSharpedBuffers(IVideoBuffer[] sharped, List<IVideoBuffer> buffers, Output output) {
        int o = output.ordinal() - Output.RESULT_FROM_STAGE1_UM.ordinal();
        int i = 0;
        while (i < 4) {
            IVideoBuffer srp;
            if (i != o && (srp = sharped[i]) != null) {
                srp.dispose();
                sharped[i] = null;
                buffers.remove(srp);
            }
            ++i;
        }
    }

    private IVideoBuffer createDifference(IVideoBuffer[] sharped, List<IVideoBuffer> buffers) {
        double threshold = (Double)this.context.value((IAnimatableValue)this.differenceThreshold) / 1000.0;
        double cutoff = (Double)this.context.value((IAnimatableValue)this.differenceCutoff) / 1000.0;
        ArrayList<IVideoBuffer> srpList = new ArrayList<IVideoBuffer>();
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        int i = 0;
        while (i < 4) {
            if (sharped[i] != null) {
                srpList.add(sharped[i]);
                int j = srpList.size();
                uniforms.add(new GLUniformData("texture" + j, j - 1));
            }
            ++i;
        }
        uniforms.add(new GLUniformData("threshold", (float)threshold));
        uniforms.add(new GLUniformData("t_minus_c", (float)(threshold - cutoff)));
        IVideoBuffer difference = this.support.useShaderProgram(this.differencePrograms[srpList.size() - 2], uniforms, null, srpList.toArray(new IVideoBuffer[srpList.size()]));
        buffers.add(difference);
        return difference;
    }

    private IVideoBuffer createEdge(VideoBounds bounds, IVideoBuffer[] sharped, List<IVideoBuffer> buffers) {
        IVideoBuffer edge = this.context.createVideoBuffer(bounds);
        buffers.add(edge);
        edge.clear(Color.BLACK);
        this.addEdge(sharped, edge);
        return edge;
    }

    /*
     * Unable to fully structure code
     */
    private void addEdge(IVideoBuffer[] sharped, IVideoBuffer dstbuf) {
        bounds = dstbuf.getBounds();
        dx = 1.0 / (double)bounds.width;
        dy = 1.0 / (double)bounds.height;
        offset = this.toFloatBuffer(new double[]{-dx, -dy, 0.0, -dy, dx, -dy, -dx, 0.0, dx, 0.0, -dx, dy, 0.0, dy, dx, dy});
        grad = new ArrayList<IVideoBuffer>();
        try {
            i = 0;
            while (i < 4) {
                srp = sharped[i];
                if (srp != null) {
                    uniforms = new HashSet<GLUniformData>();
                    uniforms.add(new GLUniformData("texture", 0));
                    luma = this.support.useShaderProgram(this.luminosityProgram, uniforms, null, new IVideoBuffer[]{srp});
                    try {
                        luma.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE);
                        uniforms.clear();
                        uniforms.add(new GLUniformData("texture", 0));
                        uniforms.add(new GLUniformData("offset[0]", 2, offset));
                        grad.add(this.support.useShaderProgram(this.gradientProgram, uniforms, null, new IVideoBuffer[]{luma}));
                    }
                    finally {
                        luma.dispose();
                    }
                }
                ++i;
            }
            threshold = (Double)this.context.value((IAnimatableValue)this.edgeThreshold) / 100.0;
            uniforms = new HashSet<E>();
            i = 0;
            while (i < grad.size()) {
                uniforms.add(new GLUniformData("texture" + (i + 1), i));
                ++i;
            }
            uniforms.add(new GLUniformData("threshold", (float)threshold));
            uniforms.add(new GLUniformData("offset[0]", 2, offset));
            operation = new Runnable(){

                public void run() {
                    GL2 gl = Imas2StageDifferenceKey.this.context.getGL().getGL2();
                    gl.glEnable(3042);
                    gl.glBlendFuncSeparate(1, 1, 0, 1);
                    gl.glBlendEquation(32774);
                    Imas2StageDifferenceKey.this.support.ortho2D(bounds);
                    Imas2StageDifferenceKey.this.support.quad2D(bounds, (double[][][])new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}}});
                }
            };
            pushAttribs = 24576;
            this.support.useShaderProgram(this.edgePrograms[grad.size() - 2], uniforms, operation, pushAttribs, dstbuf, grad.toArray(new IVideoBuffer[grad.size()]));
        }
        finally {
            ** for (buf : grad)
        }
lbl-1000:
        // 1 sources

        {
            buf.dispose();
            continue;
        }
lbl52:
        // 1 sources

    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] farray = new float[values.length];
        int i = 0;
        while (i < values.length) {
            farray[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(farray);
    }

    private void filterGarbage(IVideoBuffer diffAndEdge) {
        Resolution resolution = this.context.getVideoResolution();
        double minEdgeCoverage = (Double)this.context.value((IAnimatableValue)this.minEdgeCoverage) / 100.0;
        double minRegionSize = resolution.scale(resolution.scale((double)((Integer)this.context.value((IAnimatableValue)this.minRegionSize)).intValue()));
        RegionFilter filter = new RegionFilter(diffAndEdge);
        try {
            filter.filterGarbage(minEdgeCoverage, minRegionSize);
        }
        finally {
            filter.dispose();
        }
    }

    private boolean isStage(Output output) {
        int o = output.ordinal();
        return o >= Output.STAGE1.ordinal() && o <= Output.STAGE4.ordinal();
    }

    private boolean isStageUM(Output output) {
        int o = output.ordinal();
        return o >= Output.STAGE1_UM.ordinal() && o <= Output.STAGE4_UM.ordinal();
    }

    private boolean isResult(Output output) {
        int o = output.ordinal();
        return o >= Output.RESULT_FROM_STAGE1.ordinal() && o <= Output.RESULT_FROM_STAGE4.ordinal();
    }

    private boolean isResultUM(Output output) {
        int o = output.ordinal();
        return o >= Output.RESULT_FROM_STAGE1_UM.ordinal() && o <= Output.RESULT_FROM_STAGE4_UM.ordinal();
    }

    private IVideoBuffer quit(IVideoBuffer outbuf, List<IVideoBuffer> buffers) {
        buffers.remove(outbuf);
        return outbuf;
    }

    private IVideoBuffer blank(VideoBounds bounds) {
        IVideoBuffer buffer = null;
        try {
            buffer = this.context.createVideoBuffer(bounds);
            buffer.clear();
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private static String[] createDifferenceProgramSource(int n) {
        if (n < 2 || n > 4) {
            throw new IllegalArgumentException();
        }
        return new String[]{"#define N " + n, "", "uniform sampler2D texture1;", "uniform sampler2D texture2;", "", "#if N >= 3", "\tuniform sampler2D texture3;", "#endif", "", "#if N >= 4", "\tuniform sampler2D texture4;", "#endif", "", "uniform float threshold;", "uniform float t_minus_c;", "", "void main(void)", "{", "\tvec2 tc = gl_TexCoord[0].st;", "\tvec3 sum = vec3(0.0);", "\tfloat sum2 = 0.0;", "", "\tvec4 color1 = texture2D(texture1, tc);", "\tcolor1.rgb = (color1.a > 0.0) ? color1.rgb/color1.a : vec3(0.0);", "\tsum += color1.rgb;", "\tsum2 += dot(color1.rgb, color1.rgb);", "", "\tvec4 color2 = texture2D(texture2, tc);", "\tcolor2.rgb = (color2.a > 0.0) ? color2.rgb/color2.a : vec3(0.0);", "\tsum += color2.rgb;", "\tsum2 += dot(color2.rgb, color2.rgb);", "", "#if N >= 3", "\tvec4 color3 = texture2D(texture3, tc);", "\tcolor3.rgb = (color3.a > 0.0) ? color3.rgb/color3.a : vec3(0.0);", "\tsum += color3.rgb;", "\tsum2 += dot(color3.rgb, color3.rgb);", "#endif", "", "#if N >= 4", "\tvec4 color4 = texture2D(texture4, tc);", "\tcolor4.rgb = (color4.a > 0.0) ? color4.rgb/color4.a : vec3(0.0);", "\tsum += color4.rgb;", "\tsum2 += dot(color4.rgb, color4.rgb);", "#endif", "", "\tvec3 avg = sum / float(N);", "\tfloat variance = max(sum2 / float(N) - dot(avg, avg), 0.0);", "", "\tfloat result = clamp((threshold-sqrt(variance))/t_minus_c, 0.0, 1.0);", "\tgl_FragColor = vec4(result, 0.0, 0.0, 1.0);", "}"};
    }

    private static String[] createEdgeProgramSource(int n) {
        if (n < 2 || n > 4) {
            throw new IllegalArgumentException();
        }
        return new String[]{"#define N " + n, "", "uniform sampler2D texture1;", "uniform sampler2D texture2;", "", "#if N >= 3", "\tuniform sampler2D texture3;", "#endif", "", "#if N >= 4", "\tuniform sampler2D texture4;", "#endif", "", "uniform float threshold;", "uniform vec2 offset[8];", "", "float grad(sampler2D texture, vec2 tc)", "{", "\tfloat grad = texture2D(texture, tc).r;", "\tif (grad != 0.0 && (", "\t\t\t   texture2D(texture, tc+offset[0]).g != 0.0", "\t\t\t|| texture2D(texture, tc+offset[1]).g != 0.0", "\t\t\t|| texture2D(texture, tc+offset[2]).g != 0.0", "\t\t\t|| texture2D(texture, tc+offset[3]).g != 0.0", "\t\t\t|| texture2D(texture, tc+offset[4]).g != 0.0", "\t\t\t|| texture2D(texture, tc+offset[5]).g != 0.0", "\t\t\t|| texture2D(texture, tc+offset[6]).g != 0.0", "\t\t\t|| texture2D(texture, tc+offset[7]).g != 0.0)) {", "\t\treturn grad;", "\t} else {", "\t\treturn 0.0;", "\t}", "}", "", "void main(void)", "{", "\tvec2 tc = gl_TexCoord[0].st;", "\tfloat sum = grad(texture1, tc)", "\t\t\t  + grad(texture2, tc)", "#if N >= 3", "\t\t\t  + grad(texture3, tc)", "#endif", "#if N >= 4", "\t\t\t  + grad(texture4, tc)", "#endif", "\t\t;", "", "\tgl_FragColor = vec4(0.0, step(threshold, sum/float(N)), 0.0, 1.0);", "}"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Output {
        RESULT_FROM_STAGE1,
        RESULT_FROM_STAGE2,
        RESULT_FROM_STAGE3,
        RESULT_FROM_STAGE4,
        RESULT_FROM_STAGE1_UM,
        RESULT_FROM_STAGE2_UM,
        RESULT_FROM_STAGE3_UM,
        RESULT_FROM_STAGE4_UM,
        MASK,
        STAGE1,
        STAGE2,
        STAGE3,
        STAGE4,
        STAGE1_UM,
        STAGE2_UM,
        STAGE3_UM,
        STAGE4_UM,
        DIFFERENCE,
        EDGE,
        DIFFERENCE_AND_EDGE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RegionFilter {
        private final IVideoBuffer buffer;
        private final IArray<byte[]> diffAndEdgeIA;
        private final byte[] diffAndEdge;
        private final IArray<int[]> regionLabelsIA;
        private final int[] regionLabels;
        private int regionCount;
        private IArray<int[]> regionSizesIA;
        private int[] regionSizes;
        private IArray<int[]> edgeLengthsIA;
        private int[] edgeLengths;
        private IArray<int[]> edgeCoveragesIA;
        private int[] edgeCoverages;

        RegionFilter(IVideoBuffer diffAndEdgeBuffer) {
            this.buffer = diffAndEdgeBuffer;
            VideoBounds bounds = this.buffer.getBounds();
            int len = bounds.width * bounds.height;
            this.diffAndEdgeIA = Imas2StageDifferenceKey.this.arrayPools.getByteArray(len);
            this.diffAndEdge = (byte[])this.diffAndEdgeIA.getArray();
            this.initDiffAndEdge();
            this.regionLabelsIA = Imas2StageDifferenceKey.this.arrayPools.getIntArray(len);
            this.regionLabels = (int[])this.regionLabelsIA.getArray();
            this.regionSizesIA = Imas2StageDifferenceKey.this.arrayPools.getIntArray(4096);
            this.regionSizes = (int[])this.regionSizesIA.getArray();
            this.edgeLengthsIA = Imas2StageDifferenceKey.this.arrayPools.getIntArray(4096);
            this.edgeLengths = (int[])this.edgeLengthsIA.getArray();
            this.edgeCoveragesIA = Imas2StageDifferenceKey.this.arrayPools.getIntArray(4096);
            this.edgeCoverages = (int[])this.edgeCoveragesIA.getArray();
        }

        private void initDiffAndEdge() {
            int len = this.diffAndEdgeIA.getLength();
            switch (this.buffer.getColorMode()) {
                case RGBA8: {
                    byte[] b = (byte[])this.buffer.getArray();
                    int i = 0;
                    while (i < len) {
                        this.diffAndEdge[i] = (byte)((b[i * 4 + 1] != 0 ? 1 : 0) + (b[i * 4 + 2] != 0 ? 2 : 0));
                        ++i;
                    }
                    break;
                }
                case RGBA16: {
                    short[] s = (short[])this.buffer.getArray();
                    int i = 0;
                    while (i < len) {
                        this.diffAndEdge[i] = (byte)((s[i * 4 + 1] != 0 ? 1 : 0) + (s[i * 4 + 2] != 0 ? 2 : 0));
                        ++i;
                    }
                    break;
                }
                default: {
                    float[] f = (float[])this.buffer.getArray();
                    int i = 0;
                    while (i < len) {
                        this.diffAndEdge[i] = (byte)((f[i * 4 + 1] != 0.0f ? 1 : 0) + (f[i * 4 + 2] != 0.0f ? 2 : 0));
                        ++i;
                    }
                    break block0;
                }
            }
        }

        void dispose() {
            this.diffAndEdgeIA.release();
            this.regionLabelsIA.release();
            this.regionSizesIA.release();
            this.edgeLengthsIA.release();
            this.edgeCoveragesIA.release();
        }

        void filterGarbage(double minEdgeCoverage, double minRegionSize) {
            abstract class MaskSetter {
                MaskSetter() {
                }

                abstract void set(int var1);

                abstract void clear(int var1);
            }
            MaskSetter ms;
            int p;
            VideoBounds bounds = this.buffer.getBounds();
            int w = bounds.width;
            int w1 = bounds.width - 1;
            int h1 = bounds.height - 1;
            this.add(0, 0, 0, (byte)0, (byte)0, this.diffAndEdge[0], this.diffAndEdge[1], this.diffAndEdge[w]);
            int x = 1;
            while (x < w1) {
                this.add(x, 0, this.regionLabels[x - 1], (byte)0, this.diffAndEdge[x - 1], this.diffAndEdge[x], this.diffAndEdge[x + 1], this.diffAndEdge[x + w]);
                ++x;
            }
            this.add(w1, 0, this.regionLabels[w1 - 1], (byte)0, this.diffAndEdge[w1 - 1], this.diffAndEdge[w1], (byte)0, this.diffAndEdge[w1 + w]);
            int y = 1;
            while (y < h1) {
                p = y * w;
                this.add(p, this.regionLabels[p - w], 0, this.diffAndEdge[p - w], (byte)0, this.diffAndEdge[p], this.diffAndEdge[p + 1], this.diffAndEdge[p + w]);
                int x2 = 1;
                while (x2 < w1) {
                    p = y * w + x2;
                    this.add(p, this.regionLabels[p - w], this.regionLabels[p - 1], this.diffAndEdge[p - w], this.diffAndEdge[p - 1], this.diffAndEdge[p], this.diffAndEdge[p + 1], this.diffAndEdge[p + w]);
                    ++x2;
                }
                this.add(++p, this.regionLabels[p - w], this.regionLabels[p - 1], this.diffAndEdge[p - w], this.diffAndEdge[p - 1], this.diffAndEdge[p], (byte)0, this.diffAndEdge[p + w]);
                ++y;
            }
            p = h1 * w;
            this.add(p, this.regionLabels[p - w], 0, this.diffAndEdge[p - w], (byte)0, this.diffAndEdge[p], this.diffAndEdge[p + 1], (byte)0);
            x = 1;
            while (x < w1) {
                p = h1 * w + x;
                this.add(p, this.regionLabels[p - w], this.regionLabels[p - 1], this.diffAndEdge[p - w], this.diffAndEdge[p - 1], this.diffAndEdge[p], this.diffAndEdge[p + 1], (byte)0);
                ++x;
            }
            this.add(++p, this.regionLabels[p - w], this.regionLabels[p - 1], this.diffAndEdge[p - w], this.diffAndEdge[p - 1], this.diffAndEdge[p], (byte)0, (byte)0);
            switch (this.buffer.getColorMode()) {
                case RGBA8: {
                    ms = new MaskSetter(){
                        final byte[] b;
                        {
                            this.b = (byte[])RegionFilter.this.buffer.getArray();
                        }

                        void set(int i) {
                            byte by = this.b[i * 4 + 2];
                            this.b[i * 4 + 3] = by;
                            this.b[i * 4 + 1] = by;
                            this.b[i * 4] = by;
                        }

                        void clear(int i) {
                            this.b[i * 4 + 3] = 0;
                            this.b[i * 4 + 2] = 0;
                            this.b[i * 4 + 1] = 0;
                            this.b[i * 4] = 0;
                        }
                    };
                    break;
                }
                case RGBA16: {
                    ms = new MaskSetter(){
                        final short[] s;
                        {
                            this.s = (short[])RegionFilter.this.buffer.getArray();
                        }

                        void set(int i) {
                            short s = this.s[i * 4 + 2];
                            this.s[i * 4 + 3] = s;
                            this.s[i * 4 + 1] = s;
                            this.s[i * 4] = s;
                        }

                        void clear(int i) {
                            this.s[i * 4 + 3] = 0;
                            this.s[i * 4 + 2] = 0;
                            this.s[i * 4 + 1] = 0;
                            this.s[i * 4] = 0;
                        }
                    };
                    break;
                }
                default: {
                    ms = new MaskSetter(){
                        final float[] f;
                        {
                            this.f = (float[])RegionFilter.this.buffer.getArray();
                        }

                        void set(int i) {
                            float f = this.f[i * 4 + 2];
                            this.f[i * 4 + 3] = f;
                            this.f[i * 4 + 1] = f;
                            this.f[i * 4] = f;
                        }

                        void clear(int i) {
                            this.f[i * 4 + 3] = 0.0f;
                            this.f[i * 4 + 2] = 0.0f;
                            this.f[i * 4 + 1] = 0.0f;
                            this.f[i * 4] = 0.0f;
                        }
                    };
                }
            }
            int len = this.regionLabelsIA.getLength();
            int i = 0;
            while (i < len) {
                int regionSize;
                int label = this.regionLabels[i];
                while ((regionSize = this.regionSizes[label]) < 0) {
                    label = -this.regionSizes[label];
                }
                if ((double)regionSize < minRegionSize || (double)this.edgeCoverages[label] < (double)this.edgeLengths[label] * minEdgeCoverage) {
                    ms.clear(i);
                } else {
                    ms.set(i);
                }
                ++i;
            }
        }

        private void add(int pxIndex, int upperLabel, int leftLabel, byte upper, byte left, byte center, byte right, byte lower) {
            boolean edge;
            if ((center & 2) == 0) {
                this.regionLabels[pxIndex] = 0;
                return;
            }
            int label = 0;
            if (upperLabel > 0 && leftLabel > 0 && upperLabel != leftLabel) {
                while (this.regionSizes[upperLabel] < 0) {
                    upperLabel = -this.regionSizes[upperLabel];
                }
                while (this.regionSizes[leftLabel] < 0) {
                    leftLabel = -this.regionSizes[leftLabel];
                }
                if (leftLabel != upperLabel) {
                    int n = upperLabel;
                    this.regionSizes[n] = this.regionSizes[n] + this.regionSizes[leftLabel];
                    int n2 = upperLabel;
                    this.edgeLengths[n2] = this.edgeLengths[n2] + this.edgeLengths[leftLabel];
                    int n3 = upperLabel;
                    this.edgeCoverages[n3] = this.edgeCoverages[n3] + this.edgeCoverages[leftLabel];
                    this.regionSizes[leftLabel] = -upperLabel;
                }
                label = upperLabel;
            } else if (upperLabel > 0) {
                label = upperLabel;
            } else if (leftLabel > 0) {
                label = leftLabel;
            }
            if (label > 0) {
                while (this.regionSizes[label] < 0) {
                    label = -this.regionSizes[label];
                }
                this.regionLabels[pxIndex] = label;
                int n = label;
                this.regionSizes[n] = this.regionSizes[n] + 1;
            } else {
                if (this.regionSizesIA.getLength() - 1 == this.regionCount) {
                    this.regionSizesIA = this.expandArray(this.regionSizesIA);
                    this.regionSizes = (int[])this.regionSizesIA.getArray();
                    this.edgeLengthsIA = this.expandArray(this.edgeLengthsIA);
                    this.edgeLengths = (int[])this.edgeLengthsIA.getArray();
                    this.edgeCoveragesIA = this.expandArray(this.edgeCoveragesIA);
                    this.edgeCoverages = (int[])this.edgeCoveragesIA.getArray();
                }
                this.regionLabels[pxIndex] = label = ++this.regionCount;
                this.regionSizes[label] = 1;
                this.edgeLengths[label] = 0;
                this.edgeCoverages[label] = 0;
            }
            boolean bl = edge = (center & 1) != 0;
            if ((upper & 2) == 0) {
                int n = label;
                this.edgeLengths[n] = this.edgeLengths[n] + 1;
                if (edge || (upper & 1) != 0) {
                    int n4 = label;
                    this.edgeCoverages[n4] = this.edgeCoverages[n4] + 1;
                }
            }
            if ((left & 2) == 0) {
                int n = label;
                this.edgeLengths[n] = this.edgeLengths[n] + 1;
                if (edge || (left & 1) != 0) {
                    int n5 = label;
                    this.edgeCoverages[n5] = this.edgeCoverages[n5] + 1;
                }
            }
            if ((right & 2) == 0) {
                int n = label;
                this.edgeLengths[n] = this.edgeLengths[n] + 1;
                if (edge || (right & 1) != 0) {
                    int n6 = label;
                    this.edgeCoverages[n6] = this.edgeCoverages[n6] + 1;
                }
            }
            if ((lower & 2) == 0) {
                int n = label;
                this.edgeLengths[n] = this.edgeLengths[n] + 1;
                if (edge || (lower & 1) != 0) {
                    int n7 = label;
                    this.edgeCoverages[n7] = this.edgeCoverages[n7] + 1;
                }
            }
        }

        private IArray<int[]> expandArray(IArray<int[]> oldArray) {
            try {
                IArray newArray = Imas2StageDifferenceKey.this.arrayPools.getIntArray(oldArray.getLength() * 2);
                System.arraycopy(oldArray.getArray(), 0, newArray.getArray(), 0, oldArray.getLength());
                IArray iArray = newArray;
                return iArray;
            }
            finally {
                oldArray.release();
            }
        }
    }
}

