package org.dyndns.nuda.tools.regex.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 正規表現解析結果を表すアノテーションです
 * 
 * @author nkoseki
 * 
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface RegexItem {
	/**
	 * 正規表現マッチグループ内のインデックスを表します
	 * 
	 * @return
	 */
	public int groupIndex();
	
	/**
	 * 
	 * @return
	 */
	public String pattern() default "";
	
	/**
	 * 
	 * @return
	 */
	public int subindex() default -1;
	
	/**
	 * 
	 * @return
	 */
	public String unmatcherRef() default "";
}
