/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.regex;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.dyndns.nuda.tools.regex.annotation.Regex;
import org.dyndns.nuda.tools.regex.annotation.RegexItem;
import org.dyndns.nuda.tools.util.ReflectUtil;

public class RegexProcessor {
    private static Map<String, Pattern> cache = new HashMap<String, Pattern>();

    public <T> List<T> process(String source, Class<T> cls) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (source == null) {
            return resultList;
        }
        if (cls == null) {
            return resultList;
        }
        if (!cls.isAnnotationPresent(Regex.class)) {
            return resultList;
        }
        Regex regex = cls.getAnnotation(Regex.class);
        int flg = 0;
        if (regex.isMultiLine()) {
            flg |= 8;
        }
        if (regex.isDoTall()) {
            flg |= 0x20;
        }
        if (regex.isCaseInsentive()) {
            flg |= 2;
        }
        if (regex.isComments()) {
            flg |= 4;
        }
        if (regex.isLiteral()) {
            flg |= 0x10;
        }
        if (regex.isUnixLines()) {
            flg |= 1;
        }
        if (regex.isUnicodeCase()) {
            flg |= 0x40;
        }
        if (regex.isCanonEq()) {
            flg |= 0x80;
        }
        try {
            Pattern pattern = null;
            if (cache.containsKey(regex.pattern())) {
                pattern = cache.get(regex.pattern());
            } else {
                pattern = flg != 0 ? Pattern.compile(regex.pattern(), flg) : Pattern.compile(regex.pattern());
                cache.put(regex.pattern(), pattern);
            }
            Matcher matcher = pattern.matcher(source);
            List fields = ReflectUtil.getAnnotationPresentedField(cls, RegexItem.class);
            HashMap<Integer, Field> fieldMap = new HashMap<Integer, Field>();
            for (Field f : fields) {
                fieldMap.put(f.getAnnotation(RegexItem.class).groupIndex(), f);
            }
            while (matcher.find()) {
                T instance = cls.newInstance();
                for (Map.Entry entry : fieldMap.entrySet()) {
                    Field targetField = (Field)fieldMap.get(entry.getKey());
                    if (targetField == null) continue;
                    Class<?> fieldType = targetField.getType();
                    if (fieldType.equals(String.class)) {
                        targetField.set(instance, matcher.group((Integer)entry.getKey()));
                        continue;
                    }
                    if (!fieldType.equals(List.class)) continue;
                    ParameterizedType paramType = (ParameterizedType)targetField.getGenericType();
                    Type[] types = paramType.getActualTypeArguments();
                    Class componentType = (Class)types[0];
                    if (componentType.equals(String.class)) {
                        RegexItem subRegexItem = targetField.getAnnotation(RegexItem.class);
                        String subPatternStr = subRegexItem.pattern();
                        int subindex = subRegexItem.subindex();
                        if (subindex <= -1 || subPatternStr == null || subPatternStr.isEmpty()) continue;
                        ArrayList<String> subList = new ArrayList<String>();
                        String subSource = matcher.group((Integer)entry.getKey());
                        Pattern subPattern = Pattern.compile(subPatternStr, flg);
                        Matcher subMatcher = subPattern.matcher(subSource);
                        while (subMatcher.find()) {
                            String subResult = subMatcher.group(subindex);
                            if (subResult == null || subResult.isEmpty()) continue;
                            subList.add(subResult);
                        }
                        targetField.set(instance, subList);
                        continue;
                    }
                    if (!componentType.isAnnotationPresent(Regex.class)) continue;
                    String subSource = matcher.group((Integer)entry.getKey());
                    Regex subRegex = componentType.getAnnotation(Regex.class);
                    List<T> subList = this.process(subSource, componentType);
                    if (subList.size() > 0) {
                        targetField.set(instance, subList);
                        continue;
                    }
                    RegexItem refSource = targetField.getAnnotation(RegexItem.class);
                    if (refSource.unmatcherRef().isEmpty()) continue;
                    String unmatcherRef = refSource.unmatcherRef();
                    try {
                        Field unmatcherRefField = cls.getDeclaredField(unmatcherRef);
                        if (!unmatcherRefField.getType().equals(String.class)) continue;
                        unmatcherRefField.set(instance, subSource);
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                }
                resultList.add(instance);
            }
            return resultList;
        }
        catch (PatternSyntaxException e) {
            return resultList;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return resultList;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return resultList;
        }
    }

    public static void main(String[] args) {
        System.out.println(32);
        System.out.println(32);
        System.out.println(40);
        System.out.println(8);
        System.out.println(8);
    }
}

