/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.Base64InputStream;
import com.sun.faces.io.Base64OutputStreamWriter;
import com.sun.faces.renderkit.ByteArrayGuard;
import com.sun.faces.spi.SerializationProvider;
import com.sun.faces.spi.SerializationProviderFactory;
import com.sun.faces.util.Util;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ResponseStateManager;

public class ResponseStateManagerImpl
extends ResponseStateManager {
    private static final Logger LOGGER = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.renderkit");
    private static final String FACES_VIEW_STATE = "com.sun.faces.FACES_VIEW_STATE";
    private static final String FACES_VIEW_STRUCTURE = "com.sun.faces.FACES_VIEW_STRUCTURE";
    private static final char[] STATE_FIELD_START = "<input type=\"hidden\" name=\"javax.faces.ViewState\" id=\"javax.faces.ViewState\" value=\"".toCharArray();
    private static final char[] STATE_FIELD_END = "\" />".toCharArray();
    private SerializationProvider serialProvider;
    private Boolean compressState;
    private ByteArrayGuard guard;
    private int csBuffSize;

    public ResponseStateManagerImpl() {
        this.init();
    }

    public Object getComponentStateToRestore(FacesContext context) {
        return context.getExternalContext().getRequestMap().get(FACES_VIEW_STATE);
    }

    public boolean isPostback(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey("javax.faces.ViewState");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getTreeStructureToRestore(FacesContext context, String treeId) {
        Object object;
        Object s = context.getExternalContext().getRequestMap().get(FACES_VIEW_STRUCTURE);
        if (s != null) {
            return s;
        }
        if (this.serialProvider == null) {
            this.serialProvider = SerializationProviderFactory.createInstance(context.getExternalContext());
        }
        StateManager stateManager = Util.getStateManager(context);
        String viewString = ResponseStateManagerImpl.getStateParam(context);
        if (viewString == null) {
            return null;
        }
        if (!stateManager.isSavingStateInClient(context)) return viewString;
        ObjectInputStream ois = null;
        try {
            try {
                InputStream bis = this.guard != null ? new CipherInputStream(new Base64InputStream(viewString), this.guard.getDecryptionCipher()) : new Base64InputStream(viewString);
                ois = this.compressState != false ? this.serialProvider.createObjectInputStream(new GZIPInputStream(bis)) : this.serialProvider.createObjectInputStream(bis);
                Object structure = ois.readObject();
                Object state = ois.readObject();
                ResponseStateManagerImpl.storeStateInRequest(context, state);
                ResponseStateManagerImpl.storeStructureInRequest(context, structure);
                object = structure;
                Object var12_14 = null;
                if (ois == null) return object;
            }
            catch (OptionalDataException ode) {
                LOGGER.log(Level.SEVERE, ode.getMessage(), ode);
                throw new FacesException((Throwable)ode);
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.log(Level.SEVERE, cnfe.getMessage(), cnfe);
                throw new FacesException((Throwable)cnfe);
            }
            catch (IOException iox) {
                LOGGER.log(Level.SEVERE, iox.getMessage(), iox);
                throw new FacesException((Throwable)iox);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {
            // empty catch block
            return object;
        }
        ois.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeState(FacesContext context, StateManager.SerializedView view) throws IOException {
        ResponseWriter writer;
        block11: {
            if (this.serialProvider == null) {
                this.serialProvider = SerializationProviderFactory.createInstance(context.getExternalContext());
            }
            StateManager stateManager = Util.getStateManager(context);
            writer = context.getResponseWriter();
            writer.write(STATE_FIELD_START);
            if (stateManager.isSavingStateInClient(context)) {
                ObjectOutputStream oos = null;
                try {
                    void var7_9;
                    Base64OutputStreamWriter bos = new Base64OutputStreamWriter(this.csBuffSize, (Writer)writer);
                    if (this.guard != null) {
                        CipherOutputStream cipherOutputStream = new CipherOutputStream(bos, this.guard.getEncryptionCipher());
                    } else {
                        Base64OutputStreamWriter base64OutputStreamWriter = bos;
                    }
                    oos = this.compressState != false ? this.serialProvider.createObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream((OutputStream)var7_9), 1024)) : this.serialProvider.createObjectOutputStream(new BufferedOutputStream((OutputStream)var7_9, 1024));
                    oos.writeObject(view.getStructure());
                    oos.writeObject(view.getState());
                    oos.flush();
                    oos.close();
                    bos.finish();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Client State: total number of characters written: " + bos.getTotalCharsWritten());
                    }
                    Object var9_10 = null;
                    if (oos == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (oos == null) throw throwable;
                    try {
                        oos.close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException ioe) {}
                oos.close();
            } else {
                writer.write(view.getStructure().toString());
            }
        }
        writer.write(STATE_FIELD_END);
        ResponseStateManagerImpl.writeRenderKitIdField(context, writer);
    }

    private static void storeStateInRequest(FacesContext context, Object state) {
        context.getExternalContext().getRequestMap().put(FACES_VIEW_STATE, state);
    }

    private static void storeStructureInRequest(FacesContext context, Object structure) {
        context.getExternalContext().getRequestMap().put(FACES_VIEW_STRUCTURE, structure);
    }

    private static void writeRenderKitIdField(FacesContext context, ResponseWriter writer) throws IOException {
        String result = context.getApplication().getDefaultRenderKitId();
        if (result != null && !"HTML_BASIC".equals(result)) {
            writer.startElement("input", (UIComponent)context.getViewRoot());
            writer.writeAttribute("type", (Object)"hidden", "type");
            writer.writeAttribute("name", (Object)"javax.faces.RenderKitId", "name");
            writer.writeAttribute("value", (Object)result, "value");
            writer.endElement("input");
        }
    }

    private static String getStateParam(FacesContext context) {
        return (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.ViewState");
    }

    private void init() {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        assert (webConfig != null);
        String pass = webConfig.getEnvironmentEntry(WebConfiguration.WebEnvironmentEntry.ClientStateSavingPassword);
        if (pass != null) {
            this.guard = new ByteArrayGuard(pass);
        }
        this.compressState = webConfig.getBooleanContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.CompressViewState);
        String size = webConfig.getContextInitParameter(WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize);
        String defaultSize = WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getDefaultValue();
        try {
            this.csBuffSize = Integer.parseInt(size);
            if (this.csBuffSize % 2 != 0) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.renderkit.resstatemgr.clientbuf_div_two", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), size, defaultSize});
                }
                this.csBuffSize = Integer.parseInt(defaultSize);
            } else {
                this.csBuffSize /= 2;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Using client state buffer size of " + this.csBuffSize);
                }
            }
        }
        catch (NumberFormatException nfe) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.renderkit.resstatemgr.clientbuf_not_integer", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), size, defaultSize});
            }
            this.csBuffSize = Integer.parseInt(defaultSize);
        }
    }
}

