package trail.sfsb;

import javax.ejb.*;
import java.util.*;
import java.io.Serializable;

@Stateful
public class StatefulCalculator implements Calculator, Serializable {

  public ArrayList <Integer> starts = new ArrayList <Integer> ();
  public ArrayList <Integer> ends = new ArrayList <Integer> ();
  public ArrayList <Double> growthrates = new ArrayList <Double> ();
  public ArrayList <Double> savings = new ArrayList <Double> ();
  public ArrayList <Double> results = new ArrayList <Double> ();

  /*
  @PostConstruct
  public void initialize () {
    // System.err.println("Init is called");
    starts = new ArrayList <Integer> ();
    ends = new ArrayList <Integer> ();
    growthrates = new ArrayList <Double> ();
    savings = new ArrayList <Double> ();
    results = new ArrayList <Double> ();
  }
  */

  public double calculate (int start, int end, double growthrate, double saving) {
    double tmp = Math.pow(1. + growthrate / 12., 12. * (end - start) + 1);
    double result = saving * 12. * (tmp - 1) / growthrate;

    starts.add(Integer.valueOf(start));
    ends.add(Integer.valueOf(end));
    growthrates.add(Double.valueOf(growthrate));
    savings.add(Double.valueOf(saving));
    results.add(Double.valueOf(result));

    return result;
  }

  public ArrayList <Integer> getStarts () {
    return starts;
  }

  public ArrayList <Integer> getEnds () {
    return ends;
  }

  public ArrayList <Double> getGrowthrates () {
    return growthrates;
  }

  public ArrayList <Double> getSavings () {
    return savings;
  }

  public ArrayList <Double> getResults () {
    return results;
  }

}
