package trail.mdpojo;

import org.jboss.annotation.ejb.Consumer;

import javax.ejb.*;
import java.sql.Timestamp;

@Consumer(activationConfig =
{
  @ActivationConfigProperty(propertyName="destinationType",
    propertyValue="javax.jms.Queue"),
  @ActivationConfigProperty(propertyName="destination",
    propertyValue="queue/mdpojo")
})
public class MdpojoCalculator implements Calculator {

  public void doCalculation (long sent, int start, int end, double growthrate, double saving) {

    double result = calculate (start, end, growthrate, saving);
    RecordManager.addRecord (new Timestamp(sent), result);

    System.out.println ("The MD POJO is invoked");
  }

  private double calculate (int start, int end, double growthrate, double saving) {
    double tmp = Math.pow(1. + growthrate / 12., 12. * (end - start) + 1);
    return saving * 12. * (tmp - 1) / growthrate;
  }

}