package trail.interceptor;

import javax.ejb.*;


public class Tracer {

  @AroundInvoke
  public Object log (InvocationContext ctx)
                            throws Exception {

    InterceptorCalculator cal = (InterceptorCalculator) ctx.getBean();
    String className = ctx.getBean().getClass().getName();
    String methodName = ctx.getMethod().getName();
    String target = className + "." + methodName + "()";

    long start = System.currentTimeMillis();
    System.out.println ("Invoking " + target);
    cal.setTrace(cal.getTrace() + "<br/>" +
                 "Invoking " + target);
    try {
      return ctx.proceed();
    } catch(Exception e) {
      throw e;
    } finally {
      System.out.println("Exiting " + target);
      cal.setTrace(cal.getTrace() + "<br/>" +
                   "Exiting " + target);
      long time = System.currentTimeMillis() - start;
      System.out.println("This method takes " +
                          time + "ms to execute");
      cal.setTrace(cal.getTrace() + "<br/>" + 
                   "This method takes " +
                   time + "ms to execute");
    }
  }

}
