package trail.entity.query;

import trail.entity.beans.*;
import javax.ejb.*;
import javax.persistence.*;
import javax.annotation.Resource;
import java.util.*;

@Stateless
public class QueryCalculator implements Calculator {

  @PersistenceContext
  protected EntityManager em;

  public Collection <Fund> getFunds () {
    return em.createQuery("from Fund f").getResultList();
  }
  public Collection <Investor> getInvestors () {
    return em.createQuery("from Investor p").getResultList();
  }
  public Collection <TimedRecord> getRecords () {
    return em.createQuery("from TimedRecord r order by r.id desc").getResultList();
  }
  public Collection <TimedRecord> filterRecords (double low, double high) {
    return em.createQuery(
        "from TimedRecord r where r.result > :low AND r.result < :high")
        .setParameter ("low", new Double (low))
        .setParameter ("high", new Double (high))
        .getResultList();
  }

}
