package trail.entity.beans;

import javax.persistence.*;
import java.sql.Timestamp;
import java.io.Serializable;

@Entity
@DiscriminatorValue (value="T")
public class TimedRecord extends Record
                        implements Serializable {

  private Timestamp ts;

  public TimedRecord () { }

  public TimedRecord (Fund fund, Investor investor,
                      double saving, double result,
                      Timestamp ts) {
    this.fund = fund;
    this.investor = investor;
    this.saving = saving;
    this.result = result;
    this.ts = ts;
  }

  public Timestamp getTs () {
    return ts;
  }

  public void setTs (Timestamp ts) {
    this.ts = ts;
  }

}
