package trail.entity.beans;

import javax.persistence.*;
import java.io.Serializable;

@Entity
@Table(name = "record")
@DiscriminatorColumn(name="record_type")
@DiscriminatorValue(value="B")
public class Record implements Serializable {
  protected int id;
  protected Fund fund;
  protected Investor investor;
  protected double saving;
  protected double result;

  public Record () { }

  public Record (Fund fund, Investor investor, double saving, double result) {
    this.fund = fund;
    this.investor = investor;
    this.saving = saving;
    this.result = result;
  }

  @Id
  @GeneratedValue
  public int getId () {
    return id;
  }

  public void setId (int id) {
    this.id = id;
  }

  @ManyToOne(optional=false)
  @JoinColumn(name="my_fundid")
  public Fund getFund () {
    return fund;
  }

  public void setFund (Fund fund) {
    this.fund = fund;
  }

  @ManyToOne(optional=false)
  // Use the system-specified join column
  public Investor getInvestor () {
    return investor;
  }

  public void setInvestor (Investor investor) {
    this.investor = investor;
  }

  public double getSaving () {
    return saving;
  }

  public void setSaving (double saving) {
    this.saving = saving;
  }

  public double getResult () {
    return result;
  }

  public void setResult (double result) {
    this.result = result;
  }

}
