<%@ page contentType="text/html; charset=Shift_JIS" %>
<%@ page import="javax.naming.*,
                 java.text.*,
                 java.util.*,
                 trail.entity.beans.*, trail.entity.query.*"%>

<%!
  private Calculator cal = null;
  private NumberFormat nf = null;

  public void jspInit () {
    try {
      InitialContext ctx = new InitialContext();
      cal = (Calculator) ctx.lookup(
                  "EJB3Trail/QueryCalculator/local");
    } catch (Exception e) {
      e.printStackTrace ();
    }

    nf = NumberFormat.getInstance();
    nf.setMaximumFractionDigits(2);
  }
%>

<%
    Collection records;
    if ("Filter".equals(request.getParameter("action"))) {
        double low, high;
        try {
            low = Double.parseDouble(request.getParameter("low"));
            high = Double.parseDouble(request.getParameter("high"));
        } catch (Exception e) {
            low = 0.;
            high = 0.;
        }
        records = cal.filterRecords (low, high);
        // System.err.println("Filtered the records; low=" + low + " high=" + high);
    } else {
        records = new ArrayList ();
        // System.err.println("Empty records");
    }
%>

<html><body>

<p>ߋ̌vZʂ<br/>
<form action="filter.jsp" method="POST">
  <input type="text" name="low" value="0">
  <input type="text" name="high" value="1000000">܂
  <input type="hidden" name="action" value="Filter"><br/>
  <input type="submit" value="Search">
  <INPUT type="button" value="Close Window" onClick="window.close()">
</form><br/>

<table>
<tr>
<td>^CX^v</td>
<td></td>
<td>l</td>
<td>|z</td>
<td><b>vz</b></td>
</tr>

<%
    for (Iterator iter = records.iterator(); iter.hasNext();) {
        TimedRecord record = (TimedRecord) iter.next();
%>

<tr>
<td><%=record.getTs()%></td>
<td><%=record.getFund().getName()%></td>
<td><%=record.getInvestor().getName()%></td>
<td><%=nf.format(record.getSaving())%></td>
<td><%=nf.format(record.getResult())%></td>
</tr>

<%
    }
%>
</table>


</p>
</body></html>