/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.xml;

import java.io.PrintWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    protected PrintWriter out;
    protected boolean canonical;

    public DOMWriter(Writer w) {
        this(w, false);
    }

    public DOMWriter(Writer w, boolean canonical) {
        this.out = new PrintWriter(w);
        this.canonical = canonical;
    }

    public void print(Node node) {
        this.print(node, true);
    }

    public void print(Node node, boolean prettyprint) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                if (!this.canonical) {
                    this.out.println("<?xml version=\"1.0\"?>");
                }
                NodeList children = node.getChildNodes();
                for (int iChild = 0; iChild < children.getLength(); ++iChild) {
                    this.print(children.item(iChild));
                }
                this.out.flush();
                break;
            }
            case 1: {
                this.out.print('<');
                this.out.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    this.out.print(' ');
                    this.out.print(attr.getNodeName());
                    this.out.print("=\"");
                    this.out.print(this.normalize(attr.getNodeValue()));
                    this.out.print('\"');
                }
                this.out.print('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.print(children.item(i));
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        this.print(children.item(i));
                    }
                    break;
                }
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    this.out.print(this.normalize(node.getNodeValue()));
                    break;
                }
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                this.out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.out.print(' ');
                    this.out.print(data);
                }
                this.out.print("?>");
                break;
            }
            case 8: {
                this.out.print("<!--");
                String data = node.getNodeValue();
                if (data != null) {
                    this.out.print(data);
                }
                this.out.print("-->");
                break;
            }
        }
        if (type == 1) {
            this.out.print("</");
            this.out.print(node.getNodeName());
            this.out.print('>');
        }
        this.out.flush();
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name = array[i].getNodeName();
            int index = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }

    protected String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        continue block7;
                    }
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }
}

