/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.util.Properties;
import org.jboss.util.platform.Constants;

public final class StringPropertyReplacer {
    public static final String NEWLINE = Constants.LINE_SEPARATOR;
    private static final String FILE_SEPARATOR = Constants.FILE_SEPARATOR;
    private static final String PATH_SEPARATOR = Constants.PATH_SEPARATOR;
    private static final String FILE_SEPARATOR_ALIAS = "/";
    private static final String PATH_SEPARATOR_ALIAS = ":";
    private static final int NORMAL = 0;
    private static final int SEEN_DOLLAR = 1;
    private static final int IN_BRACKET = 2;

    public static String replaceProperties(String string) {
        return StringPropertyReplacer.replaceProperties(string, System.getProperties());
    }

    public static String replaceProperties(String string, Properties props) {
        char[] chars = string.toCharArray();
        StringBuffer buffer = new StringBuffer();
        boolean properties = false;
        int state = 0;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '$' && state != 2) {
                state = 1;
                continue;
            }
            if (c == '{' && state == 1) {
                buffer.append(string.substring(start, i - 1));
                state = 2;
                start = i - 1;
                continue;
            }
            if (state == 1) {
                state = 0;
                continue;
            }
            if (c != '}' || state != 2) continue;
            if (start + 2 == i) {
                buffer.append("${}");
            } else {
                String value = null;
                String key = string.substring(start + 2, i);
                if (FILE_SEPARATOR_ALIAS.equals(key)) {
                    value = FILE_SEPARATOR;
                } else if (PATH_SEPARATOR_ALIAS.equals(key)) {
                    value = PATH_SEPARATOR;
                } else {
                    String realKey;
                    int colon;
                    value = props.getProperty(key);
                    if (value == null && (colon = key.indexOf(58)) > 0 && (value = System.getProperty(realKey = key.substring(0, colon))) == null) {
                        value = key.substring(colon + 1);
                    }
                }
                if (value != null) {
                    properties = true;
                    buffer.append(value);
                }
            }
            start = i + 1;
            state = 0;
        }
        if (!properties) {
            return string;
        }
        if (start != chars.length) {
            buffer.append(string.substring(start, chars.length));
        }
        return buffer.toString();
    }
}

