/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.jboss.logging.LoggerPlugin;

public class LoggerPluginWriter
extends PrintWriter {
    public LoggerPluginWriter(LoggerPlugin logger) {
        super((Writer)new PluginWriter(logger), true);
    }

    static class PluginWriter
    extends Writer {
        private LoggerPlugin logger;
        private boolean closed;

        public PluginWriter(LoggerPlugin logger) {
            this.lock = logger;
            this.logger = logger;
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Called write on closed Writer");
            }
            while (len > 0 && (cbuf[len - 1] == '\n' || cbuf[len - 1] == '\r')) {
                --len;
            }
            if (len > 0) {
                this.logger.info(String.copyValueOf(cbuf, off, len));
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Called flush on closed Writer");
            }
        }

        public void close() {
            this.closed = true;
        }
    }
}

