/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.standalone.Compiler;

public class ConstructionTransformer {
    private Instrumentor instrumentor;
    private AspectManager manager;

    public ConstructionTransformer(Instrumentor instrumentor, AspectManager manager) {
        this.instrumentor = instrumentor;
        this.manager = manager;
    }

    public static String constructorFactory(String className) {
        return className + "_new_" + "$aop";
    }

    public boolean insertConstructionInterception(CtClass clazz, ClassAdvisor advisor) throws Exception {
        if (!advisor.getManager().isConstruction()) {
            return false;
        }
        boolean oneMatch = false;
        List constructors = this.instrumentor.getConstructors(clazz);
        Iterator it = constructors.iterator();
        int index = 0;
        while (it.hasNext()) {
            CtConstructor constructor = (CtConstructor)it.next();
            if (!constructor.isClassInitializer() && ConstructionTransformer.isAdvisableConstructor(constructor, advisor)) {
                if (!oneMatch) {
                    oneMatch = true;
                    this.instrumentor.setupBasics(clazz);
                }
                if (AspectManager.optimize) {
                    this.optimize(constructor, index);
                } else {
                    this.unoptimized(constructor, index);
                }
            }
            ++index;
        }
        return oneMatch;
    }

    private void optimize(CtConstructor constructor, int index) throws Exception {
        CtClass type = constructor.getDeclaringClass();
        this.createOptimizedInvocationClass(type, constructor, index);
        this.createOptimizedWrapper(type, constructor, constructor.getDeclaringClass(), index);
    }

    public static boolean isAdvisableConstructor(CtConstructor con, ClassAdvisor advisor) throws NotFoundException {
        Iterator pointcuts = advisor.getManager().getPointcuts().values().iterator();
        while (pointcuts.hasNext()) {
            Pointcut pointcut = (Pointcut)pointcuts.next();
            if (!pointcut.matchesConstruction((Advisor)advisor, con)) continue;
            return true;
        }
        return false;
    }

    private void createOptimizedWrapper(CtClass type, CtConstructor constructor, CtClass clazz, int index) throws Exception {
        String invocationClass = this.getOptimizedInvocationClassName(type, index);
        if (!Modifier.isPublic((int)constructor.getModifiers())) {
            invocationClass = invocationClass.substring(invocationClass.lastIndexOf(46) + 1);
            invocationClass = clazz.getName() + "$" + invocationClass;
        }
        String code = "    org.jboss.aop.advice.Interceptor[] interceptors = aop$classAdvisor$aop.getConstructionInterceptors()[" + index + "]; " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "       " + invocationClass + " invocation = new " + invocationClass + "(interceptors, " + "aop$classAdvisor$aop" + ".getConstructors()[" + index + "]); " + MethodExecutionTransformer.setArguments(constructor.getParameterTypes()) + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       invocation.setTargetObject(this); " + "       invocation.invokeNext(); " + "    } ";
        constructor.insertAfter(code, false);
    }

    private void unoptimized(CtConstructor constructor, int index) throws Exception {
        String args = "";
        if (constructor.getParameterTypes().length > 0) {
            args = ", $args";
        }
        String code = "    org.jboss.aop.advice.Interceptor[] interceptors = aop$classAdvisor$aop.getConstructionInterceptors()[" + index + "]; " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "       org.jboss.aop.joinpoint.ConstructionInvocation invocation = new org.jboss.aop.joinpoint.ConstructionInvocation(interceptors, " + "aop$classAdvisor$aop" + ".getConstructors()[" + index + "]" + args + "); " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       invocation.setTargetObject(this); " + "       invocation.invokeNext(); " + "    } ";
        constructor.insertAfter(code, false);
    }

    protected String createOptimizedInvocationClass(CtClass clazz, CtConstructor con, int index) throws Exception {
        CtClass invocation;
        boolean makeInnerClass;
        AOPClassPool pool = (AOPClassPool)this.instrumentor.getClassPool();
        CtClass conInvocation = pool.get("org.jboss.aop.joinpoint.ConstructionInvocation");
        CtClass untransformable = pool.get("org.jboss.aop.instrument.Untransformable");
        String className = this.getOptimizedInvocationClassName(clazz, index);
        boolean bl = makeInnerClass = !Modifier.isPublic((int)con.getModifiers());
        if (makeInnerClass) {
            String innerClassName = className.substring(className.lastIndexOf(46) + 1);
            boolean classStatic = true;
            invocation = clazz.makeNestedClass(innerClassName, classStatic);
            invocation.setSuperclass(conInvocation);
        } else {
            invocation = pool.makeClass(className, conInvocation);
        }
        invocation.addInterface(untransformable);
        CtConstructor template = null;
        CtConstructor[] tcons = conInvocation.getDeclaredConstructors();
        for (int i = 0; i < tcons.length; ++i) {
            if (tcons[i].getParameterTypes().length != 2) continue;
            template = tcons[i];
            break;
        }
        CtConstructor icon = CtNewConstructor.make((CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (CtClass)invocation);
        invocation.addConstructor(icon);
        CtClass[] params = con.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            CtField field = new CtField(params[i], "arg" + i, invocation);
            field.setModifiers(1);
            invocation.addField(field);
        }
        TransformerCommon.addGetArguments(pool, invocation, con.getParameterTypes());
        this.addCopy(pool, invocation, con.getParameterTypes());
        if (Compiler.loader != null) {
            URL url = Compiler.loader.getResource(con.getDeclaringClass().getName().replace('.', '/') + ".class");
            String path = url.toString();
            path = path.substring(0, path.lastIndexOf(47) + 1);
            path = path + invocation.getSimpleName() + ".class";
            URI newUrl = new URI(path);
            File file = new File(newUrl);
            FileOutputStream fp = new FileOutputStream(file);
            fp.write(invocation.toBytecode());
            fp.close();
        } else {
            invocation.toClass();
        }
        return invocation.getName();
    }

    private String getOptimizedInvocationClassName(CtClass declaringClazz, int constructorIndex) {
        return declaringClazz.getName() + constructorIndex + "OptimizedConstructionInvocation";
    }

    private void addCopy(ClassPool pool, CtClass invocation, CtClass[] params) throws Exception {
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.ConstructionInvocation");
        CtMethod template = methodInvocation.getDeclaredMethod("copy");
        CtMethod copy = CtNewMethod.make((CtClass)template.getReturnType(), (String)"copy", (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), null, (CtClass)invocation);
        copy.setModifiers(template.getModifiers());
        String code = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.interceptors, this.constructor); " + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; ";
        for (int i = 0; i < params.length; ++i) {
            code = code + "   wrapper.arg" + i + " = this.arg" + i + "; ";
        }
        code = code + "   return wrapper; }";
        copy.setBody(code);
        invocation.addMethod(copy);
    }
}

