/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.properties;

import de.java2html.javasource.JavaSourceType;
import de.java2html.options.ConversionOptionsUtilities;
import de.java2html.options.HorizontalAlignment;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.options.JavaSourceStyleEntry;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.properties.IllegalPropertyValueException;
import de.java2html.util.RGB;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConversionOptionsPropertiesReader {
    public JavaSourceConversionOptions read(Properties properties) throws IllegalPropertyValueException {
        JavaSourceConversionOptions conversionOptions = JavaSourceConversionOptions.getRawDefault();
        this.adjustStyleTable(properties, conversionOptions);
        this.adjustShowFileName(properties, conversionOptions);
        this.adjustBorder(properties, conversionOptions);
        this.adjustLineNumbers(properties, conversionOptions);
        this.adjustShowJava2HtmlLink(properties, conversionOptions);
        this.adjustTabSize(properties, conversionOptions);
        this.adjustAlignment(properties, conversionOptions);
        this.adjustStyleEntries(properties, conversionOptions);
        return conversionOptions;
    }

    private void adjustAlignment(Properties properties, JavaSourceConversionOptions conversionOptions) throws IllegalPropertyValueException {
        String alignmentValue = properties.getProperty("horizontalAlignment");
        if (alignmentValue != null) {
            HorizontalAlignment alignment = HorizontalAlignment.getByName(alignmentValue);
            if (alignment == null) {
                throw new IllegalPropertyValueException("horizontalAlignment", alignmentValue, ConversionOptionsUtilities.getAvailableHorizontalAlignmentNames());
            }
            conversionOptions.setHorizontalAlignment(alignment);
        }
    }

    private void adjustTabSize(Properties properties, JavaSourceConversionOptions conversionOptions) throws IllegalPropertyValueException {
        String tabSizeValue = properties.getProperty("TAB_SIZE");
        if (tabSizeValue != null) {
            try {
                int tabSize = Integer.parseInt(tabSizeValue);
                if (tabSize < 0) {
                    throw new NumberFormatException();
                }
                conversionOptions.setTabSize(tabSize);
            }
            catch (NumberFormatException e) {
                throw new IllegalPropertyValueException("TAB_SIZE", tabSizeValue);
            }
        }
    }

    private void adjustShowFileName(Properties properties, JavaSourceConversionOptions conversionOptions) throws IllegalPropertyValueException {
        String value = properties.getProperty("showFileName");
        if (value != null) {
            conversionOptions.setShowFileName(this.parseBooleanValue("showFileName", value));
        }
    }

    private void adjustShowJava2HtmlLink(Properties properties, JavaSourceConversionOptions conversionOptions) throws IllegalPropertyValueException {
        String value = properties.getProperty("showJava2HtmlLink");
        if (value != null) {
            conversionOptions.setShowJava2HtmlLink(this.parseBooleanValue("showJava2HtmlLink", value));
        }
    }

    private void adjustLineNumbers(Properties properties, JavaSourceConversionOptions conversionOptions) throws IllegalPropertyValueException {
        String value = properties.getProperty("showLineNumbers");
        if (value != null) {
            conversionOptions.setShowLineNumbers(this.parseBooleanValue("showLineNumbers", value));
        }
    }

    private void adjustBorder(Properties properties, JavaSourceConversionOptions conversionOptions) throws IllegalPropertyValueException {
        String value = properties.getProperty("showTableBorder");
        if (value != null) {
            conversionOptions.setShowTableBorder(this.parseBooleanValue("showTableBorder", value));
        }
    }

    private void adjustStyleTable(Properties properties, JavaSourceConversionOptions conversionOptions) throws IllegalPropertyValueException {
        String defaultTableName = properties.getProperty("defaultStyleName");
        if (defaultTableName != null) {
            JavaSourceStyleTable table = JavaSourceStyleTable.getPredefinedTable(defaultTableName);
            if (table == null) {
                throw new IllegalPropertyValueException("defaultStyleName", defaultTableName, ConversionOptionsUtilities.getPredefinedStyleTableNames());
            }
            conversionOptions.setStyleTable(table);
        }
    }

    private boolean parseBooleanValue(String propertyName, String value) throws IllegalPropertyValueException {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
            return false;
        }
        throw new IllegalPropertyValueException(propertyName, value, new String[]{"true", "false"});
    }

    private RGB parseColorValue(String propertyName, String colorValue) throws IllegalPropertyValueException {
        StringTokenizer tokenizer = new StringTokenizer(colorValue, ",");
        if (tokenizer.countTokens() != 3) {
            throw new IllegalPropertyValueException(propertyName, colorValue);
        }
        String redValue = tokenizer.nextToken();
        String greenValue = tokenizer.nextToken();
        String blueValue = tokenizer.nextToken();
        int red = 0;
        int green = 0;
        int blue = 0;
        try {
            red = Integer.parseInt(redValue);
            green = Integer.parseInt(greenValue);
            blue = Integer.parseInt(blueValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalPropertyValueException(propertyName, colorValue);
        }
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
            throw new IllegalPropertyValueException(propertyName, colorValue);
        }
        return new RGB(red, green, blue);
    }

    private void adjustStyleEntries(Properties properties, JavaSourceConversionOptions conversionOptions) throws IllegalPropertyValueException {
        JavaSourceType[] sourceTypes = JavaSourceType.getAll();
        for (int i = 0; i < sourceTypes.length; ++i) {
            this.adjustStyleEntry(properties, conversionOptions, sourceTypes[i]);
        }
    }

    private void adjustStyleEntry(Properties properties, JavaSourceConversionOptions conversionOptions, JavaSourceType type) throws IllegalPropertyValueException {
        RGB color = this.getColor(properties, conversionOptions, type);
        boolean bold = this.getBold(properties, conversionOptions, type);
        boolean italic = this.getItalic(properties, conversionOptions, type);
        conversionOptions.getStyleTable().put(type, new JavaSourceStyleEntry(color, bold, italic));
    }

    private boolean getItalic(Properties properties, JavaSourceConversionOptions conversionOptions, JavaSourceType type) throws IllegalPropertyValueException {
        String italicPropertyName = type.getName() + "_ITALIC";
        String italicValue = properties.getProperty(italicPropertyName);
        if (italicValue != null) {
            return this.parseBooleanValue(italicPropertyName, italicValue);
        }
        return conversionOptions.getStyleTable().get(type).isItalic();
    }

    private boolean getBold(Properties properties, JavaSourceConversionOptions conversionOptions, JavaSourceType type) throws IllegalPropertyValueException {
        String boldPropertyName = type.getName() + "_BOLD";
        String boldValue = properties.getProperty(boldPropertyName);
        if (boldValue != null) {
            return this.parseBooleanValue(boldPropertyName, boldValue);
        }
        return conversionOptions.getStyleTable().get(type).isBold();
    }

    private RGB getColor(Properties properties, JavaSourceConversionOptions conversionOptions, JavaSourceType type) throws IllegalPropertyValueException {
        String colorPropertyName = type.getName() + "_COLOR";
        String colorValue = properties.getProperty(colorPropertyName);
        if (colorValue != null) {
            return this.parseColorValue(colorPropertyName, colorValue);
        }
        return conversionOptions.getStyleTable().get(type).getColor();
    }
}

