/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.annotation.ejb.MessageProperties;
import org.jboss.annotation.ejb.MessagePropertiesImpl;
import org.jboss.annotation.ejb.Producer;
import org.jboss.annotation.ejb.Producers;
import org.jboss.aop.util.MethodHashing;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.JndiProxyFactory;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.mdb.ConsumerContainer;
import org.jboss.ejb3.mdb.ProducerImpl;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

public abstract class ProducerFactory
implements ProxyFactory {
    private static final Logger log = Logger.getLogger(ProducerFactory.class);
    protected Class producer;
    protected MessageProperties props;
    protected Destination dest;
    protected HashMap<Long, MessageProperties> methodMap;
    protected ProducerImpl pImpl;
    protected String jndiName;
    protected InitialContext ctx;
    protected Hashtable initialContextProperties;
    public static final String PROXY_FACTORY_NAME = "PRODUCER_FACTORY";

    protected ProducerFactory(ConsumerContainer container, Class producer, MessageProperties props, Destination dest, InitialContext ctx, Hashtable ctxProperties) {
        this.producer = producer;
        this.props = props;
        this.dest = dest;
        this.ctx = ctx;
        this.initialContextProperties = ctxProperties;
        this.methodMap = new HashMap();
        for (Method method : producer.getMethods()) {
            MessageProperties mProps = method.getAnnotation(MessageProperties.class);
            if (mProps == null) continue;
            try {
                this.methodMap.put(MethodHashing.methodHash((Method)method), (MessageProperties)new MessagePropertiesImpl(mProps));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Producer p = producer.getAnnotation(Producer.class);
        if (p == null) {
            p = (Producer)container.resolveAnnotation(Producer.class);
        }
        if (p == null) {
            Producers annotation = (Producers)container.resolveAnnotation(Producers.class);
            for (Producer producerAnnotation : annotation.value()) {
                if (producerAnnotation.producer() == null || !producerAnnotation.producer().equals(producer)) continue;
                p = producerAnnotation;
            }
        }
        this.pImpl = new ProducerImpl(p);
        this.jndiName = producer.getName();
    }

    public void setContainer(Container container) {
    }

    public void start() throws Exception {
        Context baseCtx = this.ctx;
        Name name = baseCtx.getNameParser("").parse(this.jndiName);
        baseCtx = Util.createSubcontext((Context)baseCtx, (Name)name.getPrefix(name.size() - 1));
        String atom = name.get(name.size() - 1);
        StringRefAddr refAddr = new StringRefAddr("FACTORY", atom + PROXY_FACTORY_NAME);
        Reference ref = new Reference("java.lang.Object", refAddr, JndiProxyFactory.class.getName(), null);
        try {
            Util.bind((Context)baseCtx, (String)atom, (Object)ref);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind producer factory into JNDI under jndiName: " + baseCtx.getNameInNamespace() + "/" + atom);
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    public void stop() throws Exception {
        Util.unbind((Context)this.ctx, (String)this.jndiName);
    }
}

