/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitRegistry {
    private static final Logger log = Logger.getLogger(PersistenceUnitRegistry.class);
    private static ConcurrentHashMap<String, PersistenceUnitDeployment> persistenceUnits = new ConcurrentHashMap();

    public static void register(PersistenceUnitDeployment container) {
        if (persistenceUnits.contains(container.getKernelName())) {
            throw new RuntimeException("Persistence Unit is already registered: " + container.getKernelName());
        }
        persistenceUnits.put(container.getKernelName(), container);
    }

    public static void unregister(PersistenceUnitDeployment container) {
        persistenceUnits.remove(container.getKernelName());
    }

    public static PersistenceUnitDeployment getPersistenceUnit(String kernelName) {
        return persistenceUnits.get(kernelName);
    }

    public static Collection<PersistenceUnitDeployment> getPersistenceUnits() {
        return persistenceUnits.values();
    }
}

