/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.RunAsIdentity;

public final class SecurityAssociation {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$SecurityAssociation == null ? (class$org$jboss$security$SecurityAssociation = SecurityAssociation.class$("org.jboss.security.SecurityAssociation")) : class$org$jboss$security$SecurityAssociation));
    private static boolean trace;
    private static boolean server;
    private static Principal principal;
    private static Object credential;
    private static Subject subject;
    private static ThreadLocal threadPrincipal;
    private static ThreadLocal threadCredential;
    private static ThreadLocal threadSubject;
    private static ThreadLocal threadContextMap;
    private static RunAsThreadLocalStack threadRunAsStacks;
    private static final RuntimePermission getPrincipalInfoPermission;
    private static final RuntimePermission getSubjectPermission;
    private static final RuntimePermission setPrincipalInfoPermission;
    private static final RuntimePermission setServerPermission;
    private static final RuntimePermission setRunAsIdentity;
    private static final RuntimePermission getContextInfo;
    private static final RuntimePermission setContextInfo;
    static /* synthetic */ Class class$org$jboss$security$SecurityAssociation;

    public static Principal getPrincipal() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getPrincipalInfoPermission);
        }
        if (SecurityAssociation.peekRunAsIdentity() != null) {
            return SecurityAssociation.peekRunAsIdentity();
        }
        if (server) {
            return (Principal)threadPrincipal.get();
        }
        return principal;
    }

    public static Principal getCallerPrincipal() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getPrincipalInfoPermission);
        }
        if (SecurityAssociation.peekRunAsIdentity(1) != null) {
            return SecurityAssociation.peekRunAsIdentity(1);
        }
        if (server) {
            return (Principal)threadPrincipal.get();
        }
        return principal;
    }

    public static Object getCredential() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getPrincipalInfoPermission);
        }
        if (SecurityAssociation.peekRunAsIdentity() != null) {
            return SecurityAssociation.peekRunAsIdentity().getCredential();
        }
        if (server) {
            return threadCredential.get();
        }
        return credential;
    }

    public static Subject getSubject() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getSubjectPermission);
        }
        if (server) {
            return (Subject)threadSubject.get();
        }
        return subject;
    }

    public static void setPrincipal(Principal principal) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (trace) {
            log.trace((Object)("setPrincipal, p=" + principal + ", server=" + server));
        }
        if (server) {
            threadPrincipal.set(principal);
        } else {
            SecurityAssociation.principal = principal;
        }
    }

    public static void setCredential(Object credential) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (server) {
            threadCredential.set(credential);
        } else {
            SecurityAssociation.credential = credential;
        }
    }

    public static void setSubject(Subject subject) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (trace) {
            log.trace((Object)("setSubject, s=" + subject + ", server=" + server));
        }
        if (server) {
            threadSubject.set(subject);
        } else {
            SecurityAssociation.subject = subject;
        }
    }

    public static Object getContextInfo(Object key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getContextInfo);
        }
        HashMap contextInfo = (HashMap)threadContextMap.get();
        return contextInfo.get(key);
    }

    public static Object setContextInfo(Object key, Object value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setContextInfo);
        }
        HashMap contextInfo = (HashMap)threadContextMap.get();
        return contextInfo.put(key, value);
    }

    public static void clear() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (trace) {
            log.trace((Object)("clear, server=" + server));
        }
        if (server) {
            threadPrincipal.set(null);
            threadCredential.set(null);
            threadSubject.set(null);
        } else {
            principal = null;
            credential = null;
            subject = null;
        }
    }

    public static void pushRunAsIdentity(RunAsIdentity runAs) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setRunAsIdentity);
        }
        if (trace) {
            log.trace((Object)("pushRunAsIdentity, runAs=" + runAs));
        }
        threadRunAsStacks.push(runAs);
    }

    public static RunAsIdentity popRunAsIdentity() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setRunAsIdentity);
        }
        RunAsIdentity runAs = threadRunAsStacks.pop();
        if (trace) {
            log.trace((Object)("popRunAsIdentity, runAs=" + runAs));
        }
        return runAs;
    }

    public static RunAsIdentity peekRunAsIdentity() {
        return SecurityAssociation.peekRunAsIdentity(0);
    }

    public static RunAsIdentity peekRunAsIdentity(int depth) {
        RunAsIdentity runAs = threadRunAsStacks.peek(depth);
        return runAs;
    }

    public static void setServer() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setServerPermission);
        }
        server = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        threadRunAsStacks = new RunAsThreadLocalStack();
        getPrincipalInfoPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.getPrincipalInfo");
        getSubjectPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.getSubject");
        setPrincipalInfoPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.setPrincipalInfo");
        setServerPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.setServer");
        setRunAsIdentity = new RuntimePermission("org.jboss.security.SecurityAssociation.setRunAsRole");
        getContextInfo = new RuntimePermission("org.jboss.security.SecurityAssociation.accessContextInfo", "get");
        setContextInfo = new RuntimePermission("org.jboss.security.SecurityAssociation.accessContextInfo", "set");
        boolean useThreadLocal = false;
        try {
            useThreadLocal = Boolean.getBoolean("org.jboss.security.SecurityAssociation.ThreadLocal");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        trace = log.isTraceEnabled();
        if (useThreadLocal) {
            threadPrincipal = new ThreadLocal();
            threadCredential = new ThreadLocal();
            threadSubject = new ThreadLocal();
            threadContextMap = new ThreadLocal(){

                protected Object initialValue() {
                    return new HashMap();
                }
            };
        } else {
            threadPrincipal = new InheritableThreadLocal();
            threadCredential = new InheritableThreadLocal();
            threadSubject = new InheritableThreadLocal();
            threadContextMap = new InheritableThreadLocal(){

                protected Object initialValue() {
                    return new HashMap();
                }
            };
        }
    }

    private static class RunAsThreadLocalStack
    extends ThreadLocal {
        private RunAsThreadLocalStack() {
        }

        protected Object initialValue() {
            return new ArrayList();
        }

        void push(RunAsIdentity runAs) {
            ArrayList stack = (ArrayList)super.get();
            stack.add(runAs);
        }

        RunAsIdentity pop() {
            ArrayList stack = (ArrayList)super.get();
            RunAsIdentity runAs = null;
            int lastIndex = stack.size() - 1;
            if (lastIndex >= 0) {
                runAs = (RunAsIdentity)stack.remove(lastIndex);
            }
            return runAs;
        }

        RunAsIdentity peek(int depth) {
            ArrayList stack = (ArrayList)super.get();
            RunAsIdentity runAs = null;
            int stackSize = stack.size();
            do {
                int index;
                if ((index = stackSize - 1 - depth) < 0) continue;
                runAs = (RunAsIdentity)stack.get(index);
            } while (runAs == null && ++depth <= stackSize - 1);
            return runAs;
        }
    }
}

