/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import org.hibernate.MappingException;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.ejb.EJB3AutoFlushEventListener;
import org.hibernate.ejb.EJB3FlushEventListener;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.ejb.callback.EJB3PostDeleteEventListener;
import org.hibernate.ejb.callback.EJB3PostInsertEventListener;
import org.hibernate.ejb.callback.EJB3PostLoadEventListener;
import org.hibernate.ejb.callback.EJB3PostUpdateEventListener;
import org.hibernate.ejb.callback.EntityCallbackHandler;
import org.hibernate.mapping.PersistentClass;

public class HibernatePersistence
implements PersistenceProvider {
    public static final String CLASS_NAMES = "hibernate.ejb.classes";
    public static final String PACKAGE_NAMES = "hibernate.ejb.packages";
    public static final String CFG_FILE = "hibernate.ejb.cfgfile";
    public static final String CLASS_CACHE_PREFIX = "hibernate.ejb.classcache";
    public static final String COLLECTION_CACHE_PREFIX = "hibernate.ejb.collectioncache";
    public static final String HBXML_FILES = "hibernate.hbmxml.files";
    public static final String LOADED_CLASSES = "hibernate.ejb.loaded.classes";

    public EntityManagerFactory createEntityManagerFactory(Map properties) {
        AnnotationConfiguration cfg = new AnnotationConfiguration();
        cfg.getSessionEventListenerConfig().setFlushEventListener(EJB3FlushEventListener.INSTANCE);
        cfg.getSessionEventListenerConfig().setAutoFlushEventListener(EJB3AutoFlushEventListener.INSTANCE);
        Properties props = new Properties();
        props.setProperty("hibernate.connection.release_mode", "auto");
        props.putAll((Map<?, ?>)properties);
        cfg.setProperties(props);
        if (properties == null || !properties.containsKey(CLASS_NAMES) && !properties.containsKey(LOADED_CLASSES) && !properties.containsKey(HBXML_FILES)) {
            if (properties != null && properties.containsKey(CFG_FILE)) {
                cfg.configure((String)properties.get(CFG_FILE));
            } else {
                cfg.configure();
            }
        } else {
            if (properties.containsKey(CLASS_NAMES)) {
                String classNames = (String)properties.get(CLASS_NAMES);
                this.addNamedAnnotatedClasses(cfg, classNames);
            }
            if (properties.containsKey(LOADED_CLASSES)) {
                List classes = (List)properties.get(LOADED_CLASSES);
                for (Class clazz : classes) {
                    cfg.addAnnotatedClass(clazz);
                }
            }
            if (properties.containsKey(PACKAGE_NAMES)) {
                List packages = (List)properties.get(PACKAGE_NAMES);
                for (String pkg : packages) {
                    cfg.addPackage(pkg);
                }
            }
            if (properties.containsKey(HBXML_FILES)) {
                List hbmXmlFiles = (List)properties.get(HBXML_FILES);
                for (InputStream is : hbmXmlFiles) {
                    cfg.addInputStream(is);
                }
            }
        }
        for (String propertyKey : properties.keySet()) {
            if (propertyKey.startsWith(CLASS_CACHE_PREFIX)) {
                this.setCacheStrategy(propertyKey, properties, cfg, true);
                continue;
            }
            if (!propertyKey.startsWith(COLLECTION_CACHE_PREFIX)) continue;
            this.setCacheStrategy(propertyKey, properties, cfg, false);
        }
        cfg.setProperty("hibernate.connection.autocommit", "true");
        cfg.setProperty("hibernate.use_identifier_rollback", "true");
        EntityCallbackHandler callbackHandler = this.handleCallbacks(cfg);
        return new EntityManagerFactoryImpl(cfg.buildSessionFactory(), callbackHandler);
    }

    private EntityCallbackHandler handleCallbacks(AnnotationConfiguration cfg) {
        EntityCallbackHandler callbackHandler = new EntityCallbackHandler();
        cfg.buildMappings();
        Iterator classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            PersistentClass clazz = (PersistentClass)classes.next();
            callbackHandler.add(clazz.getMappedClass());
        }
        cfg.setListener("post-delete", (Object)new EJB3PostDeleteEventListener(callbackHandler));
        cfg.setListener("post-load", (Object)new EJB3PostLoadEventListener(callbackHandler));
        cfg.setListener("post-update", (Object)new EJB3PostUpdateEventListener(callbackHandler));
        cfg.setListener("post-insert", (Object)new EJB3PostInsertEventListener(callbackHandler));
        return callbackHandler;
    }

    private void setCacheStrategy(String propertyKey, Map properties, AnnotationConfiguration cfg, boolean isClass) {
        String role = propertyKey.substring((isClass ? CLASS_CACHE_PREFIX.length() : COLLECTION_CACHE_PREFIX.length()) + 1);
        String value = (String)properties.get(propertyKey);
        StringTokenizer params = new StringTokenizer(value, ";, ");
        if (!params.hasMoreTokens()) {
            StringBuffer error = new StringBuffer("Illegal usage of ");
            error.append(isClass ? CLASS_CACHE_PREFIX : COLLECTION_CACHE_PREFIX);
            error.append(": ").append(propertyKey).append(" ").append(value);
            throw new MappingException(error.toString());
        }
        String usage = params.nextToken();
        String region = null;
        if (params.hasMoreTokens()) {
            region = params.nextToken();
        }
        if (isClass) {
            cfg.setCacheConcurrencyStrategy(role, usage, region);
        } else {
            cfg.setCollectionCacheConcurrencyStrategy(role, usage, region);
        }
    }

    private void addNamedAnnotatedClasses(AnnotationConfiguration cfg, String classNames) {
        StringTokenizer classes = new StringTokenizer(classNames, ";, ");
        while (classes.hasMoreTokens()) {
            String name = classes.nextToken();
            try {
                Class<?> clazz = Class.forName(name);
                cfg.addAnnotatedClass(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                Package pkg = Package.getPackage(name);
                if (pkg == null) {
                    throw new IllegalArgumentException("class not found", cnfe);
                }
                cfg.addPackage(name);
            }
        }
    }
}

