package trail.jmx;

import org.jboss.annotation.ejb.Service;
import org.jboss.annotation.ejb.Management;

@Service (objectName="trail:service=calculator")
@Management(Calculator.class)
public class CalculatorMBean implements Calculator {

  double growthrate;

  public void setGrowthrate (double growthrate) {
    this.growthrate = growthrate;
  }

  public double getGrowthrate () {
    return growthrate;
  }
  
  public double calculate (int start, int end, double saving) {
    double tmp = Math.pow(1. + growthrate / 12., 12. * (end - start) + 1);
    return saving * 12. * (tmp - 1) / growthrate;
  }

  // Lifecycle methods
  public void create() throws Exception {
    growthrate = 0.08;
    System.out.println("Calculator - Creating");
  }

  public void destroy() {
    System.out.println("Calculator - Destroying");
  }

}
