/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.CodeConversionObserver;
import org.jboss.aop.instrument.Codifier;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.instrument.WrapperTransformer;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.standalone.Compiler;

public class ConstructorExecutionTransformer
implements CodeConversionObserver {
    private Instrumentor instrumentor;
    private AspectManager manager;
    private Codifier codifier;
    private JoinpointClassifier classifier;
    private static final WrapperTransformer wrapper = new WrapperTransformer(new String[]{"wrapperStatus", "constructorsWrapped"});
    private static final int CONSTRUCTOR_STATUS = 0;
    private static final int ALL_CONSTRUCTORS_STATUS = 1;

    public ConstructorExecutionTransformer(Instrumentor instrumentor, AspectManager manager) {
        this.instrumentor = instrumentor;
        this.manager = manager;
        this.codifier = new Codifier();
        this.classifier = instrumentor.joinpointClassifier;
    }

    public static String constructorFactory(String className) {
        return className + "_new_" + "$aop";
    }

    public boolean transform(CtClass clazz, ClassAdvisor classAdvisor) throws Exception {
        List constructors = this.instrumentor.getConstructors(clazz);
        JoinpointClassification[] classification = this.classifyConstructor(constructors, classAdvisor);
        boolean wrappersGenerated = false;
        boolean oneOrMoreWrapped = false;
        int i = 0;
        boolean dynamicalyWrapped = false;
        boolean notDynamicalyWrapped = false;
        CtConstructor firstConstructor = null;
        if (!constructors.isEmpty()) {
            firstConstructor = (CtConstructor)constructors.get(0);
        }
        Iterator iterator = constructors.iterator();
        while (iterator.hasNext()) {
            CtConstructor constructor = (CtConstructor)iterator.next();
            if (classification[i] != JoinpointClassification.NOT_INSTRUMENTED || oneOrMoreWrapped) {
                if (!wrappersGenerated) {
                    this.buildConstructorWrappers(clazz, classAdvisor);
                    wrappersGenerated = true;
                    wrapper.prepareForWrapping((CtMember)firstConstructor, 1);
                }
                if (classification[i].equals(JoinpointClassification.WRAPPED)) {
                    if (!oneOrMoreWrapped) {
                        for (int j = 0; j < i; ++j) {
                            this.setEmptyWrapperCodeLater(clazz, (CtConstructor)constructors.get(j));
                        }
                        oneOrMoreWrapped = true;
                    }
                    this.wrap(clazz, constructor, i);
                    dynamicalyWrapped = dynamicalyWrapped || classification[i].equals(JoinpointClassification.DYNAMICALY_WRAPPED);
                    notDynamicalyWrapped = notDynamicalyWrapped || !classification[i].equals(JoinpointClassification.DYNAMICALY_WRAPPED);
                } else if (oneOrMoreWrapped) {
                    this.setEmptyWrapperCodeLater(clazz, constructor);
                }
            }
            ++i;
        }
        if (oneOrMoreWrapped) {
            this.wrapAllConstructors(clazz, firstConstructor, null);
        }
        if (dynamicalyWrapped && !notDynamicalyWrapped) {
            this.instrumentor.dynamicTransformationObserver.constructorDynamicalyWrapped();
        }
        return wrappersGenerated;
    }

    private void wrapAllConstructors(CtClass clazz, CtConstructor firstConstructor, List constructors) throws NotFoundException, CannotCompileException {
        wrapper.wrap((CtMember)firstConstructor, 1);
        if (constructors == null) {
            return;
        }
        Iterator i = constructors.iterator();
        while (i.hasNext()) {
            CtConstructor constructor = (CtConstructor)i.next();
            if (wrapper.isWrapped((CtMember)constructor, 0)) continue;
            this.setEmptyWrapperCodeLater(clazz, constructor);
        }
        this.instrumentor.converter.replaceNew(clazz, clazz, ConstructorExecutionTransformer.constructorFactory(clazz.getSimpleName()));
    }

    public void wrap(CtClass clazz, Collection constructorIndexes) throws Exception {
        List constructors = this.instrumentor.getConstructors(clazz);
        CtConstructor firstConstructor = (CtConstructor)constructors.get(0);
        if (wrapper.isNotPrepared((CtMember)firstConstructor, 1)) {
            return;
        }
        Iterator iterator = constructorIndexes.iterator();
        while (iterator.hasNext()) {
            int constructorIndex = (Integer)iterator.next();
            CtConstructor constructor = (CtConstructor)constructors.get(constructorIndex);
            this.wrap(clazz, constructor, constructorIndex);
        }
        if (!wrapper.isWrapped((CtMember)firstConstructor, 1)) {
            this.wrapAllConstructors(clazz, firstConstructor, constructors);
        }
    }

    private void wrap(CtClass clazz, CtConstructor constructor, int constructorIndex) throws NotFoundException, Exception, CannotCompileException {
        CtClass type = constructor.getDeclaringClass();
        String name = clazz.getSimpleName();
        if (wrapper.isNotPrepared((CtMember)constructor, 0)) {
            return;
        }
        wrapper.wrap((CtMember)constructor, 0);
        CtMethod wrapperMethod = clazz.getDeclaredMethod(ConstructorExecutionTransformer.constructorFactory(name), constructor.getParameterTypes());
        this.setTemporaryWrapperCode(constructor.getDeclaringClass(), wrapperMethod);
        if (AspectManager.optimize) {
            this.createOptimizedWrapper(type, name, constructor, clazz, constructorIndex);
        } else {
            this.createWrapper(type, name, constructor, clazz, constructorIndex);
        }
    }

    public void unwrap(CtClass clazz, Collection constructorIndexes) throws NotFoundException {
        List constructors = this.instrumentor.getConstructors(clazz);
        if (wrapper.isNotPrepared((CtMember)constructors.get(0), 1)) {
            return;
        }
        Iterator iterator = constructorIndexes.iterator();
        while (iterator.hasNext()) {
            int constructorIndex = (Integer)iterator.next();
            CtConstructor constructor = (CtConstructor)constructors.get(constructorIndex);
            CtClass type = constructor.getDeclaringClass();
            String name = clazz.getSimpleName();
            if (wrapper.isNotPrepared((CtMember)constructor, 0)) continue;
            wrapper.unwrap((CtMember)constructor, 0);
            CtMethod wrapperMethod = clazz.getDeclaredMethod(ConstructorExecutionTransformer.constructorFactory(name), constructor.getParameterTypes());
            this.setEmptyWrapperCode(constructor.getDeclaringClass(), wrapperMethod);
        }
    }

    public void codeConverted() throws CannotCompileException {
        this.codifier.codifyPending();
    }

    public boolean replaceConstructorAccess(ClassAdvisor sourceAdvisor, CtClass source) throws NotFoundException {
        if (!this.isAnyConstructorAdvised(source, sourceAdvisor)) {
            return false;
        }
        this.instrumentor.converter.replaceNew(source, source, ConstructorExecutionTransformer.constructorFactory(source.getSimpleName()));
        return true;
    }

    public void buildConstructorWrappers(CtClass clazz, ClassAdvisor advisor) throws Exception {
        this.instrumentor.setupBasics(clazz);
        List constructors = this.instrumentor.getConstructors(clazz);
        Iterator it = constructors.iterator();
        int index = 0;
        while (it.hasNext()) {
            CtConstructor constructor = (CtConstructor)it.next();
            int mod = 8;
            mod = (constructor.getModifiers() & 1) != 0 ? (mod |= 1) : ((constructor.getModifiers() & 4) != 0 ? (mod |= 4) : ((constructor.getModifiers() & 2) != 0 ? (mod |= 2) : (mod |= 1)));
            CtClass[] exceptions = constructor.getExceptionTypes();
            String name = clazz.getSimpleName();
            CtClass type = constructor.getDeclaringClass();
            String invocationClass = this.createOptimizedInvocationClass(type, constructor, index);
            CtMethod wmethod = CtNewMethod.make((CtClass)type, (String)ConstructorExecutionTransformer.constructorFactory(name), (CtClass[])constructor.getParameterTypes(), (CtClass[])exceptions, null, (CtClass)clazz);
            wmethod.setModifiers(mod);
            this.setEmptyWrapperCode(type, wmethod);
            clazz.addMethod(wmethod);
            wrapper.prepareForWrapping((CtMember)constructor, 0);
            ++index;
        }
    }

    private void setTemporaryWrapperCode(CtClass type, CtMethod wrapperMethod) {
        String code = "{   return null;}";
        try {
            wrapperMethod.setBody(code);
        }
        catch (CannotCompileException e) {
            System.out.println(code);
            throw new RuntimeException(e);
        }
    }

    private void setEmptyWrapperCode(CtClass type, CtMethod wrapperMethod) {
        String code = "{     return new " + type.getName() + "($$); " + "}";
        try {
            wrapperMethod.setBody(code);
        }
        catch (CannotCompileException e) {
            System.out.println(code);
            throw new RuntimeException(e);
        }
    }

    private void setEmptyWrapperCodeLater(CtClass type, CtConstructor constructor) throws NotFoundException {
        CtMethod wrapperMethod = type.getDeclaredMethod(ConstructorExecutionTransformer.constructorFactory(type.getSimpleName()), constructor.getParameterTypes());
        String code = "{     return new " + type.getName() + "($$); " + "}";
        this.codifier.addPendingCode(wrapperMethod, code);
    }

    private void createWrapper(CtClass type, String name, CtConstructor constructor, CtClass clazz, int index) throws CannotCompileException, NotFoundException {
        CtMethod wmethod = type.getDeclaredMethod(ConstructorExecutionTransformer.constructorFactory(name), constructor.getParameterTypes());
        String code = null;
        String args = "(Object[])null";
        if (constructor.getParameterTypes().length > 0) {
            args = "$args";
        }
        code = "{     org.jboss.aop.advice.Interceptor[] interceptors = aop$classAdvisor$aop.getConstructorInterceptors()[" + index + "]; " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "       return ($r)" + "aop$classAdvisor$aop" + ".invokeNew(" + args + ", (int)" + index + "); " + "    } " + "    return new " + clazz.getName() + "($$); " + "}";
        this.codifier.addPendingCode(wmethod, code);
    }

    private void createOptimizedWrapper(CtClass type, String name, CtConstructor constructor, CtClass clazz, int index) throws Exception {
        String invocationClass = this.getOptimizedInvocationClassName(type, index);
        if (!Modifier.isPublic((int)constructor.getModifiers())) {
            invocationClass = invocationClass.substring(invocationClass.lastIndexOf(46) + 1);
            invocationClass = clazz.getName() + "$" + invocationClass;
        }
        CtMethod wmethod = type.getDeclaredMethod(ConstructorExecutionTransformer.constructorFactory(name), constructor.getParameterTypes());
        String code = "{     org.jboss.aop.advice.Interceptor[] interceptors = aop$classAdvisor$aop.getConstructorInterceptors()[" + index + "]; " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "       " + invocationClass + " invocation = new " + invocationClass + "(interceptors); " + "       invocation.setConstructor(" + "aop$classAdvisor$aop" + ".getConstructors()[" + index + "]); " + MethodExecutionTransformer.setArguments(constructor.getParameterTypes()) + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       return ($r)invocation.invokeNext(); " + "    } " + "    return new " + clazz.getName() + "($$); " + "}";
        this.codifier.addPendingCode(wmethod, code);
    }

    private boolean isAnyConstructorAdvised(CtClass clazz, ClassAdvisor advisor) throws NotFoundException {
        CtConstructor[] constructors = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            JoinpointClassification classification = this.classifier.classifyConstructorExecution(constructors[i], advisor);
            if (!classification.equals(JoinpointClassification.WRAPPED)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdvisableConstructor(CtConstructor con, ClassAdvisor advisor) throws NotFoundException {
        Iterator pointcuts = advisor.getManager().getPointcuts().values().iterator();
        while (pointcuts.hasNext()) {
            Pointcut pointcut = (Pointcut)pointcuts.next();
            if (!pointcut.matchesExecution((Advisor)advisor, con)) continue;
            return true;
        }
        return false;
    }

    private JoinpointClassification[] classifyConstructor(List constructors, ClassAdvisor advisor) throws NotFoundException {
        JoinpointClassification[] classification = new JoinpointClassification[constructors.size()];
        int index = 0;
        Iterator iterator = constructors.iterator();
        while (iterator.hasNext()) {
            CtConstructor constructor = (CtConstructor)iterator.next();
            classification[index] = this.classifier.classifyConstructorExecution(constructor, advisor);
            ++index;
        }
        return classification;
    }

    protected String createOptimizedInvocationClass(CtClass clazz, CtConstructor con, int index) throws Exception {
        CtClass invocation;
        boolean makeInnerClass;
        AOPClassPool pool = (AOPClassPool)this.instrumentor.getClassPool();
        CtClass conInvocation = pool.get("org.jboss.aop.joinpoint.ConstructorInvocation");
        CtClass untransformable = pool.get("org.jboss.aop.instrument.Untransformable");
        String className = this.getOptimizedInvocationClassName(clazz, index);
        boolean bl = makeInnerClass = !Modifier.isPublic((int)con.getModifiers());
        if (makeInnerClass) {
            String innerClassName = className.substring(className.lastIndexOf(46) + 1);
            boolean classStatic = true;
            invocation = clazz.makeNestedClass(innerClassName, classStatic);
            invocation.setSuperclass(conInvocation);
        } else {
            try {
                CtClass existing = pool.get(className);
                existing.defrost();
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            invocation = pool.makeClass(className, conInvocation);
        }
        invocation.addInterface(untransformable);
        CtConstructor template = conInvocation.getDeclaredConstructors()[0];
        CtConstructor icon = CtNewConstructor.make((CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (CtClass)invocation);
        invocation.addConstructor(icon);
        CtClass[] params = con.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            CtField field = new CtField(params[i], "arg" + i, invocation);
            field.setModifiers(1);
            invocation.addField(field);
        }
        CtMethod in = conInvocation.getDeclaredMethod("invokeNext");
        CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
        invokeNext.setModifiers(in.getModifiers());
        String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)        {           currentInterceptor--;           throw t;       }    } ";
        code = code + "return new " + con.getDeclaringClass().getName() + "(";
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                code = code + ", ";
            }
            code = code + "arg" + i;
        }
        code = code + ");  ";
        code = code + "}";
        try {
            invokeNext.setBody(code);
        }
        catch (CannotCompileException e) {
            System.out.println(code);
            throw e;
        }
        invocation.addMethod(invokeNext);
        TransformerCommon.addGetArguments(pool, invocation, con.getParameterTypes());
        this.addCopy(pool, invocation, con.getParameterTypes());
        if (Compiler.loader != null) {
            URL url = Compiler.loader.getResource(con.getDeclaringClass().getName().replace('.', '/') + ".class");
            String path = url.toString();
            path = path.substring(0, path.lastIndexOf(47) + 1);
            path = path + invocation.getSimpleName() + ".class";
            URI newUrl = new URI(path);
            File file = new File(newUrl);
            FileOutputStream fp = new FileOutputStream(file);
            fp.write(invocation.toBytecode());
            fp.close();
        } else {
            invocation.toClass();
        }
        return invocation.getName();
    }

    private String getOptimizedInvocationClassName(CtClass declaringClazz, int constructorIndex) {
        return declaringClazz.getName() + constructorIndex + "OptimizedConstructorInvocation";
    }

    private void addCopy(ClassPool pool, CtClass invocation, CtClass[] params) throws Exception {
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.ConstructorInvocation");
        CtMethod template = methodInvocation.getDeclaredMethod("copy");
        CtMethod copy = CtNewMethod.make((CtClass)template.getReturnType(), (String)"copy", (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), null, (CtClass)invocation);
        copy.setModifiers(template.getModifiers());
        String code = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.interceptors); " + "   wrapper.constructor = this.constructor; " + "   wrapper.arguments = this.arguments; " + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; ";
        for (int i = 0; i < params.length; ++i) {
            code = code + "   wrapper.arg" + i + " = this.arg" + i + "; ";
        }
        code = code + "   return wrapper; }";
        copy.setBody(code);
        invocation.addMethod(copy);
    }
}

