/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.PolicyConfig;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xml.binding.ContentNavigator;
import org.jboss.xml.binding.ObjectModelFactory;
import org.xml.sax.Attributes;

public class LoginConfigObjectModelFactory
implements ObjectModelFactory {
    public Object newRoot(Object root, ContentNavigator navigator, String namespaceURI, String localName, Attributes attrs) {
        if (!localName.equals("policy")) {
            throw new IllegalStateException("Unexpected root element: was expecting 'policy' but got '" + localName + "'");
        }
        return new PolicyConfig();
    }

    public Object newChild(PolicyConfig config, ContentNavigator navigator, String namespaceUri, String localName, Attributes attrs) {
        AuthenticationInfo child = null;
        if ("application-policy".equals(localName)) {
            String name = attrs.getValue("name");
            child = new AuthenticationInfo(name);
        }
        return child;
    }

    public Object newChild(AuthenticationInfo info, ContentNavigator navigator, String namespaceUri, String localName, Attributes attrs) {
        AppConfigurationEntryHolder child = null;
        if ("login-module".equals(localName)) {
            AppConfigurationEntryHolder holder;
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties((String)code.trim());
            String flag = attrs.getValue("flag");
            flag = StringPropertyReplacer.replaceProperties((String)flag.trim());
            child = holder = new AppConfigurationEntryHolder(code, flag);
        }
        return child;
    }

    public Object newChild(AppConfigurationEntryHolder entry, ContentNavigator navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
        }
        return child;
    }

    public void setValue(ModuleOption option, ContentNavigator navigator, String namespaceUri, String localName, String value) {
        if ("module-option".equals(localName)) {
            String valueWithReplacement = StringPropertyReplacer.replaceProperties((String)value.trim());
            option.setValue(valueWithReplacement);
        }
    }

    public void addChild(PolicyConfig config, AuthenticationInfo authInfo, ContentNavigator navigator, String namespaceURI, String localName) {
        config.add(authInfo);
    }

    public void addChild(AuthenticationInfo authInfo, AppConfigurationEntryHolder entryInfo, ContentNavigator navigator, String namespaceURI, String localName) {
        AppConfigurationEntry entry = entryInfo.getEntry();
        authInfo.addAppConfigurationEntry(entry);
    }

    public void addChild(AppConfigurationEntryHolder entryInfo, ModuleOption option, ContentNavigator navigator, String namespaceURI, String localName) {
        entryInfo.addOption(option);
    }

    public void addChild(ModuleOption option, Object value, ContentNavigator navigator, String namespaceURI, String localName) {
        option.setValue(value);
    }

    private static class ModuleOption {
        String name;
        Object value;

        ModuleOption(String name) {
            this.name = name;
        }

        void setValue(Object value) {
            this.value = value;
        }
    }

    private static class AppConfigurationEntryHolder {
        String code;
        AppConfigurationEntry.LoginModuleControlFlag controlFlag;
        HashMap options = new HashMap();

        AppConfigurationEntryHolder(String code, String flag) {
            this.code = code;
            this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            if (flag != null) {
                flag = flag.toLowerCase();
                if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.toString().indexOf(flag) > 0) {
                    this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                } else if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.toString().indexOf(flag) > 0) {
                    this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
                } else if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.toString().indexOf(flag) > 0) {
                    this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
                } else if (AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.toString().indexOf(flag) > 0) {
                    this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
                }
            }
        }

        public AppConfigurationEntry getEntry() {
            AppConfigurationEntry entry = new AppConfigurationEntry(this.code, this.controlFlag, this.options);
            return entry;
        }

        public void addOption(ModuleOption option) {
            this.options.put(option.name, option.value);
        }
    }
}

