/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.transform.impl.InterceptFieldEnabled;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CacheEntry;
import org.hibernate.cache.entry.CacheEntryStructure;
import org.hibernate.cache.entry.StructuredCacheEntry;
import org.hibernate.cache.entry.UnstructuredCacheEntry;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Versioning;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.loader.entity.BatchingEntityLoader;
import org.hibernate.loader.entity.CascadeEntityLoader;
import org.hibernate.loader.entity.EntityLoader;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.BasicEntityPropertyMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.NamedQueryLoader;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.entity.SQLLoadable;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.property.BackrefPropertyAccessor;
import org.hibernate.sql.Alias;
import org.hibernate.sql.Delete;
import org.hibernate.sql.Insert;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.sql.SelectFragment;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.sql.Template;
import org.hibernate.sql.Update;
import org.hibernate.tuple.EntityMetamodel;
import org.hibernate.tuple.EntityTuplizer;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.type.VersionType;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.FilterHelper;
import org.hibernate.util.GetGeneratedKeysHelper;
import org.hibernate.util.StringHelper;

public abstract class AbstractEntityPersister
implements OuterJoinLoadable,
Queryable,
ClassMetadata,
UniqueKeyLoadable,
SQLLoadable,
LazyPropertyInitializer,
PostInsertIdentityPersister {
    private static final Log log = LogFactory.getLog((Class)AbstractEntityPersister.class);
    public static final String ENTITY_CLASS = "class";
    private final SessionFactoryImplementor factory;
    private final CacheConcurrencyStrategy cache;
    private final boolean isLazyPropertiesCacheable;
    private final CacheEntryStructure cacheEntryStructure;
    private final EntityMetamodel entityMetamodel;
    private final Map entityNameBySubclass = new HashMap();
    private final String[] rootTableKeyColumnNames;
    private final String[] identifierAliases;
    private final int identifierColumnSpan;
    private final String versionColumnName;
    private final boolean hasFormulaProperties;
    private final int batchSize;
    private final boolean hasSubselectLoadableCollections;
    protected final String rowIdName;
    private final Set lazyProperties;
    private final String sqlWhereString;
    private final String sqlWhereStringTemplate;
    private final int[] propertyColumnSpans;
    private final String[] propertySubclassNames;
    private final String[][] propertyColumnAliases;
    private final String[][] propertyColumnNames;
    private final String[][] propertyColumnFormulaTemplates;
    private final boolean[][] propertyColumnUpdateable;
    private final boolean[][] propertyColumnInsertable;
    private final boolean[] propertyUniqueness;
    private final boolean[] propertySelectable;
    private final String[] lazyPropertyNames;
    private final int[] lazyPropertyNumbers;
    private final Type[] lazyPropertyTypes;
    private final String[][] lazyPropertyColumnAliases;
    private final String[] subclassPropertyNameClosure;
    private final String[] subclassPropertySubclassNameClosure;
    private final Type[] subclassPropertyTypeClosure;
    private final String[][] subclassPropertyFormulaTemplateClosure;
    private final String[][] subclassPropertyColumnNameClosure;
    private final FetchMode[] subclassPropertyFetchModeClosure;
    private final boolean[] subclassPropertyNullabilityClosure;
    private final boolean[] propertyDefinedOnSubclass;
    private final int[][] subclassPropertyColumnNumberClosure;
    private final int[][] subclassPropertyFormulaNumberClosure;
    private final CascadeStyle[] subclassPropertyCascadeStyleClosure;
    private final String[] subclassColumnClosure;
    private final boolean[] subclassColumnLazyClosure;
    private final String[] subclassColumnAliasClosure;
    private final boolean[] subclassColumnSelectableClosure;
    private final String[] subclassFormulaClosure;
    private final String[] subclassFormulaTemplateClosure;
    private final String[] subclassFormulaAliasClosure;
    private final boolean[] subclassFormulaLazyClosure;
    private final FilterHelper filterHelper;
    private final Map uniqueKeyLoaders = new HashMap();
    private final Map lockers = new HashMap();
    private final Map loaders = new HashMap();
    private String sqlVersionSelectString;
    private String sqlSnapshotSelectString;
    private String sqlLazySelectString;
    private String sqlIdentityInsertString;
    private String sqlUpdateByRowIdString;
    private String sqlLazyUpdateByRowIdString;
    private String[] sqlDeleteStrings;
    private String[] sqlInsertStrings;
    private String[] sqlUpdateStrings;
    private String[] sqlLazyUpdateStrings;
    private String sqlInsertGeneratedValuesSelectString;
    private String sqlUpdateGeneratedValuesSelectString;
    protected boolean[] insertCallable;
    protected boolean[] updateCallable;
    protected boolean[] deleteCallable;
    protected String[] customSQLInsert;
    protected String[] customSQLUpdate;
    protected String[] customSQLDelete;
    private boolean[] tableHasColumns;
    private final String loaderName;
    private UniqueEntityLoader queryLoader;
    private final String temporaryIdTableName;
    private final String temporaryIdTableDDL;
    private final Map subclassPropertyAliases = new HashMap();
    private final Map subclassPropertyColumnNames = new HashMap();
    protected final BasicEntityPropertyMapping propertyMapping;
    private static final String DISCRIMINATOR_ALIAS = "clazz_";

    protected void addDiscriminatorToInsert(Insert insert) {
    }

    protected void addDiscriminatorToSelect(SelectFragment select, String name, String suffix) {
    }

    protected abstract int[] getSubclassColumnTableNumberClosure();

    protected abstract int[] getSubclassFormulaTableNumberClosure();

    public abstract String getSubclassTableName(int var1);

    protected abstract String[] getSubclassTableKeyColumns(int var1);

    protected abstract boolean isClassOrSuperclassTable(int var1);

    protected abstract int getSubclassTableSpan();

    protected abstract int getTableSpan();

    protected abstract boolean isTableCascadeDeleteEnabled(int var1);

    protected abstract String getTableName(int var1);

    protected abstract String[] getKeyColumns(int var1);

    protected abstract boolean isPropertyOfTable(int var1, int var2);

    protected abstract int[] getPropertyTableNumbersInSelect();

    protected abstract int[] getPropertyTableNumbers();

    protected abstract int getSubclassPropertyTableNumber(int var1);

    protected abstract String filterFragment(String var1) throws MappingException;

    public String getDiscriminatorColumnName() {
        return DISCRIMINATOR_ALIAS;
    }

    protected String getDiscriminatorAlias() {
        return DISCRIMINATOR_ALIAS;
    }

    protected String getDiscriminatorFormulaTemplate() {
        return null;
    }

    protected boolean isInverseTable(int j) {
        return false;
    }

    protected boolean isNullableTable(int j) {
        return false;
    }

    protected boolean isNullableSubclassTable(int j) {
        return false;
    }

    protected boolean isInverseSubclassTable(int j) {
        return false;
    }

    public boolean isSubclassEntityName(String entityName) {
        return this.entityMetamodel.getSubclassEntityNames().contains(entityName);
    }

    private boolean[] getTableHasColumns() {
        return this.tableHasColumns;
    }

    public String[] getRootTableKeyColumnNames() {
        return this.rootTableKeyColumnNames;
    }

    protected String[] getSQLUpdateByRowIdStrings() {
        if (this.sqlUpdateByRowIdString == null) {
            throw new AssertionFailure("no update by row id");
        }
        String[] result = new String[this.getTableSpan()];
        result[0] = this.sqlUpdateByRowIdString;
        for (int i = 1; i < this.getTableSpan(); ++i) {
            result[i] = this.sqlUpdateStrings[i];
        }
        return result;
    }

    protected String[] getSQLLazyUpdateByRowIdStrings() {
        if (this.sqlLazyUpdateByRowIdString == null) {
            throw new AssertionFailure("no update by row id");
        }
        String[] result = new String[this.getTableSpan()];
        result[0] = this.sqlLazyUpdateByRowIdString;
        for (int i = 1; i < this.getTableSpan(); ++i) {
            result[i] = this.sqlLazyUpdateStrings[i];
        }
        return result;
    }

    protected String getSQLSnapshotSelectString() {
        return this.sqlSnapshotSelectString;
    }

    protected String getSQLLazySelectString() {
        return this.sqlLazySelectString;
    }

    protected String[] getSQLDeleteStrings() {
        return this.sqlDeleteStrings;
    }

    protected String[] getSQLInsertStrings() {
        return this.sqlInsertStrings;
    }

    protected String[] getSQLUpdateStrings() {
        return this.sqlUpdateStrings;
    }

    protected String[] getSQLLazyUpdateStrings() {
        return this.sqlLazyUpdateStrings;
    }

    protected String getSQLIdentityInsertString() {
        return this.sqlIdentityInsertString;
    }

    protected String getVersionSelectString() {
        return this.sqlVersionSelectString;
    }

    protected boolean isInsertCallable(int j) {
        return this.insertCallable[j];
    }

    protected boolean isUpdateCallable(int j) {
        return this.updateCallable[j];
    }

    protected boolean isDeleteCallable(int j) {
        return this.deleteCallable[j];
    }

    protected boolean isSubclassPropertyDeferred(String propertyName, String entityName) {
        return false;
    }

    protected boolean isSubclassTableSequentialSelect(int j) {
        return false;
    }

    public boolean hasSequentialSelect() {
        return false;
    }

    protected boolean[] getTableUpdateNeeded(int[] dirtyProperties, boolean hasDirtyCollection) {
        if (dirtyProperties == null) {
            return this.getTableHasColumns();
        }
        boolean[] updateability = this.getPropertyUpdateability();
        int[] propertyTableNumbers = this.getPropertyTableNumbers();
        boolean[] tableUpdateNeeded = new boolean[this.getTableSpan()];
        for (int i = 0; i < dirtyProperties.length; ++i) {
            int property = dirtyProperties[i];
            int table = propertyTableNumbers[property];
            tableUpdateNeeded[table] = tableUpdateNeeded[table] || this.getPropertyColumnSpan(property) > 0 && updateability[property];
        }
        if (this.isVersioned()) {
            tableUpdateNeeded[0] = tableUpdateNeeded[0] || Versioning.isVersionIncrementRequired(dirtyProperties, hasDirtyCollection, this.getPropertyVersionability());
        }
        return tableUpdateNeeded;
    }

    public boolean hasRowId() {
        return this.rowIdName != null;
    }

    public AbstractEntityPersister(PersistentClass persistentClass, CacheConcurrencyStrategy cache, SessionFactoryImplementor factory) throws HibernateException {
        int batch;
        this.factory = factory;
        this.cache = cache;
        this.isLazyPropertiesCacheable = persistentClass.isLazyPropertiesCacheable();
        this.cacheEntryStructure = factory.getSettings().isStructuredCacheEntriesEnabled() ? new StructuredCacheEntry(this) : new UnstructuredCacheEntry();
        this.entityMetamodel = new EntityMetamodel(persistentClass, factory);
        if (persistentClass.hasPojoRepresentation()) {
            Iterator iter = persistentClass.getSubclassIterator();
            while (iter.hasNext()) {
                PersistentClass pc = (PersistentClass)iter.next();
                this.entityNameBySubclass.put(pc.getMappedClass(), pc.getEntityName());
            }
        }
        if ((batch = persistentClass.getBatchSize()) == -1) {
            batch = factory.getSettings().getDefaultBatchFetchSize();
        }
        this.batchSize = batch;
        this.hasSubselectLoadableCollections = persistentClass.hasSubselectLoadableCollections();
        this.propertyMapping = new BasicEntityPropertyMapping(this);
        this.identifierColumnSpan = persistentClass.getIdentifier().getColumnSpan();
        this.rootTableKeyColumnNames = new String[this.identifierColumnSpan];
        this.identifierAliases = new String[this.identifierColumnSpan];
        this.rowIdName = persistentClass.getRootTable().getRowId();
        this.loaderName = persistentClass.getLoaderName();
        Iterator iter = persistentClass.getIdentifier().getColumnIterator();
        int i = 0;
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            this.rootTableKeyColumnNames[i] = col.getQuotedName(factory.getDialect());
            this.identifierAliases[i] = col.getAlias(factory.getDialect(), persistentClass.getRootTable());
            ++i;
        }
        this.versionColumnName = persistentClass.isVersioned() ? ((Column)persistentClass.getVersion().getColumnIterator().next()).getQuotedName(factory.getDialect()) : null;
        this.sqlWhereString = persistentClass.getWhere();
        this.sqlWhereStringTemplate = this.sqlWhereString == null ? null : Template.renderWhereStringTemplate(this.sqlWhereString, factory.getDialect());
        boolean lazyAvailable = this.isInstrumented(EntityMode.POJO);
        int hydrateSpan = this.entityMetamodel.getPropertySpan();
        this.propertyColumnSpans = new int[hydrateSpan];
        this.propertySubclassNames = new String[hydrateSpan];
        this.propertyColumnAliases = new String[hydrateSpan][];
        this.propertyColumnNames = new String[hydrateSpan][];
        this.propertyColumnFormulaTemplates = new String[hydrateSpan][];
        this.propertyUniqueness = new boolean[hydrateSpan];
        this.propertySelectable = new boolean[hydrateSpan];
        this.propertyColumnUpdateable = new boolean[hydrateSpan][];
        this.propertyColumnInsertable = new boolean[hydrateSpan][];
        HashSet<Property> thisClassProperties = new HashSet<Property>();
        this.lazyProperties = new HashSet();
        ArrayList<String> lazyNames = new ArrayList<String>();
        ArrayList<Integer> lazyNumbers = new ArrayList<Integer>();
        ArrayList<Type> lazyTypes = new ArrayList<Type>();
        ArrayList<String[]> lazyColAliases = new ArrayList<String[]>();
        iter = persistentClass.getPropertyClosureIterator();
        i = 0;
        boolean foundFormula = false;
        while (iter.hasNext()) {
            int span;
            Property prop = (Property)iter.next();
            thisClassProperties.add(prop);
            this.propertyColumnSpans[i] = span = prop.getColumnSpan();
            this.propertySubclassNames[i] = prop.getPersistentClass().getEntityName();
            String[] colNames = new String[span];
            String[] colAliases = new String[span];
            String[] templates = new String[span];
            Iterator colIter = prop.getColumnIterator();
            int k = 0;
            while (colIter.hasNext()) {
                Selectable thing = (Selectable)colIter.next();
                colAliases[k] = thing.getAlias(factory.getDialect(), prop.getValue().getTable());
                if (thing.isFormula()) {
                    foundFormula = true;
                    templates[k] = thing.getTemplate(factory.getDialect());
                } else {
                    colNames[k] = thing.getTemplate(factory.getDialect());
                }
                ++k;
            }
            this.propertyColumnNames[i] = colNames;
            this.propertyColumnFormulaTemplates[i] = templates;
            this.propertyColumnAliases[i] = colAliases;
            if (lazyAvailable && prop.isLazy()) {
                this.lazyProperties.add(prop.getName());
                lazyNames.add(prop.getName());
                lazyNumbers.add(new Integer(i));
                lazyTypes.add(prop.getValue().getType());
                lazyColAliases.add(colAliases);
            }
            this.propertyColumnUpdateable[i] = prop.getValue().getColumnUpdateability();
            this.propertyColumnInsertable[i] = prop.getValue().getColumnInsertability();
            this.propertySelectable[i] = prop.isSelectable();
            this.propertyUniqueness[i] = prop.getValue().isAlternateUniqueKey();
            ++i;
        }
        this.hasFormulaProperties = foundFormula;
        this.lazyPropertyColumnAliases = ArrayHelper.to2DStringArray(lazyColAliases);
        this.lazyPropertyNames = ArrayHelper.toStringArray(lazyNames);
        this.lazyPropertyNumbers = ArrayHelper.toIntArray(lazyNumbers);
        this.lazyPropertyTypes = ArrayHelper.toTypeArray(lazyTypes);
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Boolean> columnsLazy = new ArrayList<Boolean>();
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<String> formulas = new ArrayList<String>();
        ArrayList<String> formulaAliases = new ArrayList<String>();
        ArrayList<String> formulaTemplates = new ArrayList<String>();
        ArrayList<Boolean> formulasLazy = new ArrayList<Boolean>();
        ArrayList<Type> types = new ArrayList<Type>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<String[]> templates = new ArrayList<String[]>();
        ArrayList<String[]> propColumns = new ArrayList<String[]>();
        ArrayList<FetchMode> joinedFetchesList = new ArrayList<FetchMode>();
        ArrayList<CascadeStyle> cascades = new ArrayList<CascadeStyle>();
        ArrayList<Boolean> definedBySubclass = new ArrayList<Boolean>();
        ArrayList<int[]> propColumnNumbers = new ArrayList<int[]>();
        ArrayList<int[]> propFormulaNumbers = new ArrayList<int[]>();
        ArrayList<Boolean> columnSelectables = new ArrayList<Boolean>();
        ArrayList<Boolean> propNullables = new ArrayList<Boolean>();
        iter = persistentClass.getSubclassPropertyClosureIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            names.add(prop.getName());
            classes.add(prop.getPersistentClass().getEntityName());
            boolean isDefinedBySubclass = !thisClassProperties.contains(prop);
            definedBySubclass.add(new Boolean(isDefinedBySubclass));
            propNullables.add(new Boolean(prop.isOptional() || isDefinedBySubclass));
            types.add(prop.getType());
            Iterator colIter = prop.getColumnIterator();
            String[] cols = new String[prop.getColumnSpan()];
            String[] forms = new String[prop.getColumnSpan()];
            int[] colnos = new int[prop.getColumnSpan()];
            int[] formnos = new int[prop.getColumnSpan()];
            int l = 0;
            Boolean lazy = new Boolean(prop.isLazy() && lazyAvailable);
            while (colIter.hasNext()) {
                Selectable thing = (Selectable)colIter.next();
                if (thing.isFormula()) {
                    String template = thing.getTemplate(factory.getDialect());
                    formnos[l] = formulaTemplates.size();
                    colnos[l] = -1;
                    formulaTemplates.add(template);
                    forms[l] = template;
                    formulas.add(thing.getText(factory.getDialect()));
                    formulaAliases.add(thing.getAlias(factory.getDialect()));
                    formulasLazy.add(lazy);
                } else {
                    String colName = thing.getTemplate(factory.getDialect());
                    colnos[l] = columns.size();
                    formnos[l] = -1;
                    columns.add(colName);
                    cols[l] = colName;
                    aliases.add(thing.getAlias(factory.getDialect(), prop.getValue().getTable()));
                    columnsLazy.add(lazy);
                    columnSelectables.add(new Boolean(prop.isSelectable()));
                }
                ++l;
            }
            propColumns.add(cols);
            templates.add(forms);
            propColumnNumbers.add(colnos);
            propFormulaNumbers.add(formnos);
            joinedFetchesList.add(prop.getValue().getFetchMode());
            cascades.add(prop.getCascadeStyle());
        }
        this.subclassColumnClosure = ArrayHelper.toStringArray(columns);
        this.subclassColumnAliasClosure = ArrayHelper.toStringArray(aliases);
        this.subclassColumnLazyClosure = ArrayHelper.toBooleanArray(columnsLazy);
        this.subclassColumnSelectableClosure = ArrayHelper.toBooleanArray(columnSelectables);
        this.subclassFormulaClosure = ArrayHelper.toStringArray(formulas);
        this.subclassFormulaTemplateClosure = ArrayHelper.toStringArray(formulaTemplates);
        this.subclassFormulaAliasClosure = ArrayHelper.toStringArray(formulaAliases);
        this.subclassFormulaLazyClosure = ArrayHelper.toBooleanArray(formulasLazy);
        this.subclassPropertyNameClosure = ArrayHelper.toStringArray(names);
        this.subclassPropertySubclassNameClosure = ArrayHelper.toStringArray(classes);
        this.subclassPropertyTypeClosure = ArrayHelper.toTypeArray(types);
        this.subclassPropertyNullabilityClosure = ArrayHelper.toBooleanArray(propNullables);
        this.subclassPropertyFormulaTemplateClosure = ArrayHelper.to2DStringArray(templates);
        this.subclassPropertyColumnNameClosure = ArrayHelper.to2DStringArray(propColumns);
        this.subclassPropertyColumnNumberClosure = ArrayHelper.to2DIntArray(propColumnNumbers);
        this.subclassPropertyFormulaNumberClosure = ArrayHelper.to2DIntArray(propFormulaNumbers);
        this.subclassPropertyCascadeStyleClosure = new CascadeStyle[cascades.size()];
        iter = cascades.iterator();
        int j = 0;
        while (iter.hasNext()) {
            this.subclassPropertyCascadeStyleClosure[j++] = (CascadeStyle)iter.next();
        }
        this.subclassPropertyFetchModeClosure = new FetchMode[joinedFetchesList.size()];
        iter = joinedFetchesList.iterator();
        j = 0;
        while (iter.hasNext()) {
            this.subclassPropertyFetchModeClosure[j++] = (FetchMode)iter.next();
        }
        this.propertyDefinedOnSubclass = new boolean[definedBySubclass.size()];
        iter = definedBySubclass.iterator();
        j = 0;
        while (iter.hasNext()) {
            this.propertyDefinedOnSubclass[j++] = (Boolean)iter.next();
        }
        this.filterHelper = new FilterHelper(persistentClass.getFilterMap(), factory.getDialect());
        this.temporaryIdTableName = persistentClass.getTemporaryIdTableName();
        this.temporaryIdTableDDL = persistentClass.getTemporaryIdTableDDL();
    }

    protected String generateLazySelectString() {
        if (!this.entityMetamodel.hasLazyProperties()) {
            return null;
        }
        HashSet<Integer> tableNumbers = new HashSet<Integer>();
        ArrayList<Integer> columnNumbers = new ArrayList<Integer>();
        ArrayList<Integer> formulaNumbers = new ArrayList<Integer>();
        for (int i = 0; i < this.lazyPropertyNames.length; ++i) {
            int propertyNumber = this.getSubclassPropertyIndex(this.lazyPropertyNames[i]);
            int tableNumber = this.getSubclassPropertyTableNumber(propertyNumber);
            tableNumbers.add(new Integer(tableNumber));
            int[] colNumbers = this.subclassPropertyColumnNumberClosure[propertyNumber];
            for (int j = 0; j < colNumbers.length; ++j) {
                if (colNumbers[j] == -1) continue;
                columnNumbers.add(new Integer(colNumbers[j]));
            }
            int[] formNumbers = this.subclassPropertyFormulaNumberClosure[propertyNumber];
            for (int j = 0; j < formNumbers.length; ++j) {
                if (formNumbers[j] == -1) continue;
                formulaNumbers.add(new Integer(formNumbers[j]));
            }
        }
        if (columnNumbers.size() == 0 && formulaNumbers.size() == 0) {
            return null;
        }
        return this.renderSelect(ArrayHelper.toIntArray(tableNumbers), ArrayHelper.toIntArray(columnNumbers), ArrayHelper.toIntArray(formulaNumbers));
    }

    public Object initializeLazyProperty(String fieldName, Object entity, SessionImplementor session) throws HibernateException {
        Serializable id = session.getContextEntityIdentifier(entity);
        EntityEntry entry = session.getPersistenceContext().getEntry(entity);
        if (entry == null) {
            throw new HibernateException("entity is not associated with the session: " + id);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("initializing lazy properties of: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory()) + ", field access: " + fieldName));
        }
        if (this.hasCache()) {
            CacheEntry cacheEntry;
            CacheKey cacheKey = new CacheKey(id, this.getIdentifierType(), this.getEntityName(), session.getEntityMode(), this.getFactory());
            Object ce = this.getCache().get(cacheKey, session.getTimestamp());
            if (ce != null && !(cacheEntry = (CacheEntry)this.getCacheEntryStructure().destructure(ce, this.factory)).areLazyPropertiesUnfetched()) {
                return this.initializeLazyPropertiesFromCache(fieldName, entity, session, entry, cacheEntry);
            }
        }
        return this.initializeLazyPropertiesFromDatastore(fieldName, entity, session, id, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object initializeLazyPropertiesFromDatastore(String fieldName, Object entity, SessionImplementor session, Serializable id, EntityEntry entry) {
        if (!this.hasLazyProperties()) {
            throw new AssertionFailure("no lazy properties");
        }
        log.trace((Object)"initializing lazy properties from datastore");
        try {
            Object result;
            block9: {
                result = null;
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    String lazySelect = this.getSQLLazySelectString();
                    if (lazySelect != null) {
                        ps = session.getBatcher().prepareSelectStatement(lazySelect);
                        this.getIdentifierType().nullSafeSet(ps, id, 1, session);
                        rs = ps.executeQuery();
                        rs.next();
                    }
                    Object[] snapshot = entry.getLoadedState();
                    for (int j = 0; j < this.lazyPropertyNames.length; ++j) {
                        Object propValue = this.lazyPropertyTypes[j].nullSafeGet(rs, this.lazyPropertyColumnAliases[j], session, entity);
                        if (!this.initializeLazyProperty(fieldName, entity, session, snapshot, j, propValue)) continue;
                        result = propValue;
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps == null) break block9;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        session.getBatcher().closeStatement(ps);
                    }
                    throw throwable;
                }
                session.getBatcher().closeStatement(ps);
            }
            log.trace((Object)"done initializing lazy properties");
            return result;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not initialize lazy properties: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory()), this.getSQLLazySelectString());
        }
    }

    private Object initializeLazyPropertiesFromCache(String fieldName, Object entity, SessionImplementor session, EntityEntry entry, CacheEntry cacheEntry) {
        log.trace((Object)"initializing lazy properties from second-level cache");
        Object result = null;
        Serializable[] disassembledValues = cacheEntry.getDisassembledState();
        Object[] snapshot = entry.getLoadedState();
        for (int j = 0; j < this.lazyPropertyNames.length; ++j) {
            Object propValue = this.lazyPropertyTypes[j].assemble(disassembledValues[this.lazyPropertyNumbers[j]], session, entity);
            if (!this.initializeLazyProperty(fieldName, entity, session, snapshot, j, propValue)) continue;
            result = propValue;
        }
        log.trace((Object)"done initializing lazy properties");
        return result;
    }

    private boolean initializeLazyProperty(String fieldName, Object entity, SessionImplementor session, Object[] snapshot, int j, Object propValue) {
        this.setPropertyValue(entity, this.lazyPropertyNumbers[j], propValue, session.getEntityMode());
        snapshot[this.lazyPropertyNumbers[j]] = this.lazyPropertyTypes[j].deepCopy(propValue, session.getEntityMode(), this.factory);
        return fieldName.equals(this.lazyPropertyNames[j]);
    }

    public boolean isBatchable() {
        return this.optimisticLockMode() == -1 || !this.isVersioned() && this.optimisticLockMode() == 0 || this.getFactory().getSettings().isJdbcBatchVersionedData();
    }

    public Serializable[] getQuerySpaces() {
        return this.getPropertySpaces();
    }

    protected Set getLazyProperties() {
        return this.lazyProperties;
    }

    private String getLockString(LockMode lockMode) {
        return (String)this.lockers.get(lockMode);
    }

    public boolean isBatchLoadable() {
        return this.batchSize > 1;
    }

    public String[] getIdentifierColumnNames() {
        return this.rootTableKeyColumnNames;
    }

    protected int getIdentifierColumnSpan() {
        return this.identifierColumnSpan;
    }

    protected String[] getIdentifierAliases() {
        return this.identifierAliases;
    }

    public String getVersionColumnName() {
        return this.versionColumnName;
    }

    protected String getVersionedTableName() {
        return this.getTableName(0);
    }

    protected boolean[] getSubclassColumnLazyiness() {
        return this.subclassColumnLazyClosure;
    }

    protected boolean[] getSubclassFormulaLazyiness() {
        return this.subclassFormulaLazyClosure;
    }

    public boolean isCacheInvalidationRequired() {
        return this.hasFormulaProperties() || !this.isVersioned() && (this.entityMetamodel.isDynamicUpdate() || this.getTableSpan() > 1);
    }

    public boolean isLazyPropertiesCacheable() {
        return this.isLazyPropertiesCacheable;
    }

    public String selectFragment(String alias, String suffix) {
        return this.identifierSelectFragment(alias, suffix) + this.propertySelectFragment(alias, suffix, false);
    }

    public String[] getIdentifierAliases(String suffix) {
        return new Alias(suffix).toAliasStrings(this.getIdentifierAliases());
    }

    public String[] getPropertyAliases(String suffix, int i) {
        return new Alias(suffix).toUnquotedAliasStrings(this.propertyColumnAliases[i]);
    }

    public String getDiscriminatorAlias(String suffix) {
        return this.entityMetamodel.hasSubclasses() ? new Alias(suffix).toAliasString(this.getDiscriminatorAlias()) : null;
    }

    public String identifierSelectFragment(String name, String suffix) {
        return new SelectFragment().setSuffix(suffix).addColumns(name, this.getIdentifierColumnNames(), this.getIdentifierAliases()).toFragmentString().substring(2);
    }

    public String propertySelectFragment(String name, String suffix, boolean allProperties) {
        SelectFragment select = new SelectFragment().setSuffix(suffix).setUsedAliases(this.getIdentifierAliases());
        int[] columnTableNumbers = this.getSubclassColumnTableNumberClosure();
        String[] columnAliases = this.getSubclassColumnAliasClosure();
        String[] columns = this.getSubclassColumnClosure();
        for (int i = 0; i < this.getSubclassColumnClosure().length; ++i) {
            boolean selectable;
            boolean bl = selectable = (allProperties || !this.subclassColumnLazyClosure[i]) && !this.isSubclassTableSequentialSelect(columnTableNumbers[i]) && this.subclassColumnSelectableClosure[i];
            if (!selectable) continue;
            String subalias = this.generateTableAlias(name, columnTableNumbers[i]);
            select.addColumn(subalias, columns[i], columnAliases[i]);
        }
        int[] formulaTableNumbers = this.getSubclassFormulaTableNumberClosure();
        String[] formulaTemplates = this.getSubclassFormulaTemplateClosure();
        String[] formulaAliases = this.getSubclassFormulaAliasClosure();
        for (int i = 0; i < this.getSubclassFormulaTemplateClosure().length; ++i) {
            boolean selectable;
            boolean bl = selectable = (allProperties || !this.subclassFormulaLazyClosure[i]) && !this.isSubclassTableSequentialSelect(formulaTableNumbers[i]);
            if (!selectable) continue;
            String subalias = this.generateTableAlias(name, formulaTableNumbers[i]);
            select.addFormula(subalias, formulaTemplates[i], formulaAliases[i]);
        }
        if (this.entityMetamodel.hasSubclasses()) {
            this.addDiscriminatorToSelect(select, name, suffix);
        }
        if (this.hasRowId()) {
            select.addColumn(name, this.rowIdName, "rowid_");
        }
        return select.toFragmentString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Object[] getDatabaseSnapshot(Serializable id, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Getting current persistent state for: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory())));
        }
        try {
            PreparedStatement ps = session.getBatcher().prepareSelectStatement(this.getSQLSnapshotSelectString());
            try {
                Object[] objectArray;
                ResultSet rs;
                block12: {
                    this.getIdentifierType().nullSafeSet(ps, id, 1, session);
                    rs = ps.executeQuery();
                    if (rs.next()) break block12;
                    Object[] objectArray2 = null;
                    rs.close();
                    return objectArray2;
                }
                try {
                    Type[] types = this.getPropertyTypes();
                    Object[] values = new Object[types.length];
                    boolean[] includeProperty = this.getPropertyUpdateability();
                    for (int i = 0; i < types.length; ++i) {
                        if (!includeProperty[i]) continue;
                        values[i] = types[i].hydrate(rs, this.getPropertyAliases("", i), session, null);
                    }
                    objectArray = values;
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return objectArray;
            }
            finally {
                session.getBatcher().closeStatement(ps);
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not retrieve snapshot: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory()), this.getSQLSnapshotSelectString());
        }
    }

    protected String generateSelectVersionString() {
        SimpleSelect select = new SimpleSelect(this.getFactory().getDialect()).setTableName(this.getVersionedTableName());
        if (this.isVersioned()) {
            select.addColumn(this.versionColumnName);
        } else {
            select.addColumns(this.rootTableKeyColumnNames);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("get version " + this.getEntityName());
        }
        return select.addCondition(this.rootTableKeyColumnNames, "=?").toStatementString();
    }

    protected String generateInsertGeneratedValuesSelectString() {
        return this.generateGeneratedValuesSelectString(this.getPropertyInsertGeneration());
    }

    protected String generateUpdateGeneratedValuesSelectString() {
        return this.generateGeneratedValuesSelectString(this.getPropertyUpdateGeneration());
    }

    private String generateGeneratedValuesSelectString(boolean[] inclusions) {
        Select select = new Select(this.getFactory().getDialect());
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("get generated state " + this.getEntityName());
        }
        String[] aliasedIdColumns = StringHelper.qualify(this.getRootAlias(), this.getIdentifierColumnNames());
        String selectClause = this.concretePropertySelectFragment(this.getRootAlias(), inclusions);
        selectClause = selectClause.substring(2);
        String fromClause = this.fromTableFragment(this.getRootAlias()) + this.fromJoinFragment(this.getRootAlias(), true, false);
        String whereClause = StringHelper.join("=? and ", aliasedIdColumns) + "=?" + this.whereJoinFragment(this.getRootAlias(), true, false);
        return select.setSelectClause(selectClause).setFromClause(fromClause).setOuterJoins("", "").setWhereClause(whereClause).toStatementString();
    }

    protected String concretePropertySelectFragment(String alias, boolean[] includeProperty) {
        int propertyCount = this.getPropertyNames().length;
        int[] propertyTableNumbers = this.getPropertyTableNumbersInSelect();
        SelectFragment frag = new SelectFragment();
        for (int i = 0; i < propertyCount; ++i) {
            if (!includeProperty[i]) continue;
            frag.addColumns(this.generateTableAlias(alias, propertyTableNumbers[i]), this.propertyColumnNames[i], this.propertyColumnAliases[i]);
            frag.addFormulas(this.generateTableAlias(alias, propertyTableNumbers[i]), this.propertyColumnFormulaTemplates[i], this.propertyColumnAliases[i]);
        }
        return frag.toFragmentString();
    }

    protected String generateSnapshotSelectString() {
        Select select = new Select(this.getFactory().getDialect());
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("get current state " + this.getEntityName());
        }
        String[] aliasedIdColumns = StringHelper.qualify(this.getRootAlias(), this.getIdentifierColumnNames());
        String selectClause = StringHelper.join(", ", aliasedIdColumns) + this.concretePropertySelectFragment(this.getRootAlias(), this.getPropertyUpdateability());
        String fromClause = this.fromTableFragment(this.getRootAlias()) + this.fromJoinFragment(this.getRootAlias(), true, false);
        String whereClause = StringHelper.join("=? and ", aliasedIdColumns) + "=?" + this.whereJoinFragment(this.getRootAlias(), true, false);
        return select.setSelectClause(selectClause).setFromClause(fromClause).setOuterJoins("", "").setWhereClause(whereClause).toStatementString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Serializable id, Object version, Object object, LockMode lockMode, SessionImplementor session) throws HibernateException {
        if (lockMode != LockMode.NONE) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Locking entity: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory())));
                if (this.isVersioned()) {
                    log.trace((Object)("Version: " + version));
                }
            }
            String sql = this.getLockString(lockMode);
            try {
                PreparedStatement st = session.getBatcher().prepareSelectStatement(sql);
                try {
                    this.getIdentifierType().nullSafeSet(st, id, 1, session);
                    if (this.isVersioned()) {
                        this.getVersionType().nullSafeSet(st, version, this.getIdentifierColumnSpan() + 1, session);
                    }
                    ResultSet rs = st.executeQuery();
                    try {
                        if (!rs.next()) {
                            if (this.getFactory().getStatistics().isStatisticsEnabled()) {
                                this.getFactory().getStatisticsImplementor().optimisticFailure(this.getEntityName());
                            }
                            throw new StaleObjectStateException(this.getEntityName(), id);
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    session.getBatcher().closeStatement(st);
                }
            }
            catch (SQLException sqle) {
                throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not lock: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory()), sql);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Object getCurrentVersion(Serializable id, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Getting version: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory())));
        }
        try {
            PreparedStatement st = session.getBatcher().prepareSelectStatement(this.getVersionSelectString());
            try {
                ResultSet rs;
                block14: {
                    block13: {
                        Object var5_6;
                        this.getIdentifierType().nullSafeSet(st, id, 1, session);
                        rs = st.executeQuery();
                        try {
                            if (rs.next()) break block13;
                            var5_6 = null;
                        }
                        catch (Throwable throwable) {
                            rs.close();
                            throw throwable;
                        }
                        rs.close();
                        return var5_6;
                    }
                    if (this.isVersioned()) break block14;
                    AbstractEntityPersister abstractEntityPersister = this;
                    rs.close();
                    return abstractEntityPersister;
                }
                Object object = this.getVersionType().nullSafeGet(rs, this.getVersionColumnName(), session, null);
                rs.close();
                return object;
            }
            finally {
                session.getBatcher().closeStatement(st);
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not retrieve version: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory()), this.getVersionSelectString());
        }
    }

    protected String generateLockString(LockMode lockMode) {
        SimpleSelect select = new SimpleSelect(this.getFactory().getDialect()).setLockMode(lockMode).setTableName(this.getVersionedTableName()).addColumn(this.rootTableKeyColumnNames[0]).addCondition(this.rootTableKeyColumnNames, "=?");
        if (this.isVersioned()) {
            select.addCondition(this.getVersionColumnName(), "=?");
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("lock " + this.getEntityName());
        }
        return select.toStatementString();
    }

    protected void initLockers() {
        this.lockers.put(LockMode.READ, this.generateLockString(LockMode.READ));
        this.lockers.put(LockMode.UPGRADE, this.generateLockString(LockMode.UPGRADE));
        this.lockers.put(LockMode.UPGRADE_NOWAIT, this.generateLockString(LockMode.UPGRADE_NOWAIT));
    }

    public String[] toColumns(String alias, String propertyName) throws QueryException {
        return this.propertyMapping.toColumns(alias, propertyName);
    }

    public String[] toColumns(String propertyName) throws QueryException {
        return this.propertyMapping.getColumnNames(propertyName);
    }

    public Type toType(String propertyName) throws QueryException {
        return this.propertyMapping.toType(propertyName);
    }

    public String[] getPropertyColumnNames(String propertyName) {
        return this.propertyMapping.getColumnNames(propertyName);
    }

    public int getSubclassPropertyTableNumber(String propertyPath) {
        String rootPropertyName = StringHelper.root(propertyPath);
        Type type = this.propertyMapping.toType(rootPropertyName);
        if (type.isAssociationType() && ((AssociationType)type).useLHSPrimaryKey()) {
            return 0;
        }
        int index = ArrayHelper.indexOf(this.getSubclassPropertyNameClosure(), rootPropertyName);
        return index == -1 ? 0 : this.getSubclassPropertyTableNumber(index);
    }

    protected String generateTableAlias(String rootAlias, int tableNumber) {
        if (tableNumber == 0) {
            return rootAlias;
        }
        StringBuffer buf = new StringBuffer().append(rootAlias);
        if (!rootAlias.endsWith("_")) {
            buf.append('_');
        }
        return buf.append(tableNumber).append('_').toString();
    }

    public String[] toColumns(String name, int i) {
        String alias = this.generateTableAlias(name, this.getSubclassPropertyTableNumber(i));
        String[] cols = this.getSubclassPropertyColumnNames(i);
        String[] templates = this.getSubclassPropertyFormulaTemplateClosure()[i];
        String[] result = new String[cols.length];
        for (int j = 0; j < cols.length; ++j) {
            result[j] = cols[j] == null ? StringHelper.replace(templates[j], "$PlaceHolder$", alias) : StringHelper.qualify(alias, cols[j]);
        }
        return result;
    }

    private int getSubclassPropertyIndex(String propertyName) {
        return ArrayHelper.indexOf(this.subclassPropertyNameClosure, propertyName);
    }

    protected String[] getPropertySubclassNames() {
        return this.propertySubclassNames;
    }

    public String[] getPropertyColumnNames(int i) {
        return this.propertyColumnNames[i];
    }

    protected int getPropertyColumnSpan(int i) {
        return this.propertyColumnSpans[i];
    }

    protected boolean hasFormulaProperties() {
        return this.hasFormulaProperties;
    }

    public FetchMode getFetchMode(int i) {
        return this.subclassPropertyFetchModeClosure[i];
    }

    public CascadeStyle getCascadeStyle(int i) {
        return this.subclassPropertyCascadeStyleClosure[i];
    }

    public Type getSubclassPropertyType(int i) {
        return this.subclassPropertyTypeClosure[i];
    }

    public String getSubclassPropertyName(int i) {
        return this.subclassPropertyNameClosure[i];
    }

    public int countSubclassProperties() {
        return this.subclassPropertyTypeClosure.length;
    }

    public String[] getSubclassPropertyColumnNames(int i) {
        return this.subclassPropertyColumnNameClosure[i];
    }

    public boolean isDefinedOnSubclass(int i) {
        return this.propertyDefinedOnSubclass[i];
    }

    protected String[][] getSubclassPropertyFormulaTemplateClosure() {
        return this.subclassPropertyFormulaTemplateClosure;
    }

    protected Type[] getSubclassPropertyTypeClosure() {
        return this.subclassPropertyTypeClosure;
    }

    protected String[][] getSubclassPropertyColumnNameClosure() {
        return this.subclassPropertyColumnNameClosure;
    }

    protected String[] getSubclassPropertyNameClosure() {
        return this.subclassPropertyNameClosure;
    }

    protected String[] getSubclassPropertySubclassNameClosure() {
        return this.subclassPropertySubclassNameClosure;
    }

    protected String[] getSubclassColumnClosure() {
        return this.subclassColumnClosure;
    }

    protected String[] getSubclassColumnAliasClosure() {
        return this.subclassColumnAliasClosure;
    }

    protected String[] getSubclassFormulaClosure() {
        return this.subclassFormulaClosure;
    }

    protected String[] getSubclassFormulaTemplateClosure() {
        return this.subclassFormulaTemplateClosure;
    }

    protected String[] getSubclassFormulaAliasClosure() {
        return this.subclassFormulaAliasClosure;
    }

    public String[] getSubclassPropertyColumnAliases(String propertyName, String suffix) {
        String[] rawAliases = (String[])this.subclassPropertyAliases.get(propertyName);
        if (rawAliases == null) {
            return null;
        }
        String[] result = new String[rawAliases.length];
        for (int i = 0; i < rawAliases.length; ++i) {
            result[i] = new Alias(suffix).toUnquotedAliasString(rawAliases[i]);
        }
        return result;
    }

    public String[] getSubclassPropertyColumnNames(String propertyName) {
        return (String[])this.subclassPropertyColumnNames.get(propertyName);
    }

    protected void initSubclassPropertyAliasesMap(PersistentClass model) throws MappingException {
        this.internalInitSubclassPropertyAliasesMap(null, model.getSubclassPropertyClosureIterator());
        this.subclassPropertyAliases.put("id", this.getIdentifierAliases());
        this.subclassPropertyColumnNames.put("id", this.getIdentifierColumnNames());
        if (this.hasIdentifierProperty()) {
            this.subclassPropertyAliases.put(this.getIdentifierPropertyName(), this.getIdentifierAliases());
            this.subclassPropertyColumnNames.put(this.getIdentifierPropertyName(), this.getIdentifierColumnNames());
        }
        if (this.getIdentifierType().isComponentType()) {
            AbstractComponentType componentId = (AbstractComponentType)this.getIdentifierType();
            String[] idPropertyNames = componentId.getPropertyNames();
            String[] idAliases = this.getIdentifierAliases();
            String[] idColumnNames = this.getIdentifierColumnNames();
            for (int i = 0; i < idPropertyNames.length; ++i) {
                this.subclassPropertyAliases.put("id." + idPropertyNames[i], new String[]{idAliases[i]});
                this.subclassPropertyColumnNames.put("id." + this.getIdentifierPropertyName() + "." + idPropertyNames[i], new String[]{idColumnNames[i]});
                if (this.hasIdentifierProperty() && !"id".equals(this.getIdentifierPropertyName())) {
                    this.subclassPropertyAliases.put(this.getIdentifierPropertyName() + "." + idPropertyNames[i], new String[]{idAliases[i]});
                    this.subclassPropertyColumnNames.put(this.getIdentifierPropertyName() + "." + idPropertyNames[i], new String[]{idColumnNames[i]});
                    continue;
                }
                this.subclassPropertyAliases.put(idPropertyNames[i], new String[]{idAliases[i]});
                this.subclassPropertyColumnNames.put(idPropertyNames[i], new String[]{idColumnNames[i]});
            }
        }
        if (this.entityMetamodel.isPolymorphic()) {
            this.subclassPropertyAliases.put(ENTITY_CLASS, new String[]{this.getDiscriminatorAlias()});
            this.subclassPropertyColumnNames.put(ENTITY_CLASS, new String[]{this.getDiscriminatorColumnName()});
        }
    }

    private void internalInitSubclassPropertyAliasesMap(String path, Iterator propertyIterator) {
        while (propertyIterator.hasNext()) {
            String propname;
            Property prop = (Property)propertyIterator.next();
            String string = propname = path == null ? prop.getName() : path + "." + prop.getName();
            if (prop.isComposite()) {
                Component component = (Component)prop.getValue();
                Iterator compProps = component.getPropertyIterator();
                this.internalInitSubclassPropertyAliasesMap(propname, compProps);
                continue;
            }
            String[] aliases = new String[prop.getColumnSpan()];
            String[] cols = new String[prop.getColumnSpan()];
            Iterator colIter = prop.getColumnIterator();
            int l = 0;
            while (colIter.hasNext()) {
                Selectable thing = (Selectable)colIter.next();
                aliases[l] = thing.getAlias(this.getFactory().getDialect(), prop.getValue().getTable());
                cols[l] = thing.getText(this.getFactory().getDialect());
                ++l;
            }
            this.subclassPropertyAliases.put(propname, aliases);
            this.subclassPropertyColumnNames.put(propname, cols);
        }
    }

    public Object loadByUniqueKey(String propertyName, Object uniqueKey, SessionImplementor session) throws HibernateException {
        return this.getAppropriateUniqueKeyLoader(propertyName, session.getEnabledFilters()).loadByUniqueKey(session, uniqueKey);
    }

    private EntityLoader getAppropriateUniqueKeyLoader(String propertyName, Map enabledFilters) {
        boolean useStaticLoader;
        boolean bl = useStaticLoader = (enabledFilters == null || enabledFilters.isEmpty()) && propertyName.indexOf(46) < 0;
        if (useStaticLoader) {
            return (EntityLoader)this.uniqueKeyLoaders.get(propertyName);
        }
        return this.createUniqueKeyLoader(this.propertyMapping.toType(propertyName), this.propertyMapping.toColumns(propertyName), enabledFilters);
    }

    public int getPropertyIndex(String propertyName) {
        return this.entityMetamodel.getPropertyIndex(propertyName);
    }

    protected void createUniqueKeyLoaders() throws MappingException {
        Type[] propertyTypes = this.getPropertyTypes();
        String[] propertyNames = this.getPropertyNames();
        for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
            if (!this.propertyUniqueness[i]) continue;
            this.uniqueKeyLoaders.put(propertyNames[i], this.createUniqueKeyLoader(propertyTypes[i], this.getPropertyColumnNames(i), CollectionHelper.EMPTY_MAP));
        }
    }

    private EntityLoader createUniqueKeyLoader(Type uniqueKeyType, String[] columns, Map enabledFilters) {
        if (uniqueKeyType.isEntityType()) {
            String className = ((EntityType)uniqueKeyType).getAssociatedEntityName();
            uniqueKeyType = this.getFactory().getEntityPersister(className).getIdentifierType();
        }
        return new EntityLoader(this, columns, uniqueKeyType, 1, LockMode.NONE, this.getFactory(), enabledFilters);
    }

    protected String getSQLWhereString(String alias) {
        return StringHelper.replace(this.sqlWhereStringTemplate, "$PlaceHolder$", alias);
    }

    protected boolean hasWhere() {
        return this.sqlWhereString != null;
    }

    private void initOrdinaryPropertyPaths(Mapping mapping) throws MappingException {
        for (int i = 0; i < this.getSubclassPropertyNameClosure().length; ++i) {
            this.propertyMapping.initPropertyPaths(this.getSubclassPropertyNameClosure()[i], this.getSubclassPropertyTypeClosure()[i], this.getSubclassPropertyColumnNameClosure()[i], this.getSubclassPropertyFormulaTemplateClosure()[i], mapping);
        }
    }

    private void initIdentifierPropertyPaths(Mapping mapping) throws MappingException {
        String idProp = this.getIdentifierPropertyName();
        if (idProp != null) {
            this.propertyMapping.initPropertyPaths(idProp, this.getIdentifierType(), this.getIdentifierColumnNames(), null, mapping);
        }
        if (this.entityMetamodel.getIdentifierProperty().isEmbedded()) {
            this.propertyMapping.initPropertyPaths(null, this.getIdentifierType(), this.getIdentifierColumnNames(), null, mapping);
        }
        this.propertyMapping.initPropertyPaths("id", this.getIdentifierType(), this.getIdentifierColumnNames(), null, mapping);
    }

    private void initDiscriminatorPropertyPath(Mapping mapping) throws MappingException {
        this.propertyMapping.initPropertyPaths(ENTITY_CLASS, this.getDiscriminatorType(), new String[]{this.getDiscriminatorColumnName()}, new String[]{this.getDiscriminatorFormulaTemplate()}, this.getFactory());
    }

    protected void initPropertyPaths(Mapping mapping) throws MappingException {
        this.initOrdinaryPropertyPaths(mapping);
        this.initOrdinaryPropertyPaths(mapping);
        this.initIdentifierPropertyPaths(mapping);
        if (this.entityMetamodel.isPolymorphic()) {
            this.initDiscriminatorPropertyPath(mapping);
        }
    }

    protected UniqueEntityLoader createEntityLoader(LockMode lockMode, Map enabledFilters) throws MappingException {
        return BatchingEntityLoader.createBatchingEntityLoader(this, this.batchSize, lockMode, this.getFactory(), enabledFilters);
    }

    protected UniqueEntityLoader createEntityLoader(LockMode lockMode) throws MappingException {
        return this.createEntityLoader(lockMode, CollectionHelper.EMPTY_MAP);
    }

    protected boolean check(int rows, Serializable id, int tableNumber) throws HibernateException {
        if (rows < 1) {
            if (!this.isNullableTable(tableNumber)) {
                if (this.getFactory().getStatistics().isStatisticsEnabled()) {
                    this.getFactory().getStatisticsImplementor().optimisticFailure(this.getEntityName());
                }
                throw new StaleObjectStateException(this.getEntityName(), id);
            }
        } else if (rows > 1) {
            throw new HibernateException("Duplicate identifier in table for: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory()));
        }
        return rows > 0;
    }

    protected String generateUpdateString(boolean[] includeProperty, int j, boolean useRowId) {
        return this.generateUpdateString(includeProperty, j, null, useRowId);
    }

    protected String generateUpdateString(boolean[] includeProperty, int j, Object[] oldFields, boolean useRowId) {
        Update update = new Update(this.getFactory().getDialect()).setTableName(this.getTableName(j));
        if (useRowId) {
            update.setPrimaryKeyColumnNames(new String[]{this.rowIdName});
        } else {
            update.setPrimaryKeyColumnNames(this.getKeyColumns(j));
        }
        boolean hasColumns = false;
        for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
            if (!includeProperty[i] || !this.isPropertyOfTable(i, j)) continue;
            update.addColumns(this.getPropertyColumnNames(i), this.propertyColumnUpdateable[i]);
            hasColumns = hasColumns || this.getPropertyColumnSpan(i) > 0;
        }
        if (j == 0 && this.isVersioned() && this.entityMetamodel.getOptimisticLockMode() == 0) {
            if (this.checkVersion(includeProperty)) {
                update.setVersionColumnName(this.getVersionColumnName());
                hasColumns = true;
            }
        } else if (this.entityMetamodel.getOptimisticLockMode() > 0 && oldFields != null) {
            boolean[] includeInWhere = this.entityMetamodel.getOptimisticLockMode() == 2 ? this.getPropertyUpdateability() : includeProperty;
            for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
                boolean include;
                boolean[] versionability = this.getPropertyVersionability();
                Type[] types = this.getPropertyTypes();
                boolean bl = include = includeInWhere[i] && this.isPropertyOfTable(i, j) && versionability[i];
                if (!include) continue;
                String[] propertyColumnNames = this.getPropertyColumnNames(i);
                boolean[] propertyNullness = types[i].toColumnNullness(oldFields[i], this.getFactory());
                for (int k = 0; k < propertyNullness.length; ++k) {
                    if (propertyNullness[k]) {
                        update.addWhereColumn(propertyColumnNames[k]);
                        continue;
                    }
                    update.addWhereColumn(propertyColumnNames[k], " is null");
                }
            }
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("update " + this.getEntityName());
        }
        return hasColumns ? update.toStatementString() : null;
    }

    private boolean checkVersion(boolean[] includeProperty) {
        boolean checkVersion = includeProperty[this.getVersionProperty()] || this.entityMetamodel.getPropertyUpdateGeneration()[this.getVersionProperty()];
        return checkVersion;
    }

    protected String generateInsertString(boolean[] includeProperty, int j) {
        return this.generateInsertString(false, includeProperty, j);
    }

    protected String generateInsertString(boolean identityInsert, boolean[] includeProperty) {
        return this.generateInsertString(identityInsert, includeProperty, 0);
    }

    protected String generateInsertString(boolean identityInsert, boolean[] includeProperty, int j) {
        Insert insert = new Insert(this.getFactory().getDialect()).setTableName(this.getTableName(j));
        for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
            if (!includeProperty[i] || !this.isPropertyOfTable(i, j)) continue;
            insert.addColumns(this.getPropertyColumnNames(i), this.propertyColumnInsertable[i]);
        }
        if (j == 0) {
            this.addDiscriminatorToInsert(insert);
        }
        if (j == 0 && identityInsert) {
            insert.addIdentityColumn(this.getKeyColumns(0)[0]);
        } else {
            insert.addColumns(this.getKeyColumns(j));
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            insert.setComment("insert " + this.getEntityName());
        }
        String result = insert.toStatementString();
        if (j == 0 && identityInsert && this.useInsertSelectIdentity()) {
            result = this.getFactory().getDialect().appendIdentitySelectToInsert(result);
        }
        return result;
    }

    protected String generateDeleteString(int j) {
        Delete delete = new Delete().setTableName(this.getTableName(j)).setPrimaryKeyColumnNames(this.getKeyColumns(j));
        if (j == 0) {
            delete.setVersionColumnName(this.getVersionColumnName());
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            delete.setComment("delete " + this.getEntityName());
        }
        return delete.toStatementString();
    }

    protected int dehydrate(Serializable id, Object[] fields, boolean[] includeProperty, boolean[][] includeColumns, int j, PreparedStatement st, SessionImplementor session) throws HibernateException, SQLException {
        return this.dehydrate(id, fields, null, includeProperty, includeColumns, j, st, session, 1);
    }

    protected int dehydrate(Serializable id, Object[] fields, Object rowId, boolean[] includeProperty, boolean[][] includeColumns, int j, PreparedStatement ps, SessionImplementor session, int index) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Dehydrating entity: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory())));
        }
        for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
            if (!includeProperty[i] || !this.isPropertyOfTable(i, j)) continue;
            this.getPropertyTypes()[i].nullSafeSet(ps, fields[i], index, includeColumns[i], session);
            index += ArrayHelper.countTrue(includeColumns[i]);
        }
        if (rowId != null) {
            ps.setObject(index, rowId);
            ++index;
        } else if (id != null) {
            this.getIdentifierType().nullSafeSet(ps, id, index, session);
            index += this.getIdentifierColumnSpan();
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] hydrate(ResultSet rs, Serializable id, Object object, Loadable rootLoadable, String[][] suffixedPropertyColumns, boolean allProperties, SessionImplementor session) throws SQLException, HibernateException {
        Object[] objectArray;
        block9: {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Hydrating entity: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory())));
            }
            AbstractEntityPersister rootPersister = (AbstractEntityPersister)rootLoadable;
            boolean hasDeferred = rootPersister.hasSequentialSelect();
            PreparedStatement sequentialSelect = null;
            ResultSet sequentialResultSet = null;
            try {
                String sql;
                if (hasDeferred && (sql = rootPersister.getSequentialSelect(this.getEntityName())) != null) {
                    sequentialSelect = session.getBatcher().prepareSelectStatement(sql);
                    rootPersister.getIdentifierType().nullSafeSet(sequentialSelect, id, 1, session);
                    sequentialResultSet = sequentialSelect.executeQuery();
                    sequentialResultSet.next();
                }
                String[] propNames = this.getPropertyNames();
                Type[] types = this.getPropertyTypes();
                Object[] values = new Object[types.length];
                boolean[] laziness = this.getPropertyLaziness();
                String[] propSubclassNames = this.getSubclassPropertySubclassNameClosure();
                for (int i = 0; i < types.length; ++i) {
                    if (!this.propertySelectable[i]) {
                        values[i] = BackrefPropertyAccessor.UNKNOWN;
                        continue;
                    }
                    if (allProperties || !laziness[i]) {
                        boolean propertyIsDeferred = hasDeferred && rootPersister.isSubclassPropertyDeferred(propNames[i], propSubclassNames[i]);
                        ResultSet propertyResultSet = propertyIsDeferred ? sequentialResultSet : rs;
                        String[] cols = propertyIsDeferred ? this.propertyColumnAliases[i] : suffixedPropertyColumns[i];
                        values[i] = types[i].hydrate(propertyResultSet, cols, session, object);
                        continue;
                    }
                    values[i] = LazyPropertyInitializer.UNFETCHED_PROPERTY;
                }
                if (sequentialResultSet != null) {
                    sequentialResultSet.close();
                }
                objectArray = values;
                if (sequentialSelect == null) break block9;
            }
            catch (Throwable throwable) {
                if (sequentialSelect != null) {
                    session.getBatcher().closeStatement(sequentialSelect);
                }
                throw throwable;
            }
            session.getBatcher().closeStatement(sequentialSelect);
        }
        return objectArray;
    }

    protected boolean useInsertSelectIdentity() {
        return !this.useGetGeneratedKeys() && this.getFactory().getDialect().supportsInsertSelectIdentity();
    }

    protected boolean useGetGeneratedKeys() {
        return this.getFactory().getSettings().isGetGeneratedKeysEnabled();
    }

    protected String getSequentialSelect(String entityName) {
        throw new UnsupportedOperationException("no sequential selects");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Serializable insert(Object[] fields, boolean[] notNull, String sql, Object object, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Inserting entity: " + this.getEntityName() + " (native id)"));
            if (this.isVersioned()) {
                log.trace((Object)("Version: " + Versioning.getVersion(fields, this)));
            }
        }
        try {
            PreparedStatement insert = session.getBatcher().prepareStatement(sql, this.useGetGeneratedKeys(), this.getKeyColumnNames());
            try {
                this.dehydrate(null, fields, notNull, this.propertyColumnInsertable, 0, insert, session);
                if (this.useInsertSelectIdentity()) {
                    if (!insert.execute()) {
                        while (!insert.getMoreResults() && insert.getUpdateCount() != -1) {
                        }
                    }
                    ResultSet rs = insert.getResultSet();
                    try {
                        Serializable serializable = IdentifierGeneratorFactory.getGeneratedIdentity(rs, this.getIdentifierType());
                        return serializable;
                    }
                    finally {
                        rs.close();
                    }
                }
                if (this.useGetGeneratedKeys()) {
                    insert.executeUpdate();
                    Serializable serializable = IdentifierGeneratorFactory.getGeneratedIdentity(GetGeneratedKeysHelper.getGeneratedKey(insert), this.getIdentifierType());
                    return serializable;
                }
                insert.executeUpdate();
                return ((PostInsertIdentifierGenerator)this.getIdentifierGenerator()).getGenerated(session, object, this);
            }
            finally {
                session.getBatcher().closeStatement(insert);
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not insert: " + MessageHelper.infoString(this), sql);
        }
    }

    public String getIdentitySelectString() {
        return this.getFactory().getDialect().getIdentitySelectString(this.getTableName(0), this.getKeyColumns(0)[0], this.getIdentifierType().sqlTypes(this.getFactory())[0]);
    }

    public String getSelectByUniqueKeyString(String propertyName) {
        return new SimpleSelect(this.getFactory().getDialect()).setTableName(this.getTableName(0)).addColumns(this.getKeyColumns(0)).addCondition(this.getPropertyColumnNames(propertyName), "=?").toStatementString();
    }

    protected void insert(Serializable id, Object[] fields, boolean[] notNull, int j, String sql, Object object, SessionImplementor session) throws HibernateException {
        if (this.isInverseTable(j)) {
            return;
        }
        if (this.isNullableTable(j) && this.isAllNull(fields, j)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Inserting entity: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory())));
            if (j == 0 && this.isVersioned()) {
                log.trace((Object)("Version: " + Versioning.getVersion(fields, this)));
            }
        }
        boolean callable = this.isInsertCallable(j);
        boolean useBatch = j == 0 && !callable;
        try {
            PreparedStatement insert = callable ? session.getBatcher().prepareCallableStatement(sql) : (useBatch ? session.getBatcher().prepareBatchStatement(sql) : session.getBatcher().prepareStatement(sql));
            try {
                this.dehydrate(id, fields, notNull, this.propertyColumnInsertable, j, insert, session);
                if (useBatch) {
                    session.getBatcher().addToBatch(1);
                } else {
                    insert.executeUpdate();
                }
            }
            catch (SQLException sqle) {
                if (useBatch) {
                    session.getBatcher().abortBatch(sqle);
                }
                throw sqle;
            }
            finally {
                if (!useBatch) {
                    session.getBatcher().closeStatement(insert);
                }
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not insert: " + MessageHelper.infoString(this), sql);
        }
    }

    protected void updateOrInsert(Serializable id, Object[] fields, Object[] oldFields, Object rowId, boolean[] includeProperty, int j, Object oldVersion, Object object, String sql, SessionImplementor session) throws HibernateException {
        if (!this.isInverseTable(j)) {
            boolean isRowToUpdate;
            if (this.isNullableTable(j) && oldFields != null && this.isAllNull(oldFields, j)) {
                isRowToUpdate = false;
            } else if (this.isNullableTable(j) && this.isAllNull(fields, j)) {
                isRowToUpdate = true;
                this.delete(id, oldVersion, j, object, this.getSQLDeleteStrings()[j], session);
            } else {
                isRowToUpdate = this.update(id, fields, oldFields, rowId, includeProperty, j, oldVersion, object, sql, session);
            }
            if (!isRowToUpdate && !this.isAllNull(fields, j)) {
                this.insert(id, fields, this.getPropertyInsertability(), j, this.getSQLInsertStrings()[j], object, session);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean update(Serializable id, Object[] fields, Object[] oldFields, Object rowId, boolean[] includeProperty, int j, Object oldVersion, Object object, String sql, SessionImplementor session) throws HibernateException {
        boolean useBatch;
        boolean useVersion = j == 0 && this.isVersioned();
        boolean callable = this.isUpdateCallable(j);
        boolean bl = useBatch = j == 0 && !callable && this.isBatchable();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Updating entity: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory())));
            if (useVersion) {
                log.trace((Object)("Existing version: " + oldVersion + " -> New version: " + fields[this.getVersionProperty()]));
            }
        }
        try {
            PreparedStatement update;
            int index = 1;
            if (callable) {
                CallableStatement callstatement = session.getBatcher().prepareCallableStatement(sql);
                callstatement.registerOutParameter(index++, 2);
                update = callstatement;
            } else {
                update = useBatch ? session.getBatcher().prepareBatchStatement(sql) : session.getBatcher().prepareStatement(sql);
            }
            try {
                index = this.dehydrate(id, fields, rowId, includeProperty, this.propertyColumnUpdateable, j, update, session, index);
                if (useVersion && 0 == this.entityMetamodel.getOptimisticLockMode()) {
                    if (this.checkVersion(includeProperty)) {
                        this.getVersionType().nullSafeSet(update, oldVersion, index, session);
                    }
                } else if (this.entityMetamodel.getOptimisticLockMode() > 0 && oldFields != null) {
                    boolean[] versionability = this.getPropertyVersionability();
                    boolean[] includeOldField = this.entityMetamodel.getOptimisticLockMode() == 2 ? this.getPropertyUpdateability() : includeProperty;
                    Type[] types = this.getPropertyTypes();
                    for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
                        boolean include;
                        boolean bl2 = include = includeOldField[i] && this.isPropertyOfTable(i, j) && versionability[i];
                        if (!include) continue;
                        boolean[] settable = types[i].toColumnNullness(oldFields[i], this.getFactory());
                        types[i].nullSafeSet(update, oldFields[i], index, settable, session);
                        index += ArrayHelper.countTrue(settable);
                    }
                }
                if (useBatch) {
                    session.getBatcher().addToBatch(1);
                    boolean versionability = true;
                    return versionability;
                }
                boolean versionability = this.check(update.executeUpdate(), id, j);
                return versionability;
            }
            catch (SQLException sqle) {
                if (!useBatch) throw sqle;
                session.getBatcher().abortBatch(sqle);
                throw sqle;
            }
            finally {
                if (!useBatch) {
                    session.getBatcher().closeStatement(update);
                }
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not update: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory()), sql);
        }
    }

    protected void delete(Serializable id, Object version, int j, Object object, String sql, SessionImplementor session) throws HibernateException {
        boolean useBatch;
        if (this.isInverseTable(j)) {
            return;
        }
        boolean useVersion = j == 0 && this.isVersioned();
        boolean callable = this.isDeleteCallable(j);
        boolean bl = useBatch = j == 0 && this.isBatchable() && !callable;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deleting entity: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory())));
            if (useVersion) {
                log.trace((Object)("Version: " + version));
            }
        }
        if (this.isTableCascadeDeleteEnabled(j)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("delete handled by foreign key constraint: " + this.getTableName(j)));
            }
            return;
        }
        try {
            PreparedStatement delete;
            int index = 1;
            if (callable) {
                CallableStatement callstatement = session.getBatcher().prepareCallableStatement(sql);
                callstatement.registerOutParameter(index++, 2);
                delete = callstatement;
            } else {
                delete = useBatch ? session.getBatcher().prepareBatchStatement(sql) : session.getBatcher().prepareStatement(sql);
            }
            try {
                this.getIdentifierType().nullSafeSet(delete, id, index, session);
                if (useVersion) {
                    this.getVersionType().nullSafeSet(delete, version, this.getIdentifierColumnSpan() + index, session);
                }
                if (useBatch) {
                    session.getBatcher().addToBatch(1);
                } else {
                    this.check(delete.executeUpdate(), id, j);
                }
            }
            catch (SQLException sqle) {
                if (useBatch) {
                    session.getBatcher().abortBatch(sqle);
                }
                throw sqle;
            }
            finally {
                if (!useBatch) {
                    session.getBatcher().closeStatement(delete);
                }
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not delete: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory()), sql);
        }
    }

    private String[] getUpdateStrings(boolean byRowId, boolean lazy) {
        if (byRowId) {
            return lazy ? this.getSQLLazyUpdateByRowIdStrings() : this.getSQLUpdateByRowIdStrings();
        }
        return lazy ? this.getSQLLazyUpdateStrings() : this.getSQLUpdateStrings();
    }

    public void update(Serializable id, Object[] fields, int[] dirtyFields, boolean hasDirtyCollection, Object[] oldFields, Object oldVersion, Object object, Object rowId, SessionImplementor session) throws HibernateException {
        int j;
        String[] updateStrings;
        boolean[] propsToUpdate;
        boolean[] tableUpdateNeeded = this.getTableUpdateNeeded(dirtyFields, hasDirtyCollection);
        int span = this.getTableSpan();
        if (this.entityMetamodel.isDynamicUpdate() && dirtyFields != null) {
            propsToUpdate = this.getPropertiesToUpdate(dirtyFields, hasDirtyCollection);
            updateStrings = new String[span];
            for (j = 0; j < span; ++j) {
                updateStrings[j] = tableUpdateNeeded[j] ? this.generateUpdateString(propsToUpdate, j, oldFields, j == 0 && rowId != null) : null;
            }
        } else {
            updateStrings = this.getUpdateStrings(rowId != null, this.hasUninitializedLazyProperties(object, session.getEntityMode()));
            propsToUpdate = this.getPropertyUpdateability(object, session.getEntityMode());
        }
        for (j = 0; j < span; ++j) {
            if (!tableUpdateNeeded[j]) continue;
            this.updateOrInsert(id, fields, oldFields, j == 0 ? rowId : null, propsToUpdate, j, oldVersion, object, updateStrings[j], session);
        }
    }

    public Serializable insert(Object[] fields, Object object, SessionImplementor session) throws HibernateException {
        Serializable id;
        int span = this.getTableSpan();
        if (this.entityMetamodel.isDynamicInsert()) {
            boolean[] notNull = this.getPropertiesToInsert(fields);
            id = this.insert(fields, notNull, this.generateInsertString(true, notNull), object, session);
            for (int j = 1; j < span; ++j) {
                this.insert(id, fields, notNull, j, this.generateInsertString(notNull, j), object, session);
            }
        } else {
            id = this.insert(fields, this.getPropertyInsertability(), this.getSQLIdentityInsertString(), object, session);
            for (int j = 1; j < span; ++j) {
                this.insert(id, fields, this.getPropertyInsertability(), j, this.getSQLInsertStrings()[j], object, session);
            }
        }
        return id;
    }

    public void insert(Serializable id, Object[] fields, Object object, SessionImplementor session) throws HibernateException {
        int span = this.getTableSpan();
        if (this.entityMetamodel.isDynamicInsert()) {
            boolean[] notNull = this.getPropertiesToInsert(fields);
            for (int j = 0; j < span; ++j) {
                this.insert(id, fields, notNull, j, this.generateInsertString(notNull, j), object, session);
            }
        } else {
            for (int j = 0; j < span; ++j) {
                this.insert(id, fields, this.getPropertyInsertability(), j, this.getSQLInsertStrings()[j], object, session);
            }
        }
    }

    public void delete(Serializable id, Object version, Object object, SessionImplementor session) throws HibernateException {
        int span = this.getTableSpan();
        for (int j = span - 1; j >= 0; --j) {
            this.delete(id, version, j, object, this.getSQLDeleteStrings()[j], session);
        }
    }

    protected void logStaticSQL() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Static SQL for entity: " + this.getEntityName()));
            if (this.sqlLazySelectString != null) {
                log.debug((Object)(" Lazy select: " + this.sqlLazySelectString));
            }
            if (this.sqlVersionSelectString != null) {
                log.debug((Object)(" Version select: " + this.sqlVersionSelectString));
            }
            if (this.sqlSnapshotSelectString != null) {
                log.debug((Object)(" Snapshot select: " + this.sqlSnapshotSelectString));
            }
            for (int j = 0; j < this.getTableSpan(); ++j) {
                log.debug((Object)(" Insert " + j + ": " + this.getSQLInsertStrings()[j]));
                log.debug((Object)(" Update " + j + ": " + this.getSQLUpdateStrings()[j]));
                log.debug((Object)(" Delete " + j + ": " + this.getSQLDeleteStrings()[j]));
            }
            if (this.sqlIdentityInsertString != null) {
                log.debug((Object)(" Identity insert: " + this.sqlIdentityInsertString));
            }
            if (this.sqlUpdateByRowIdString != null) {
                log.debug((Object)(" Update by row id (all fields): " + this.sqlUpdateByRowIdString));
            }
            if (this.sqlLazyUpdateByRowIdString != null) {
                log.debug((Object)(" Update by row id (non-lazy fields): " + this.sqlLazyUpdateByRowIdString));
            }
            if (this.sqlInsertGeneratedValuesSelectString != null) {
                log.debug((Object)("Insert-generated property select: " + this.sqlInsertGeneratedValuesSelectString));
            }
            if (this.sqlUpdateGeneratedValuesSelectString != null) {
                log.debug((Object)("Update-generated property select: " + this.sqlUpdateGeneratedValuesSelectString));
            }
        }
    }

    public String filterFragment(String alias, Map enabledFilters) throws MappingException {
        StringBuffer sessionFilterFragment = new StringBuffer();
        this.filterHelper.render(sessionFilterFragment, this.generateFilterConditionAlias(alias), enabledFilters);
        return sessionFilterFragment.append(this.filterFragment(alias)).toString();
    }

    public String generateFilterConditionAlias(String rootAlias) {
        return rootAlias;
    }

    public String oneToManyFilterFragment(String alias) throws MappingException {
        return "";
    }

    public String fromJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return this.getSubclassTableSpan() == 1 ? "" : this.createJoin(alias, innerJoin, includeSubclasses).toFromFragmentString();
    }

    public String whereJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return this.getSubclassTableSpan() == 1 ? "" : this.createJoin(alias, innerJoin, includeSubclasses).toWhereFragmentString();
    }

    protected boolean isSubclassTableLazy(int j) {
        return false;
    }

    protected JoinFragment createJoin(String name, boolean innerJoin, boolean includeSubclasses) {
        String[] idCols = StringHelper.qualify(name, this.getIdentifierColumnNames());
        JoinFragment join = this.getFactory().getDialect().createOuterJoinFragment();
        int tableSpan = this.getSubclassTableSpan();
        for (int j = 1; j < tableSpan; ++j) {
            boolean joinIsIncluded;
            boolean bl = joinIsIncluded = this.isClassOrSuperclassTable(j) || includeSubclasses && !this.isSubclassTableSequentialSelect(j) && !this.isSubclassTableLazy(j);
            if (!joinIsIncluded) continue;
            join.addJoin(this.getSubclassTableName(j), this.generateTableAlias(name, j), idCols, this.getSubclassTableKeyColumns(j), innerJoin && this.isClassOrSuperclassTable(j) && !this.isInverseTable(j) && !this.isNullableTable(j) ? 0 : 1);
        }
        return join;
    }

    protected JoinFragment createJoin(int[] tableNumbers, String drivingAlias) {
        String[] keyCols = StringHelper.qualify(drivingAlias, this.getSubclassTableKeyColumns(tableNumbers[0]));
        JoinFragment jf = this.getFactory().getDialect().createOuterJoinFragment();
        for (int i = 1; i < tableNumbers.length; ++i) {
            int j = tableNumbers[i];
            jf.addJoin(this.getSubclassTableName(j), this.generateTableAlias(this.getRootAlias(), j), keyCols, this.getSubclassTableKeyColumns(j), this.isInverseSubclassTable(j) || this.isNullableSubclassTable(j) ? 1 : 0);
        }
        return jf;
    }

    protected SelectFragment createSelect(int[] subclassColumnNumbers, int[] subclassFormulaNumbers) {
        SelectFragment selectFragment = new SelectFragment();
        int[] columnTableNumbers = this.getSubclassColumnTableNumberClosure();
        String[] columnAliases = this.getSubclassColumnAliasClosure();
        String[] columns = this.getSubclassColumnClosure();
        for (int i = 0; i < subclassColumnNumbers.length; ++i) {
            if (!this.subclassColumnSelectableClosure[i]) continue;
            int columnNumber = subclassColumnNumbers[i];
            String subalias = this.generateTableAlias(this.getRootAlias(), columnTableNumbers[columnNumber]);
            selectFragment.addColumn(subalias, columns[columnNumber], columnAliases[columnNumber]);
        }
        int[] formulaTableNumbers = this.getSubclassFormulaTableNumberClosure();
        String[] formulaTemplates = this.getSubclassFormulaTemplateClosure();
        String[] formulaAliases = this.getSubclassFormulaAliasClosure();
        for (int i = 0; i < subclassFormulaNumbers.length; ++i) {
            int formulaNumber = subclassFormulaNumbers[i];
            String subalias = this.generateTableAlias(this.getRootAlias(), formulaTableNumbers[formulaNumber]);
            selectFragment.addFormula(subalias, formulaTemplates[formulaNumber], formulaAliases[formulaNumber]);
        }
        return selectFragment;
    }

    protected String createFrom(int tableNumber, String alias) {
        return this.getSubclassTableName(tableNumber) + ' ' + alias;
    }

    protected String createWhereByKey(int tableNumber, String alias) {
        return StringHelper.join("=? and ", StringHelper.qualify(alias, this.getSubclassTableKeyColumns(tableNumber))) + "=?";
    }

    protected String renderSelect(int[] tableNumbers, int[] columnNumbers, int[] formulaNumbers) {
        Arrays.sort(tableNumbers);
        int drivingTable = tableNumbers[0];
        String drivingAlias = this.generateTableAlias(this.getRootAlias(), drivingTable);
        String where = this.createWhereByKey(drivingTable, drivingAlias);
        String from = this.createFrom(drivingTable, drivingAlias);
        JoinFragment jf = this.createJoin(tableNumbers, drivingAlias);
        SelectFragment selectFragment = this.createSelect(columnNumbers, formulaNumbers);
        Select select = new Select(this.getFactory().getDialect());
        select.setSelectClause(selectFragment.toFragmentString().substring(2));
        select.setFromClause(from);
        select.setWhereClause(where);
        select.setOuterJoins(jf.toFromFragmentString(), jf.toWhereFragmentString());
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("sequential select " + this.getEntityName());
        }
        return select.toStatementString();
    }

    private String getRootAlias() {
        return StringHelper.generateAlias(this.getEntityName());
    }

    protected void postConstruct(Mapping mapping) throws MappingException {
        int j;
        this.initPropertyPaths(mapping);
        int joinSpan = this.getTableSpan();
        this.sqlDeleteStrings = new String[joinSpan];
        this.sqlInsertStrings = new String[joinSpan];
        this.sqlUpdateStrings = new String[joinSpan];
        this.sqlLazyUpdateStrings = new String[joinSpan];
        this.sqlUpdateByRowIdString = this.rowIdName == null ? null : this.generateUpdateString(this.getPropertyUpdateability(), 0, true);
        this.sqlLazyUpdateByRowIdString = this.rowIdName == null ? null : this.generateUpdateString(this.getNonLazyPropertyUpdateability(), 0, true);
        for (j = 0; j < joinSpan; ++j) {
            this.sqlInsertStrings[j] = this.customSQLInsert[j] == null ? this.generateInsertString(this.getPropertyInsertability(), j) : this.customSQLInsert[j];
            this.sqlUpdateStrings[j] = this.customSQLUpdate[j] == null ? this.generateUpdateString(this.getPropertyUpdateability(), j, false) : this.customSQLUpdate[j];
            this.sqlLazyUpdateStrings[j] = this.customSQLUpdate[j] == null ? this.generateUpdateString(this.getNonLazyPropertyUpdateability(), j, false) : this.customSQLUpdate[j];
            this.sqlDeleteStrings[j] = this.customSQLDelete[j] == null ? this.generateDeleteString(j) : this.customSQLDelete[j];
        }
        this.tableHasColumns = new boolean[joinSpan];
        for (j = 0; j < joinSpan; ++j) {
            this.tableHasColumns[j] = this.sqlUpdateStrings[j] != null;
        }
        this.sqlSnapshotSelectString = this.generateSnapshotSelectString();
        this.sqlLazySelectString = this.generateLazySelectString();
        this.sqlVersionSelectString = this.generateSelectVersionString();
        if (this.hasInsertGeneratedProperties()) {
            this.sqlInsertGeneratedValuesSelectString = this.generateInsertGeneratedValuesSelectString();
        }
        if (this.hasUpdateGeneratedProperties()) {
            this.sqlUpdateGeneratedValuesSelectString = this.generateUpdateGeneratedValuesSelectString();
        }
        this.sqlIdentityInsertString = this.isIdentifierAssignedByInsert() ? (this.customSQLInsert[0] == null ? this.generateInsertString(true, this.getPropertyInsertability()) : this.customSQLInsert[0]) : null;
        this.logStaticSQL();
    }

    public void postInstantiate() throws MappingException {
        this.createLoaders();
        this.createUniqueKeyLoaders();
        this.createQueryLoader();
    }

    private void createLoaders() {
        this.loaders.put(LockMode.NONE, this.createEntityLoader(LockMode.NONE));
        UniqueEntityLoader readLoader = this.createEntityLoader(LockMode.READ);
        this.loaders.put(LockMode.READ, readLoader);
        boolean disableForUpdate = this.getSubclassTableSpan() > 1 && this.hasSubclasses() && !this.getFactory().getDialect().supportsOuterJoinForUpdate();
        this.loaders.put(LockMode.UPGRADE, disableForUpdate ? readLoader : this.createEntityLoader(LockMode.UPGRADE));
        this.loaders.put(LockMode.UPGRADE_NOWAIT, disableForUpdate ? readLoader : this.createEntityLoader(LockMode.UPGRADE_NOWAIT));
        this.loaders.put("merge", new CascadeEntityLoader(this, CascadingAction.MERGE, this.getFactory()));
        this.loaders.put("refresh", new CascadeEntityLoader(this, CascadingAction.REFRESH, this.getFactory()));
    }

    protected void createQueryLoader() {
        if (this.loaderName != null) {
            this.queryLoader = new NamedQueryLoader(this.loaderName, this);
        }
    }

    public Object load(Serializable id, Object optionalObject, LockMode lockMode, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Fetching entity: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory())));
        }
        UniqueEntityLoader loader = this.getAppropriateLoader(lockMode, session);
        return loader.load(id, optionalObject, session);
    }

    private UniqueEntityLoader getAppropriateLoader(LockMode lockMode, SessionImplementor session) {
        Map enabledFilters = session.getEnabledFilters();
        if (this.queryLoader != null) {
            return this.queryLoader;
        }
        if (enabledFilters == null || enabledFilters.isEmpty()) {
            if (session.getFetchProfile() != null && LockMode.UPGRADE.greaterThan(lockMode)) {
                return (UniqueEntityLoader)this.loaders.get(session.getFetchProfile());
            }
            return (UniqueEntityLoader)this.loaders.get(lockMode);
        }
        return this.createEntityLoader(lockMode, enabledFilters);
    }

    private boolean isAllNull(Object[] array, int tableNumber) {
        for (int i = 0; i < array.length; ++i) {
            if (!this.isPropertyOfTable(i, tableNumber) || array[i] == null) continue;
            return false;
        }
        return true;
    }

    public boolean isSubclassPropertyNullable(int i) {
        return this.subclassPropertyNullabilityClosure[i];
    }

    protected final boolean[] getPropertiesToUpdate(int[] dirtyProperties, boolean hasDirtyCollection) {
        boolean[] propsToUpdate = new boolean[this.entityMetamodel.getPropertySpan()];
        boolean[] updateability = this.getPropertyUpdateability();
        for (int j = 0; j < dirtyProperties.length; ++j) {
            int property = dirtyProperties[j];
            if (!updateability[property]) continue;
            propsToUpdate[property] = true;
        }
        if (this.isVersioned()) {
            propsToUpdate[this.getVersionProperty()] = Versioning.isVersionIncrementRequired(dirtyProperties, hasDirtyCollection, this.getPropertyVersionability());
        }
        return propsToUpdate;
    }

    protected boolean[] getPropertiesToInsert(Object[] fields) {
        boolean[] notNull = new boolean[fields.length];
        boolean[] insertable = this.getPropertyInsertability();
        for (int i = 0; i < fields.length; ++i) {
            notNull[i] = insertable[i] && fields[i] != null;
        }
        return notNull;
    }

    public int[] findDirty(Object[] currentState, Object[] previousState, Object entity, SessionImplementor session) throws HibernateException {
        int[] props = TypeFactory.findDirty(this.entityMetamodel.getProperties(), currentState, previousState, this.propertyColumnUpdateable, this.hasUninitializedLazyProperties(entity, session.getEntityMode()), session);
        if (props == null) {
            return null;
        }
        this.logDirtyProperties(props);
        return props;
    }

    public int[] findModified(Object[] old, Object[] current, Object entity, SessionImplementor session) throws HibernateException {
        int[] props = TypeFactory.findModified(this.entityMetamodel.getProperties(), current, old, this.propertyColumnUpdateable, this.hasUninitializedLazyProperties(entity, session.getEntityMode()), session);
        if (props == null) {
            return null;
        }
        this.logDirtyProperties(props);
        return props;
    }

    protected boolean[] getPropertyUpdateability(Object entity, EntityMode entityMode) {
        return this.hasUninitializedLazyProperties(entity, entityMode) ? this.getNonLazyPropertyUpdateability() : this.getPropertyUpdateability();
    }

    private void logDirtyProperties(int[] props) {
        if (log.isTraceEnabled()) {
            for (int i = 0; i < props.length; ++i) {
                String propertyName = this.entityMetamodel.getProperties()[props[i]].getName();
                log.trace((Object)(StringHelper.qualify(this.getEntityName(), propertyName) + " is dirty"));
            }
        }
    }

    protected EntityTuplizer getTuplizer(SessionImplementor session) {
        return this.getTuplizer(session.getEntityMode());
    }

    protected EntityTuplizer getTuplizer(EntityMode entityMode) {
        return this.entityMetamodel.getTuplizer(entityMode);
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    protected EntityMetamodel getEntityMetamodel() {
        return this.entityMetamodel;
    }

    public boolean hasCache() {
        return this.cache != null;
    }

    public CacheConcurrencyStrategy getCache() {
        return this.cache;
    }

    public CacheEntryStructure getCacheEntryStructure() {
        return this.cacheEntryStructure;
    }

    public final String getEntityName() {
        return this.entityMetamodel.getName();
    }

    public EntityType getEntityType() {
        return this.entityMetamodel.getEntityType();
    }

    private String getSubclassEntityName(Class clazz) {
        return (String)this.entityNameBySubclass.get(clazz);
    }

    public boolean isPolymorphic() {
        return this.entityMetamodel.isPolymorphic();
    }

    public boolean isInherited() {
        return this.entityMetamodel.isInherited();
    }

    public boolean hasCascades() {
        return this.entityMetamodel.hasCascades();
    }

    public boolean hasIdentifierProperty() {
        return !this.entityMetamodel.getIdentifierProperty().isVirtual();
    }

    public VersionType getVersionType() {
        return (VersionType)this.locateVersionType();
    }

    private Type locateVersionType() {
        return this.entityMetamodel.getVersionProperty() == null ? null : this.entityMetamodel.getVersionProperty().getType();
    }

    public int getVersionProperty() {
        return this.entityMetamodel.getVersionPropertyIndex();
    }

    public boolean isVersioned() {
        return this.entityMetamodel.isVersioned();
    }

    public boolean isIdentifierAssignedByInsert() {
        return this.entityMetamodel.getIdentifierProperty().isIdentifierAssignedByInsert();
    }

    public boolean hasLazyProperties() {
        return this.entityMetamodel.hasLazyProperties();
    }

    public void afterReassociate(Object entity, SessionImplementor session) {
        if (entity instanceof InterceptFieldEnabled) {
            FieldInterceptor interceptor = FieldInterceptor.getFieldInterceptor(entity);
            if (interceptor != null) {
                interceptor.setSession(session);
            } else {
                FieldInterceptor fieldInterceptor = FieldInterceptor.initFieldInterceptor(entity, this.getEntityName(), session, null);
                fieldInterceptor.dirty();
            }
        }
    }

    public Boolean isTransient(Object entity, SessionImplementor session) throws HibernateException {
        Boolean result;
        Serializable id = this.hasIdentifierPropertyOrEmbeddedCompositeIdentifier() ? this.getIdentifier(entity, session.getEntityMode()) : null;
        if (id == null) {
            return Boolean.TRUE;
        }
        Object version = this.getVersion(entity, session.getEntityMode());
        if (this.isVersioned() && (result = this.entityMetamodel.getVersionProperty().getUnsavedValue().isUnsaved(version)) != null) {
            return result;
        }
        result = this.entityMetamodel.getIdentifierProperty().getUnsavedValue().isUnsaved(id);
        if (result != null) {
            return result;
        }
        if (this.hasCache()) {
            CacheKey ck = new CacheKey(id, this.getIdentifierType(), this.getRootEntityName(), session.getEntityMode(), session.getFactory());
            if (this.getCache().get(ck, session.getTimestamp()) != null) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public boolean hasCollections() {
        return this.entityMetamodel.hasCollections();
    }

    public boolean hasMutableProperties() {
        return this.entityMetamodel.hasMutableProperties();
    }

    public boolean isMutable() {
        return this.entityMetamodel.isMutable();
    }

    public boolean isAbstract() {
        return this.entityMetamodel.isAbstract();
    }

    public boolean hasSubclasses() {
        return this.entityMetamodel.hasSubclasses();
    }

    public boolean hasProxy() {
        return this.entityMetamodel.isLazy();
    }

    public IdentifierGenerator getIdentifierGenerator() throws HibernateException {
        return this.entityMetamodel.getIdentifierProperty().getIdentifierGenerator();
    }

    public String getRootEntityName() {
        return this.entityMetamodel.getRootName();
    }

    public ClassMetadata getClassMetadata() {
        return this;
    }

    public String getMappedSuperclass() {
        return this.entityMetamodel.getSuperclass();
    }

    public boolean isExplicitPolymorphism() {
        return this.entityMetamodel.isExplicitPolymorphism();
    }

    protected boolean useDynamicUpdate() {
        return this.entityMetamodel.isDynamicUpdate();
    }

    protected boolean useDynamicInsert() {
        return this.entityMetamodel.isDynamicInsert();
    }

    protected boolean hasEmbeddedCompositeIdentifier() {
        return this.entityMetamodel.getIdentifierProperty().isEmbedded();
    }

    public boolean hasIdentifierPropertyOrEmbeddedCompositeIdentifier() {
        return this.hasIdentifierProperty() || this.hasEmbeddedCompositeIdentifier();
    }

    public String[] getKeyColumnNames() {
        return this.getIdentifierColumnNames();
    }

    public String getName() {
        return this.getEntityName();
    }

    public boolean isCollection() {
        return false;
    }

    public boolean consumesEntityAlias() {
        return true;
    }

    public boolean consumesCollectionAlias() {
        return false;
    }

    public Type getPropertyType(String propertyName) throws MappingException {
        return this.propertyMapping.toType(propertyName);
    }

    public Type getType() {
        return this.entityMetamodel.getEntityType();
    }

    public boolean isSelectBeforeUpdateRequired() {
        return this.entityMetamodel.isSelectBeforeUpdate();
    }

    protected final int optimisticLockMode() {
        return this.entityMetamodel.getOptimisticLockMode();
    }

    public Object createProxy(Serializable id, SessionImplementor session) throws HibernateException {
        return this.entityMetamodel.getTuplizer(session.getEntityMode()).createProxy(id, session);
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + '(' + this.entityMetamodel.getName() + ')';
    }

    public final String selectFragment(Joinable rhs, String rhsAlias, String lhsAlias, String entitySuffix, String collectionSuffix, boolean includeCollectionColumns) {
        return this.selectFragment(lhsAlias, entitySuffix);
    }

    public boolean isInstrumented(EntityMode entityMode) {
        EntityTuplizer tuplizer = this.entityMetamodel.getTuplizerOrNull(entityMode);
        return tuplizer != null && tuplizer.isInstrumented();
    }

    public boolean hasInsertGeneratedProperties() {
        return !ArrayHelper.isAllFalse(this.getPropertyInsertGeneration());
    }

    public boolean hasUpdateGeneratedProperties() {
        return !ArrayHelper.isAllFalse(this.getPropertyUpdateGeneration());
    }

    public boolean isVersionPropertyGenerated() {
        return this.isVersioned() && this.getPropertyUpdateGeneration()[this.getVersionProperty()];
    }

    public boolean isVersionPropertyInsertable() {
        return this.isVersioned() && this.getPropertyInsertability()[this.getVersionProperty()];
    }

    public void afterInitialize(Object entity, boolean lazyPropertiesAreUnfetched, SessionImplementor session) {
        this.getTuplizer(session).afterInitialize(entity, lazyPropertiesAreUnfetched, session);
    }

    public String[] getPropertyNames() {
        return this.entityMetamodel.getPropertyNames();
    }

    public Type[] getPropertyTypes() {
        return this.entityMetamodel.getPropertyTypes();
    }

    public boolean[] getPropertyLaziness() {
        return this.entityMetamodel.getPropertyLaziness();
    }

    public boolean[] getPropertyUpdateability() {
        return this.entityMetamodel.getPropertyUpdateability();
    }

    public boolean[] getPropertyCheckability() {
        return this.entityMetamodel.getPropertyCheckability();
    }

    public boolean[] getNonLazyPropertyUpdateability() {
        return this.entityMetamodel.getNonlazyPropertyUpdateability();
    }

    public boolean[] getPropertyInsertability() {
        return this.entityMetamodel.getPropertyInsertability();
    }

    public boolean[] getPropertyInsertGeneration() {
        return this.entityMetamodel.getPropertyInsertGeneration();
    }

    public boolean[] getPropertyUpdateGeneration() {
        return this.entityMetamodel.getPropertyUpdateGeneration();
    }

    public boolean[] getPropertyNullability() {
        return this.entityMetamodel.getPropertyNullability();
    }

    public boolean[] getPropertyVersionability() {
        return this.entityMetamodel.getPropertyVersionability();
    }

    public CascadeStyle[] getPropertyCascadeStyles() {
        return this.entityMetamodel.getCascadeStyles();
    }

    public final Class getMappedClass(EntityMode entityMode) {
        EntityTuplizer tup = this.entityMetamodel.getTuplizerOrNull(entityMode);
        return tup == null ? null : tup.getMappedClass();
    }

    public boolean implementsLifecycle(EntityMode entityMode) {
        return this.getTuplizer(entityMode).isLifecycleImplementor();
    }

    public boolean implementsValidatable(EntityMode entityMode) {
        return this.getTuplizer(entityMode).isValidatableImplementor();
    }

    public Class getConcreteProxyClass(EntityMode entityMode) {
        return this.getTuplizer(entityMode).getConcreteProxyClass();
    }

    public void setPropertyValues(Object object, Object[] values, EntityMode entityMode) throws HibernateException {
        this.getTuplizer(entityMode).setPropertyValues(object, values);
    }

    public void setPropertyValue(Object object, int i, Object value, EntityMode entityMode) throws HibernateException {
        this.getTuplizer(entityMode).setPropertyValue(object, i, value);
    }

    public Object[] getPropertyValues(Object object, EntityMode entityMode) throws HibernateException {
        return this.getTuplizer(entityMode).getPropertyValues(object);
    }

    public Object getPropertyValue(Object object, int i, EntityMode entityMode) throws HibernateException {
        return this.getTuplizer(entityMode).getPropertyValue(object, i);
    }

    public Object getPropertyValue(Object object, String propertyName, EntityMode entityMode) throws HibernateException {
        return this.getTuplizer(entityMode).getPropertyValue(object, propertyName);
    }

    public Serializable getIdentifier(Object object, EntityMode entityMode) throws HibernateException {
        return this.getTuplizer(entityMode).getIdentifier(object);
    }

    public void setIdentifier(Object object, Serializable id, EntityMode entityMode) throws HibernateException {
        this.getTuplizer(entityMode).setIdentifier(object, id);
    }

    public Object getVersion(Object object, EntityMode entityMode) throws HibernateException {
        return this.getTuplizer(entityMode).getVersion(object);
    }

    public Object instantiate(Serializable id, EntityMode entityMode) throws HibernateException {
        return this.getTuplizer(entityMode).instantiate(id);
    }

    public boolean isInstance(Object object, EntityMode entityMode) {
        return this.getTuplizer(entityMode).isInstance(object);
    }

    public boolean hasUninitializedLazyProperties(Object object, EntityMode entityMode) {
        return this.getTuplizer(entityMode).hasUninitializedLazyProperties(object);
    }

    public void resetIdentifier(Object entity, Serializable currentId, Object currentVersion, EntityMode entityMode) {
        this.getTuplizer(entityMode).resetIdentifier(entity, currentId, currentVersion);
    }

    public EntityPersister getSubclassEntityPersister(Object instance, SessionFactoryImplementor factory, EntityMode entityMode) {
        if (!this.hasSubclasses()) {
            return this;
        }
        Class<?> clazz = instance.getClass();
        if (clazz == this.getMappedClass(entityMode)) {
            return this;
        }
        String subclassEntityName = this.getSubclassEntityName(clazz);
        if (subclassEntityName == null) {
            throw new HibernateException("instance not of expected entity type: " + this.getEntityName());
        }
        return factory.getEntityPersister(subclassEntityName);
    }

    public EntityMode guessEntityMode(Object object) {
        return this.entityMetamodel.guessEntityMode(object);
    }

    public boolean isMultiTable() {
        return false;
    }

    public String getTemporaryIdTableName() {
        return this.temporaryIdTableName;
    }

    public String getTemporaryIdTableDDL() {
        return this.temporaryIdTableDDL;
    }

    protected int getPropertySpan() {
        return this.entityMetamodel.getPropertySpan();
    }

    public Object[] getPropertyValuesToInsert(Object object, Map mergeMap, SessionImplementor session) throws HibernateException {
        return this.getTuplizer(session.getEntityMode()).getPropertyValuesToInsert(object, mergeMap, session);
    }

    public void processInsertGeneratedProperties(Serializable id, Object entity, Object[] state, SessionImplementor session) {
        if (!this.hasInsertGeneratedProperties()) {
            throw new AssertionFailure("no insert-generated properties");
        }
        this.processGeneratedProperties(id, entity, state, session, this.sqlInsertGeneratedValuesSelectString, this.getPropertyInsertGeneration());
    }

    public void processUpdateGeneratedProperties(Serializable id, Object entity, Object[] state, SessionImplementor session) {
        if (!this.hasInsertGeneratedProperties()) {
            throw new AssertionFailure("no insert-generated properties");
        }
        this.processGeneratedProperties(id, entity, state, session, this.sqlUpdateGeneratedValuesSelectString, this.getPropertyUpdateGeneration());
    }

    private void processGeneratedProperties(Serializable id, Object entity, Object[] state, SessionImplementor session, String selectionSQL, boolean[] included) {
        session.getBatcher().executeBatch();
        PreparedStatement ps = null;
        try {
            ps = session.getBatcher().prepareSelectStatement(selectionSQL);
            this.getIdentifierType().nullSafeSet(ps, id, 1, session);
            ResultSet rs = session.getBatcher().getResultSet(ps);
            if (!rs.next()) {
                throw new HibernateException("Unable to locate row for retrieval of generated properties: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory()));
            }
            for (int i = 0; i < this.getPropertySpan(); ++i) {
                if (!included[i]) continue;
                state[i] = this.getPropertyTypes()[i].hydrate(rs, this.getPropertyAliases("", i), session, entity);
                this.setPropertyValue(entity, i, state[i], session.getEntityMode());
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "unable to select generated column values", selectionSQL);
        }
    }

    public String getIdentifierPropertyName() {
        return this.entityMetamodel.getIdentifierProperty().getName();
    }

    public Type getIdentifierType() {
        return this.entityMetamodel.getIdentifierProperty().getType();
    }

    public boolean hasSubselectLoadableCollections() {
        return this.hasSubselectLoadableCollections;
    }

    public int[] getNaturalIdentifierProperties() {
        return this.entityMetamodel.getNaturalIdentifierProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Object[] getNaturalIdentifierSnapshot(Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.hasNaturalIdentifier()) {
            throw new MappingException("persistent class did not define a natural-id : " + MessageHelper.infoString(this));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Getting current natural-id snapshot state for: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory())));
        }
        int[] naturalIdPropertyIndexes = this.getNaturalIdentifierProperties();
        int naturalIdPropertyCount = naturalIdPropertyIndexes.length;
        boolean[] naturalIdMarkers = new boolean[this.getPropertySpan()];
        Type[] extractionTypes = new Type[naturalIdPropertyCount];
        for (int i = 0; i < naturalIdPropertyCount; ++i) {
            extractionTypes[i] = this.getPropertyTypes()[naturalIdPropertyIndexes[i]];
            naturalIdMarkers[naturalIdPropertyIndexes[i]] = true;
        }
        Select select = new Select(this.getFactory().getDialect());
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("get current natural-id state " + this.getEntityName());
        }
        select.setSelectClause(this.concretePropertySelectFragmentSansLeadingComma(this.getRootAlias(), naturalIdMarkers));
        select.setFromClause(this.fromTableFragment(this.getRootAlias()) + this.fromJoinFragment(this.getRootAlias(), true, false));
        String[] aliasedIdColumns = StringHelper.qualify(this.getRootAlias(), this.getIdentifierColumnNames());
        String whereClause = StringHelper.join("=? and ", aliasedIdColumns) + "=?" + this.whereJoinFragment(this.getRootAlias(), true, false);
        String sql = select.setOuterJoins("", "").setWhereClause(whereClause).toStatementString();
        Object[] snapshot = new Object[naturalIdPropertyCount];
        try {
            PreparedStatement ps = session.getBatcher().prepareSelectStatement(sql);
            try {
                Object[] objectArray;
                ResultSet rs;
                block15: {
                    this.getIdentifierType().nullSafeSet(ps, id, 1, session);
                    rs = ps.executeQuery();
                    if (rs.next()) break block15;
                    Object[] objectArray2 = null;
                    rs.close();
                    return objectArray2;
                }
                try {
                    for (int i = 0; i < naturalIdPropertyCount; ++i) {
                        snapshot[i] = extractionTypes[i].hydrate(rs, this.getPropertyAliases("", naturalIdPropertyIndexes[i]), session, null);
                    }
                    objectArray = snapshot;
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return objectArray;
            }
            finally {
                session.getBatcher().closeStatement(ps);
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not retrieve snapshot: " + MessageHelper.infoString((EntityPersister)this, id, this.getFactory()), sql);
        }
    }

    protected String concretePropertySelectFragmentSansLeadingComma(String alias, boolean[] include) {
        String concretePropertySelectFragment = this.concretePropertySelectFragment(alias, include);
        int firstComma = concretePropertySelectFragment.indexOf(", ");
        if (firstComma == 0) {
            concretePropertySelectFragment = concretePropertySelectFragment.substring(2);
        }
        return concretePropertySelectFragment;
    }

    public boolean hasNaturalIdentifier() {
        return this.entityMetamodel.hasNaturalIdentifier();
    }

    public void setPropertyValue(Object object, String propertyName, Object value, EntityMode entityMode) throws HibernateException {
        this.getTuplizer(entityMode).setPropertyValue(object, propertyName, value);
    }
}

