/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.Loader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;

public class CustomLoader
extends Loader {
    private final Type[] resultTypes;
    private final Loadable[] persisters;
    private final CollectionPersister[] collectionPersisters;
    private final CustomQuery customQuery;
    private Type[] discoveredTypes;
    private String[] discoveredColumnAliases;
    private ResultSetMetaData metaData;

    public CustomLoader(CustomQuery customQuery, SessionFactoryImplementor factory) {
        super(factory);
        int i;
        int i2;
        this.customQuery = customQuery;
        String[] collectionRoles = customQuery.getCollectionRoles();
        if (collectionRoles == null) {
            this.collectionPersisters = null;
        } else {
            int length = collectionRoles.length;
            this.collectionPersisters = new CollectionPersister[length];
            for (i2 = 0; i2 < length; ++i2) {
                this.collectionPersisters[i2] = factory.getCollectionPersister(collectionRoles[i2]);
            }
        }
        String[] entityNames = customQuery.getEntityNames();
        this.persisters = new Loadable[entityNames.length];
        for (i2 = 0; i2 < entityNames.length; ++i2) {
            this.persisters[i2] = (Loadable)factory.getEntityPersister(entityNames[i2]);
        }
        Type[] scalarTypes = customQuery.getScalarTypes();
        this.resultTypes = new Type[entityNames.length + (scalarTypes == null ? 0 : scalarTypes.length)];
        for (i = 0; i < scalarTypes.length; ++i) {
            this.resultTypes[i] = scalarTypes[i];
        }
        for (i = 0; i < entityNames.length; ++i) {
            this.resultTypes[i + scalarTypes.length] = TypeFactory.manyToOne(entityNames[i]);
        }
    }

    protected String getSQLString() {
        return this.customQuery.getSQL();
    }

    protected Loadable[] getEntityPersisters() {
        return this.persisters;
    }

    protected LockMode[] getLockModes(Map lockModesMap) {
        return this.customQuery.getLockModes();
    }

    protected CollectionPersister[] getCollectionPersisters() {
        return this.collectionPersisters;
    }

    protected int[] getCollectionOwners() {
        return this.customQuery.getCollectionOwner();
    }

    protected int[] getOwners() {
        return this.customQuery.getEntityOwners();
    }

    public Set getQuerySpaces() {
        return this.customQuery.getQuerySpaces();
    }

    protected String getQueryIdentifier() {
        return this.customQuery.getSQL();
    }

    public List list(SessionImplementor session, QueryParameters queryParameters) throws HibernateException {
        return this.list(session, queryParameters, this.customQuery.getQuerySpaces(), this.resultTypes);
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        return this.scroll(queryParameters, this.resultTypes, null, session);
    }

    protected void autoDiscoverTypes(ResultSet rs) {
        try {
            this.metaData = rs.getMetaData();
            Type[] scalarTypes = this.customQuery.getScalarTypes();
            if (scalarTypes.length == 0) {
                int columnCount = this.metaData.getColumnCount();
                this.discoveredTypes = new Type[columnCount];
                this.discoveredColumnAliases = new String[columnCount];
                for (int i = 1; i <= columnCount; ++i) {
                    Type heuristicType;
                    this.discoveredTypes[i - 1] = heuristicType = this.getHibernateType(i);
                    this.discoveredColumnAliases[i - 1] = this.metaData.getColumnName(i);
                }
            } else {
                String[] scalarColumnAliases = this.customQuery.getScalarColumnAliases();
                this.discoveredTypes = new Type[scalarTypes.length];
                this.discoveredColumnAliases = new String[scalarTypes.length];
                for (int i = 0; i < scalarTypes.length; ++i) {
                    this.discoveredColumnAliases[i] = scalarColumnAliases[i];
                    if (scalarTypes[i] == null) {
                        Type heuristicType;
                        String alias = scalarColumnAliases[i];
                        int column = rs.findColumn(alias);
                        this.discoveredTypes[i] = heuristicType = this.getHibernateType(column);
                        continue;
                    }
                    this.discoveredTypes[i] = scalarTypes[i];
                }
            }
        }
        catch (SQLException e) {
            throw new HibernateException("Exception while trying to autodiscover types.", e);
        }
    }

    private Type getHibernateType(int columnPos) throws SQLException {
        int column = columnPos;
        int columnType = this.metaData.getColumnType(column);
        int scale = this.metaData.getScale(column);
        int precision = this.metaData.getPrecision(column);
        Type heuristicType = TypeFactory.heuristicType(this.getFactory().getDialect().getHibernateTypeName(columnType, precision, precision, scale));
        return heuristicType;
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        Object[] resultRow;
        String[] scalarColumnAliases;
        Type[] scalarTypes = this.discoveredTypes == null ? this.customQuery.getScalarTypes() : this.discoveredTypes;
        String[] stringArray = scalarColumnAliases = this.discoveredColumnAliases == null ? this.customQuery.getScalarColumnAliases() : this.discoveredColumnAliases;
        if (scalarTypes != null && scalarTypes.length > 0) {
            resultRow = new Object[scalarTypes.length + row.length];
            for (int i = 0; i < scalarTypes.length; ++i) {
                resultRow[i] = scalarTypes[i].nullSafeGet(rs, scalarColumnAliases[i], session, null);
            }
            System.arraycopy(row, 0, resultRow, scalarTypes.length, row.length);
        } else {
            resultRow = row;
        }
        return resultRow.length == 1 ? resultRow[0] : resultRow;
    }

    protected EntityAliases[] getEntityAliases() {
        return this.customQuery.getEntityAliases();
    }

    protected CollectionAliases[] getCollectionAliases() {
        return this.customQuery.getCollectionAliases();
    }

    public int[] getNamedParameterLocs(String name) throws QueryException {
        Object loc = this.customQuery.getNamedParameterBindPoints().get(name);
        if (loc == null) {
            QueryException qe = new QueryException("Named parameter does not appear in Query: " + name, this.customQuery.getSQL());
            throw qe;
        }
        if (loc instanceof Integer) {
            return new int[]{(Integer)loc};
        }
        return ArrayHelper.toIntArray((List)loc);
    }
}

