/*
 * Decompiled with CFR 0.152.
 */
package de.java2html;

import de.java2html.JavaSourceConversionSettings;
import de.java2html.commandline.IJava2HtmlConversion;
import de.java2html.commandline.IllegalCommandlineParametersException;
import de.java2html.commandline.Java2HtmlCommandline;
import de.java2html.converter.IJavaSourceConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.options.JavaSourceConversionOptions;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

public class Java2Html {
    private Java2Html() {
    }

    public static String convertToHtml(String javaSource) {
        return Java2Html.convertToHtml(javaSource, (JavaSourceConversionSettings)null);
    }

    public static String convertToHtml(String javaSource, JavaSourceConversionSettings settings) {
        if (javaSource == null) {
            return null;
        }
        if (settings == null) {
            settings = JavaSourceConversionSettings.getDefault();
        }
        StringReader stringReader = new StringReader(javaSource);
        JavaSource source = null;
        try {
            source = new JavaSourceParser(settings.getConversionOptions()).parse(stringReader);
        }
        catch (IOException e) {
            return null;
        }
        IJavaSourceConverter converter = settings.createConverter();
        StringWriter writer = new StringWriter();
        try {
            converter.convert(source, settings.getConversionOptions(), writer);
        }
        catch (IOException e) {
            return null;
        }
        return writer.toString();
    }

    public static String convertToHtmlPage(String javaSource) {
        return Java2Html.convertToHtmlPage(javaSource, (JavaSourceConversionSettings)null);
    }

    public static String convertToHtmlPage(String javaSource, JavaSourceConversionSettings settings) {
        if (settings == null) {
            settings = JavaSourceConversionSettings.getDefault();
        }
        IJavaSourceConverter converter = settings.createConverter();
        StringWriter writer = new StringWriter();
        try {
            converter.writeDocumentHeader(writer, settings.getConversionOptions(), "");
            writer.write(Java2Html.convertToHtml(javaSource, settings));
            converter.writeDocumentFooter(writer, settings.getConversionOptions());
        }
        catch (IOException e) {
            return null;
        }
        return writer.toString();
    }

    public static void main(String[] args) {
        IJava2HtmlConversion commandlineConversion = null;
        try {
            commandlineConversion = Java2HtmlCommandline.createCommandlineConversion(args);
        }
        catch (IllegalCommandlineParametersException exception) {
            System.err.println("Illegal commandline parameters: " + exception.getMessage());
            Java2HtmlCommandline.printUsage();
            System.exit(-1);
        }
        commandlineConversion.execute();
    }

    public static String convertToHtml(String text, JavaSourceConversionOptions options) {
        return Java2Html.convertToHtml(text, new JavaSourceConversionSettings(options));
    }

    public static String convertToHtmlPage(String text, JavaSourceConversionOptions options) {
        return Java2Html.convertToHtmlPage(text, new JavaSourceConversionSettings(options));
    }
}

