/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.injection.Injector;
import org.jboss.ejb3.injection.PojoInjector;

public class JndiMethodInjector
implements Injector,
PojoInjector {
    private Method setMethod;
    private String jndiName;
    private Context ctx;

    public JndiMethodInjector(Method setMethod, String jndiName, Context ctx) {
        this.setMethod = setMethod;
        this.jndiName = jndiName;
        this.ctx = ctx;
    }

    public void inject(BeanContext bctx) {
        this.inject(bctx, bctx.getInstance());
    }

    public void inject(BeanContext bctx, Object instance) {
        Object dependency = null;
        try {
            dependency = this.ctx.lookup(this.jndiName);
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to @Inject jndi dependency: " + this.jndiName + " into method " + this.setMethod, e);
        }
        Object[] args = new Object[]{dependency};
        try {
            this.setMethod.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            String type = "UNKNOWN";
            if (dependency != null) {
                type = dependency.getClass().getName();
            }
            throw new RuntimeException("Non matching type for @Inject of setter: " + this.setMethod + " for type: " + type, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

