/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.TransactionRequiredException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TxManager;
import org.jboss.tm.TxUtils;

public class ManagedEntityManagerFactory {
    private static final Logger log = Logger.getLogger(ManagedEntityManagerFactory.class);
    protected EntityManagerFactory entityManagerFactory;
    protected TransactionLocal session = new TransactionLocal((TransactionManager)TxManager.getInstance());
    protected String kernelName;
    public static ThreadLocal longLivedSession = new ThreadLocal();

    public ManagedEntityManagerFactory(EntityManagerFactory sf, String kernelName) {
        this.entityManagerFactory = sf;
        this.kernelName = kernelName;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public void destroy() {
        this.entityManagerFactory.close();
    }

    public TransactionLocal getTransactionSession() {
        return this.session;
    }

    public void registerExtendedWithTransaction(EntityManager pc) {
        pc.isOpen();
        this.session.set((Object)pc);
    }

    public EntityManager getSession() {
        Transaction tx = this.session.getTransaction();
        if (tx == null) {
            throw new TransactionRequiredException("EntityManager must be access within a transaction");
        }
        if (!TxUtils.isActive((Transaction)tx)) {
            throw new TransactionRequiredException("Transaction must be active to access EntityManager");
        }
        EntityManager rtnSession = (EntityManager)this.session.get();
        if (rtnSession == null) {
            rtnSession = this.createEntityManager(PersistenceContextType.TRANSACTION);
            try {
                tx.registerSynchronization((Synchronization)new SessionSynchronization(rtnSession, tx, true));
            }
            catch (RollbackException e) {
                throw new RuntimeException(e);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
            this.session.set((Object)rtnSession);
            rtnSession.isOpen();
        }
        return rtnSession;
    }

    public EntityManager createEntityManager(PersistenceContextType type) {
        return this.entityManagerFactory.createEntityManager(type);
    }

    private static class SessionSynchronization
    implements Synchronization {
        private EntityManager manager;
        private Transaction tx;
        private boolean closeAtTxCompletion;

        public SessionSynchronization(EntityManager session, Transaction tx, boolean close) {
            this.manager = session;
            this.tx = tx;
            this.closeAtTxCompletion = close;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (this.closeAtTxCompletion) {
                log.debug((Object)"************** closing entity managersession **************");
                this.manager.close();
            }
        }
    }
}

