/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.security.jacc.URLPattern;

class URLPatternSpec {
    URLPattern urlPattern;
    HashSet urlPatternList;

    URLPatternSpec(String spec) {
        if (spec == null) {
            this.urlPattern = new URLPattern("/");
        } else if (spec.indexOf(58) > 0) {
            StringTokenizer tokenizer = new StringTokenizer(spec, ":");
            this.urlPatternList = new HashSet();
            while (tokenizer.hasMoreTokens()) {
                String pattern = tokenizer.nextToken();
                URLPattern p = new URLPattern(pattern);
                if (this.urlPattern == null) {
                    this.urlPattern = p;
                    continue;
                }
                if (p.matches(this.urlPattern)) {
                    String msg = "1: URLPatternList item: " + pattern + " matches: " + this.urlPattern.getPattern();
                    throw new IllegalArgumentException(msg);
                }
                if (this.urlPattern.isPrefix()) {
                    if (!p.isPrefix() && !p.isExact()) {
                        String msg = "2: URLPatternList item: " + pattern + " is not an exact or prefix pattern";
                        throw new IllegalArgumentException(msg);
                    }
                } else if (this.urlPattern.isExtension()) {
                    if (!p.isPrefix() && !p.isExact()) {
                        String msg = "3: URLPatternList item: " + pattern + " is not an exact or prefix pattern";
                        throw new IllegalArgumentException(msg);
                    }
                } else if (this.urlPattern.isDefault()) {
                    if (p.isDefault()) {
                        String msg = "4: URLPatternList item: " + pattern + " cannot be the default pattern";
                        throw new IllegalArgumentException(msg);
                    }
                } else if (this.urlPattern.isExact()) {
                    String msg = "5: URLPatternList item: " + pattern + " is not allowed in an exact pattern";
                    throw new IllegalArgumentException(msg);
                }
                this.urlPatternList.add(p);
            }
        } else {
            this.urlPattern = new URLPattern(spec);
        }
    }

    boolean implies(URLPatternSpec spec) {
        boolean implies = this.urlPattern.matches(spec.urlPattern);
        if (implies) {
            URLPattern p;
            Iterator iter;
            if (this.urlPatternList != null) {
                iter = this.urlPatternList.iterator();
                while (iter.hasNext()) {
                    p = (URLPattern)iter.next();
                    if (!p.matches(spec.urlPattern)) continue;
                    return false;
                }
            }
            if (this.urlPatternList != null && spec.urlPatternList != null) {
                iter = this.urlPatternList.iterator();
                while (iter.hasNext()) {
                    p = (URLPattern)iter.next();
                    boolean hasMatch = false;
                    Iterator iter2 = spec.urlPatternList.iterator();
                    while (iter2.hasNext()) {
                        URLPattern p2 = (URLPattern)iter2.next();
                        if (!p.matches(p2)) continue;
                        hasMatch = true;
                        break;
                    }
                    if (hasMatch) continue;
                    return false;
                }
            }
        }
        return implies;
    }

    int hash() {
        int hashCode = this.urlPattern.hashCode();
        if (this.urlPatternList != null) {
            hashCode += this.urlPatternList.hashCode();
        }
        return hashCode;
    }

    boolean equals(URLPatternSpec spec) {
        return this.urlPattern.equals(spec.urlPattern) && (this.urlPatternList == null || this.urlPatternList.equals(spec.urlPatternList));
    }
}

