/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.jdbc3;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.jms.JMSException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.pm.CacheStore;
import org.jboss.mq.pm.NewPersistenceManager;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.pm.jdbc3.PersistenceManagerMBean;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSTopic;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.MessageReference;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TransactionManagerService;

public class PersistenceManager
extends ServiceMBeanSupport
implements PersistenceManagerMBean,
NewPersistenceManager,
CacheStore,
Runnable {
    static final int OBJECT_BLOB = 0;
    static final int BYTES_BLOB = 1;
    static final int BINARYSTREAM_BLOB = 2;
    static final int BLOB_BLOB = 3;
    private SynchronizedLong nextTransactionId = new SynchronizedLong(0L);
    private TxManager txManager;
    private DataSource datasource;
    private TransactionManager tm;
    private ObjectName connectionManagerName;
    private Properties sqlProperties = new Properties();
    String UPDATE_MARKED_MESSAGES = "UPDATE JMS_MESSAGE_LOG SET TXID=?, TXOP=? WHERE TXOP=?";
    String UPDATE_MARKED_REFERENCES = "UPDATE JMS_REFERENCE_LOG SET TXID=?, TXOP=? WHERE TXOP=?";
    String UPDATE_MARKED_MESSAGES_WITH_TX = "UPDATE JMS_MESSAGE_LOG SET TXID=?, TXOP=? WHERE TXOP=? AND TXID=?";
    String UPDATE_MARKED_REFERENCES_WITH_TX = "UPDATE JMS_REFERENCE_LOG SET TXID=?, TXOP=? WHERE TXOP=? AND TXID=?";
    String DELETE_MARKED_MESSAGES_WITH_TX = "DELETE FROM JMS_MESSAGE_LOG WHERE TXID IN (SELECT TXID FROM JMS_TRANSACTION_LOG) AND TXOP=?";
    String DELETE_MARKED_REFERENCES_WITH_TX = "DELETE FROM JMS_REFERENCE_LOG WHERE TXID IN (SELECT TXID FROM JMS_TRANSACTION_LOG) AND TXOP=?";
    String DELETE_TX = "DELETE FROM JMS_TRANSACTION_LOG WHERE TXID = ?";
    String DELETE_MARKED_MESSAGES = "DELETE FROM JMS_MESSAGE_LOG WHERE TXID=? AND TXOP=?";
    String DELETE_MARKED_REFERENCES = "DELETE FROM JMS_REFERENCE_LOG WHERE TXID=? AND TXOP=?";
    String DELETE_TEMPORARY_MESSAGES = "DELETE FROM JMS_MESSAGE_LOG WHERE TXOP='T'";
    String DELETE_TEMPORARY_REFERENCES = "DELETE FROM JMS_REFERENCE_LOG WHERE TXOP='T'";
    String INSERT_TX = "INSERT INTO JMS_TRANSACTION_LOG (TXID) values(?)";
    String SELECT_MAX_TX = "SELECT MAX(TXID) FROM JMS_TRANSACTION_LOG";
    String SELECT_MESSAGES_IN_DEST = "SELECT MESSAGEID, MESSAGEBLOB FROM JMS_MESSAGE_LOG WHERE DESTINATION=?";
    String SELECT_REFERENCES_IN_DEST = "SELECT R.MESSAGEID, M.MESSAGEBLOB, R.REDELIVERED, R.REDELIVERS FROM JMS_REFERENCE_LOG AS R, JMS_MESSAGE_LOG AS M WHERE R.MESSAGEID = M.MESSAGEID AND R.DESTINATION=?";
    String SELECT_MESSAGE = "SELECT MESSAGEID, MESSAGEBLOB FROM JMS_MESSAGE_LOG WHERE MESSAGEID=? AND DESTINATION=?";
    String INSERT_MESSAGE = "INSERT INTO JMS_MESSAGE_LOG (MESSAGEID, DESTINATION, MESSAGEBLOB, TXID, TXOP, LATECLONE) VALUES(?,?,?,?,?,?)";
    String INSERT_REFERENCE = "INSERT INTO JMS_REFERENCE_LOG (MESSAGEID, DESTINATION, TXID, TXOP, REDELIVERED, REDELIVERS) VALUES(?,?,?,?,?,?)";
    String MARK_MESSAGE = "UPDATE JMS_MESSAGE_LOG SET TXID=?, TXOP=? WHERE MESSAGEID=? AND DESTINATION=?";
    String MARK_REFERENCE = "UPDATE JMS_REFERENCE_LOG SET TXID=?, TXOP=? WHERE MESSAGEID=? AND DESTINATION=?";
    String DELETE_MESSAGE = "DELETE FROM JMS_MESSAGE_LOG WHERE MESSAGEID=? AND DESTINATION=?";
    String DELETE_REFERENCE = "DELETE FROM JMS_REFERENCE_LOG WHERE MESSAGEID=? AND DESTINATION=?";
    String UPDATE_MESSAGE = "UPDATE JMS_MESSAGE_LOG SET MESSAGEBLOB=? WHERE MESSAGEID=? AND DESTINATION=?";
    String UPDATE_REFERENCE = "UPDATE JMS_REFERENCE_LOG SET REDELIVERED=?, REDELIVERS=? WHERE MESSAGEID=? AND DESTINATION=?";
    String DELETE_ORPHANED_MESSAGES = "DELETE FROM JMS_MESSAGE_LOG WHERE LATECLONE = '1' AND MESSAGEID NOT IN (SELECT MESSAGEID FROM JMS_REFERENCE_LOG)";
    String DELETE_ALL_TXS = "DELETE FROM JMS_TRANSACTION_LOG";
    String CREATE_REFERENCE_TABLE = "CREATE TABLE JMS_REFERENCE_LOG ( MESSAGEID INTEGER NOT NULL, DESTINATION VARCHAR(256) NOT NULL, TXID INTEGER, TXOP CHAR(1), REDELIVERED CHAR(1), REDELIVERS INTEGER, PRIMARY KEY (MESSAGEID, DESTINATION) )";
    String CREATE_MESSAGE_TABLE = "CREATE TABLE JMS_MESSAGE_LOG ( MESSAGEID INTEGER NOT NULL, DESTINATION VARCHAR(256), TXID INTEGER, TXOP CHAR(1), LATECLONE CHAR(1), MESSAGEBLOB OBJECT, PRIMARY KEY (MESSAGEID, DESTINATION) )";
    String CREATE_TX_TABLE = "CREATE TABLE JMS_TRANSACTION_LOG ( TXID INTEGER )";
    int blobType = 0;
    boolean createTables = true;
    private int connectionRetryAttempts = 5;
    private long gcPeriod = 60000L;
    private Thread gcThread;

    public PersistenceManager() throws JMSException {
        this.txManager = new TxManager(this);
    }

    public ObjectName getConnectionManager() {
        return this.connectionManagerName;
    }

    public void setConnectionManager(ObjectName connectionManagerName) {
        this.connectionManagerName = connectionManagerName;
    }

    public int getGCPeriodSecs() {
        return (int)this.gcPeriod / 1000;
    }

    public void setGCPeriodSecs(int gcPeriodSecs) {
        this.gcPeriod = gcPeriodSecs * 1000;
    }

    public int getConnectionRetryAttempts() {
        return this.connectionRetryAttempts;
    }

    public void setConnectionRetryAttempts(int value) {
        this.connectionRetryAttempts = value;
    }

    public String getSqlProperties() {
        try {
            ByteArrayOutputStream boa = new ByteArrayOutputStream();
            this.sqlProperties.store(boa, "");
            return new String(boa.toByteArray());
        }
        catch (IOException shouldnothappen) {
            return "";
        }
    }

    public void setSqlProperties(String value) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes());
            this.sqlProperties = new Properties();
            this.sqlProperties.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     */
    public Tx createPersistentTx() throws JMSException {
        Tx id;
        block14: {
            id = new Tx(this.nextTransactionId.increment());
            TransactionManagerStrategy tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            Statement stmt = null;
            boolean threadWasInterrupted = Thread.interrupted();
            c = this.getConnection();
            stmt = c.prepareStatement(this.INSERT_TX);
            stmt.setLong(1, id.longValue());
            stmt.executeUpdate();
            Object var8_6 = null;
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                c.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block14;
            {
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not crate tx: " + id, e);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    stmt.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
        return id;
    }

    /*
     * Loose catch block
     */
    public void commitPersistentTx(Tx txId) throws JMSException {
        block10: {
            TransactionManagerStrategy tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            boolean threadWasInterrupted = Thread.interrupted();
            c = this.getConnection();
            this.removeMarkedMessages(c, txId, "D");
            this.removeMarkedReferences(c, txId, "D");
            this.removeTXRecord(c, txId.longValue());
            Object var7_5 = null;
            try {
                c.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block10;
            {
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not commit tx: " + txId, e);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void rollbackPersistentTx(Tx txId) throws JMSException {
        block14: {
            TransactionManagerStrategy tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            Statement stmt = null;
            boolean threadWasInterrupted = Thread.interrupted();
            c = this.getConnection();
            this.removeMarkedMessages(c, txId, "A");
            this.removeMarkedReferences(c, txId, "A");
            this.removeTXRecord(c, txId.longValue());
            stmt = c.prepareStatement(this.UPDATE_MARKED_MESSAGES_WITH_TX);
            stmt.setNull(1, -5);
            stmt.setString(2, "A");
            stmt.setString(3, "D");
            stmt.setLong(4, txId.longValue());
            stmt.executeUpdate();
            stmt.close();
            stmt = c.prepareStatement(this.UPDATE_MARKED_REFERENCES_WITH_TX);
            stmt.setNull(1, -5);
            stmt.setString(2, "A");
            stmt.setString(3, "D");
            stmt.setLong(4, txId.longValue());
            stmt.executeUpdate();
            stmt.close();
            Object var8_6 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block14;
            {
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not rollback tx: " + txId, e);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void add(MessageReference messageRef, Tx txId) throws JMSException {
        block19: {
            boolean trace = this.log.isTraceEnabled();
            if (trace) {
                this.log.trace((Object)("About to add message " + messageRef + " transaction=" + txId));
            }
            TransactionManagerStrategy tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            boolean threadWasInterrupted = Thread.interrupted();
            c = this.getConnection();
            MessageReference messageReference = messageRef;
            synchronized (messageReference) {
                if (trace) {
                    this.log.trace((Object)("Inserting message " + messageRef + " transaction=" + txId));
                }
                if (messageRef.isLateClone()) {
                    this.addReference(c, messageRef.getPersistentKey(), messageRef, txId, "A");
                } else {
                    SpyMessage message = messageRef.getMessage();
                    this.addMessage(c, messageRef.getPersistentKey(), message, txId, "A", "0");
                }
                messageRef.setStored(2);
                if (trace) {
                    this.log.trace((Object)("Added message " + messageRef + " transaction=" + txId));
                }
            }
            Object var11_12 = null;
            try {
                c.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block19;
            {
                catch (IOException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not store message: " + messageRef, e);
                }
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not store message: " + messageRef, e);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void update(MessageReference messageRef, Tx txId) throws JMSException {
        block24: {
            boolean threadWasInterrupted;
            Statement stmt;
            Connection c;
            TransactionManagerStrategy tms;
            block21: {
                boolean trace = this.log.isTraceEnabled();
                if (trace) {
                    this.log.trace((Object)("Updating message " + messageRef + " transaction=" + txId));
                }
                tms = new TransactionManagerStrategy();
                tms.startTX();
                c = null;
                stmt = null;
                threadWasInterrupted = Thread.interrupted();
                c = this.getConnection();
                if (txId == null) {
                    if (messageRef.isLateClone()) {
                        stmt = c.prepareStatement(this.UPDATE_REFERENCE);
                        if (messageRef.redelivered) {
                            stmt.setString(1, "1");
                        } else {
                            stmt.setString(1, "0");
                        }
                        stmt.setLong(2, messageRef.redeliveryCount);
                        stmt.setLong(3, messageRef.messageId);
                        stmt.setString(4, messageRef.getPersistentKey());
                    } else {
                        stmt = c.prepareStatement(this.UPDATE_MESSAGE);
                        this.setBlob((PreparedStatement)stmt, 1, messageRef.getMessage());
                        stmt.setLong(2, messageRef.messageId);
                        stmt.setString(3, messageRef.getPersistentKey());
                    }
                    int rc = stmt.executeUpdate();
                    if (rc != 1) {
                        throw new SpyJMSException("Could not update the message in the database: update affected " + rc + " rows");
                    }
                } else {
                    throw new SpyJMSException("NYI: Updating a message in a transaction is not currently used");
                }
                if (!trace) break block21;
                this.log.trace((Object)("Updated message " + messageRef + " transaction=" + txId));
            }
            Object var10_11 = null;
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                c.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block24;
            {
                catch (IOException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not update message: " + messageRef, e);
                }
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not update message: " + messageRef, e);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    stmt.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void remove(MessageReference messageRef, Tx txId) throws JMSException {
        block25: {
            boolean trace = this.log.isTraceEnabled();
            if (trace) {
                this.log.trace((Object)("Removing message " + messageRef + " transaction=" + txId));
            }
            TransactionManagerStrategy tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            Statement stmt = null;
            boolean threadWasInterrupted = Thread.interrupted();
            c = this.getConnection();
            MessageReference messageReference = messageRef;
            synchronized (messageReference) {
                if (txId == null) {
                    stmt = messageRef.isLateClone() ? c.prepareStatement(this.DELETE_REFERENCE) : c.prepareStatement(this.DELETE_MESSAGE);
                    stmt.setLong(1, messageRef.messageId);
                    stmt.setString(2, messageRef.getPersistentKey());
                    int rc = stmt.executeUpdate();
                    if (rc != 1) {
                        throw new SpyJMSException("Could not delete the message from the database: delete affected " + rc + " rows");
                    }
                    messageRef.setStored(1);
                    messageRef.removeDelayed();
                } else {
                    if (messageRef.isLateClone()) {
                        stmt = c.prepareStatement(this.MARK_REFERENCE);
                        stmt.setLong(1, txId.longValue());
                        stmt.setString(2, "D");
                        stmt.setLong(3, messageRef.messageId);
                        stmt.setString(4, messageRef.getPersistentKey());
                    } else {
                        stmt = c.prepareStatement(this.MARK_MESSAGE);
                        stmt.setLong(1, txId.longValue());
                        stmt.setString(2, "D");
                        stmt.setLong(3, messageRef.messageId);
                        stmt.setString(4, messageRef.getPersistentKey());
                    }
                    int rc = stmt.executeUpdate();
                    if (rc != 1) {
                        throw new SpyJMSException("Could not mark the message as deleted in the database: update affected " + rc + " rows");
                    }
                }
                if (trace) {
                    this.log.trace((Object)("Removed message " + messageRef + " transaction=" + txId));
                }
            }
            Object var12_13 = null;
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                c.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block25;
            {
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not remove message: " + messageRef, e);
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    stmt.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void restoreQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
        block27: {
            if (jmsDest == null) {
                throw new IllegalArgumentException("Must supply non null JMSDestination to restoreQueue");
            }
            if (dest == null) {
                throw new IllegalArgumentException("Must supply non null SpyDestination to restoreQueue");
            }
            TransactionManagerStrategy tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            Statement stmt = null;
            ResultSet rs = null;
            boolean threadWasInterrupted = Thread.interrupted();
            c = this.getConnection();
            int counter = 0;
            if (jmsDest.parameters.lateClone) {
                JMSTopic topic = (JMSTopic)jmsDest;
                DurableSubscriptionID id = ((SpyTopic)dest).getDurableSubscriptionID();
                stmt = c.prepareStatement(this.SELECT_REFERENCES_IN_DEST);
                stmt.setString(1, dest.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    SpyMessage message = this.extractMessage(rs, 2);
                    boolean redelivered = false;
                    if (rs.getString(3).equals("1")) {
                        redelivered = true;
                    }
                    message.header.jmsRedelivered = redelivered;
                    message.header.jmsProperties.put("JMS_JBOSS_REDELIVERY_COUNT", new Integer(rs.getInt(4)));
                    topic.restoreMessage(message, id);
                    ++counter;
                }
            } else {
                stmt = c.prepareStatement(this.SELECT_MESSAGES_IN_DEST);
                stmt.setString(1, dest.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    SpyMessage message = this.extractMessage(rs, 2);
                    if (dest instanceof SpyTopic) {
                        message.header.durableSubscriberID = ((SpyTopic)dest).getDurableSubscriptionID();
                    }
                    jmsDest.restoreMessage(message);
                    ++counter;
                }
            }
            this.log.debug((Object)("Restored " + counter + " message(s) to: " + dest));
            Object var14_16 = null;
            try {
                rs.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                c.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block27;
            {
                catch (IOException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not restore messages to destination : " + dest.toString(), e);
                }
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not restore messages to destination : " + dest.toString(), e);
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                try {
                    rs.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    stmt.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    public TxManager getTxManager() {
        return this.txManager;
    }

    public void closeQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
    }

    public MessageCache getMessageCacheInstance() {
        throw new UnsupportedOperationException("This is now set on the destination manager");
    }

    /*
     * Loose catch block
     */
    public void addMessage(SpyMessage message) throws JMSException {
        block13: {
            TransactionManagerStrategy tms = new TransactionManagerStrategy();
            tms.startTX();
            Connection c = null;
            boolean threadWasInterrupted = Thread.interrupted();
            c = this.datasource.getConnection();
            this.addMessage(c, "*", message, null, null, "1");
            Object var7_5 = null;
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block13;
            {
                catch (IOException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not add message:", e);
                }
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not add message:", e);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    public Object getInstance() {
        return this;
    }

    public ObjectName getMessageCache() {
        throw new UnsupportedOperationException("This is now set on the destination manager");
    }

    public void setMessageCache(ObjectName messageCache) {
        throw new UnsupportedOperationException("This is now set on the destination manager");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SpyMessage loadFromStorage(MessageReference messageRef) throws JMSException {
        block32: {
            block31: {
                block30: {
                    block23: {
                        block29: {
                            block28: {
                                block27: {
                                    block22: {
                                        if (this.log.isTraceEnabled()) {
                                            this.log.trace((Object)("Loading message from storage " + messageRef));
                                        }
                                        tms = new TransactionManagerStrategy();
                                        tms.startTX();
                                        c = null;
                                        stmt = null;
                                        rs = null;
                                        threadWasInterrupted = Thread.interrupted();
                                        try {
                                            try {
                                                c = this.getConnection();
                                                stmt = c.prepareStatement(this.SELECT_MESSAGE);
                                                stmt.setLong(1, messageRef.messageId);
                                                if (messageRef.isLateClone()) {
                                                    stmt.setString(2, "*");
                                                } else {
                                                    stmt.setString(2, messageRef.getPersistentKey());
                                                }
                                                rs = stmt.executeQuery();
                                                if (rs.next()) {
                                                    var7_7 = this.extractMessage(rs, 2);
                                                    var9_11 = null;
                                                    break block22;
                                                }
                                                var7_8 = null;
                                                break block23;
                                            }
                                            catch (IOException e) {
                                                tms.setRollbackOnly();
                                                throw new SpyJMSException("Could not load message : " + messageRef, e);
                                            }
                                            catch (SQLException e) {
                                                tms.setRollbackOnly();
                                                throw new SpyJMSException("Could not load message : " + messageRef, e);
                                            }
                                        }
                                        catch (Throwable var8_17) {
                                            var9_13 = null;
                                            try {
                                                rs.close();
                                            }
                                            catch (Throwable ignore) {
                                                // empty catch block
                                            }
                                            try {
                                                stmt.close();
                                            }
                                            catch (Throwable ignore) {
                                                // empty catch block
                                            }
                                            try {
                                                c.close();
                                            }
                                            catch (Throwable ignore) {
                                                // empty catch block
                                            }
                                            tms.endTX();
                                            if (threadWasInterrupted == false) throw var8_17;
                                            Thread.currentThread().interrupt();
                                            throw var8_17;
                                        }
                                    }
                                    ** try [egrp 2[TRYBLOCK] [7 : 246->256)] { 
lbl60:
                                    // 1 sources

                                    rs.close();
                                    break block27;
lbl62:
                                    // 1 sources

                                    catch (Throwable ignore) {
                                        // empty catch block
                                    }
                                }
                                ** try [egrp 3[TRYBLOCK] [8 : 258->268)] { 
lbl66:
                                // 1 sources

                                stmt.close();
                                break block28;
lbl68:
                                // 1 sources

                                catch (Throwable ignore) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 4[TRYBLOCK] [9 : 270->279)] { 
lbl72:
                            // 1 sources

                            c.close();
                            break block29;
lbl74:
                            // 1 sources

                            catch (Throwable ignore) {
                                // empty catch block
                            }
                        }
                        tms.endTX();
                        if (threadWasInterrupted == false) return var7_7;
                        Thread.currentThread().interrupt();
                        return var7_7;
                    }
                    var9_12 = null;
                    ** try [egrp 2[TRYBLOCK] [7 : 246->256)] { 
lbl84:
                    // 1 sources

                    rs.close();
                    break block30;
lbl86:
                    // 1 sources

                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                ** try [egrp 3[TRYBLOCK] [8 : 258->268)] { 
lbl90:
                // 1 sources

                stmt.close();
                break block31;
lbl92:
                // 1 sources

                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            ** try [egrp 4[TRYBLOCK] [9 : 270->279)] { 
lbl96:
            // 1 sources

            c.close();
            break block32;
lbl98:
            // 1 sources

            catch (Throwable ignore) {
                // empty catch block
            }
        }
        tms.endTX();
        if (threadWasInterrupted == false) return var7_8;
        Thread.currentThread().interrupt();
        return var7_8;
    }

    /*
     * Loose catch block
     */
    public void removeFromStorage(MessageReference messageRef) throws JMSException {
        block19: {
            boolean threadWasInterrupted;
            Statement stmt;
            Connection c;
            TransactionManagerStrategy tms;
            block16: {
                if (messageRef.isPersistent()) {
                    return;
                }
                boolean trace = this.log.isTraceEnabled();
                if (trace) {
                    this.log.trace((Object)("Removing message from storage " + messageRef));
                }
                tms = new TransactionManagerStrategy();
                tms.startTX();
                c = null;
                stmt = null;
                threadWasInterrupted = Thread.interrupted();
                c = this.getConnection();
                if (messageRef.isLateClone()) {
                    stmt = c.prepareStatement(this.DELETE_REFERENCE);
                    stmt.setLong(1, messageRef.messageId);
                    stmt.setString(2, messageRef.getPersistentKey());
                    stmt.executeUpdate();
                    messageRef.setStored(1);
                } else {
                    stmt = c.prepareStatement(this.DELETE_MESSAGE);
                    stmt.setLong(1, messageRef.messageId);
                    stmt.setString(2, messageRef.getPersistentKey());
                    stmt.executeUpdate();
                    messageRef.setStored(1);
                }
                if (!trace) break block16;
                this.log.trace((Object)("Removed message from storage " + messageRef));
            }
            Object var9_7 = null;
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                c.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block19;
            {
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not remove message: " + messageRef, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                try {
                    stmt.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void saveToStorage(MessageReference messageRef, SpyMessage message) throws JMSException {
        block18: {
            boolean threadWasInterrupted;
            Connection c;
            TransactionManagerStrategy tms;
            block16: {
                if (messageRef.isPersistent()) {
                    return;
                }
                boolean trace = this.log.isTraceEnabled();
                if (trace) {
                    this.log.trace((Object)("Saving message to storage " + messageRef));
                }
                tms = new TransactionManagerStrategy();
                tms.startTX();
                c = null;
                threadWasInterrupted = Thread.interrupted();
                c = this.getConnection();
                if (messageRef.isLateClone()) {
                    this.addReference(c, messageRef.getPersistentKey(), messageRef, null, "T");
                    try {
                        this.addMessage(c, "*", message, null, "T", "1");
                    }
                    catch (SQLException e) {
                        this.log.trace((Object)"TODO: Check this is really a duplicate", (Throwable)e);
                    }
                } else {
                    this.addMessage(c, messageRef.getPersistentKey(), message, null, "T", "0");
                }
                messageRef.setStored(2);
                if (!trace) break block16;
                this.log.trace((Object)("Saved message to storage " + messageRef));
            }
            Object var9_10 = null;
            try {
                c.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block18;
            {
                catch (IOException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not store message: " + messageRef, e);
                }
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not store message: " + messageRef, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread current = Thread.currentThread();
        while (this.gcThread == current) {
            try {
                SQLException ignored3;
                Object var8_8;
                Thread.sleep(this.gcPeriod);
                if (this.gcThread != current) {
                    return;
                }
                Connection connection = this.datasource.getConnection();
                try {
                    SQLException ignored22;
                    Object var5_6;
                    PreparedStatement stmt = connection.prepareStatement(this.DELETE_ORPHANED_MESSAGES);
                    try {
                        stmt.executeUpdate();
                        var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        var5_6 = null;
                        try {
                            stmt.close();
                        }
                        catch (SQLException ignored22) {
                            this.log.trace((Object)"Error closing statement", (Throwable)ignored22);
                        }
                        throw throwable;
                    }
                    try {
                        stmt.close();
                    }
                    catch (SQLException ignored22) {
                        this.log.trace((Object)"Error closing statement", (Throwable)ignored22);
                    }
                    var8_8 = null;
                }
                catch (Throwable throwable) {
                    var8_8 = null;
                    try {
                        connection.close();
                    }
                    catch (SQLException ignored3) {
                        this.log.trace((Object)"Error closing connection", (Throwable)ignored3);
                    }
                    throw throwable;
                }
                try {
                    connection.close();
                }
                catch (SQLException ignored3) {
                    this.log.trace((Object)"Error closing connection", (Throwable)ignored3);
                }
            }
            catch (InterruptedException ignored) {
            }
            catch (Throwable t) {
                this.log.warn((Object)"Unhandled throwable in gc thread:", t);
            }
        }
    }

    protected void startService() throws Exception {
        this.UPDATE_MARKED_MESSAGES = this.sqlProperties.getProperty("UPDATE_MARKED_MESSAGES", this.UPDATE_MARKED_MESSAGES);
        this.UPDATE_MARKED_REFERENCES = this.sqlProperties.getProperty("UPDATE_MARKED_REFERENCES", this.UPDATE_MARKED_REFERENCES);
        this.UPDATE_MARKED_MESSAGES_WITH_TX = this.sqlProperties.getProperty("UPDATE_MARKED_MESSAGES_WITH_TX", this.UPDATE_MARKED_MESSAGES_WITH_TX);
        this.UPDATE_MARKED_REFERENCES_WITH_TX = this.sqlProperties.getProperty("UPDATE_MARKED_REFERENCES_WITH_TX", this.UPDATE_MARKED_REFERENCES_WITH_TX);
        this.DELETE_MARKED_MESSAGES_WITH_TX = this.sqlProperties.getProperty("DELETE_MARKED_MESSAGES_WITH_TX", this.DELETE_MARKED_MESSAGES_WITH_TX);
        this.DELETE_MARKED_REFERENCES_WITH_TX = this.sqlProperties.getProperty("DELETE_MARKED_REFERENCES_WITH_TX", this.DELETE_MARKED_REFERENCES_WITH_TX);
        this.DELETE_TX = this.sqlProperties.getProperty("DELETE_TX", this.DELETE_TX);
        this.DELETE_MARKED_MESSAGES = this.sqlProperties.getProperty("DELETE_MARKED_MESSAGES", this.DELETE_MARKED_MESSAGES);
        this.DELETE_MARKED_REFERENCES = this.sqlProperties.getProperty("DELETE_MARKED_REFERENCES", this.DELETE_MARKED_REFERENCES);
        this.DELETE_TEMPORARY_MESSAGES = this.sqlProperties.getProperty("DELETE_TEMPORARY_MESSAGES", this.DELETE_TEMPORARY_MESSAGES);
        this.DELETE_TEMPORARY_REFERENCES = this.sqlProperties.getProperty("DELETE_TEMPORARY_REFERENCES", this.DELETE_TEMPORARY_REFERENCES);
        this.INSERT_TX = this.sqlProperties.getProperty("INSERT_TX", this.INSERT_TX);
        this.SELECT_MAX_TX = this.sqlProperties.getProperty("SELECT_MAX_TX", this.SELECT_MAX_TX);
        this.SELECT_MESSAGES_IN_DEST = this.sqlProperties.getProperty("SELECT_MESSAGES_IN_DEST", this.SELECT_MESSAGES_IN_DEST);
        this.SELECT_REFERENCES_IN_DEST = this.sqlProperties.getProperty("SELECT_REFERENCES_IN_DEST", this.SELECT_REFERENCES_IN_DEST);
        this.SELECT_MESSAGE = this.sqlProperties.getProperty("SELECT_MESSAGE", this.SELECT_MESSAGE);
        this.INSERT_MESSAGE = this.sqlProperties.getProperty("INSERT_MESSAGE", this.INSERT_MESSAGE);
        this.INSERT_REFERENCE = this.sqlProperties.getProperty("INSERT_REFERENCE", this.INSERT_REFERENCE);
        this.MARK_MESSAGE = this.sqlProperties.getProperty("MARK_MESSAGE", this.MARK_MESSAGE);
        this.MARK_REFERENCE = this.sqlProperties.getProperty("MARK_REFERENCE", this.MARK_REFERENCE);
        this.DELETE_MESSAGE = this.sqlProperties.getProperty("DELETE_MESSAGE", this.DELETE_MESSAGE);
        this.DELETE_REFERENCE = this.sqlProperties.getProperty("DELETE_REFERENCE", this.DELETE_REFERENCE);
        this.UPDATE_MESSAGE = this.sqlProperties.getProperty("UPDATE_MESSAGE", this.UPDATE_MESSAGE);
        this.UPDATE_REFERENCE = this.sqlProperties.getProperty("UPDATE_REFERENCE", this.UPDATE_REFERENCE);
        this.DELETE_ORPHANED_MESSAGES = this.sqlProperties.getProperty("DELETE_ORPHANED_MESSAGES", this.DELETE_ORPHANED_MESSAGES);
        this.DELETE_ALL_TXS = this.sqlProperties.getProperty("DELETE_ALL_TXS", this.DELETE_ALL_TXS);
        this.CREATE_REFERENCE_TABLE = this.sqlProperties.getProperty("CREATE_REFERENCE_TABLE", this.CREATE_REFERENCE_TABLE);
        this.CREATE_MESSAGE_TABLE = this.sqlProperties.getProperty("CREATE_MESSAGE_TABLE", this.CREATE_MESSAGE_TABLE);
        this.CREATE_TX_TABLE = this.sqlProperties.getProperty("CREATE_TX_TABLE", this.CREATE_TX_TABLE);
        this.createTables = this.sqlProperties.getProperty("CREATE_TABLES_ON_STARTUP", "true").equalsIgnoreCase("true");
        String s = this.sqlProperties.getProperty("BLOB_TYPE", "OBJECT_BLOB");
        if (s.equals("OBJECT_BLOB")) {
            this.blobType = 0;
        } else if (s.equals("BYTES_BLOB")) {
            this.blobType = 1;
        } else if (s.equals("BINARYSTREAM_BLOB")) {
            this.blobType = 2;
        } else if (s.equals("BLOB_BLOB")) {
            this.blobType = 3;
        }
        String dsName = (String)this.getServer().getAttribute(this.connectionManagerName, "BindName");
        InitialContext ctx = new InitialContext();
        this.datasource = (DataSource)ctx.lookup(dsName);
        this.tm = (TransactionManager)ctx.lookup(TransactionManagerService.JNDI_NAME);
        this.log.debug((Object)"Resolving uncommited TXS");
        this.resolveAllUncommitedTXs();
        this.gcThread = new Thread((Runnable)this, "JBossMQ persistent message garbage collection");
        this.gcThread.setDaemon(true);
        this.gcThread.start();
    }

    protected void stopService() throws Exception {
        if (this.gcThread != null) {
            this.gcThread.interrupt();
        }
        this.gcThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected synchronized void resolveAllUncommitedTXs() throws JMSException {
        block79: {
            boolean threadWasInterrupted;
            ResultSet rs;
            Statement stmt;
            Connection c;
            TransactionManagerStrategy tms;
            block78: {
                block71: {
                    tms = new TransactionManagerStrategy();
                    tms.startTX();
                    c = null;
                    stmt = null;
                    rs = null;
                    threadWasInterrupted = Thread.interrupted();
                    if (this.createTables) {
                        block68: {
                            block65: {
                                c = this.getConnection();
                                stmt = c.prepareStatement(this.CREATE_REFERENCE_TABLE);
                                stmt.executeUpdate();
                                Object var8_6 = null;
                                try {
                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                }
                                catch (Throwable ignored) {
                                    this.log.trace((Object)("Ignored: " + ignored));
                                }
                                stmt = null;
                                {
                                    break block65;
                                    catch (SQLException e) {
                                        this.log.debug((Object)("Could not create table with SQL: " + this.CREATE_REFERENCE_TABLE + ", got : " + e));
                                        Object var8_7 = null;
                                        try {
                                            if (stmt != null) {
                                                stmt.close();
                                            }
                                        }
                                        catch (Throwable ignored) {
                                            this.log.trace((Object)("Ignored: " + ignored));
                                        }
                                        stmt = null;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var8_8 = null;
                                    try {
                                        if (stmt != null) {
                                            stmt.close();
                                        }
                                    }
                                    catch (Throwable ignored) {
                                        this.log.trace((Object)("Ignored: " + ignored));
                                    }
                                    stmt = null;
                                    throw throwable;
                                }
                            }
                            stmt = c.prepareStatement(this.CREATE_MESSAGE_TABLE);
                            stmt.executeUpdate();
                            Object var11_19 = null;
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                            catch (Throwable ignored) {
                                this.log.trace((Object)("Ignored: " + ignored));
                            }
                            stmt = null;
                            {
                                break block68;
                                catch (SQLException e) {
                                    this.log.debug((Object)("Could not create table with SQL: " + this.CREATE_MESSAGE_TABLE + ", got : " + e));
                                    Object var11_20 = null;
                                    try {
                                        if (stmt != null) {
                                            stmt.close();
                                        }
                                    }
                                    catch (Throwable ignored) {
                                        this.log.trace((Object)("Ignored: " + ignored));
                                    }
                                    stmt = null;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var11_21 = null;
                                try {
                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                }
                                catch (Throwable ignored) {
                                    this.log.trace((Object)("Ignored: " + ignored));
                                }
                                stmt = null;
                                throw throwable;
                            }
                        }
                        stmt = c.prepareStatement(this.CREATE_TX_TABLE);
                        stmt.executeUpdate();
                        Object var14_26 = null;
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (Throwable ignored) {
                            this.log.trace((Object)("Ignored: " + ignored));
                        }
                        stmt = null;
                        {
                            break block71;
                            catch (SQLException e) {
                                this.log.debug((Object)("Could not create table with SQL: " + this.CREATE_TX_TABLE + ", got : " + e));
                                Object var14_27 = null;
                                try {
                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                }
                                catch (Throwable ignored) {
                                    this.log.trace((Object)("Ignored: " + ignored));
                                }
                                stmt = null;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var14_28 = null;
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                            catch (Throwable ignored) {
                                this.log.trace((Object)("Ignored: " + ignored));
                            }
                            stmt = null;
                            throw throwable;
                        }
                    }
                }
                Object var17_33 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                stmt = null;
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                c = null;
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                break block78;
                {
                    catch (SQLException e) {
                        tms.setRollbackOnly();
                        throw new SpyJMSException("Could not get a connection for jdbc2 table construction ", e);
                    }
                }
                catch (Throwable throwable) {
                    Object var17_34 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    stmt = null;
                    try {
                        c.close();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    c = null;
                    tms.endTX();
                    if (threadWasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
            }
            tms = new TransactionManagerStrategy();
            tms.startTX();
            threadWasInterrupted = Thread.interrupted();
            c = this.getConnection();
            stmt = c.prepareStatement(this.DELETE_TEMPORARY_MESSAGES);
            stmt.executeUpdate();
            stmt.close();
            stmt = c.prepareStatement(this.DELETE_MARKED_MESSAGES_WITH_TX);
            stmt.setString(1, "A");
            stmt.executeUpdate();
            stmt.close();
            stmt = c.prepareStatement(this.UPDATE_MARKED_MESSAGES);
            stmt.setNull(1, -5);
            stmt.setString(2, "A");
            stmt.setString(3, "D");
            stmt.executeUpdate();
            stmt.close();
            stmt = c.prepareStatement(this.DELETE_TEMPORARY_REFERENCES);
            stmt.executeUpdate();
            stmt.close();
            stmt = c.prepareStatement(this.DELETE_MARKED_REFERENCES_WITH_TX);
            stmt.setString(1, "A");
            stmt.executeUpdate();
            stmt.close();
            stmt = c.prepareStatement(this.UPDATE_MARKED_REFERENCES);
            stmt.setNull(1, -5);
            stmt.setString(2, "A");
            stmt.setString(3, "D");
            stmt.executeUpdate();
            stmt.close();
            stmt = c.prepareStatement(this.DELETE_ORPHANED_MESSAGES);
            stmt.executeUpdate();
            stmt.close();
            stmt = c.prepareStatement(this.SELECT_MAX_TX);
            rs = stmt.executeQuery();
            if (rs.next()) {
                this.nextTransactionId.set(rs.getLong(1) + 1L);
            }
            rs.close();
            stmt.close();
            stmt = c.prepareStatement(this.DELETE_ALL_TXS);
            stmt.executeUpdate();
            stmt.close();
            Object var20_38 = null;
            try {
                rs.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                c.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            tms.endTX();
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
            break block79;
            {
                catch (SQLException e) {
                    tms.setRollbackOnly();
                    throw new SpyJMSException("Could not resolve uncommited transactions.  Message recovery may not be accurate", e);
                }
            }
            catch (Throwable throwable) {
                Object var20_39 = null;
                try {
                    rs.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    stmt.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    c.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                tms.endTX();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTXRecord(Connection c, long txid) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.DELETE_TX);
            stmt.setLong(1, txid);
            stmt.executeUpdate();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessage(Connection c, String queue, SpyMessage message, Tx txId, String mark, String lateClone) throws SQLException, IOException {
        block15: {
            PreparedStatement stmt = null;
            try {
                stmt = c.prepareStatement(this.INSERT_MESSAGE);
                stmt.setLong(1, message.header.messageId);
                String dest = "*";
                if (queue != null) {
                    dest = queue;
                }
                stmt.setString(2, dest);
                this.setBlob(stmt, 3, message);
                if (txId != null) {
                    stmt.setLong(4, txId.longValue());
                } else {
                    stmt.setNull(4, -5);
                }
                if (mark == null) {
                    stmt.setNull(5, 12);
                } else {
                    stmt.setString(5, mark);
                }
                stmt.setString(6, lateClone);
                try {
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    if (lateClone.equals("1")) {
                        this.log.trace((Object)("Assumed already added to message log: " + message.header.messageId));
                        break block15;
                    }
                    throw e;
                }
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Throwable ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReference(Connection c, String queue, MessageReference message, Tx txId, String mark) throws SQLException, IOException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.INSERT_REFERENCE);
            stmt.setLong(1, message.messageId);
            stmt.setString(2, queue);
            if (txId != null) {
                stmt.setLong(3, txId.longValue());
            } else {
                stmt.setNull(3, -5);
            }
            stmt.setString(4, mark);
            if (message.redelivered) {
                stmt.setString(5, "1");
            } else {
                stmt.setString(5, "0");
            }
            stmt.setLong(6, message.redeliveryCount);
            stmt.executeUpdate();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMarkedMessages(Connection c, Tx txid, String mark) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.DELETE_MARKED_MESSAGES);
            stmt.setLong(1, txid.longValue());
            stmt.setString(2, mark);
            stmt.executeUpdate();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMarkedReferences(Connection c, Tx txid, String mark) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(this.DELETE_MARKED_REFERENCES);
            if (txid != null) {
                stmt.setLong(1, txid.longValue());
            } else {
                stmt.setNull(1, -5);
            }
            stmt.setString(2, mark);
            stmt.executeUpdate();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable e) {}
        }
    }

    protected void setBlob(PreparedStatement stmt, int column, SpyMessage message) throws IOException, SQLException {
        if (this.blobType == 0) {
            stmt.setObject(column, message);
        } else if (this.blobType == 1) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            SpyMessage.writeMessage(message, oos);
            oos.flush();
            byte[] messageAsBytes = baos.toByteArray();
            stmt.setBytes(column, messageAsBytes);
        } else if (this.blobType == 2) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            SpyMessage.writeMessage(message, oos);
            oos.flush();
            byte[] messageAsBytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(messageAsBytes);
            stmt.setBinaryStream(column, (InputStream)bais, messageAsBytes.length);
        } else if (this.blobType == 3) {
            throw new RuntimeException("BLOB_TYPE: BLOB_BLOB is not yet implemented.");
        }
    }

    protected SpyMessage extractMessage(ResultSet rs, int column) throws SQLException, IOException {
        long messageid = rs.getLong(1);
        SpyMessage message = null;
        if (this.blobType == 0) {
            message = (SpyMessage)rs.getObject(column);
        } else if (this.blobType == 1) {
            byte[] st = rs.getBytes(column);
            ByteArrayInputStream baip = new ByteArrayInputStream(st);
            ObjectInputStream ois = new ObjectInputStream(baip);
            message = SpyMessage.readMessage(ois);
        } else if (this.blobType == 2) {
            ObjectInputStream ois = new ObjectInputStream(rs.getBinaryStream(column));
            message = SpyMessage.readMessage(ois);
        } else if (this.blobType == 3) {
            ObjectInputStream ois = new ObjectInputStream(rs.getBlob(column).getBinaryStream());
            message = SpyMessage.readMessage(ois);
        } else {
            throw new IllegalStateException();
        }
        message.header.messageId = messageid;
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connection getConnection() throws SQLException {
        int attempts = this.connectionRetryAttempts;
        int attemptCount = 0;
        SQLException sqlException = null;
        while (attempts-- > 0) {
            block14: {
                Connection connection;
                block13: {
                    Object var6_7;
                    if (++attemptCount > 1) {
                        this.log.debug((Object)("Retrying connection: attempt # " + attemptCount));
                    }
                    try {
                        block12: {
                            try {
                                sqlException = null;
                                connection = this.datasource.getConnection();
                                var6_7 = null;
                                if (sqlException != null) return connection;
                                if (attemptCount <= 1) break block12;
                                break block13;
                            }
                            catch (SQLException exception) {
                                this.log.debug((Object)("Connection attempt # " + attemptCount + " failed with SQLException"), (Throwable)exception);
                                sqlException = exception;
                                var6_7 = null;
                                if (sqlException == null && attemptCount > 1) {
                                    this.log.debug((Object)("Connection succeeded on attempt # " + attemptCount));
                                }
                                break block14;
                            }
                        }
                        return connection;
                    }
                    catch (Throwable throwable) {
                        var6_7 = null;
                        if (sqlException != null || attemptCount <= 1) throw throwable;
                        this.log.debug((Object)("Connection succeeded on attempt # " + attemptCount));
                        throw throwable;
                    }
                }
                this.log.debug((Object)("Connection succeeded on attempt # " + attemptCount));
                return connection;
            }
            if (attempts <= 0) continue;
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        if (sqlException == null) throw new SQLException("connection attempt interrupted");
        throw sqlException;
    }

    class TransactionManagerStrategy {
        Transaction threadTx;

        TransactionManagerStrategy() {
        }

        void startTX() throws JMSException {
            try {
                this.threadTx = PersistenceManager.this.tm.suspend();
                PersistenceManager.this.tm.begin();
            }
            catch (Exception e) {
                try {
                    if (this.threadTx != null) {
                        PersistenceManager.this.tm.resume(this.threadTx);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SpyJMSException("Could not start a transaction with the transaction manager.", e);
            }
        }

        void setRollbackOnly() throws JMSException {
            try {
                PersistenceManager.this.tm.setRollbackOnly();
            }
            catch (Exception e) {
                throw new SpyJMSException("Could not start a mark the transaction for rollback .", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void endTX() throws JMSException {
            try {
                try {
                    if (PersistenceManager.this.tm.getStatus() == 1) {
                        PersistenceManager.this.tm.rollback();
                    } else {
                        PersistenceManager.this.tm.commit();
                    }
                }
                catch (Exception e) {
                    throw new SpyJMSException("Could not start a transaction with the transaction manager.", e);
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                try {
                    if (this.threadTx == null) throw throwable;
                    PersistenceManager.this.tm.resume(this.threadTx);
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ignore) {}
            if (this.threadTx == null) return;
            PersistenceManager.this.tm.resume(this.threadTx);
            return;
        }
    }
}

