/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il;

import java.util.Properties;
import javax.jms.IllegalStateException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.mq.GenericConnectionFactory;
import org.jboss.mq.SpyConnectionFactory;
import org.jboss.mq.SpyXAConnectionFactory;
import org.jboss.mq.il.Invoker;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILJMXServiceMBean;
import org.jboss.system.ServiceMBeanSupport;

public abstract class ServerILJMXService
extends ServiceMBeanSupport
implements ServerILJMXServiceMBean {
    private ObjectName jbossMQService;
    private Invoker jmsServer;
    protected String connectionFactoryJNDIRef;
    protected String xaConnectionFactoryJNDIRef;
    protected long pingPeriod = 60000L;
    protected String clientID;

    public ObjectName getJBossMQService() {
        return this.jbossMQService;
    }

    public void setInvoker(ObjectName jbossMQService) {
        this.jbossMQService = jbossMQService;
    }

    public void startService() throws Exception {
        this.jmsServer = (Invoker)this.getServer().getAttribute(this.jbossMQService, "Invoker");
        if (this.jmsServer == null) {
            throw new IllegalStateException("Cannot find JBossMQService!");
        }
    }

    public void stopService() throws Exception {
        this.jmsServer = null;
    }

    public void setConnectionFactoryJNDIRef(String newConnectionFactoryJNDIRef) {
        this.connectionFactoryJNDIRef = newConnectionFactoryJNDIRef;
    }

    public void setXAConnectionFactoryJNDIRef(String newXaConnectionFactoryJNDIRef) {
        this.xaConnectionFactoryJNDIRef = newXaConnectionFactoryJNDIRef;
    }

    public Properties getClientConnectionProperties() {
        Properties rc = new Properties();
        rc.setProperty("PingPeriod", "" + this.pingPeriod);
        if (this.clientID != null) {
            rc.setProperty("ClientID", this.clientID);
        }
        return rc;
    }

    public abstract ServerIL getServerIL();

    public String getConnectionFactoryJNDIRef() {
        return this.connectionFactoryJNDIRef;
    }

    public String getXAConnectionFactoryJNDIRef() {
        return this.xaConnectionFactoryJNDIRef;
    }

    public void bindJNDIReferences() throws NamingException {
        GenericConnectionFactory gcf = new GenericConnectionFactory(this.getServerIL(), this.getClientConnectionProperties());
        SpyConnectionFactory scf = new SpyConnectionFactory(gcf);
        SpyXAConnectionFactory sxacf = new SpyXAConnectionFactory(gcf);
        InitialContext ctx = new InitialContext();
        this.rebind(ctx, this.connectionFactoryJNDIRef, scf);
        this.rebind(ctx, this.xaConnectionFactoryJNDIRef, sxacf);
    }

    protected void rebind(Context ctx, String name, Object val) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        ctx.rebind(n.get(0), val);
    }

    public void unbindJNDIReferences() throws NamingException {
        InitialContext ctx = new InitialContext();
        ctx.unbind(this.connectionFactoryJNDIRef);
        ctx.unbind(this.xaConnectionFactoryJNDIRef);
    }

    public Invoker lookupJMSServer() {
        return this.jmsServer;
    }

    public long getPingPeriod() {
        return this.pingPeriod;
    }

    public void setPingPeriod(long period) {
        this.pingPeriod = period;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }
}

