/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.util.NestedRuntimeException;
import org.jboss.xml.binding.GenericObjectModelFactory;
import org.jboss.xml.binding.JBossXBException;
import org.jboss.xml.binding.JBossXBRuntimeException;
import org.jboss.xml.binding.SimpleTypeBindings;
import org.jboss.xml.binding.TypeBinding;
import org.jboss.xml.binding.UnmarshallingContext;
import org.jboss.xml.binding.Util;
import org.xml.sax.Attributes;

public class MappingObjectModelFactory
implements GenericObjectModelFactory {
    private static final Logger log = Logger.getLogger(MappingObjectModelFactory.class);
    private final Map elementToClassMapping = new HashMap();
    private final Map elementToFieldMapping = new HashMap();

    public void mapElementToClass(String element, Class cls) {
        ElementToClassMapping mapping = new ElementToClassMapping(element, cls);
        this.addElementToClassMapping(mapping);
        if (log.isTraceEnabled()) {
            log.trace(mapping);
        }
    }

    public void mapElementToField(String element, Class cls, String field, TypeBinding converter) {
        ElementToFieldMapping mapping = new ElementToFieldMapping(element, cls, field, converter);
        this.addElementToFieldMapping(mapping);
        if (log.isTraceEnabled()) {
            log.trace(mapping);
        }
    }

    public Object newRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs) {
        if (log.isTraceEnabled()) {
            log.trace("newRoot root=" + root + " namespaceURI=" + namespaceURI + " localName=" + localName + " attributes=" + attrs);
        }
        if (root == null) {
            ElementToClassMapping mapping = (ElementToClassMapping)this.elementToClassMapping.get(localName);
            if (mapping != null) {
                if (log.isTraceEnabled()) {
                    log.trace("creating root using " + mapping);
                }
                root = MappingObjectModelFactory.newInstance(mapping.cls);
            } else {
                root = MappingObjectModelFactory.create(namespaceURI, localName, ctx.getType());
            }
            if (root == null) {
                throw new IllegalStateException("Failed to resolve Java type binding for root element: ns=" + namespaceURI + ", local=" + localName);
            }
        }
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                try {
                    if (attrs.getLocalName(i).length() <= 0 || attrs.getQName(i).startsWith("xsi:")) continue;
                    this.setAttribute(root, attrs.getLocalName(i), attrs.getValue(i), ctx);
                    continue;
                }
                catch (Exception e) {
                    String msg = "Failed to set attribute " + attrs.getQName(i) + "=" + attrs.getValue(i);
                    log.error(msg, e);
                    throw new IllegalStateException(msg + ": " + e.getMessage());
                }
            }
        }
        return root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object newChild(Object o, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs) {
        Class<?> childType;
        if (log.isTraceEnabled()) {
            log.trace("newChild object=" + o + " namespaceURI=" + namespaceURI + " localName=" + localName + " attributes=" + attrs);
        }
        if (o == null) {
            throw new RuntimeException("Attempt to add a new child to a null parent localName=" + localName);
        }
        Object child = null;
        ElementToClassMapping mapping = (ElementToClassMapping)this.elementToClassMapping.get(localName);
        XSTypeDefinition type = ctx.getType();
        if (mapping != null) {
            if (log.isTraceEnabled()) {
                log.trace("newChild using mapping " + mapping);
            }
            try {
                if (!(o instanceof Collection)) {
                    ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, o.getClass()));
                    if (fieldMapping != null) {
                        child = MappingObjectModelFactory.get(o, localName, fieldMapping.getter, fieldMapping.field);
                    } else {
                        String xmlToCls = Util.xmlNameToClassName(localName, true);
                        Method getter = null;
                        Field field = null;
                        try {
                            getter = o.getClass().getMethod("get" + xmlToCls, null);
                        }
                        catch (NoSuchMethodException e) {
                            try {
                                field = o.getClass().getField(Character.toLowerCase(xmlToCls.charAt(0)) + xmlToCls.substring(1));
                            }
                            catch (NoSuchFieldException ee) {
                                throw new JBossXBException("Neither field nor its getter were found for " + localName + " in " + o.getClass());
                            }
                        }
                        child = MappingObjectModelFactory.get(o, localName, getter, field);
                    }
                }
                if (child == null) {
                    child = MappingObjectModelFactory.newInstance(mapping.cls);
                }
                if (attrs == null) return child;
                int i = 0;
                while (i < attrs.getLength()) {
                    if (attrs.getLocalName(i).length() > 0 && !attrs.getQName(i).startsWith("xsi:")) {
                        this.setAttribute(child, attrs.getLocalName(i), attrs.getValue(i), ctx);
                    }
                    ++i;
                }
                return child;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NestedRuntimeException("newChild failed for o=" + o + ", uri=" + namespaceURI + ", local=" + localName + ", attrs=" + attrs, e);
            }
        }
        if (o instanceof Collection) {
            return MappingObjectModelFactory.create(namespaceURI, localName, type);
        }
        Class oCls = o instanceof ImmutableContainer ? ((ImmutableContainer)o).cls : o.getClass();
        String xmlToCls = Util.xmlNameToClassName(localName, true);
        Method getter = null;
        Field field = null;
        try {
            getter = oCls.getMethod("get" + xmlToCls, null);
            childType = getter.getReturnType();
        }
        catch (NoSuchMethodException e) {
            try {
                field = oCls.getField(Character.toLowerCase(xmlToCls.charAt(0)) + xmlToCls.substring(1));
                childType = field.getType();
            }
            catch (NoSuchFieldException e1) {
                throw new IllegalStateException("newChild failed for o=" + o + ", uri=" + namespaceURI + ", local=" + localName + ", attrs=" + attrs + ": neither field nor its getter were found");
            }
        }
        if (Collection.class.isAssignableFrom(childType)) {
            child = MappingObjectModelFactory.get(o, localName, getter, field);
            Object item = null;
            if (type == null || type != null && type.getTypeCategory() == 15) {
                item = MappingObjectModelFactory.create(namespaceURI, localName, type);
            }
            if (item != null) {
                if (child != null) return item;
                this.setChild(new ArrayList(), o, localName);
                return item;
            }
            if (child != null) return child;
            return new ArrayList();
        }
        if (Util.isAttributeType(childType)) return child;
        ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, o.getClass()));
        TypeBinding converter = fieldMapping == null ? null : fieldMapping.converter;
        if (converter != null) return child;
        return MappingObjectModelFactory.newInstance(childType);
    }

    public void addChild(Object parent, Object child, UnmarshallingContext ctx, String namespaceURI, String localName) {
        if (log.isTraceEnabled()) {
            log.trace("addChild parent=" + parent + " child=" + child + " namespaceURI=" + namespaceURI + " localName=" + localName);
        }
        if (child instanceof ImmutableContainer) {
            child = ((ImmutableContainer)child).newInstance();
        }
        this.setChild(child, parent, localName);
    }

    public void setValue(Object o, UnmarshallingContext ctx, String namespaceURI, String localName, String value) {
        if (log.isTraceEnabled()) {
            log.trace("setValue object=" + o + " ctx=" + ctx + " namespaceURI=" + namespaceURI + " localName=" + localName + " value=" + value);
        }
        this.setAttribute(o, localName, value, ctx);
    }

    public Object completeRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName) {
        if (log.isTraceEnabled()) {
            log.trace("completeRoot root=" + root + " navigator=" + navigator + " namespaceURI=" + namespaceURI + " localName=" + localName);
        }
        if (root instanceof ImmutableContainer) {
            root = ((ImmutableContainer)root).newInstance();
        }
        return root;
    }

    private void addElementToClassMapping(ElementToClassMapping mapping) {
        this.elementToClassMapping.put(mapping.element, mapping);
    }

    private void addElementToFieldMapping(ElementToFieldMapping mapping) {
        this.elementToFieldMapping.put(mapping.key, mapping);
    }

    private void setChild(Object child, Object parent, String localName) {
        boolean trace = log.isTraceEnabled();
        Object value = child;
        if (parent instanceof Collection) {
            if (trace) {
                log.trace("Add " + value + " to collection " + parent);
            }
            ((Collection)parent).add(value);
        } else {
            ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, parent.getClass()));
            if (fieldMapping != null) {
                if (trace) {
                    log.trace("Add " + value + " to " + parent + " using field mapping " + fieldMapping);
                }
                MappingObjectModelFactory.set(parent, value, localName, fieldMapping.setter, fieldMapping.field);
            } else {
                String xmlToCls = Util.xmlNameToClassName(localName, true);
                if (trace) {
                    log.trace("Add " + value + " to xml mapped class " + xmlToCls);
                }
                Class parentCls = parent instanceof ImmutableContainer ? ((ImmutableContainer)parent).cls : parent.getClass();
                Method getter = null;
                Field field = null;
                Class<?> fieldType = null;
                try {
                    getter = parentCls.getMethod("get" + xmlToCls, null);
                    fieldType = getter.getReturnType();
                }
                catch (NoSuchMethodException e) {
                    try {
                        field = parentCls.getField(Character.toLowerCase(xmlToCls.charAt(0)) + xmlToCls.substring(1));
                        fieldType = field.getType();
                    }
                    catch (NoSuchFieldException e1) {
                        log.warn("neither field nor its getter were found for " + localName + " in " + parent);
                    }
                }
                if (fieldType != null) {
                    if (!(child instanceof Collection) && Collection.class.isAssignableFrom(fieldType)) {
                        Object o = MappingObjectModelFactory.get(parent, localName, getter, field);
                        Collection col = (Collection)o;
                        if (trace) {
                            log.trace("Add " + value + " to collection " + col + " retrieved from getter " + getter);
                        }
                        col.add(child);
                    } else {
                        Method setter = null;
                        if (field == null) {
                            try {
                                setter = parentCls.getMethod("set" + xmlToCls, getter.getReturnType());
                            }
                            catch (NoSuchMethodException e) {
                                log.warn("No setter for " + localName + " in " + parentCls);
                            }
                        }
                        MappingObjectModelFactory.set(parent, value, localName, setter, field);
                    }
                }
            }
        }
    }

    private void setAttribute(Object o, String localName, String value, UnmarshallingContext ctx) {
        if (o instanceof Collection) {
            XSTypeDefinition type = ctx.getType();
            if (type == null) {
                log.warn("Type is not available for collection item " + localName + "=" + value + " -> adding as string.");
                ((Collection)o).add(value);
            } else {
                if (type.getName() == null) {
                    throw new IllegalStateException("Name is null for simple type?!");
                }
                Object trgValue = SimpleTypeBindings.unmarshal(type.getName(), value, ctx.getNamespaceContext());
                ((Collection)o).add(trgValue);
            }
        } else {
            Object fieldValue = null;
            ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, o.getClass()));
            if (fieldMapping != null) {
                fieldValue = fieldMapping.converter.unmarshal(value);
                MappingObjectModelFactory.set(o, fieldValue, localName, fieldMapping.setter, fieldMapping.field);
            } else {
                Class<?> fieldType;
                Field field;
                Method setter;
                block11: {
                    Class oCls = o instanceof ImmutableContainer ? ((ImmutableContainer)o).cls : o.getClass();
                    setter = null;
                    field = null;
                    fieldType = null;
                    String xmlToCls = Util.xmlNameToClassName(localName, true);
                    try {
                        Method getter = oCls.getMethod("get" + xmlToCls, null);
                        fieldType = getter.getReturnType();
                        setter = oCls.getMethod("set" + xmlToCls, getter.getReturnType());
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            field = oCls.getField(Character.toLowerCase(xmlToCls.charAt(0)) + xmlToCls.substring(1));
                            fieldType = field.getType();
                        }
                        catch (NoSuchFieldException e1) {
                            if (fieldType != null) break block11;
                            throw new JBossXBRuntimeException("Failed to discover field's type: niether field nor its getter were found for " + localName + " in " + oCls);
                        }
                    }
                }
                fieldValue = SimpleTypeBindings.unmarshal(value, fieldType);
                MappingObjectModelFactory.set(o, fieldValue, localName, setter, field);
            }
        }
    }

    private static Object create(String namespaceURI, String localName, XSTypeDefinition type) {
        Class<?> cls;
        Object o;
        block3: {
            o = null;
            String clsName = type != null && type.getName() != null ? Util.xmlNameToClassName(namespaceURI, type.getName(), true) : Util.xmlNameToClassName(namespaceURI, localName, true);
            cls = null;
            try {
                cls = Thread.currentThread().getContextClassLoader().loadClass(clsName);
            }
            catch (ClassNotFoundException e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace("create: failed to load class " + clsName);
            }
        }
        if (cls != null) {
            o = MappingObjectModelFactory.newInstance(cls);
        }
        return o;
    }

    /*
     * WARNING - void declaration
     */
    private static Object get(Object o, String localName, Method getter, Field field) {
        void var4_6;
        Object value;
        if (log.isTraceEnabled()) {
            log.trace("get object=" + o + " localName=" + localName + " getter=" + getter + " field=" + field);
        }
        if (o instanceof ImmutableContainer) {
            ImmutableContainer con = (ImmutableContainer)o;
            value = con.getChild(localName);
        } else {
            try {
                value = getter != null ? getter.invoke(o, null) : field.get(o);
            }
            catch (Exception e) {
                throw new NestedRuntimeException("Failed to get field value " + (getter != null ? getter.getName() : field.getName()) + " on " + o, e);
            }
        }
        return var4_6;
    }

    private static void set(Object parent, Object child, String localName, Method setter, Field field) {
        if (log.isTraceEnabled()) {
            log.trace("set parent=" + parent + " child=" + child + " localName=" + localName + " setter=" + setter);
        }
        if (setter != null) {
            try {
                setter.invoke(parent, child);
            }
            catch (Exception e) {
                throw new NestedRuntimeException("Failed to set field value " + child + " with setter " + setter + " on " + parent + ": ", e);
            }
        } else if (field != null) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                field.set(parent, child);
            }
            catch (IllegalArgumentException e) {
                throw new NestedRuntimeException("Failed to set field value " + child + " with field " + field.getName() + " on " + parent + ": field type is " + field.getType() + ", value type is " + (child == null ? null : child.getClass()), e);
            }
            catch (IllegalAccessException e) {
                throw new NestedRuntimeException("Failed to set field value " + child + " with field " + field.getName() + " on " + parent + ": ", e);
            }
        } else if (parent instanceof ImmutableContainer) {
            ((ImmutableContainer)parent).addChild(localName, child);
        } else {
            throw new IllegalStateException("Field and setter are null and it's not an immutable container: parent=" + parent.getClass() + ", localName=" + localName + ", parent=" + parent + ", child=" + child);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Object newInstance(Class cls) {
        void var1_4;
        Object instance;
        if (log.isTraceEnabled()) {
            log.trace("new " + cls.getName());
        }
        try {
            Constructor ctor = cls.getConstructor(null);
            instance = ctor.newInstance(null);
        }
        catch (NoSuchMethodException e) {
            log.warn("No no-arg constructor in " + cls);
            instance = new ImmutableContainer(cls);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create an instance of " + cls + " with the no-arg constructor: " + e.getMessage());
        }
        return var1_4;
    }

    private static class ImmutableContainer {
        private final Class cls;
        private final List names = new ArrayList();
        private final List values = new ArrayList();

        public ImmutableContainer(Class cls) {
            this.cls = cls;
            if (log.isTraceEnabled()) {
                log.trace("created immutable container for " + cls);
            }
        }

        public void addChild(String localName, Object child) {
            if (!this.names.isEmpty() && this.names.get(this.names.size() - 1).equals(localName)) {
                throw new IllegalStateException("Attempt to add duplicate element " + localName);
            }
            this.names.add(localName);
            this.values.add(child);
            if (log.isTraceEnabled()) {
                log.trace("added child " + localName + " for " + this.cls + ": " + child);
            }
        }

        public Object getChild(String localName) {
            return this.names.get(this.names.size() - 1).equals(localName) ? this.values.get(this.values.size() - 1) : null;
        }

        public Object[] getValues() {
            return this.values.toArray();
        }

        public Class[] getValueTypes() {
            Class[] types = new Class[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                types[i] = this.values.get(i).getClass();
            }
            return types;
        }

        public Object newInstance() {
            Constructor<?> ctor = null;
            Constructor<?>[] ctors = this.cls.getConstructors();
            if (ctors == null || ctors.length == 0) {
                throw new JBossXBRuntimeException("The class has no declared constructors: " + this.cls);
            }
            for (int i = 0; i < ctors.length; ++i) {
                Class<?>[] types = ctors[i].getParameterTypes();
                if (types == null || types.length == 0) {
                    throw new IllegalStateException("Found no-arg constructor for immutable " + this.cls);
                }
                if (types.length != this.values.size()) continue;
                ctor = ctors[i];
                int typeInd = 0;
                while (typeInd < types.length) {
                    if (types[typeInd].isAssignableFrom(this.values.get(typeInd++).getClass())) continue;
                    ctor = null;
                    break;
                }
                if (ctor != null) break;
            }
            if (ctor == null) {
                throw new IllegalStateException("No constructor in " + this.cls + " that would take arguments " + this.values);
            }
            try {
                return ctor.newInstance(this.values.toArray());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create immutable instance of " + this.cls + " using arguments: " + this.values + ": " + e.getMessage());
            }
        }
    }

    private class ElementToFieldMapping {
        public final String element;
        public final Class cls;
        public final String fieldName;
        public final TypeBinding converter;
        public final ElementToFieldMappingKey key;
        public final Method getter;
        public final Method setter;
        public final Field field;

        public ElementToFieldMapping(String element, Class cls, String fieldName, TypeBinding converter) {
            this.element = element;
            this.cls = cls;
            this.fieldName = fieldName;
            this.converter = converter;
            this.key = new ElementToFieldMappingKey(element, cls);
            Field field = null;
            Method getter = null;
            Method setter = null;
            try {
                field = cls.getField(fieldName);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
            }
            catch (NoSuchFieldException e) {
                try {
                    getter = Classes.getAttributeGetter(cls, fieldName);
                }
                catch (NoSuchMethodException e1) {
                    throw new JBossXBRuntimeException("Neither field nor its getter method was found for " + fieldName + " in " + cls);
                }
                try {
                    setter = Classes.getAttributeSetter(cls, fieldName, getter.getReturnType());
                }
                catch (NoSuchMethodException e1) {
                    throw new JBossXBRuntimeException("Neither field nor its setter method was found for " + fieldName + " in " + cls);
                }
            }
            this.field = field;
            this.getter = getter;
            this.setter = setter;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("ElementToField@").append(System.identityHashCode(this));
            buffer.append("{element=").append(this.element);
            if (this.cls != null) {
                buffer.append(" class=").append(this.cls.getName());
            }
            buffer.append(" field=").append(this.fieldName);
            buffer.append(" getter=").append(this.getter);
            buffer.append(" setter=").append(this.setter);
            if (this.converter != null) {
                buffer.append(" convertor=").append(this.converter.getClass().getName());
            }
            buffer.append("}");
            return buffer.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementToFieldMapping)) {
                return false;
            }
            ElementToFieldMapping elementToFieldMapping = (ElementToFieldMapping)o;
            if (this.cls != null ? !this.cls.equals(elementToFieldMapping.cls) : elementToFieldMapping.cls != null) {
                return false;
            }
            if (this.element != null ? !this.element.equals(elementToFieldMapping.element) : elementToFieldMapping.element != null) {
                return false;
            }
            return !(this.fieldName != null ? !this.fieldName.equals(elementToFieldMapping.fieldName) : elementToFieldMapping.fieldName != null);
        }

        public int hashCode() {
            int result = this.element != null ? this.element.hashCode() : 0;
            result = 29 * result + (this.cls != null ? this.cls.hashCode() : 0);
            result = 29 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
            return result;
        }
    }

    private class ElementToFieldMappingKey {
        public final String element;
        public final Class cls;

        public ElementToFieldMappingKey(String element, Class cls) {
            this.element = element;
            this.cls = cls;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementToFieldMappingKey)) {
                return false;
            }
            ElementToFieldMappingKey elementToFieldMappingKey = (ElementToFieldMappingKey)o;
            if (this.cls != null ? !this.cls.equals(elementToFieldMappingKey.cls) : elementToFieldMappingKey.cls != null) {
                return false;
            }
            return !(this.element != null ? !this.element.equals(elementToFieldMappingKey.element) : elementToFieldMappingKey.element != null);
        }

        public int hashCode() {
            int result = this.element != null ? this.element.hashCode() : 0;
            result = 29 * result + (this.cls != null ? this.cls.hashCode() : 0);
            return result;
        }
    }

    private class ElementToClassMapping {
        public final String element;
        public final Class cls;

        public ElementToClassMapping(String element, Class cls) {
            this.element = element;
            this.cls = cls;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("ElementToClass@").append(System.identityHashCode(this));
            buffer.append("{element=").append(this.element);
            if (this.cls != null) {
                buffer.append(" class=").append(this.cls.getName());
            }
            buffer.append("}");
            return buffer.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementToClassMapping)) {
                return false;
            }
            ElementToClassMapping classMapping = (ElementToClassMapping)o;
            return !(this.cls != null ? !this.cls.equals(classMapping.cls) : classMapping.cls != null);
        }

        public int hashCode() {
            return this.cls != null ? this.cls.hashCode() : 0;
        }
    }
}

