#/*
# *  Copyright 2007-2010 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Icon.pm 1901 2009-12-31 02:40:20Z hikarin $
#

package Img0ch::Icon;

use strict;

sub new {
    my ( $iClass, $iBBS ) = @_;
    my $iKernel = $iBBS->get_kernel();
    my $iRepos  = $iKernel->get_repos( $iBBS->get_repos_path('icon') );

    bless {
        _bbs    => $iBBS->get_name(),
        _count  => $iRepos->get_int('I:I._'),
        __icons => [],
        _kernel => $iKernel,
        _repos  => $iRepos,
        __path  => $iBBS->path('icon.csv'),
    }, $iClass;
}

sub load {
    my ($iIcon) = @_;
    $iIcon->{_repos}->load();
    return 1;
}

sub get {
    my ( $iIcon, $id ) = @_;
    my $iRepos = $iIcon->{_repos};
    return {
        description => $iRepos->get("I:I.${id}.description"),
        extension   => $iRepos->get("I:I.${id}.extension"),
        is_global   => $iRepos->get("I:I.${id}.is_global"),
        name        => $iRepos->get("I:I.${id}.name"),
        pass        => $iRepos->get("I:I.${id}.pass"),
        width       => $iRepos->get_int("I:I.${id}.width"),
        height      => $iRepos->get_int("I:I.${id}.height"),
    };
}

sub count { $_[0]->{_count} }

sub get_icon_list {
    my ($iIcon) = @_;
    my $path = $iIcon->path();

    if ( -r $path ) {
        require Unicode::Japanese;
        my $iKernel = $iIcon->{_kernel};
        my $stack   = [];
        my $fh      = $iKernel->get_read_file_handle($path);
        my $unijp   = Unicode::Japanese->new();
        while ( my $line = <$fh> ) {
            my $data = $unijp->set( $line, 'auto' )->split_csv();
            push @$stack,
                {
                id          => $data->[0],
                extension   => $data->[1],
                width       => $data->[2],
                height      => $data->[3],
                is_global   => $data->[4],
                name        => $data->[5],
                description => $data->[6],
                };
        }
        close $fh or $iKernel->throw_io_exception($path);
        return $stack;
    }
    return $iIcon->to_array();
}

sub to_array {
    my ($iIcon) = @_;
    my $icons   = {};
    my $iRepos  = $iIcon->{_repos};

    $iRepos->iterate(
        sub {
            my ( $key, $value, $icons ) = @_;
            if ( $key =~ /\AI:I\.([^\.]+)\.(\w+)\z/xms ) {
                my ( $id, $name ) = ( $1, $2 );
                $icons->{$id} ||= {};
                $icons->{$id}->{$name} = $$value;
            }
            return 0;
        },
        $icons
    );

    my $stack = [];
    while ( my ( $id, $value ) = each %$icons ) {
        push @$stack,
            {
            id          => $id,
            is_global   => $value->{is_global},
            extension   => $value->{extension},
            name        => $value->{name},
            width       => $value->{width},
            height      => $value->{height},
            description => $value->{description},
            };
    }
    return $stack;
}

sub path { $_[0]->{__path} }

1;
__END__
