#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: setting.pm 1936 2010-01-21 00:55:51Z hikarin $
#

package Zeromin2::App::setting;

use strict;
use Zeromin::Setting qw();

sub load {
    my ($zApp) = @_;
    $zApp->privilege( 'can_enter_setting_section', 1 )
        or return $zApp->return_value(1);

    my $iKernel  = $zApp->kernel();
    my $zBBS     = $zApp->bbs();
    my $zSetting = Zeromin::Setting->new($zBBS);
    my $zUser    = $zApp->user();
    my $param    = {};
    my $data     = {};
    $zSetting->load();

    for my $key ( @{ $zSetting->keyset(1) } ) {
        my $priv_meth = $zSetting->get_require_privilege($key);

        # NOT use get_normalized_utf8()
        my $value = $zSetting->get_normalized($key);

        $value =~ tr/,/\n/;
        my $type      = $zSetting->get_type($key);
        my $privilege = $zUser->$priv_meth;
        %$param = (
            %$param,
            "${key}_type"      => $type,
            "${key}_value"     => $value,
            "${key}_privilege" => $privilege,
            "${key}_${value}"  => 1,
        );
        $data->{$key} = {
            'type'      => $type,
            'value'     => $value,
            'privilege' => $privilege,
        };
    }

    $zApp->add_template_param($param);
    return $zApp->return_value( 0, $data );
}

*load_color = \&load;

*load_restrict = \&load;

*load_other = \&load;

*load_upload = \&load;

#sub save { _save( [ 'BBS_MODE', 'BBS_SUBTITLE', 'BBS_TITLE' ], @_ ) }

sub save { _save( [], @_ ) }

sub _save {
    my ( $spec_keys, $zApp ) = @_;
    $zApp->check_csrf() or return $zApp->return_value(1);
    $zApp->privilege( 'can_enter_setting_section', 1 )
        or return $zApp->return_value(1);

    my $iKernel  = $zApp->kernel();
    my $iRequest = $zApp->request();
    my $zSetting = Zeromin::Setting->new( $zApp->bbs() );
    my $zUser    = $zApp->user();
    my @keys     = @$spec_keys ? @$spec_keys : $iRequest->param('setting');
    my ( $ok, $ng ) = ( 0, 0 );

    for my $key (@keys) {
        my $priv_meth = $zSetting->get_require_privilege($key);

        if ( !$zUser->$priv_meth ) {
            $zApp->logger( 0,
                'CANNOT CHANGE SETTING.TXT WITHOUT PRIVILEGE: %s', [$key], );
            $ng++;
            next;
        }

        my $old        = $zSetting->get_utf8($key);
        my $value_utf8 = $iRequest->param($key);
        $old eq $value_utf8 and next;

        $zSetting->set( $key, $value_utf8 );
        $zApp->logger(
            1,
            'MODIFIED SETTING.TXT: from %s to %s on %s',
            [ $old, $value_utf8, $key ],
        );
        $ok++;
    }

    $ok and $zSetting->save(0);
    return $zApp->return_value( ( $ng ? 1 : 0 ), $ok );
}

1;
__END__
