#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Thread.pm 1661 2008-03-09 23:53:39Z hikarin $
#

package Zeromin2::Translate::JBBS::Thread;

use strict;
use Zeromin2::Translate::JBBS::Parser qw();

sub new {
    my ( $zClass, $iKernel, $url ) = @_;
    my $base = Zeromin2::Translate::JBBS::Parser->get_base_url();

    $url =~ m{\A$base/(\w+)/(\d+)/\z}xms;
    my ( $category_id, $bbs_id ) = ( $1, $2 );

    bless {
        __bbs      => $bbs_id,
        __category => $category_id,
        __kernel   => $iKernel,
        __url      => $url,
    }, $zClass;
}

sub get_subject {
    my ( $zTJT, $iSubject, $ret ) = @_;
    my $category_id = $zTJT->{__category} || return 0;
    my $bbs_id      = $zTJT->{__bbs}      || return 0;
    my $BASE_URL = Zeromin2::Translate::JBBS::Parser->get_base_url();
    my $url = join '/', $BASE_URL, $category_id, $bbs_id, 'subject.txt';

    my $ua  = LWP::UserAgent->new();
    my $res = $ua->get($url);
    if ( $res->is_success() ) {
        $iSubject and $iSubject->load();
        for my $line ( split "\n", $res->content() ) {
            $line =~ /\A(\d+)\.cgi,(.+?)\s?\((\d+)\)\z/xms or next;
            my ( $key, $subject, $res ) = ( $1, $2, $3 );
            $iSubject and $iSubject->age( $key, $res, $subject );
            $ret and $ret->{$key} = [ $subject, $res ];
        }
        $iSubject and $iSubject->save();
        return 1;
    }

    return 0;
}

sub get_thread {
    my ( $zTJT, $key, $iThread, $ret ) = @_;
    my $category_id = $zTJT->{__category} || return 0;
    my $bbs_id      = $zTJT->{__bbs}      || return 0;
    my $ua          = LWP::UserAgent->new();
    my $thread_url  = join '/',
        Zeromin2::Translate::JBBS::Parser->get_app_base_url(), 'rawmode.cgi',
        $category_id, $bbs_id, $key, '';
    my $res = $ua->get($thread_url);

    if ( $res->is_success() ) {
        my $iKernel = $zTJT->{__kernel};
        $iThread and $iThread->load();
        for my $line ( split "\n", $res->content() ) {
            my ( $resno, $name, $mail, $date, $message, $subject, $id )
                = split '<>', $line;
            $name    = $iKernel->get_encoded_str( $name,    undef, 'euc' );
            $mail    = $iKernel->get_encoded_str( $mail,    undef, 'euc' );
            $date    = $iKernel->get_encoded_str( $date,    undef, 'euc' );
            $id      = $iKernel->get_encoded_str( $id,      undef, 'euc' );
            $message = $iKernel->get_encoded_str( $message, undef, 'euc' );
            $subject = $iKernel->get_encoded_str( $subject, undef, 'euc' );
            $iThread
                and $iThread->set(
                [ $name, $mail, $date, $id, $message, $subject ] );
            $ret
                and push @$ret,
                [ $name, $mail, $date, $id, $message, $subject ];
        }
        $iThread and $iThread->save();
        return 1;
    }

    return 0;
}

sub get_thread_log {
    my ( $zTJT, $key, $password, $iLog, $ret ) = @_;
    my $category_id = $zTJT->{__category} || return 0;
    my $bbs_id      = $zTJT->{__bbs}      || return 0;
    my $content;

    my $zTJP  = Zeromin2::Translate::JBBS::Parser->new();
    my $param = {
        BBS  => $category_id,
        DIR  => $bbs_id,
        KEY  => $key,
        -raw => 1,
    };
    $zTJP->set_url( $zTJT->{__url} );
    $zTJP->set_password($password);

    if ( $zTJP->try_post_form( \$content, 'csv', $param ) ) {
        $content =~ tr/\r//d;

        require Time::Local;
        my $iKernel = $zTJT->{__kernel};
        my ( $header, $body ) = split "\n\n", $content, 2;
        my @csv = split "\n", ( $body || '' );
        shift @csv;

        for my $line (@csv) {
            my ( $resno, $date, $host, $device_id, $id, $mail, $name,
                $message )
                = split ',', $line;
            $date    = $iKernel->get_encoded_str( $date,    undef, 'sjis' );
            $mail    = $iKernel->get_encoded_str( $mail,    undef, 'sjis' );
            $name    = $iKernel->get_encoded_str( $name,    undef, 'sjis' );
            $message = $iKernel->get_encoded_str( $message, undef, 'sjis' );

            $date =~ m{(\d+)/(\d+)/(\d+)[^\d]+(\d+):(\d+):(\d+)}xms;
            my $stamp
                = Time::Local::timelocal( $6, $5, $4, $3, $2 - 1, $1 - 1900 );
            my $ip = gethostbyname($host);

            $iLog and $iLog->add( $resno, [ $stamp, $ip, $device_id, '' ] );
            $ret and push @$ret,
                {
                resno     => $resno,
                date      => $date,
                timestamp => $stamp,
                host      => $host,
                device_id => $device_id,
                res_id    => $id,
                mail      => $mail,
                name      => $name,
                message   => $message,
                };
        }
        $iLog and $iLog->save();
        return 1;
    }

    return 0;
}

1;
__END__
