#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: YouTube.pm 1826 2009-04-08 15:23:25Z hikarin $
#

package Img0ch::Plugin::Rewrite::StreamService::YouTube;

use strict;

sub new {
    my ( $iClass, $iBBS ) = @_;
    my $iConfig = $iBBS->get_kernel()->get_config();

    bless [
        ( $iConfig->get_int('youtube.width')  || 425 ),
        ( $iConfig->get_int('youtube.height') || 350 ),
        ( $iConfig->get('EnableXHTMLBreak') ? ' />' : '>' ),
    ], $iClass;
}

sub from_bbs {
    my ( $iObject, $key, $count, $resno, $text ) = @_;
    my ( $width, $height, $html_close_tag )
        = ( $iObject->[0], $iObject->[1], $iObject->[2] );

    $$text =~ s{
        (?:\<a[^>]+>)?
        http://(?:\w+\.)?youtube\.com/watch\?v=([\w\-]+)
        (?:\</a>)?
        }{<object width="${width}" height="${height}">
<param name="movie" value="http://www.youtube.com/v/$1"${html_close_tag}
<embed src="http://www.youtube.com/v/$1" type="application/x-shockwave-flash"
  width="${width}" height="${height}"${html_close_tag}
</object><br${html_close_tag}}gxms;
    return;
}

*from_read = \&from_bbs;

1;
__END__
