#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id$
#

package Img0ch::Plugin::Filter::NGWord2;

use strict;
use Img0ch::Filter::NGWord2;

sub check {
    my ($iApp) = @_;

    if ( !$iApp->cap()->can_pass_proxy_access() ) {
        my $input = {
            name    => $iApp->get_name(),
            mail    => $iApp->get_mail(),
            comment => $iApp->get_comment(),
            subject => $iApp->get_subject(),
        };
        my $iFNG = Img0ch::Filter::NGWord2->new( $iApp->bbs() );
        $iFNG->load();
        if ( !$iFNG->write_ok($input) ) {
            $iApp->set_error('POST_WITH_NGWORD');
            return 0;
        }
        $iApp->set_name( $input->{name} );
        $iApp->set_mail( $input->{mail} );
        $iApp->set_comment( $input->{comment} );
        $iApp->set_subject( $input->{subject} );
    }
    return 1;
}

1;
__END__
