#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: IP.pm 1827 2009-04-08 15:24:43Z hikarin $
#

package Img0ch::Filter::IP;

use strict;

sub new {
    my ( $iClass, $iBBS ) = @_;
    my $iKernel = $iBBS->get_kernel();

    bless {
        _bbs => ( $iBBS->get_name() || 'test' ),
        _rs => $iKernel->get_repos( $iKernel->get_repos_path('access') ),
    }, $iClass;
}

sub load { $_[0]->{_rs}->load(); return 1 }

sub write_ok {
    my ( $iFIP, $ip ) = @_;
    my $iRepos = $iFIP->{_rs};
    my $bbs    = $iFIP->{_bbs};
    my ( $i1, $i2, $i3, $i4 ) = split '\.', $ip;

    my $prefix1 = "I:F:I.${bbs}.${i1}.${i2}";
    $iRepos->get("${prefix1}.${i3}.${i4}") and return 0;
    $iRepos->get("${prefix1}.${i3}.0")     and return 0;
    $iRepos->get("${prefix1}.0.0")         and return 0;

    my $prefix2 = "I:F:I.test.${i1}.${i2}";
    $iRepos->get("${prefix2}.${i3}.${i4}") and return 0;
    $iRepos->get("${prefix2}.${i3}.0")     and return 0;
    $iRepos->get("${prefix2}.0.0")         and return 0;
    return 1;
}

1;
__END__
