#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Handle.pm 1134 2007-09-15 13:13:00Z hikarin $
#

package Zeromin2::Translate::JBBS::Handle;

use strict;
use Zeromin2::Translate::JBBS::Parser qw();

my $HANDLE_GROUP_NAME = 'JBBS Handle Group';

sub work {
    my ( $zClass, $iKernel, $argument ) = @_;
    my $zTJP = Zeromin2::Translate::JBBS::Parser->new();
    my $tree;

    $zTJP->set_url( $argument->{-url} );
    $zTJP->set_password( $argument->{-pass} || $argument->{-password} );
    if ( $zTJP->try_post_form( \$tree, 'handle' ) ) {
        my $zCap = $argument->{cap};
        my $gid  = $zCap->get_group_id($HANDLE_GROUP_NAME);
        if ( !$gid ) {
            $zCap->add_group(
                {   name      => $HANDLE_GROUP_NAME,
                    bbs       => $argument->{-bbs},
                    privilege => 768,
                }
            );
            $zCap->save();
            $gid = $zCap->get_group_id($HANDLE_GROUP_NAME);
        }

        my @rows = $tree->find('table')->look_down( '_tag' => 'tr' );
        shift @rows;
        for my $tr (@rows) {
            my @data = $tr->look_down( '_tag' => 'td' );
            my $content = [];
            for my $td (@data) {
                my $text = $td->as_text();
                $text =~ /\A\s*\z/ and next;
                push @$content,
                    $iKernel->get_encoded_str( $text, undef, 'euc' );
            }
            my $name = $content->[0];
            my $pass = $content->[1];
            $zCap->get_cap_id($name) and next;
            $zCap->add( { name => $name, pass => $pass, gid => $gid } );
        }

        $zCap->save();
        return 1;
    }

    return 0;
}

sub get_group_name { return $HANDLE_GROUP_NAME }

1;
__END__
