#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Log.pm 1827 2009-04-08 15:24:43Z hikarin $
#

package Zeromin::Log;

use strict;
use base qw( Img0ch::Log Zeromin::Log::Interface );

sub retrive_by_day {
    my ( $zLog, @args ) = @_;
    $zLog->SUPER::retrive_by_day( $zLog->{_i0_bbs}, qr{/log\.\w+\z}xms,
        @args );
}

sub retrive_by_month {
    my ( $zLog, @args ) = @_;
    $zLog->SUPER::retrive_by_month( $zLog->{_i0_bbs}, qr{/log\.\w+\z}xms,
        @args );
}

sub all {
    my ($zLog) = @_;
    $zLog->SUPER::all( qr{/log\.\w+\z},
        File::Basename::dirname( $zLog->{_i0_bbs}->get_repos_path(0) ) );
}

sub to_array {
    my ($zError) = @_;
    my $date_table = {};

    $zError->{_rs}->iterate(
        sub {
            my ( $key, $value, $date_table ) = @_;
            if ( $key =~ /\AI:L\.(?:.+?\.?:.+?\.\d+\.\d+)\.\w+\z/xms ) {
                $date_table->{$1} = 1;
            }
            return 0;
        },
        $date_table
    );
    return [ keys %$date_table ];
}

sub _retrive {
    my ( $zError, $repositories, $iKernel ) = @_;
    my $ret  = [];
    my $seen = {};

    for my $iRepos ( map { $iKernel->get_repos_nocache($_) } @$repositories )
    {
        $iRepos->iterate(
            sub {
                my ( $key, $value, $iRepos, $seen, $ret ) = @_;
                if ($key =~ m{
                    \AI:L\.(.+?)\.(.+?)\.(\d+?)\.(\w+)\z
                    }xms
                    )
                {
                    my ( $bbs, $thread_key, $resno, $name )
                        = ( $1, $2, $3, $4 );
                    my $prefix = "I:L.${bbs}.${thread_key}.${resno}";
                    exists $seen->{$prefix} and return 0;
                    $seen->{$prefix} = 1;
                    my $agent = $iRepos->get_binary("${prefix}.agent");
                    my $date
                        = $name eq 'date'
                        ? $$value
                        : $iRepos->get("${prefix}.date");
                    my $ip
                        = $name eq 'ip'
                        ? $$value
                        : $iRepos->get("${prefix}.ip");
                    my $serial
                        = $name eq 'serial'
                        ? $$value
                        : $iRepos->get("${prefix}.serial");
                    push @$ret,
                        {
                        bbs    => $bbs,
                        key    => $thread_key,
                        resno  => $resno,
                        agent  => $agent,
                        date   => $date,
                        ip     => $ip,
                        serial => $serial,
                        };
                }
                return 0;
            },
            $iRepos,
            $seen,
            $ret,
        );
    }
    @$ret = sort { $b->{date} cmp $a->{date} } @$ret;
    return $ret;
}

1;
__END__
