#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Category.pm 1827 2009-04-08 15:24:43Z hikarin $
#

package Zeromin::Compat::Category;

use strict;

sub update {
    my ( $zCategory, $iKernel ) = @_;

    my $base = $iKernel->get_config()->get('BBSPath');
    my $path = $base . '/test/info/category.cgi';

    -r $path or return 0;

    my $fh = $iKernel->get_read_file_handle($path);
    while ( my $line = <$fh> ) {
        chomp $line;
        my ( undef, $name ) = split '<>', $line;
        if ( my $cat_id = $zCategory->get_id($name) ) {
            $zCategory->set( $cat_id,
                $iKernel->get_encoded_str( $name, undef, 'sjis' ) );
        }
        else {
            $zCategory->add(
                $iKernel->get_encoded_str( $name, undef, 'sjis' ) );
        }
    }
    close $fh or $iKernel->throw_io_exception($path);
    $zCategory->save();

    return 1;
}

1;
__END__
