#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Removed.pm 1827 2009-04-08 15:24:43Z hikarin $
#

package Img0ch::Upload::Removed;

use strict;

sub new {
    my ( $iClass, $iObject ) = @_;
    my ( $iBBS, $iKernel );
    my $class = ref $iObject || '';

    if ( $class eq 'Img0ch::BBS' or $class eq 'Zeromin::BBS' ) {
        $iBBS    = $iObject;
        $iKernel = $iObject->get_kernel();
    }
    elsif ( $class eq 'Img0ch::Kernel' or $class eq 'Img0ch::Maple' ) {
        require Img0ch::BBS;
        $iBBS = Img0ch::BBS->new( $iObject, { id => 0 } );
        $iKernel = $iObject;
    }
    else {
        Img0ch::Kernel->throw_exception(
            'Img0ch::BBS or Img0ch::Maple(Img0ch::Kernel) not given');
    }

    my $iRepos
        = $iKernel->get_repos( $iKernel->get_repos_path('upload_removed') );

    bless {
        _bbs      => $iBBS,
        _count    => $iRepos->get_int('I:U:R.count'),
        _kernel   => $iKernel,
        __now     => time(),
        __prefix  => 'I:U:R',
        _rs       => $iRepos,
        __removed => [],
    }, $iClass;
}

sub load {
    my ($iURemoved) = @_;
    my $iRepos = $iURemoved->{_rs};
    $iRepos and $iRepos->load();
    return 1;
}

sub save {
    my ($iURemoved) = @_;
    my $iRepos      = $iURemoved->{_rs};
    my $removed     = $iURemoved->{__removed};
    if ( !@$removed ) {
        $iRepos->save();
        return 1;
    }

    my $iKernel    = $iURemoved->{_kernel};
    my $count      = $iURemoved->{_count};
    my $prefix_top = $iURemoved->{__prefix};
    for my $one (@$removed) {
        my ( $hash, $bbs, $key, $resno, $time ) = @$one;
        my $prefix = join '.', $prefix_top, $hash;
        $iRepos->get("${prefix}.removed") and next;
        $iRepos->set( "${prefix}.bbs",     $bbs );
        $iRepos->set( "${prefix}.key",     $key );
        $iRepos->set( "${prefix}.resno",   $resno );
        $iRepos->set( "${prefix}.removed", $time );
        $count++;
    }

    @{ $iURemoved->{__removed} } = ();
    $iRepos->set( 'I:U:R.count', $count );
    $iRepos->save();
    return 1;
}

sub set {
    my ( $iURemoved, $hash, $key, $resno, $time ) = @_;
    my $bbs = $iURemoved->{_bbs}->get_name() || return;
    $time ||= $iURemoved->{__now};
    push @{ $iURemoved->{__removed} }, [ $hash, $bbs, $key, $resno, $time ];
    return;
}

sub get {
    my ( $iURemoved, $hash ) = @_;
    my $prefix = join '.', $iURemoved->{__prefix}, $hash;
    my $iRepos = $iURemoved->{_rs};

    if ( my $resno = $iRepos->get("${prefix}.resno") ) {
        my $bbs     = $iRepos->get("${prefix}.bbs");
        my $key     = $iRepos->get("${prefix}.key");
        my $removed = $iRepos->get("${prefix}.removed");
        return [ $bbs, $key, $resno, $removed ];
    }
    else {
        return [ '', 0, 0, 0 ];
    }
}

sub is_removed {
    my ( $iURemoved, $hash ) = @_;
    my $prefix = join '.', $iURemoved->{__prefix}, $hash;
    my $iRepos = $iURemoved->{_rs};

    return $iRepos->get("${prefix}.removed") ? 1 : 0;
}

sub get_all_hash {
    my ($iURemoved) = @_;
    my $hash        = {};
    my $iter        = $iURemoved->{_rs}->iterate(
        sub {
            my ( $key, $value, $hash ) = @_;
            if ( $key =~ /\AI:U:R\.([^\.]+)\.\w+\z/xms ) {
                my $hash_key = $1;
                $hash->{$hash_key} = 1;
            }
            return 0;
        },
        $hash
    );

    return [ keys %$hash ];
}

sub get_all_hash_with_page {
    my ( $iURemoved, $item_per_page, $offset ) = @_;

    require Data::Page;
    my $entries = $iURemoved->get_all_hash();
    my $page = Data::Page->new( scalar @$entries, $item_per_page, $offset );
    return ( [ $page->splice($entries) ], $page );
}

sub remove {
    my ( $iURemoved, $hash ) = @_;
    my $prefix = join '.', $iURemoved->{__prefix}, $hash;
    my $iRepos = $iURemoved->{_rs};

    if ( $iRepos->remove("${prefix}.resno") ) {
        $iRepos->remove("${prefix}.bbs");
        $iRepos->remove("${prefix}.key");
        $iRepos->remove("${prefix}.removed");
        $iRepos->set( 'I:U:R.count', $iRepos->get_int('I:U:R.count') - 1 );
        return 1;
    }
    else {
        return 0;
    }
}

1;
__END__
