#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Note.pm 1827 2009-04-08 15:24:43Z hikarin $
#

package Img0ch::Plugin::Upload::Note;

use strict;
use Img0ch::Plugin::Module::Draft qw();
use Img0ch::Plugin::Module::Note qw();

sub new {
    my ( $iClass, $iBBS, $key, $called ) = @_;
    $called eq 'iterator' or return;

    my $iConfig  = $iBBS->get_kernel()->get_config();
    my $iNote    = Img0ch::Plugin::Module::Note->new( $iBBS, $key );
    my $iSetting = $iBBS->get_setting_instance();
    my $iUpload  = $iBBS->get_upload_instance($key);
    my $cgi = Img0ch::Request->get_app_uri2($iConfig) . '/img0ch-note.cgi';

    bless {
        __bbs       => $iBBS->get_name(),
        __cache_key => $key,
        __cgi       => $cgi,
        __note      => $iNote,
        __upload    => $iUpload,
    }, $iClass;
}

sub save {
    my ($iApp) = @_;
    my $iRequest = $iApp->request();

    if ( ( ref $iRequest || '' ) eq 'Img0ch::App::Note::Request' ) {
        my $iUpload = $iApp->upload();
        my $path    = $iUpload->get_uploaded_file_path();
        my ( $resno, $ext ) = $path =~ m{/(\d+)\.(\w+)\z}xms or return 1;

        my $iBBS  = $iApp->bbs();
        my $key   = $iRequest->key();
        my $pass  = $iRequest->param('editpass');
        my $iNote = Img0ch::Plugin::Module::Note->new( $iBBS, $key );
        if ( my $id = $iRequest->param_int('noteID') ) {
            my $iDraft = $iApp->get_draft_repository()
                || Img0ch::Plugin::Module::Draft->new( $iApp->kernel() );
            my $modified = $iDraft->get_last_modified($id);
            if ($modified) {
                $pass ||= $iDraft->get_edit_pass();
                $iNote->set(
                    $resno,
                    {   animation => \$iDraft->get_animation($id),
                        applet    => $iApp->get_applet_type(),
                        ellapse   => $iDraft->get_ellapse($id),
                        modified  => $modified,
                        pass      => $pass,
                        type      => $iDraft->get_image_type($id)
                    }
                );
                $iNote->save();
            }
        }
        else {
            my $pass = $iRequest->param('editpass');
            $iNote->set(
                $resno,
                {   animation => $iRequest->get_animation(),
                    applet    => $iApp->get_applet_type(),
                    ellapse   => $iRequest->param_int('timer'),
                    modified  => $iRequest->now(),
                    pass      => $pass,
                    type      => $ext
                }
            );
            $iNote->save();
        }
    }
    return 1;
}

my $animation = pack 'C*', 0x83, 0x41, 0x83, 0x6a, 0x83, 0x81, 0x81, 0x5b,
    0x83, 0x56, 0x83, 0x87, 0x83, 0x93;
my $continue = pack 'C*', 0x91, 0xb1, 0x82, 0xab, 0x82, 0xf0, 0x95, 0x60,
    0x82, 0xad;

sub rewrite {
    my ( $iObject, $key, $count, $resno, $text ) = @_;
    my $iNote   = $iObject->{__note};
    my $iUpload = $iObject->{__upload};
    if ( $iObject->{__cache_key} ne $key ) {
        $iNote->set_key($key);
        $iUpload->set_key($key);
        $iObject->{__cache_key} = $key;
        $iObject->{__note}      = $iNote;
        $iObject->{__upload}    = $iUpload;
    }

    my $hash = $iNote->get($resno);
    my $ellapse = $hash->{ellapse} or return;
    my ( undef, $width, $height, undef ) = @{ $iUpload->get($resno) };
    my $bbs = $iObject->{__bbs};
    my $cgi = $iObject->{__cgi};

    $$text .= join '', '<br /><br /><a href="', $cgi, '/continue/', $bbs, '/',
        $key, '/', $resno, '?width=', $width, '&height=', $height, '"><b>[',
        $continue, ']</b></a>';
    if ( $hash->{animation} ) {
        $$text .= join '', ' <a href="', $cgi, '/animate/', $bbs, '/', $key,
            '/', $resno, '?width=', $width, '&height=', $height, '"><b>[',
            $animation, ']</b></a>';
    }
    return;
}

*from_bbs = \&rewrite;

*from_read = \&rewrite;

1;
__END__
