#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Expires.pm 1827 2009-04-08 15:24:43Z hikarin $
#

package Img0ch::Plugin::Upload::Expires;

use strict;

sub _do {
    my ($iApp) = @_;
    my $iUpload = $iApp->upload();

    if ( -d $iUpload->path() ) {
        if ( my $expires = $iApp->setting()->get_int('BBS_IMG_EXPIRES') ) {
            my $now = $iApp->request()->now();
            for my $file ( @{ $iUpload->traverse() } ) {
                my $modified = ( stat($file) )[9];
                $now > $modified + $expires and $iUpload->remove($file);
            }
            $iUpload->save();
        }
    }

    return 1;
}

*at_post_upload = \&_do;

*at_post_write = \&_do;

1;
__END__
